/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v1_0;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MessagePublishInfo;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_from_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_1_0_to_v0_8
implements MessageConverter<Message_1_0, AMQMessage> {
    private static final int BASIC_CLASS_ID = 60;

    public Class<Message_1_0> getInputClass() {
        return Message_1_0.class;
    }

    public Class<AMQMessage> getOutputClass() {
        return AMQMessage.class;
    }

    public AMQMessage convert(Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        return new AMQMessage(this.convertToStoredMessage(serverMsg), null);
    }

    private StoredMessage<MessageMetaData> convertToStoredMessage(final Message_1_0 serverMsg) {
        Object bodyObject = MessageConverter_from_1_0.convertBodyToObject((Message_1_0)serverMsg);
        final byte[] messageContent = MessageConverter_from_1_0.convertToBody((Object)bodyObject);
        final MessageMetaData messageMetaData_0_8 = this.convertMetaData(serverMsg, MessageConverter_from_1_0.getBodyMimeType((Object)bodyObject), messageContent.length);
        return new StoredMessage<MessageMetaData>(){

            public MessageMetaData getMetaData() {
                return messageMetaData_0_8;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public Collection<QpidByteBuffer> getContent(int offset, int length) {
                return Collections.singleton(QpidByteBuffer.wrap((byte[])messageContent, (int)offset, (int)length));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    private MessageMetaData convertMetaData(Message_1_0 serverMsg, String bodyMimeType, int size) {
        MessageMetaData_1_0.MessageHeader_1_0 header = serverMsg.getMessageHeader();
        String key = header.getTo();
        if (key == null) {
            key = header.getSubject();
        }
        MessagePublishInfo publishInfo = new MessagePublishInfo(null, false, false, AMQShortString.valueOf((String)key));
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        props.setAppId(serverMsg.getMessageHeader().getAppId());
        props.setContentType(bodyMimeType);
        props.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId());
        props.setDeliveryMode(serverMsg.isPersistent() ? (byte)2 : 1);
        props.setExpiration(serverMsg.getExpiration());
        props.setMessageId(serverMsg.getMessageHeader().getMessageId());
        props.setPriority(serverMsg.getMessageHeader().getPriority());
        props.setReplyTo(serverMsg.getMessageHeader().getReplyTo());
        props.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        props.setUserId(serverMsg.getMessageHeader().getUserId());
        LinkedHashMap<String, Object> headerProps = new LinkedHashMap<String, Object>();
        if (header.getSubject() != null) {
            headerProps.put("qpid.subject", header.getSubject());
        }
        for (String headerName : serverMsg.getMessageHeader().getHeaderNames()) {
            headerProps.put(headerName, MessageConverter_from_1_0.convertValue((Object)serverMsg.getMessageHeader().getHeader(headerName)));
        }
        props.setHeaders(FieldTable.convertToFieldTable(headerProps));
        ContentHeaderBody chb = new ContentHeaderBody(props);
        chb.setBodySize((long)size);
        return new MessageMetaData(publishInfo, chb, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "v1-0 to v0-8";
    }
}

