/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_8_v1_0;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_to_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Section;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.url.AMQBindingURL;

@PluggableService
public class MessageConverter_0_8_to_1_0
extends MessageConverter_to_1_0<AMQMessage> {
    public Class<AMQMessage> getInputClass() {
        return AMQMessage.class;
    }

    protected MessageMetaData_1_0 convertMetaData(AMQMessage serverMessage, Section bodySection, SectionEncoder sectionEncoder) {
        AMQShortString messageId;
        AMQShortString correlationId;
        ArrayList<Object> sections = new ArrayList<Object>(3);
        Header header = new Header();
        header.setDurable(Boolean.valueOf(serverMessage.isPersistent()));
        BasicContentHeaderProperties contentHeader = serverMessage.getContentHeaderBody().getProperties();
        header.setPriority(UnsignedByte.valueOf((byte)contentHeader.getPriority()));
        long expiration = serverMessage.getExpiration();
        long arrivalTime = serverMessage.getArrivalTime();
        if (expiration > arrivalTime) {
            header.setTtl(UnsignedInteger.valueOf((long)(expiration - arrivalTime)));
        }
        sections.add(header);
        Properties props = new Properties();
        props.setContentEncoding(Symbol.valueOf((String)contentHeader.getEncodingAsString()));
        props.setContentType(Symbol.valueOf((String)contentHeader.getContentTypeAsString()));
        if (props.getContentType() == Symbol.valueOf((String)"application/java-object-stream")) {
            props.setContentType(Symbol.valueOf((String)"application/x-java-serialized-object"));
        }
        if ((correlationId = contentHeader.getCorrelationId()) != null) {
            props.setCorrelationId((Object)new Binary(correlationId.getBytes()));
        }
        if ((messageId = contentHeader.getMessageId()) != null) {
            props.setMessageId((Object)new Binary(messageId.getBytes()));
        }
        String originalReplyTo = String.valueOf(contentHeader.getReplyTo());
        try {
            String replyTo;
            AMQBindingURL burl = new AMQBindingURL(originalReplyTo);
            if (burl.getExchangeName() != null && !burl.getExchangeName().equals("")) {
                replyTo = burl.getExchangeName();
                if (burl.getRoutingKey() != null) {
                    replyTo = replyTo + "/" + burl.getRoutingKey();
                }
            } else {
                replyTo = burl.getQueueName() != null && !burl.getQueueName().equals("") ? burl.getQueueName() : (burl.getRoutingKey() != null ? burl.getRoutingKey() : originalReplyTo);
            }
            props.setReplyTo(replyTo);
        }
        catch (URISyntaxException e) {
            props.setReplyTo(originalReplyTo);
        }
        props.setSubject(serverMessage.getInitialRoutingAddress());
        if (contentHeader.getUserId() != null) {
            props.setUserId(new Binary(contentHeader.getUserId().getBytes()));
        }
        sections.add(props);
        LinkedHashMap applicationProperties = FieldTable.convertToMap((FieldTable)contentHeader.getHeaders());
        if (applicationProperties.containsKey("qpid.subject")) {
            props.setSubject(String.valueOf(applicationProperties.get("qpid.subject")));
            applicationProperties = new LinkedHashMap(applicationProperties);
            applicationProperties.remove("qpid.subject");
        }
        sections.add(new ApplicationProperties((Map)applicationProperties));
        if (bodySection != null) {
            sections.add(bodySection);
        }
        return new MessageMetaData_1_0(sections, sectionEncoder);
    }

    public String getType() {
        return "v0-8 to v1-0";
    }
}

