/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_10_v1_0;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_from_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.ReplyTo;

@PluggableService
public class MessageConverter_1_0_to_v0_10
implements MessageConverter<Message_1_0, MessageTransferMessage> {
    public Class<Message_1_0> getInputClass() {
        return Message_1_0.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg, addressSpace), null);
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        Object bodyObject = MessageConverter_from_1_0.convertBodyToObject((Message_1_0)serverMsg);
        final byte[] messageContent = MessageConverter_from_1_0.convertToBody((Object)bodyObject);
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg, addressSpace, MessageConverter_from_1_0.getBodyMimeType((Object)bodyObject), messageContent.length);
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public Collection<QpidByteBuffer> getContent(int offset, int length) {
                return Collections.singleton(QpidByteBuffer.wrap((byte[])messageContent, (int)offset, (int)length));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(Message_1_0 serverMsg, NamedAddressSpace addressSpace, String bodyMimeType, int size) {
        String origReplyTo;
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        MessageMetaData_1_0.MessageHeader_1_0 origHeader = serverMsg.getMessageHeader();
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)origHeader.getPriority()));
        deliveryProps.setRoutingKey(serverMsg.getInitialRoutingAddress());
        deliveryProps.setTimestamp(origHeader.getTimestamp());
        messageProps.setContentEncoding(origHeader.getEncoding());
        messageProps.setContentLength((long)size);
        messageProps.setContentType(bodyMimeType);
        if (origHeader.getCorrelationId() != null) {
            messageProps.setCorrelationId(origHeader.getCorrelationId().getBytes());
        }
        if ((origReplyTo = origHeader.getReplyTo()) != null && !origReplyTo.equals("")) {
            ReplyTo replyTo;
            if (origReplyTo.startsWith("/")) {
                replyTo = new ReplyTo("", origReplyTo);
            } else if (origReplyTo.contains("/")) {
                String[] parts = origReplyTo.split("/", 2);
                replyTo = new ReplyTo(parts[0], parts[1]);
            } else {
                replyTo = addressSpace.getAttainedMessageDestination(origReplyTo) instanceof Exchange ? new ReplyTo(origReplyTo, "") : new ReplyTo("", origReplyTo);
            }
            messageProps.setReplyTo(replyTo);
        }
        LinkedHashMap<String, String> appHeaders = (LinkedHashMap<String, String>)MessageConverter_from_1_0.convertValue((Object)serverMsg.getMessageHeader().getHeadersAsMap());
        if (origHeader.getSubject() != null && !appHeaders.containsKey("qpid.subject")) {
            appHeaders = new LinkedHashMap<String, String>(appHeaders);
            appHeaders.put("qpid.subject", origHeader.getSubject());
        }
        messageProps.setApplicationHeaders((Map)appHeaders);
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "v1-0 to v0-10";
    }
}

