/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.JdbcUtils;
import org.apache.qpid.server.store.SizeMonitoringSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.derby.DerbyUtils;
import org.slf4j.Logger;

public abstract class AbstractDerbyMessageStore
extends AbstractJDBCMessageStore {
    private final AtomicBoolean _messageStoreOpen = new AtomicBoolean(false);
    private long _persistentSizeLowThreshold;
    private long _persistentSizeHighThreshold;
    private long _totalStoreSize;
    private boolean _limitBusted;
    private ConfiguredObject<?> _parent;

    public final void openMessageStore(ConfiguredObject<?> parent) {
        if (this._messageStoreOpen.compareAndSet(false, true)) {
            this._parent = parent;
            this.initMessageStore(parent);
            DerbyUtils.loadDerbyDriver();
            this.doOpen(parent);
            SizeMonitoringSettings sizeMonitorSettings = (SizeMonitoringSettings)parent;
            this._persistentSizeHighThreshold = sizeMonitorSettings.getStoreOverfullSize();
            this._persistentSizeLowThreshold = sizeMonitorSettings.getStoreUnderfullSize();
            if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
                this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
            }
            this.createOrOpenMessageStoreDatabase();
            this.setInitialSize();
            this.setMaximumMessageId();
        }
    }

    protected abstract void doOpen(ConfiguredObject<?> var1);

    public final void upgradeStoreStructure() throws StoreException {
        this.checkMessageStoreOpen();
        this.upgrade(this._parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeMessageStore() {
        if (this._messageStoreOpen.compareAndSet(true, false)) {
            try {
                this.doClose();
            }
            finally {
                super.closeMessageStore();
            }
        }
    }

    protected abstract void doClose();

    protected boolean isMessageStoreOpen() {
        return this._messageStoreOpen.get();
    }

    protected void checkMessageStoreOpen() {
        if (!this._messageStoreOpen.get()) {
            throw new IllegalStateException("Message store is not open");
        }
    }

    protected String getSqlBlobType() {
        return "blob";
    }

    protected String getSqlVarBinaryType(int size) {
        return "varchar(" + size + ") for bit data";
    }

    protected String getSqlBigIntType() {
        return "bigint";
    }

    protected byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        return DerbyUtils.getBlobAsBytes(rs, col);
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return DerbyUtils.tableExists(tableName, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storedSizeChange(int delta) {
        if (this.getPersistentSizeHighThreshold() > 0L) {
            AbstractDerbyMessageStore abstractDerbyMessageStore = this;
            synchronized (abstractDerbyMessageStore) {
                long newSize = this._totalStoreSize += (long)(3 * delta);
                Connection conn = null;
                try {
                    if (!this._limitBusted && newSize > this.getPersistentSizeHighThreshold()) {
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (this._totalStoreSize > this.getPersistentSizeHighThreshold()) {
                            this._limitBusted = true;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
                        }
                    } else if (this._limitBusted && newSize < this.getPersistentSizeLowThreshold()) {
                        long oldSize = this._totalStoreSize;
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (oldSize <= this._totalStoreSize) {
                            this.reduceSizeOnDisk(conn);
                            this._totalStoreSize = this.getSizeOnDisk(conn);
                        }
                        if (this._totalStoreSize < this.getPersistentSizeLowThreshold()) {
                            this._limitBusted = false;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
                        }
                    }
                }
                catch (SQLException e) {
                    JdbcUtils.closeConnection(conn, (Logger)this.getLogger());
                    throw new StoreException("Exception while processing store size change", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialSize() {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            this._totalStoreSize = this.getSizeOnDisk(conn);
        }
        catch (SQLException e) {
            this.getLogger().error("Unable to set initial store size", (Throwable)e);
        }
        finally {
            JdbcUtils.closeConnection((Connection)conn, (Logger)this.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSizeOnDisk(Connection conn) {
        PreparedStatement stmt = null;
        try {
            String sizeQuery = "SELECT SUM(T2.NUMALLOCATEDPAGES * T2.PAGESIZE) TOTALSIZE    FROM         SYS.SYSTABLES systabs,        TABLE (SYSCS_DIAG.SPACE_TABLE(systabs.tablename)) AS T2    WHERE systabs.tabletype = 'T'";
            stmt = conn.prepareStatement(sizeQuery);
            long size = 0L;
            try (ResultSet rs = null;){
                rs = stmt.executeQuery();
                while (rs.next()) {
                    size = rs.getLong(1);
                }
            }
            long l = size;
            return l;
        }
        catch (SQLException e) {
            throw new StoreException("Error establishing on disk size", (Throwable)e);
        }
        finally {
            JdbcUtils.closePreparedStatement((PreparedStatement)stmt, (Logger)this.getLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduceSizeOnDisk(Connection conn) {
        CallableStatement cs = null;
        PreparedStatement stmt = null;
        try {
            String tableQuery = "SELECT S.SCHEMANAME, T.TABLENAME FROM SYS.SYSSCHEMAS S, SYS.SYSTABLES T WHERE S.SCHEMAID = T.SCHEMAID AND T.TABLETYPE='T'";
            stmt = conn.prepareStatement(tableQuery);
            ResultSet rs = null;
            ArrayList<String> schemas = new ArrayList<String>();
            ArrayList<String> tables = new ArrayList<String>();
            try {
                rs = stmt.executeQuery();
                while (rs.next()) {
                    schemas.add(rs.getString(1));
                    tables.add(rs.getString(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
            for (int i = 0; i < schemas.size(); ++i) {
                cs.setString(1, (String)schemas.get(i));
                cs.setString(2, (String)tables.get(i));
                cs.setShort(3, (short)0);
                cs.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Error reducing on disk size", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closePreparedStatement((PreparedStatement)stmt, (Logger)this.getLogger());
                JdbcUtils.closePreparedStatement(cs, (Logger)this.getLogger());
                throw throwable;
            }
        }
        JdbcUtils.closePreparedStatement((PreparedStatement)stmt, (Logger)this.getLogger());
        JdbcUtils.closePreparedStatement((PreparedStatement)cs, (Logger)this.getLogger());
    }

    private long getPersistentSizeLowThreshold() {
        return this._persistentSizeLowThreshold;
    }

    private long getPersistentSizeHighThreshold() {
        return this._persistentSizeHighThreshold;
    }
}

