/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.QueryServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;

public class VirtualHostQueryServlet
extends QueryServlet<VirtualHost<?>> {
    @Override
    protected VirtualHost<?> getParent(HttpServletRequest request) {
        VirtualHostNode vhn;
        List<String> path = HttpManagementUtil.getPathInfoElements(request.getServletPath(), request.getPathInfo());
        Broker<?> broker = HttpManagementUtil.getBroker(request.getServletContext());
        if (path.size() == 3 && (vhn = (VirtualHostNode)broker.getChildByName(VirtualHostNode.class, path.get(0))) != null) {
            return (VirtualHost)vhn.getChildByName(VirtualHost.class, path.get(1));
        }
        return null;
    }

    @Override
    protected Class<? extends ConfiguredObject> getSupportedCategory(String categoryName, Model brokerModel) {
        Class category = null;
        for (Class supportedCategory : brokerModel.getSupportedCategories()) {
            if (!categoryName.equalsIgnoreCase(supportedCategory.getSimpleName())) continue;
            category = supportedCategory;
            break;
        }
        Collection ancestors = brokerModel.getAncestorCategories(category);
        if (category == VirtualHost.class || category == Connection.class || ancestors.contains(VirtualHost.class) || ancestors.contains(Connection.class)) {
            return category;
        }
        return null;
    }

    @Override
    protected String getRequestedCategory(HttpServletRequest request) {
        List<String> pathInfoElements = HttpManagementUtil.getPathInfoElements(request.getServletPath(), request.getPathInfo());
        if (pathInfoElements.size() == 3) {
            return pathInfoElements.get(2);
        }
        return null;
    }

    @Override
    protected List<ConfiguredObject<?>> getAllObjects(VirtualHost<?> virtualHost, Class<? extends ConfiguredObject> category, HttpServletRequest request) {
        Model model = virtualHost.getModel();
        if (category == VirtualHost.class) {
            return Collections.singletonList(virtualHost);
        }
        if (model.getAncestorCategories(category).contains(VirtualHost.class)) {
            ArrayList<Class<? extends ConfiguredObject>> hierarchy = new ArrayList<Class<? extends ConfiguredObject>>();
            Class element = category;
            while (element != null && element != VirtualHost.class) {
                hierarchy.add(element);
                Collection parentTypes = model.getParentTypes(element);
                if (parentTypes == null || parentTypes.isEmpty()) break;
                element = (Class)parentTypes.iterator().next();
            }
            Collections.reverse(hierarchy);
            List<VirtualHost<?>> parents = Collections.singletonList(virtualHost);
            return this.getObjects(hierarchy, parents);
        }
        ArrayList parents = new ArrayList();
        parents.addAll(virtualHost.getConnections());
        if (category == Connection.class) {
            return parents;
        }
        ArrayList<Class<? extends ConfiguredObject>> hierarchy = new ArrayList<Class<? extends ConfiguredObject>>();
        Class element = category;
        while (element != null && element != Connection.class) {
            hierarchy.add(element);
            Collection parentTypes = model.getParentTypes(element);
            if (parentTypes == null || parentTypes.isEmpty()) break;
            element = (Class)parentTypes.iterator().next();
        }
        Collections.reverse(hierarchy);
        return this.getObjects(hierarchy, parents);
    }

    private List<ConfiguredObject<?>> getObjects(List<Class<? extends ConfiguredObject>> hierarchy, Collection<ConfiguredObject<?>> parents) {
        Collection<Object> children = Collections.emptyList();
        for (Class<? extends ConfiguredObject> childClass : hierarchy) {
            children = new HashSet();
            for (ConfiguredObject<?> parent : parents) {
                children.addAll(parent.getChildren(childClass));
            }
            parents = children;
        }
        return new ArrayList(children);
    }
}

