/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import javax.security.auth.Subject;
import javax.security.sasl.SaslServer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServlet
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaslServlet.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String ATTR_RANDOM = "SaslServlet.Random";
    private static final String ATTR_ID = "SaslServlet.ID";
    private static final String ATTR_SASL_SERVER = "SaslServlet.SaslServer";
    private static final String ATTR_EXPIRY = "SaslServlet.Expiry";
    private static final long SASL_EXCHANGE_EXPIRY = 3000L;

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getRandom(request);
        SubjectCreator subjectCreator = this.getSubjectCreator(request);
        List mechanismsList = subjectCreator.getMechanisms();
        String[] mechanisms = mechanismsList.toArray(new String[mechanismsList.size()]);
        LinkedHashMap<String, Object> outputObject = new LinkedHashMap<String, Object>();
        Subject subject = this.getAuthorisedSubject(request);
        if (subject != null) {
            AuthenticatedPrincipal principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)subject);
            outputObject.put("user", principal.getName());
        } else if (request.getRemoteUser() != null) {
            outputObject.put("user", request.getRemoteUser());
        }
        outputObject.put("mechanisms", mechanisms);
        this.sendJsonResponse(outputObject, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Random getRandom(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Random rand = (Random)session.getAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_RANDOM, request));
        if (rand == null) {
            SecureRandom secureRandom = SECURE_RANDOM;
            synchronized (secureRandom) {
                rand = new Random(SECURE_RANDOM.nextLong());
            }
            session.setAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_RANDOM, request), (Object)rand);
        }
        return rand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.checkSaslAuthEnabled(request);
        HttpSession session = request.getSession();
        try {
            String mechanism = request.getParameter("mechanism");
            String id = request.getParameter("id");
            String saslResponse = request.getParameter("response");
            SubjectCreator subjectCreator = this.getSubjectCreator(request);
            if (mechanism != null) {
                if (id == null) {
                    LOGGER.debug("Creating SaslServer for mechanism: {}", (Object)mechanism);
                    SaslServer saslServer = subjectCreator.createSaslServer(mechanism, request.getServerName(), null);
                    this.evaluateSaslResponse(request, response, session, saslResponse, saslServer, subjectCreator);
                } else {
                    response.setStatus(417);
                    session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request));
                    session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request));
                    session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request));
                }
            } else if (id != null) {
                if (id.equals(session.getAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request))) && System.currentTimeMillis() < (Long)session.getAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request))) {
                    SaslServer saslServer = (SaslServer)session.getAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request));
                    this.evaluateSaslResponse(request, response, session, saslResponse, saslServer, subjectCreator);
                } else {
                    response.setStatus(417);
                    session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request));
                    session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request));
                    session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request));
                }
            } else {
                response.setStatus(417);
                session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request));
                session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request));
                session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request));
            }
        }
        finally {
            if (response.getStatus() != 200) {
                session.invalidate();
            }
        }
    }

    private void checkSaslAuthEnabled(HttpServletRequest request) {
        boolean saslAuthEnabled = false;
        HttpManagementConfiguration management = this.getManagementConfiguration();
        saslAuthEnabled = request.isSecure() ? management.isHttpsSaslAuthenticationEnabled() : management.isHttpSaslAuthenticationEnabled();
        if (!saslAuthEnabled) {
            throw new ConnectionScopedRuntimeException("Sasl authentication disabled.");
        }
    }

    private void evaluateSaslResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session, String saslResponse, SaslServer saslServer, SubjectCreator subjectCreator) throws IOException {
        int responseStatus;
        byte[] saslResponseBytes = saslResponse == null ? new byte[]{} : Strings.decodeBase64((String)saslResponse);
        SubjectAuthenticationResult authenticationResult = subjectCreator.authenticate(saslServer, saslResponseBytes);
        byte[] challenge = authenticationResult.getChallenge();
        LinkedHashMap<String, String> outputObject = new LinkedHashMap<String, String>();
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            Subject original = authenticationResult.getSubject();
            Broker<?> broker = this.getBroker();
            try {
                HttpManagementUtil.assertManagementAccess(broker, original);
                Subject subject = HttpManagementUtil.createServletConnectionSubject(request, original);
                HttpManagementUtil.saveAuthorisedSubject(request, subject);
                session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request));
                session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request));
                session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request));
                if (challenge != null && challenge.length != 0) {
                    outputObject.put("challenge", DatatypeConverter.printBase64Binary((byte[])challenge));
                }
                responseStatus = 200;
            }
            catch (SecurityException e) {
                responseStatus = 403;
            }
        } else if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.CONTINUE) {
            Random rand = this.getRandom(request);
            String id = String.valueOf(rand.nextLong());
            session.setAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request), (Object)id);
            session.setAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request), (Object)saslServer);
            session.setAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request), (Object)(System.currentTimeMillis() + 3000L));
            outputObject.put("id", id);
            outputObject.put("challenge", DatatypeConverter.printBase64Binary((byte[])challenge));
            responseStatus = 200;
        } else {
            session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_ID, request));
            session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SASL_SERVER, request));
            session.removeAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_EXPIRY, request));
            responseStatus = 401;
        }
        this.sendJsonResponse(outputObject, request, response, responseStatus, false);
    }

    private SubjectCreator getSubjectCreator(HttpServletRequest request) {
        return HttpManagementUtil.getManagementConfiguration(this.getServletContext()).getAuthenticationProvider(request).getSubjectCreator(request.isSecure());
    }

    @Override
    protected Subject getAuthorisedSubject(HttpServletRequest request) {
        Subject subject = HttpManagementUtil.getAuthorisedSubject(request);
        if (subject == null) {
            subject = HttpManagementUtil.tryToAuthenticate(request, HttpManagementUtil.getManagementConfiguration(this.getServletContext()));
        }
        return subject;
    }
}

