/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.management.plugin.HttpManagement;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.management.plugin.servlet.ServletConnectionPrincipal;
import org.apache.qpid.server.management.plugin.session.LoginLogoutReporter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.access.Operation;

public class HttpManagementUtil {
    public static final String ATTR_BROKER = "Qpid.broker";
    public static final String ATTR_MANAGEMENT_CONFIGURATION = "Qpid.managementConfiguration";
    private static final String ATTR_LOGIN_LOGOUT_REPORTER = "Qpid.loginLogoutReporter";
    private static final String ATTR_SUBJECT = "Qpid.subject";
    private static final String ATTR_LOG_ACTOR = "Qpid.logActor";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final Collection<HttpRequestPreemptiveAuthenticator> AUTHENTICATORS;
    private static final Operation MANAGE_ACTION;

    public static String getRequestSpecificAttributeName(String name, HttpServletRequest request) {
        return name + "." + HttpManagement.getPort(request).getId();
    }

    public static Broker<?> getBroker(ServletContext servletContext) {
        return (Broker)servletContext.getAttribute(ATTR_BROKER);
    }

    public static HttpManagementConfiguration getManagementConfiguration(ServletContext servletContext) {
        return (HttpManagementConfiguration)servletContext.getAttribute(ATTR_MANAGEMENT_CONFIGURATION);
    }

    public static Subject getAuthorisedSubject(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session == null ? null : (Subject)session.getAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SUBJECT, request));
    }

    public static void checkRequestAuthenticatedAndAccessAuthorized(HttpServletRequest request, Broker broker, HttpManagementConfiguration managementConfig) {
        Subject subject = HttpManagementUtil.getAuthorisedSubject(request);
        if (subject == null) {
            subject = HttpManagementUtil.tryToAuthenticate(request, managementConfig);
            if (subject == null) {
                throw new SecurityException("Only authenticated users can access the management interface");
            }
            subject = HttpManagementUtil.createServletConnectionSubject(request, subject);
            HttpManagementUtil.assertManagementAccess(broker, subject);
            HttpManagementUtil.saveAuthorisedSubject(request, subject);
        }
    }

    public static Subject createServletConnectionSubject(HttpServletRequest request, Subject original) {
        Subject subject = new Subject(false, original.getPrincipals(), original.getPublicCredentials(), original.getPrivateCredentials());
        subject.getPrincipals().add((Principal)((Object)new ServletConnectionPrincipal((ServletRequest)request)));
        subject.setReadOnly();
        return subject;
    }

    public static void assertManagementAccess(final Broker<?> broker, Subject subject) {
        Subject.doAs(subject, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                broker.authorise(MANAGE_ACTION);
                return null;
            }
        });
    }

    public static void saveAuthorisedSubject(HttpServletRequest request, Subject subject) {
        HttpSession session = request.getSession();
        session.setAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_SUBJECT, request), (Object)subject);
        session.setAttribute(HttpManagementUtil.getRequestSpecificAttributeName(ATTR_LOGIN_LOGOUT_REPORTER, request), (Object)new LoginLogoutReporter(subject, (EventLoggerProvider)HttpManagementUtil.getBroker(session.getServletContext())));
    }

    public static Subject tryToAuthenticate(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        HttpRequestPreemptiveAuthenticator authenticator;
        Subject subject = null;
        Iterator<HttpRequestPreemptiveAuthenticator> i$ = AUTHENTICATORS.iterator();
        while (i$.hasNext() && (subject = (authenticator = i$.next()).attemptAuthentication(request, managementConfig)) == null) {
        }
        return subject;
    }

    public static OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return HttpManagementUtil.getOutputStream(request, response, HttpManagementUtil.getManagementConfiguration(request.getServletContext()));
    }

    public static OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response, HttpManagementConfiguration managementConfiguration) throws IOException {
        Object outputStream;
        if (HttpManagementUtil.isCompressingAccepted(request, managementConfiguration)) {
            outputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            response.setHeader(CONTENT_ENCODING_HEADER, GZIP_CONTENT_ENCODING);
        } else {
            outputStream = response.getOutputStream();
        }
        return outputStream;
    }

    public static boolean isCompressingAccepted(HttpServletRequest request, HttpManagementConfiguration managementConfiguration) {
        return managementConfiguration.isCompressResponses() && Collections.list(request.getHeaderNames()).contains(ACCEPT_ENCODING_HEADER) && request.getHeader(ACCEPT_ENCODING_HEADER).contains(GZIP_CONTENT_ENCODING);
    }

    public static String ensureFilenameIsRfc2183(String requestedFilename) {
        return requestedFilename.replaceAll("[\\P{InBasic_Latin}\\\\:/\\p{Cntrl}]", "");
    }

    public static List<String> getPathInfoElements(String servletPath, String pathInfo) {
        if (pathInfo == null || pathInfo.length() == 0) {
            return Collections.emptyList();
        }
        String[] pathInfoElements = pathInfo.substring(1).split("/");
        for (int i = 0; i < pathInfoElements.length; ++i) {
            try {
                pathInfoElements[i] = URLDecoder.decode(pathInfoElements[i], StandardCharsets.UTF_8.name());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Servlet at " + servletPath + " could not decode path element: " + pathInfoElements[i], e);
            }
        }
        return Arrays.asList(pathInfoElements);
    }

    public static String getRequestURL(HttpServletRequest httpRequest) {
        StringBuilder urlBuilder = new StringBuilder(httpRequest.getRequestURL());
        String queryString = httpRequest.getQueryString();
        if (queryString != null) {
            urlBuilder.append('?').append(queryString);
        }
        String url = urlBuilder.toString();
        return url;
    }

    public static String getRequestPrincipals(HttpServletRequest httpRequest) {
        Set<Principal> principalSet;
        Subject subject;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (subject = HttpManagementUtil.getAuthorisedSubject(httpRequest)) != null && !(principalSet = subject.getPrincipals()).isEmpty()) {
            TreeSet<String> principalNames = new TreeSet<String>();
            for (Principal principal : principalSet) {
                principalNames.add(principal.getName());
            }
            return principalNames.toString();
        }
        return null;
    }

    static {
        MANAGE_ACTION = Operation.ACTION((String)"manage");
        ArrayList<HttpRequestPreemptiveAuthenticator> authenticators = new ArrayList<HttpRequestPreemptiveAuthenticator>();
        for (HttpRequestPreemptiveAuthenticator authenticator : new QpidServiceLoader().instancesOf(HttpRequestPreemptiveAuthenticator.class)) {
            authenticators.add(authenticator);
        }
        AUTHENTICATORS = Collections.unmodifiableList(authenticators);
    }
}

