/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DojoHelper {
    private static final Logger _logger;
    public static final String VERSION_FILE = "dojoconfig.properties";
    public static final String DOJO_VERSION_PROPERTY = "dojo-version";
    public static final String DOJO_PATH_PROPERTY = "dojo-path";
    public static final String DIJIT_PATH_PROPERTY = "dijit-path";
    public static final String DOJOX_PATH_PROPERTY = "dojox-path";
    public static final String DGRID_PATH_PROPERTY = "dgrid-path";
    public static final String DSTORE_PATH_PROPERTY = "dstore-path";
    private static String _version;
    private static String _dojoPath;
    private static String _dijitPath;
    private static String _dojoxPath;
    private static String _dgridPath;
    private static String _dstorePath;

    public static String getDojoVersion() {
        return _version;
    }

    public static String getDojoPath() {
        return _dojoPath;
    }

    public static String getDijitPath() {
        return _dijitPath;
    }

    public static String getDojoxPath() {
        return _dojoxPath;
    }

    public static String getDstorePath() {
        return _dstorePath;
    }

    public static String getDgridPath() {
        return _dgridPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block12: {
            _logger = LoggerFactory.getLogger(DojoHelper.class);
            _version = "undefined";
            _dojoPath = "/dojo-undefined/dojo";
            _dijitPath = "/dojo-undefined/dijit";
            _dojoxPath = "/dojo-undefined/dojox";
            _dgridPath = "/META-INF/resources/webjars/dgrid/dgrid-undefined";
            _dstorePath = "/META-INF/resources/webjars/dstore/dstore-undefined";
            Properties props = new Properties();
            try {
                InputStream propertyStream = DojoHelper.class.getClassLoader().getResourceAsStream(VERSION_FILE);
                if (propertyStream == null) {
                    _logger.warn("Unable to find resource dojoconfig.properties from classloader");
                    break block12;
                }
                try {
                    props.load(propertyStream);
                }
                finally {
                    try {
                        propertyStream.close();
                    }
                    catch (IOException e) {
                        _logger.warn("Exception closing InputStream for dojoconfig.properties resource:", (Throwable)e);
                    }
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dumping Dojo Config:");
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        _logger.debug("Property: " + entry.getKey() + " Value: " + entry.getValue());
                    }
                    _logger.debug("End of property dump");
                }
                _version = props.getProperty(DOJO_VERSION_PROPERTY, _version);
                _dojoPath = props.getProperty(DOJO_PATH_PROPERTY, _dojoPath);
                _dijitPath = props.getProperty(DIJIT_PATH_PROPERTY, _dijitPath);
                _dojoxPath = props.getProperty(DOJOX_PATH_PROPERTY, _dojoxPath);
                _dgridPath = props.getProperty(DGRID_PATH_PROPERTY, _dgridPath);
                _dstorePath = props.getProperty(DSTORE_PATH_PROPERTY, _dstorePath);
            }
            catch (IOException e) {
                _logger.error("Exception loading dojoconfig.properties resource:", (Throwable)e);
            }
        }
    }
}

