/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.ArrivalTimeFilter;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterManagerFactory;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.UnknownConfiguredObjectException;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.WindowCreditManager;
import org.apache.qpid.server.queue.QueueArgumentsConverter;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.DtxNotSelectedException;
import org.apache.qpid.server.txn.IncorrectDtxStateException;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.RollbackOnlyDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.ExchangeIsAlternateException;
import org.apache.qpid.server.virtualhost.QueueExistsException;
import org.apache.qpid.server.virtualhost.RequiredExchangeException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.apache.qpid.transport.Acquired;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.DtxCommit;
import org.apache.qpid.transport.DtxEnd;
import org.apache.qpid.transport.DtxForget;
import org.apache.qpid.transport.DtxGetTimeout;
import org.apache.qpid.transport.DtxPrepare;
import org.apache.qpid.transport.DtxRecover;
import org.apache.qpid.transport.DtxRollback;
import org.apache.qpid.transport.DtxSelect;
import org.apache.qpid.transport.DtxSetTimeout;
import org.apache.qpid.transport.DtxStart;
import org.apache.qpid.transport.DtxXaStatus;
import org.apache.qpid.transport.ExchangeBind;
import org.apache.qpid.transport.ExchangeBound;
import org.apache.qpid.transport.ExchangeBoundResult;
import org.apache.qpid.transport.ExchangeDeclare;
import org.apache.qpid.transport.ExchangeDelete;
import org.apache.qpid.transport.ExchangeQuery;
import org.apache.qpid.transport.ExchangeQueryResult;
import org.apache.qpid.transport.ExchangeUnbind;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.ExecutionSync;
import org.apache.qpid.transport.GetTimeoutResult;
import org.apache.qpid.transport.MessageAccept;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquire;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageCancel;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageFlush;
import org.apache.qpid.transport.MessageReject;
import org.apache.qpid.transport.MessageRejectCode;
import org.apache.qpid.transport.MessageRelease;
import org.apache.qpid.transport.MessageResume;
import org.apache.qpid.transport.MessageSetFlowMode;
import org.apache.qpid.transport.MessageStop;
import org.apache.qpid.transport.MessageSubscribe;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.QueueDeclare;
import org.apache.qpid.transport.QueueDelete;
import org.apache.qpid.transport.QueuePurge;
import org.apache.qpid.transport.QueueQuery;
import org.apache.qpid.transport.QueueQueryResult;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RangeSetFactory;
import org.apache.qpid.transport.RecoverResult;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDelegate;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.TxCommit;
import org.apache.qpid.transport.TxRollback;
import org.apache.qpid.transport.TxSelect;
import org.apache.qpid.transport.XaResult;
import org.apache.qpid.transport.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionDelegate
extends SessionDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSessionDelegate.class);

    public void command(Session session, Method method) {
        try {
            if (!session.isClosing()) {
                Object asyncCommandMark = ((ServerSession)session).getAsyncCommandMark();
                super.command(session, method, false);
                Object newOutstanding = ((ServerSession)session).getAsyncCommandMark();
                if (newOutstanding == null || newOutstanding == asyncCommandMark) {
                    session.processed(method);
                }
                if (newOutstanding != null) {
                    ((ServerSession)session).completeAsyncCommands();
                }
                if (method.isSync()) {
                    ((ServerSession)session).awaitCommandCompletion();
                    session.flushProcessed(new Option[0]);
                }
            }
        }
        catch (ConnectionScopedRuntimeException | ServerScopedRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception processing command", (Throwable)e);
            this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, "Exception processing command: " + e);
        }
    }

    public void messageAccept(Session session, MessageAccept method) {
        ServerSession serverSession = (ServerSession)session;
        serverSession.accept(method.getTransfers());
        if (!serverSession.isTransactional()) {
            serverSession.recordFuture((ListenableFuture<Void>)Futures.immediateFuture(null), new CommandProcessedAction(serverSession, (Method)method));
        }
    }

    public void messageReject(Session session, MessageReject method) {
        ((ServerSession)session).reject(method.getTransfers());
    }

    public void messageRelease(Session session, MessageRelease method) {
        ((ServerSession)session).release(method.getTransfers(), method.getSetRedelivered());
    }

    public void messageAcquire(Session session, MessageAcquire method) {
        RangeSet acquiredRanges = ((ServerSession)session).acquire(method.getTransfers());
        Acquired result = new Acquired(acquiredRanges);
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void messageResume(Session session, MessageResume method) {
        super.messageResume((Object)session, method);
    }

    public void messageSubscribe(Session session, MessageSubscribe method) {
        if (!method.hasAcceptMode()) {
            method.setAcceptMode(MessageAcceptMode.EXPLICIT);
        }
        if (!method.hasAcquireMode()) {
            method.setAcquireMode(MessageAcquireMode.PRE_ACQUIRED);
        }
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not supplied");
        } else {
            String destination = method.getDestination();
            if (destination == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Subscriber must provide a destination. The protocol specification marking the destination argument as optional is considered a mistake.");
            } else if (((ServerSession)session).getSubscription(destination) != null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Subscription already exists with destination '" + destination + "'");
            } else {
                String queueName = method.getQueue();
                NamedAddressSpace addressSpace = this.getAddressSpace(session);
                HashSet<MessageSource> sources = new HashSet<MessageSource>();
                MessageSource queue = addressSpace.getAttainedMessageSource(queueName);
                if (method.getArguments() != null && method.getArguments().get("x-multiqueue") instanceof Collection) {
                    for (Object object : (Collection)method.getArguments().get("x-multiqueue")) {
                        String sourceName = String.valueOf(object);
                        if ((sourceName = sourceName.trim()).length() == 0) continue;
                        MessageSource source = addressSpace.getAttainedMessageSource(sourceName);
                        if (source == null) {
                            sources.clear();
                            break;
                        }
                        sources.add(source);
                    }
                    queueName = method.getArguments().get("x-multiqueue").toString();
                } else if (queue != null) {
                    sources.add(queue);
                }
                if (sources.isEmpty()) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: " + queueName + " not found");
                } else if (!this.verifySessionAccess((ServerSession)session, sources)) {
                    this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
                } else {
                    AMQPConnection_0_10 protocolEngine = this.getServerConnection(session).getAmqpConnection();
                    WindowCreditManager creditManager = new WindowCreditManager(0L, 0L, (ProtocolEngine)protocolEngine);
                    FilterManager filterManager = null;
                    try {
                        filterManager = FilterManagerFactory.createManager((Map)method.getArguments());
                    }
                    catch (AMQInvalidArgumentException amqe) {
                        this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Exception Creating FilterManager");
                        return;
                    }
                    if (method.hasArguments() && method.getArguments().containsKey(AMQPFilterTypes.REPLAY_PERIOD.toString())) {
                        long period;
                        Object value = method.getArguments().get(AMQPFilterTypes.REPLAY_PERIOD.toString());
                        if (value instanceof Number) {
                            period = ((Number)value).longValue();
                        } else if (value instanceof String) {
                            try {
                                period = Long.parseLong(value.toString());
                            }
                            catch (NumberFormatException e) {
                                this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Cannot parse value " + value + " as a number for filter " + AMQPFilterTypes.REPLAY_PERIOD.toString());
                                return;
                            }
                        } else {
                            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Cannot parse value " + value + " as a number for filter " + AMQPFilterTypes.REPLAY_PERIOD.toString());
                            return;
                        }
                        long startingFrom = System.currentTimeMillis() - 1000L * period;
                        if (filterManager == null) {
                            filterManager = new FilterManager();
                        }
                        ArrivalTimeFilter filter = new ArrivalTimeFilter(startingFrom, period == 0L);
                        filterManager.add(filter.getName(), (MessageFilter)filter);
                    }
                    boolean multiQueue = sources.size() > 1;
                    ConsumerTarget_0_10 target = new ConsumerTarget_0_10((ServerSession)session, destination, method.getAcceptMode(), method.getAcquireMode(), MessageFlowMode.WINDOW, creditManager, method.getArguments(), multiQueue);
                    Integer priority = null;
                    if (method.hasArguments() && method.getArguments().containsKey("x-priority")) {
                        Object value = method.getArguments().get("x-priority");
                        if (value instanceof Number) {
                            priority = ((Number)value).intValue();
                        } else if (value instanceof String) {
                            try {
                                priority = Integer.parseInt(value.toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    ((ServerSession)session).register(destination, target);
                    try {
                        EnumSet<ConsumerImpl.Option> options = EnumSet.noneOf(ConsumerImpl.Option.class);
                        if (method.getAcquireMode() == MessageAcquireMode.PRE_ACQUIRED) {
                            options.add(ConsumerImpl.Option.ACQUIRES);
                        }
                        if (method.getAcquireMode() != MessageAcquireMode.NOT_ACQUIRED || method.getAcceptMode() == MessageAcceptMode.EXPLICIT) {
                            options.add(ConsumerImpl.Option.SEES_REQUEUES);
                        }
                        if (method.getExclusive()) {
                            options.add(ConsumerImpl.Option.EXCLUSIVE);
                        }
                        for (MessageSource source : sources) {
                            ((ServerSession)session).register(source.addConsumer((ConsumerTarget)target, filterManager, MessageTransferMessage.class, destination, options, priority));
                        }
                    }
                    catch (MessageSource.ExistingExclusiveConsumer existing) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an exclusive consumer");
                    }
                    catch (MessageSource.ExistingConsumerPreventsExclusive exclusive) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an existing consumer - can't subscribe exclusively");
                    }
                    catch (AccessControlException e) {
                        this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                    }
                    catch (MessageSource.ConsumerAccessRefused consumerAccessRefused) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an incompatible exclusivity policy");
                    }
                }
            }
        }
    }

    protected boolean verifySessionAccess(ServerSession session, Collection<MessageSource> queues) {
        for (MessageSource source : queues) {
            if (this.verifySessionAccess(session, source)) continue;
            return false;
        }
        return true;
    }

    protected boolean verifySessionAccess(ServerSession session, MessageSource queue) {
        return queue.verifySessionAccess((AMQSessionModel)session);
    }

    private static String getMessageUserId(MessageTransfer xfr) {
        byte[] userIdBytes = xfr.getHeader() == null ? null : (xfr.getHeader().getMessageProperties() == null ? null : xfr.getHeader().getMessageProperties().getUserId());
        return userIdBytes == null ? null : new String(userIdBytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageTransfer(Session ssn, final MessageTransfer xfr) {
        block19: {
            try {
                DeliveryProperties delvProps;
                ServerSession serverSession = (ServerSession)ssn;
                if (serverSession.blockingTimeoutExceeded()) {
                    this.getEventLogger(ssn).message(ChannelMessages.FLOW_CONTROL_IGNORED());
                    serverSession.close(AMQConstant.MESSAGE_TOO_LARGE, "Session flow control was requested, but not enforced by sender");
                    break block19;
                }
                if (xfr.getBodySize() > serverSession.getConnection().getMaxMessageSize()) {
                    this.exception(ssn, (Method)xfr, ExecutionErrorCode.RESOURCE_LIMIT_EXCEEDED, "Message size of " + xfr.getBodySize() + " greater than allowed maximum of " + serverSession.getConnection().getMaxMessageSize());
                    break block19;
                }
                MessageDestination destination = this.getDestinationForMessage(ssn, xfr);
                DeliveryProperties deliveryProperties = delvProps = xfr.getHeader() == null ? null : xfr.getHeader().getDeliveryProperties();
                if (delvProps != null && delvProps.hasTtl() && !delvProps.hasExpiration()) {
                    delvProps.setExpiration(System.currentTimeMillis() + delvProps.getTtl());
                }
                MessageMetaData_0_10 messageMetaData = new MessageMetaData_0_10(xfr);
                NamedAddressSpace virtualHost = this.getAddressSpace(ssn);
                try {
                    serverSession.getAMQPConnection().checkAuthorizedMessagePrincipal(ServerSessionDelegate.getMessageUserId(xfr));
                    serverSession.authorisePublish(destination, messageMetaData.getRoutingKey(), messageMetaData.isImmediate(), serverSession.getAMQPConnection().getLastReadTime());
                }
                catch (AccessControlException e) {
                    ExecutionErrorCode errorCode = ExecutionErrorCode.UNAUTHORIZED_ACCESS;
                    this.exception(ssn, (Method)xfr, errorCode, e.getMessage());
                    xfr.dispose();
                    return;
                }
                MessageStore store = virtualHost.getMessageStore();
                StoredMessage<MessageMetaData_0_10> storeMessage = this.createStoreMessage(xfr, messageMetaData, store);
                final MessageTransferMessage message = new MessageTransferMessage(storeMessage, serverSession.getReference());
                MessageReference reference = message.newReference();
                try {
                    InstanceProperties instanceProperties = new InstanceProperties(){

                        public Object getProperty(InstanceProperties.Property prop) {
                            switch (prop) {
                                case EXPIRATION: {
                                    return message.getExpiration();
                                }
                                case IMMEDIATE: {
                                    return message.isImmediate();
                                }
                                case MANDATORY: {
                                    return (delvProps == null || !delvProps.getDiscardUnroutable()) && xfr.getAcceptMode() == MessageAcceptMode.EXPLICIT;
                                }
                                case PERSISTENT: {
                                    return message.isPersistent();
                                }
                                case REDELIVERED: {
                                    return delvProps.getRedelivered();
                                }
                            }
                            return null;
                        }
                    };
                    int enqueues = serverSession.enqueue(message, instanceProperties, destination);
                    if (enqueues == 0) {
                        if (!(delvProps != null && delvProps.getDiscardUnroutable() || xfr.getAcceptMode() != MessageAcceptMode.EXPLICIT)) {
                            RangeSet rejects = RangeSetFactory.createRangeSet();
                            rejects.add(xfr.getId());
                            MessageReject reject = new MessageReject(rejects, MessageRejectCode.UNROUTABLE, "Unroutable", new Option[0]);
                            ssn.invoke((Method)reject);
                        } else {
                            this.getEventLogger(ssn).message(ExchangeMessages.DISCARDMSG((String)destination.getName(), (String)messageMetaData.getRoutingKey()));
                        }
                    }
                    if (serverSession.isTransactional()) {
                        serverSession.processed((Method)xfr);
                    } else {
                        serverSession.recordFuture((ListenableFuture<Void>)Futures.immediateFuture(null), new CommandProcessedAction(serverSession, (Method)xfr));
                    }
                }
                catch (VirtualHostUnavailableException e) {
                    this.getServerConnection(serverSession).sendConnectionCloseAsync(AMQConstant.CONNECTION_FORCED, e.getMessage());
                }
                finally {
                    reference.release();
                }
            }
            finally {
                xfr.dispose();
            }
        }
    }

    private StoredMessage<MessageMetaData_0_10> createStoreMessage(MessageTransfer xfr, MessageMetaData_0_10 messageMetaData, MessageStore store) {
        MessageHandle addedMessage = store.addMessage((StorableMessageMetaData)messageMetaData);
        Collection body = xfr.getBody();
        if (body != null) {
            for (QpidByteBuffer b : body) {
                addedMessage.addContent(b);
            }
        }
        StoredMessage storedMessage = addedMessage.allContentAdded();
        return storedMessage;
    }

    public void messageCancel(Session session, MessageCancel method) {
        String destination = method.getDestination();
        ConsumerTarget_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            ((ServerSession)session).unregister(sub);
        }
    }

    public void messageFlush(Session session, MessageFlush method) {
        String destination = method.getDestination();
        ConsumerTarget_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.flush();
        }
    }

    public void txSelect(Session session, TxSelect method) {
        ((ServerSession)session).selectTx();
    }

    public void txCommit(Session session, TxCommit method) {
        ((ServerSession)session).commit();
    }

    public void txRollback(Session session, TxRollback method) {
        ((ServerSession)session).rollback();
    }

    public void dtxSelect(Session session, DtxSelect method) {
        ((ServerSession)session).selectDtx();
    }

    public void dtxStart(Session session, DtxStart method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            ((ServerSession)session).startDtx(method.getXid(), method.getJoin(), method.getResume());
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (JoinAndResumeDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Unknown xid " + method.getXid());
        }
        catch (AlreadyKnownDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Xid already started an neither join nor resume set" + method.getXid());
        }
        catch (DtxNotSelectedException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
    }

    public void dtxEnd(Session session, DtxEnd method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).endDtx(method.getXid(), method.getFail(), method.getSuspend());
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (NotAssociatedDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (DtxNotSelectedException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (SuspendAndFailDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
    }

    public void dtxCommit(Session session, DtxCommit method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).commitDtx(method.getXid(), method.getOnePhase());
            }
            catch (RollbackOnlyDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBROLLBACK);
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (StoreException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
            throw e;
        }
    }

    public void dtxForget(Session session, DtxForget method) {
        try {
            ((ServerSession)session).forgetDtx(method.getXid());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
    }

    public void dtxGetTimeout(Session session, DtxGetTimeout method) {
        GetTimeoutResult result = new GetTimeoutResult();
        try {
            result.setTimeout(((ServerSession)session).getTimeoutDtx(method.getXid()));
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
    }

    public void dtxPrepare(Session session, DtxPrepare method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).prepareDtx(method.getXid());
            }
            catch (RollbackOnlyDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBROLLBACK);
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (StoreException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
            throw e;
        }
    }

    public void dtxRecover(Session session, DtxRecover method) {
        RecoverResult result = new RecoverResult();
        List<Xid> inDoubt = ((ServerSession)session).recoverDtx();
        result.setInDoubt(inDoubt);
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void dtxRollback(Session session, DtxRollback method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).rollbackDtx(method.getXid());
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (StoreException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
            throw e;
        }
    }

    public void dtxSetTimeout(Session session, DtxSetTimeout method) {
        try {
            ((ServerSession)session).setTimeoutDtx(method.getXid(), method.getTimeout());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
    }

    public void executionSync(Session ssn, ExecutionSync sync) {
        ((ServerSession)ssn).awaitCommandCompletion();
        super.executionSync(ssn, sync);
    }

    public void exchangeDeclare(Session session, ExchangeDeclare method) {
        Map args;
        String exchangeName = method.getExchange();
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (method.hasArguments() && !(args = method.getArguments()).isEmpty()) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_IMPLEMENTED, "Unsupported exchange argument(s) found " + args.keySet().toString());
            return;
        }
        if (this.nameNullOrEmpty(method.getExchange())) {
            if (!"direct".equals(method.getType())) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare default exchange  of type direct to " + method.getType() + ".");
            }
            if (!this.nameNullOrEmpty(method.getAlternateExchange())) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to set alternate exchange of the default exchange  to " + method.getAlternateExchange() + ".");
            }
        } else if (method.getPassive()) {
            Exchange<?> exchange = this.getExchange(session, exchangeName);
            if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: exchange-name '" + exchangeName + "'");
            } else if (!exchange.getType().equals(method.getType()) && method.getType() != null && method.getType().length() > 0) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getType() + " to " + method.getType() + ".");
            }
        } else {
            try {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", method.getExchange());
                attributes.put("type", method.getType());
                attributes.put("durable", method.getDurable());
                attributes.put("lifetimePolicy", method.getAutoDelete() ? LifetimePolicy.DELETE_ON_NO_LINKS : LifetimePolicy.PERMANENT);
                attributes.put("alternateExchange", method.getAlternateExchange());
                addressSpace.createMessageDestination(Exchange.class, attributes);
            }
            catch (ReservedExchangeNameException e) {
                Exchange<?> existingExchange = this.getExchange(session, exchangeName);
                if (existingExchange == null || !existingExchange.getType().equals(method.getType()) || method.hasAlternateExchange() && (existingExchange.getAlternateExchange() == null || !method.getAlternateExchange().equals(existingExchange.getAlternateExchange().getName()))) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved name or prefix.");
                }
            }
            catch (UnknownConfiguredObjectException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Unknown alternate exchange " + e.getName());
            }
            catch (NoFactoryForTypeException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Unknown Exchange Type: " + method.getType());
            }
            catch (ExchangeExistsException e) {
                Exchange exchange = e.getExistingExchange();
                if (!exchange.getType().equals(method.getType())) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getType() + " to " + method.getType() + ".");
                } else if (method.hasAlternateExchange() && (exchange.getAlternateExchange() == null || !method.getAlternateExchange().equals(exchange.getAlternateExchange().getName()))) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to change alternate exchange of: " + exchangeName + " from " + exchange.getAlternateExchange() + " to " + method.getAlternateExchange() + ".");
                }
            }
            catch (AccessControlException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
            }
        }
    }

    private void exception(Session session, Method method, ExecutionErrorCode errorCode, String description) {
        ExecutionException ex = new ExecutionException();
        ex.setErrorCode(errorCode);
        ex.setCommandId(method.getId());
        ex.setDescription(description);
        session.invoke((Method)ex);
        ((ServerSession)session).close(errorCode.getValue(), description);
    }

    private Exchange<?> getExchange(Session session, String exchangeName) {
        return this.getExchange(this.getAddressSpace(session), exchangeName);
    }

    private Exchange<?> getExchange(NamedAddressSpace addressSpace, String exchangeName) {
        MessageDestination destination = addressSpace.getAttainedMessageDestination(exchangeName);
        return destination instanceof Exchange ? (Exchange)destination : null;
    }

    private Queue<?> getQueue(NamedAddressSpace addressSpace, String name) {
        MessageSource source = addressSpace.getAttainedMessageSource(name);
        return source instanceof Queue ? (Queue)source : null;
    }

    private MessageDestination getDestinationForMessage(Session ssn, MessageTransfer xfr) {
        MessageDestination destination;
        NamedAddressSpace addressSpace = this.getAddressSpace(ssn);
        if (xfr.hasDestination()) {
            destination = addressSpace.getAttainedMessageDestination(xfr.getDestination());
            if (destination == null) {
                destination = addressSpace.getDefaultDestination();
            }
        } else {
            destination = addressSpace.getDefaultDestination();
        }
        return destination;
    }

    private NamedAddressSpace getAddressSpace(Session session) {
        ServerConnection conn = this.getServerConnection(session);
        return conn.getAddressSpace();
    }

    private ServerConnection getServerConnection(Session session) {
        return (ServerConnection)session.getConnection();
    }

    private <T> T getContextValue(Session session, Class<T> clazz, String name) {
        return (T)this.getServerConnection(session).getAmqpConnection().getContextProvider().getContextValue(clazz, name);
    }

    private EventLogger getEventLogger(Session session) {
        return this.getServerConnection(session).getAmqpConnection().getEventLogger();
    }

    public void exchangeDelete(Session session, ExchangeDelete method) {
        if (this.nameNullOrEmpty(method.getExchange())) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Delete not allowed for default exchange");
            return;
        }
        Exchange<?> exchange = this.getExchange(session, method.getExchange());
        if (exchange == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No such exchange '" + method.getExchange() + "'");
        } else if (method.getIfUnused() && exchange.hasBindings()) {
            this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Exchange has bindings");
        } else {
            try {
                exchange.delete();
            }
            catch (ExchangeIsAlternateException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Exchange in use as an alternate exchange");
            }
            catch (RequiredExchangeException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Exchange '" + method.getExchange() + "' cannot be deleted");
            }
            catch (AccessControlException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
            }
        }
    }

    private boolean nameNullOrEmpty(String name) {
        return name == null || name.length() == 0;
    }

    public void exchangeQuery(Session session, ExchangeQuery method) {
        ExchangeQueryResult result = new ExchangeQueryResult();
        String exchangeName = method.getName();
        if (this.nameNullOrEmpty(exchangeName)) {
            result.setDurable(true);
            result.setType("direct");
            result.setNotFound(false);
        } else {
            Exchange<?> exchange = this.getExchange(session, exchangeName);
            if (exchange != null) {
                result.setDurable(exchange.isDurable());
                result.setType(exchange.getType());
                result.setNotFound(false);
            } else {
                result.setNotFound(true);
            }
        }
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void exchangeBind(Session session, ExchangeBind method) {
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else {
            String exchangeName = method.getExchange();
            if (this.nameNullOrEmpty(exchangeName)) {
                this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Bind not allowed for default exchange");
            } else {
                if (!method.hasBindingKey()) {
                    method.setBindingKey(method.getQueue());
                }
                Queue<?> queue = this.getQueue(addressSpace, method.getQueue());
                Exchange<?> exchange = this.getExchange(addressSpace, exchangeName);
                if (queue == null) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
                } else if (exchange == null) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + exchangeName + "' not found");
                } else if (!(!exchange.getType().equals("headers") || method.hasArguments() && method.getArguments() != null && method.getArguments().containsKey("x-match"))) {
                    this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, "Bindings to an exchange of type headers require an x-match header");
                } else if (!exchange.isBound(method.getBindingKey(), method.getArguments(), queue)) {
                    try {
                        exchange.addBinding(method.getBindingKey(), queue, method.getArguments());
                    }
                    catch (AccessControlException e) {
                        this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                    }
                }
            }
        }
    }

    public void exchangeUnbind(Session session, ExchangeUnbind method) {
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else if (this.nameNullOrEmpty(method.getExchange())) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Unbind not allowed for default exchange");
        } else if (!method.hasBindingKey()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "binding-key not set");
        } else {
            Queue<?> queue = this.getQueue(addressSpace, method.getQueue());
            Exchange<?> exchange = this.getExchange(addressSpace, method.getExchange());
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
            } else if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + method.getExchange() + "' not found");
            } else {
                try {
                    if (exchange.hasBinding(method.getBindingKey(), queue)) {
                        exchange.deleteBinding(method.getBindingKey(), queue);
                    }
                }
                catch (AccessControlException e) {
                    this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                }
            }
        }
    }

    public void exchangeBound(Session session, ExchangeBound method) {
        Exchange<?> exchange;
        boolean isDefaultExchange;
        ExchangeBoundResult result = new ExchangeBoundResult();
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        if (!this.nameNullOrEmpty(method.getExchange())) {
            isDefaultExchange = false;
            exchange = this.getExchange(addressSpace, method.getExchange());
            if (exchange == null) {
                result.setExchangeNotFound(true);
            }
        } else {
            isDefaultExchange = true;
            exchange = null;
        }
        if (isDefaultExchange) {
            if (method.hasQueue()) {
                Queue<?> queue = this.getQueue(session, method.getQueue());
                if (queue == null) {
                    result.setQueueNotFound(true);
                } else if (method.hasBindingKey() && !method.getBindingKey().equals(method.getQueue())) {
                    result.setKeyNotMatched(true);
                }
            } else if (method.hasBindingKey() && this.getQueue(session, method.getBindingKey()) == null) {
                result.setKeyNotMatched(true);
            }
            if (method.hasArguments() && !method.getArguments().isEmpty()) {
                result.setArgsNotMatched(true);
            }
        } else if (method.hasQueue()) {
            MessageSource source = this.getMessageSource(session, method.getQueue());
            if (source == null) {
                result.setQueueNotFound(true);
            }
            if (source == null || source instanceof Queue) {
                Queue queue = (Queue)source;
                if (exchange != null && queue != null) {
                    boolean queueMatched = exchange.isBound(queue);
                    result.setQueueNotMatched(!queueMatched);
                    if (method.hasBindingKey()) {
                        if (queueMatched) {
                            boolean keyMatched = exchange.isBound(method.getBindingKey(), queue);
                            result.setKeyNotMatched(!keyMatched);
                            if (method.hasArguments()) {
                                if (keyMatched) {
                                    result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments(), queue));
                                } else {
                                    result.setArgsNotMatched(!exchange.isBound(method.getArguments(), queue));
                                }
                            }
                        } else {
                            boolean keyMatched = exchange.isBound(method.getBindingKey());
                            result.setKeyNotMatched(!keyMatched);
                            if (method.hasArguments()) {
                                if (keyMatched) {
                                    result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments()));
                                } else {
                                    result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                                }
                            }
                        }
                    } else if (method.hasArguments()) {
                        if (queueMatched) {
                            result.setArgsNotMatched(!exchange.isBound(method.getArguments(), queue));
                        } else {
                            result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                        }
                    }
                } else if (exchange != null && method.hasBindingKey()) {
                    boolean keyMatched = exchange.isBound(method.getBindingKey());
                    result.setKeyNotMatched(!keyMatched);
                    if (method.hasArguments()) {
                        if (keyMatched) {
                            result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments()));
                        } else {
                            result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                        }
                    }
                }
            }
        } else if (exchange != null && method.hasBindingKey()) {
            boolean keyMatched = exchange.isBound(method.getBindingKey());
            result.setKeyNotMatched(!keyMatched);
            if (method.hasArguments()) {
                if (keyMatched) {
                    result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments()));
                } else {
                    result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
                }
            }
        } else if (exchange != null && method.hasArguments()) {
            result.setArgsNotMatched(!exchange.isBound(method.getArguments()));
        }
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    private MessageSource getMessageSource(Session session, String queue) {
        return this.getAddressSpace(session).getAttainedMessageSource(queue);
    }

    private Queue<?> getQueue(Session session, String queue) {
        return this.getQueue(this.getAddressSpace(session), queue);
    }

    public void queueDeclare(Session session, QueueDeclare method) {
        NamedAddressSpace addressSpace = this.getAddressSpace(session);
        String queueName = method.getQueue();
        boolean exclusive = method.getExclusive();
        boolean autoDelete = method.getAutoDelete();
        if (method.getPassive()) {
            Queue<?> queue = this.getQueue(addressSpace, queueName);
            if (queue == null) {
                String description = "Queue: " + queueName + " not found on VirtualHost(" + addressSpace + ").";
                ExecutionErrorCode errorCode = ExecutionErrorCode.NOT_FOUND;
                this.exception(session, (Method)method, errorCode, description);
            } else if (exclusive) {
                if (queue.getExclusive() == ExclusivityPolicy.NONE) {
                    String description = "Cannot passively declare queue ('" + queueName + "')" + " as exclusive as queue with same name is" + " already declared as non-exclusive";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                    this.exception(session, (Method)method, errorCode, description);
                } else if (!this.verifySessionAccess((ServerSession)session, (MessageSource)queue)) {
                    String description = "Cannot passively declare queue('" + queueName + "')," + " as exclusive queue with same name " + "declared on another session";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                    this.exception(session, (Method)method, errorCode, description);
                }
            }
        } else {
            try {
                String alternateExchangeName = method.getAlternateExchange();
                Map arguments = QueueArgumentsConverter.convertWireArgsToModel((Map)method.getArguments());
                if (alternateExchangeName != null && alternateExchangeName.length() != 0) {
                    arguments.put("alternateExchange", alternateExchangeName);
                }
                UUID id = UUID.randomUUID();
                arguments.put("id", id);
                arguments.put("name", queueName);
                if (!arguments.containsKey("lifetimePolicy")) {
                    LifetimePolicy lifetime = autoDelete ? (exclusive ? LifetimePolicy.DELETE_ON_SESSION_END : LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS) : LifetimePolicy.PERMANENT;
                    arguments.put("lifetimePolicy", lifetime);
                }
                if (!arguments.containsKey("exclusive")) {
                    ExclusivityPolicy exclusivityPolicy = exclusive ? ExclusivityPolicy.SESSION : ExclusivityPolicy.NONE;
                    arguments.put("exclusive", exclusivityPolicy);
                }
                arguments.put("durable", method.getDurable());
                Queue queue = (Queue)addressSpace.createMessageSource(Queue.class, arguments);
            }
            catch (QueueExistsException qe) {
                Queue queue = qe.getExistingQueue();
                if (!this.verifySessionAccess((ServerSession)session, (MessageSource)queue)) {
                    String description = "Cannot declare queue('" + queueName + "')," + " as exclusive queue with same name " + "declared on another session";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                    this.exception(session, (Method)method, errorCode, description);
                }
            }
            catch (AccessControlException e) {
                this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
            }
        }
    }

    public void queueDelete(Session session, QueueDelete method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "No queue name supplied");
        } else {
            Queue<?> queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else if (!this.verifySessionAccess((ServerSession)session, (MessageSource)queue)) {
                this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
            } else if (method.getIfEmpty() && !queue.isEmpty()) {
                this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " not empty");
            } else if (method.getIfUnused() && !queue.isUnused()) {
                this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " in use");
            } else {
                try {
                    queue.delete();
                }
                catch (AccessControlException e) {
                    this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                }
            }
        }
    }

    public void queuePurge(Session session, QueuePurge method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "No queue name supplied");
        } else {
            Queue<?> queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else {
                try {
                    queue.clearQueue();
                }
                catch (AccessControlException e) {
                    this.exception(session, (Method)method, ExecutionErrorCode.UNAUTHORIZED_ACCESS, e.getMessage());
                }
            }
        }
    }

    public void queueQuery(Session session, QueueQuery method) {
        QueueQueryResult result = new QueueQueryResult();
        MessageSource source = this.getMessageSource(session, method.getQueue());
        if (source != null) {
            result.setQueue(source.getName());
            if (source instanceof Queue) {
                Queue queue = (Queue)source;
                result.setDurable(queue.isDurable());
                result.setExclusive(queue.isExclusive());
                result.setAutoDelete(queue.getLifetimePolicy() != LifetimePolicy.PERMANENT);
                LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>();
                Collection availableAttrs = queue.getAvailableAttributes();
                for (String attrName : availableAttrs) {
                    arguments.put(attrName, queue.getAttribute(attrName));
                }
                result.setArguments(QueueArgumentsConverter.convertModelArgsToWire(arguments));
                result.setMessageCount((long)queue.getQueueDepthMessages());
                result.setSubscriberCount((long)queue.getConsumerCount());
            } else {
                result.setDurable(true);
                result.setExclusive(false);
                result.setAutoDelete(false);
                result.setMessageCount(Integer.MAX_VALUE);
                result.setSubscriberCount(0L);
            }
        }
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void messageSetFlowMode(Session session, MessageSetFlowMode sfm) {
        String destination = sfm.getDestination();
        ConsumerTarget_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)sfm, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else if (sub.isStopped()) {
            sub.setFlowMode(sfm.getFlowMode());
        }
    }

    public void messageStop(Session session, MessageStop stop) {
        String destination = stop.getDestination();
        ConsumerTarget_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)stop, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.stop();
        }
    }

    public void messageFlow(Session session, MessageFlow flow) {
        String destination = flow.getDestination();
        ConsumerTarget_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)flow, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.addCredit(flow.getUnit(), flow.getValue());
        }
    }

    public void closed(Session session) {
        ServerSession serverSession = (ServerSession)session;
        serverSession.stopSubscriptions();
        serverSession.onClose();
        serverSession.unregisterSubscriptions();
    }

    public void detached(Session session) {
        this.closed(session);
    }

    private static class CommandProcessedAction
    implements ServerTransaction.Action {
        private final ServerSession _serverSession;
        private final Method _method;

        public CommandProcessedAction(ServerSession serverSession, Method xfr) {
            this._serverSession = serverSession;
            this._method = xfr;
        }

        public void postCommit() {
            this._serverSession.processed(this._method);
        }

        public void onRollback() {
        }
    }
}

