/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.logging.subjects.ChannelLogSubject;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.CapacityChecker;
import org.apache.qpid.server.protocol.ConsumerListener;
import org.apache.qpid.server.protocol.PublishAuthorisationCache;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.AsyncAutoCommitTransaction;
import org.apache.qpid.server.txn.DistributedTransaction;
import org.apache.qpid.server.txn.DtxNotSelectedException;
import org.apache.qpid.server.txn.IncorrectDtxStateException;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.RollbackOnlyDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.Deletable;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.MessageCreditUnit;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageSetFlowMode;
import org.apache.qpid.transport.MessageStop;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Range;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RangeSetFactory;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDelegate;
import org.apache.qpid.transport.Xid;
import org.apache.qpid.transport.network.Ticker;
import org.apache.qpid.util.Serial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSession
extends Session
implements AMQSessionModel<ServerSession>,
LogSubject,
AsyncAutoCommitTransaction.FutureRecorder,
Deletable<ServerSession> {
    private static final Logger _logger = LoggerFactory.getLogger(ServerSession.class);
    private static final String NULL_DESTINATION = UUID.randomUUID().toString();
    private static final int PRODUCER_CREDIT_TOPUP_THRESHOLD = 0x40000000;
    private static final int UNFINISHED_COMMAND_QUEUE_THRESHOLD = 500;
    private final UUID _id = UUID.randomUUID();
    private final Subject _subject = new Subject();
    private final AccessControlContext _accessControllerContext;
    private final SecurityToken _token;
    private long _createTime = System.currentTimeMillis();
    private final Set<Object> _blockingEntities = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean _blocking = new AtomicBoolean(false);
    private ChannelLogSubject _logSubject;
    private final AtomicInteger _outstandingCredit = new AtomicInteger(-1);
    private final CheckCapacityAction _checkCapacityAction = new CheckCapacityAction();
    private final CopyOnWriteArrayList<ConsumerListener> _consumerListeners = new CopyOnWriteArrayList();
    private final ConfigurationChangeListener _consumerClosedListener = new ConsumerClosedListener();
    private org.apache.qpid.server.model.Session<?> _modelObject;
    private long _blockTime;
    private long _blockingTimeout;
    private boolean _wireBlockingState;
    private final List<ConsumerTarget> _consumersWithPendingWork = new ArrayList<ConsumerTarget>();
    private final PublishAuthorisationCache _publishAuthCahe;
    private final SortedMap<Integer, MessageDispositionChangeListener> _messageDispositionListenerMap = new ConcurrentSkipListMap<Integer, MessageDispositionChangeListener>();
    private ServerTransaction _transaction;
    private final AtomicLong _txnStarts = new AtomicLong(0L);
    private final AtomicLong _txnCommits = new AtomicLong(0L);
    private final AtomicLong _txnRejects = new AtomicLong(0L);
    private final AtomicLong _txnCount = new AtomicLong(0L);
    private Map<String, ConsumerTarget_0_10> _subscriptions = new ConcurrentHashMap<String, ConsumerTarget_0_10>();
    private final CopyOnWriteArrayList<Consumer<?>> _consumers = new CopyOnWriteArrayList();
    private final List<Action<? super ServerSession>> _taskList = new CopyOnWriteArrayList<Action<? super ServerSession>>();
    private AtomicReference<LogMessage> _forcedCloseLogMessage = new AtomicReference();
    private volatile long _uncommittedMessageSize;
    private final List<StoredMessage<MessageMetaData_0_10>> _uncommittedMessages = new ArrayList<StoredMessage<MessageMetaData_0_10>>();
    private long _maxUncommittedInMemorySize;
    private final LinkedList<AsyncCommand> _unfinishedCommandsQueue = new LinkedList();

    public ServerSession(Connection connection, SessionDelegate delegate, Binary name, long expiry) {
        super(connection, delegate, name, expiry);
        this._transaction = new AsyncAutoCommitTransaction(this.getMessageStore(), (AsyncAutoCommitTransaction.FutureRecorder)this);
        this._logSubject = new ChannelLogSubject((AMQSessionModel)this);
        ServerConnection serverConnection = (ServerConnection)connection;
        AMQPConnection_0_10 amqpConnection = serverConnection.getAmqpConnection();
        this._subject.getPrincipals().addAll(serverConnection.getAuthorizedSubject().getPrincipals());
        this._subject.getPrincipals().add((Principal)new SessionPrincipal((AMQSessionModel)this));
        this._accessControllerContext = amqpConnection.getAccessControlContextFromSubject(this._subject);
        NamedAddressSpace addressSpace = serverConnection.getAddressSpace();
        this._token = addressSpace instanceof ConfiguredObject ? ((ConfiguredObject)addressSpace).newToken(this._subject) : amqpConnection.getBroker().newToken(this._subject);
        this._blockingTimeout = (Long)serverConnection.getBroker().getContextValue(Long.class, "channel.flowControlEnforcementTimeout");
        this._maxUncommittedInMemorySize = (Long)this.getConnection().getAmqpConnection().getContextProvider().getContextValue(Long.class, "connection.maxUncommittedInMemorySize");
        this._publishAuthCahe = new PublishAuthorisationCache(this._token, ((Long)amqpConnection.getContextValue(Long.class, "producer.authCacheTimeout")).longValue(), ((Integer)amqpConnection.getContextValue(Integer.class, "producer.authCacheSize")).intValue());
    }

    public AccessControlContext getAccessControllerContext() {
        return this._accessControllerContext;
    }

    protected void setState(final Session.State state) {
        if (this.runningAsSubject()) {
            super.setState(state);
            if (state == Session.State.OPEN) {
                this.getConnection().getAmqpConnection().getEventLogger().message(ChannelMessages.CREATE());
            }
        } else {
            this.runAsSubject(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServerSession.this.setState(state);
                    return null;
                }
            });
        }
    }

    private <T> T runAsSubject(PrivilegedAction<T> privilegedAction) {
        return AccessController.doPrivileged(privilegedAction, this.getAccessControllerContext());
    }

    private boolean runningAsSubject() {
        return this.getAuthorizedSubject().equals(Subject.getSubject(AccessController.getContext()));
    }

    private void invokeBlock() {
        this.invoke((Method)new MessageSetFlowMode("", MessageFlowMode.CREDIT, new Option[0]));
        this.invoke((Method)new MessageStop("", new Option[0]));
    }

    private void invokeUnblock() {
        MessageFlow mf = new MessageFlow();
        mf.setUnit(MessageCreditUnit.MESSAGE);
        mf.setDestination("");
        this._outstandingCredit.set(Integer.MAX_VALUE);
        mf.setValue(Integer.MAX_VALUE);
        this.invoke((Method)mf);
    }

    void authorisePublish(MessageDestination destination, String routingKey, boolean immediate, long currentTime) {
        this._publishAuthCahe.authorisePublish(destination, routingKey, immediate, currentTime);
    }

    protected boolean isFull(int id) {
        return this.isCommandsFull(id);
    }

    public int enqueue(MessageTransferMessage message, InstanceProperties instanceProperties, MessageDestination exchange) {
        if (this._outstandingCredit.get() != -1 && this._outstandingCredit.decrementAndGet() == 0x3FFFFFFF) {
            this._outstandingCredit.addAndGet(0x40000000);
            this.invoke((Method)new MessageFlow("", MessageCreditUnit.MESSAGE, 0x40000000L, new Option[0]));
        }
        long arrivalTime = message.getArrivalTime();
        int enqueues = exchange.send((ServerMessage)message, message.getInitialRoutingAddress(), instanceProperties, this._transaction, (Action)this._checkCapacityAction);
        this.getAMQPConnection().registerMessageReceived(message.getSize(), arrivalTime);
        this.incrementOutstandingTxnsIfNecessary();
        this.incrementUncommittedMessageSize((StoredMessage<MessageMetaData_0_10>)message.getStoredMessage());
        return enqueues;
    }

    private void resetUncommittedMessages() {
        this._uncommittedMessageSize = 0L;
        this._uncommittedMessages.clear();
    }

    private void incrementUncommittedMessageSize(StoredMessage<MessageMetaData_0_10> handle) {
        if (this.isTransactional() && !(this._transaction instanceof DistributedTransaction)) {
            this._uncommittedMessageSize += (long)((MessageMetaData_0_10)handle.getMetaData()).getContentSize();
            if (this._uncommittedMessageSize > this.getMaxUncommittedInMemorySize()) {
                handle.flowToDisk();
                if (!this._uncommittedMessages.isEmpty() || this._uncommittedMessageSize == (long)((MessageMetaData_0_10)handle.getMetaData()).getContentSize()) {
                    this.getConnection().getAmqpConnection().getEventLogger().message((LogSubject)this._logSubject, ChannelMessages.LARGE_TRANSACTION_WARN((Number)this._uncommittedMessageSize));
                }
                if (!this._uncommittedMessages.isEmpty()) {
                    for (StoredMessage<MessageMetaData_0_10> uncommittedHandle : this._uncommittedMessages) {
                        uncommittedHandle.flowToDisk();
                    }
                    this._uncommittedMessages.clear();
                }
            } else {
                this._uncommittedMessages.add(handle);
            }
        }
    }

    public void sendMessage(MessageTransfer xfr, Runnable postIdSettingAction) {
        this.getAMQPConnection().registerMessageDelivered(xfr.getBodySize());
        this.invoke((Method)xfr, postIdSettingAction);
    }

    public void onMessageDispositionChange(MessageTransfer xfr, MessageDispositionChangeListener acceptListener) {
        this._messageDispositionListenerMap.put(xfr.getId(), acceptListener);
    }

    public void accept(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            @Override
            public void performAction(MessageDispositionChangeListener listener) {
                listener.onAccept();
            }
        });
    }

    public void release(RangeSet ranges, final boolean setRedelivered) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            @Override
            public void performAction(MessageDispositionChangeListener listener) {
                listener.onRelease(setRedelivered);
            }
        });
    }

    public void reject(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            @Override
            public void performAction(MessageDispositionChangeListener listener) {
                listener.onReject();
            }
        });
    }

    public RangeSet acquire(RangeSet transfers) {
        RangeSet acquired = RangeSetFactory.createRangeSet();
        if (!this._messageDispositionListenerMap.isEmpty()) {
            Iterator<Integer> unacceptedMessages = this._messageDispositionListenerMap.keySet().iterator();
            Iterator rangeIter = transfers.iterator();
            if (rangeIter.hasNext()) {
                Range range = (Range)rangeIter.next();
                while (range != null && unacceptedMessages.hasNext()) {
                    MessageDispositionChangeListener changeListener;
                    int next = unacceptedMessages.next();
                    while (Serial.gt((int)next, (int)range.getUpper())) {
                        if (rangeIter.hasNext()) {
                            range = (Range)rangeIter.next();
                            continue;
                        }
                        range = null;
                        break;
                    }
                    if (range == null || !range.includes(next) || (changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.get(next)) == null || !changeListener.acquire()) continue;
                    acquired.add(next);
                }
            }
        }
        return acquired;
    }

    public void dispositionChange(RangeSet ranges, MessageDispositionAction action) {
        block5: {
            block6: {
                if (ranges == null) break block5;
                if (ranges.size() != 1) break block6;
                Range r = ranges.getFirst();
                for (int i = r.getLower(); i <= r.getUpper(); ++i) {
                    MessageDispositionChangeListener changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.remove(i);
                    if (changeListener == null) continue;
                    action.performAction(changeListener);
                }
                break block5;
            }
            if (this._messageDispositionListenerMap.isEmpty()) break block5;
            Iterator<Integer> unacceptedMessages = this._messageDispositionListenerMap.keySet().iterator();
            Iterator rangeIter = ranges.iterator();
            if (rangeIter.hasNext()) {
                Range range = (Range)rangeIter.next();
                while (range != null && unacceptedMessages.hasNext()) {
                    int next = unacceptedMessages.next();
                    while (Serial.gt((int)next, (int)range.getUpper())) {
                        if (rangeIter.hasNext()) {
                            range = (Range)rangeIter.next();
                            continue;
                        }
                        range = null;
                        break;
                    }
                    if (range == null || !range.includes(next)) continue;
                    MessageDispositionChangeListener changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.remove(next);
                    action.performAction(changeListener);
                }
            }
        }
    }

    public void removeDispositionListener(Method method) {
        this._messageDispositionListenerMap.remove(method.getId());
    }

    public void onClose() {
        if (this._transaction instanceof LocalTransaction) {
            this._transaction.rollback();
        } else if (this._transaction instanceof DistributedTransaction) {
            this.getAddressSpace().getDtxRegistry().endAssociations((AMQSessionModel)this);
        }
        for (MessageDispositionChangeListener messageDispositionChangeListener : this._messageDispositionListenerMap.values()) {
            messageDispositionChangeListener.onRelease(true);
        }
        this._messageDispositionListenerMap.clear();
        for (Action action : this._taskList) {
            action.performAction((Object)this);
        }
        LogMessage operationalLoggingMessage = this._forcedCloseLogMessage.get();
        if (operationalLoggingMessage == null) {
            operationalLoggingMessage = ChannelMessages.CLOSE();
        }
        this.getConnection().getAmqpConnection().getEventLogger().message(this.getLogSubject(), operationalLoggingMessage);
    }

    protected void awaitClose() {
    }

    public void acknowledge(final ConsumerImpl consumer, ConsumerTarget_0_10 target, final MessageInstance entry) {
        if (entry.makeAcquisitionUnstealable(consumer)) {
            this._transaction.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

                public void postCommit() {
                    entry.delete();
                }

                public void onRollback() {
                    entry.setRedelivered();
                    entry.release(consumer);
                }
            });
        }
    }

    Collection<ConsumerTarget_0_10> getSubscriptions() {
        return this._subscriptions.values();
    }

    public void register(String destination, ConsumerTarget_0_10 sub) {
        this._subscriptions.put(destination == null ? NULL_DESTINATION : destination, sub);
    }

    public void register(ConsumerImpl consumerImpl) {
        if (consumerImpl instanceof Consumer) {
            Consumer consumer = (Consumer)consumerImpl;
            this._consumers.add(consumer);
            consumer.addChangeListener(this._consumerClosedListener);
            this.consumerAdded(consumer);
        }
    }

    public ConsumerTarget_0_10 getSubscription(String destination) {
        return this._subscriptions.get(destination == null ? NULL_DESTINATION : destination);
    }

    public void unregister(ConsumerTarget_0_10 sub) {
        this._subscriptions.remove(sub.getName());
        sub.close();
    }

    public boolean isTransactional() {
        return this._transaction.isTransactional();
    }

    public void selectTx() {
        this._transaction = new LocalTransaction(this.getMessageStore());
        this._txnStarts.incrementAndGet();
    }

    public void selectDtx() {
        this._transaction = new DistributedTransaction((AMQSessionModel)this, this.getAddressSpace().getDtxRegistry());
    }

    public void startDtx(Xid xid, boolean join, boolean resume) throws JoinAndResumeDtxException, UnknownDtxBranchException, AlreadyKnownDtxException, DtxNotSelectedException {
        DistributedTransaction distributedTransaction = this.assertDtxTransaction();
        distributedTransaction.start(xid, join, resume);
    }

    public void endDtx(Xid xid, boolean fail, boolean suspend) throws NotAssociatedDtxException, UnknownDtxBranchException, DtxNotSelectedException, SuspendAndFailDtxException, TimeoutDtxException {
        DistributedTransaction distributedTransaction = this.assertDtxTransaction();
        distributedTransaction.end(xid, fail, suspend);
    }

    public long getTimeoutDtx(Xid xid) throws UnknownDtxBranchException {
        return this.getAddressSpace().getDtxRegistry().getTimeout(xid);
    }

    public void setTimeoutDtx(Xid xid, long timeout) throws UnknownDtxBranchException {
        this.getAddressSpace().getDtxRegistry().setTimeout(xid, timeout);
    }

    public void prepareDtx(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, RollbackOnlyDtxException, TimeoutDtxException {
        this.getAddressSpace().getDtxRegistry().prepare(xid);
    }

    public void commitDtx(Xid xid, boolean onePhase) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, RollbackOnlyDtxException, TimeoutDtxException {
        this.getAddressSpace().getDtxRegistry().commit(xid, onePhase);
    }

    public void rollbackDtx(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, TimeoutDtxException {
        this.getAddressSpace().getDtxRegistry().rollback(xid);
    }

    public void forgetDtx(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException {
        this.getAddressSpace().getDtxRegistry().forget(xid);
    }

    public List<Xid> recoverDtx() {
        return this.getAddressSpace().getDtxRegistry().recover();
    }

    private DistributedTransaction assertDtxTransaction() throws DtxNotSelectedException {
        if (this._transaction instanceof DistributedTransaction) {
            return (DistributedTransaction)this._transaction;
        }
        throw new DtxNotSelectedException();
    }

    public void commit() {
        this._transaction.commit();
        this._txnCommits.incrementAndGet();
        this._txnStarts.incrementAndGet();
        this.decrementOutstandingTxnsIfNecessary();
        this.resetUncommittedMessages();
    }

    public void rollback() {
        this._transaction.rollback();
        this._txnRejects.incrementAndGet();
        this._txnStarts.incrementAndGet();
        this.decrementOutstandingTxnsIfNecessary();
        this.resetUncommittedMessages();
    }

    private void incrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(0L, 1L);
        }
    }

    private void decrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(1L, 0L);
        }
    }

    public Long getTxnCommits() {
        return this._txnCommits.get();
    }

    public Long getTxnRejects() {
        return this._txnRejects.get();
    }

    public int getChannelId() {
        return this.getChannel();
    }

    public Long getTxnCount() {
        return this._txnCount.get();
    }

    public Long getTxnStart() {
        return this._txnStarts.get();
    }

    public Principal getAuthorizedPrincipal() {
        return this.getConnection().getAuthorizedPrincipal();
    }

    public Subject getAuthorizedSubject() {
        return this._subject;
    }

    public void addDeleteTask(Action<? super ServerSession> task) {
        this._taskList.add(task);
    }

    public void removeDeleteTask(Action<? super ServerSession> task) {
        this._taskList.remove(task);
    }

    public Object getReference() {
        return this.getConnection().getReference();
    }

    public MessageStore getMessageStore() {
        return this.getAddressSpace().getMessageStore();
    }

    public NamedAddressSpace getAddressSpace() {
        return this.getConnection().getAddressSpace();
    }

    public boolean isDurable() {
        return false;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public UUID getId() {
        return this._id;
    }

    public AMQPConnection_0_10 getAMQPConnection() {
        return this.getConnection().getAmqpConnection();
    }

    public ServerConnection getConnection() {
        return (ServerConnection)super.getConnection();
    }

    public LogSubject getLogSubject() {
        return this;
    }

    public void block(Queue<?> queue) {
        this.block(queue, queue.getName());
    }

    public void block() {
        this.block((Object)this, "** All Queues **");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block(Object queue, String name) {
        Set<Object> set = this._blockingEntities;
        synchronized (set) {
            if (this._blockingEntities.add(queue) && this._blocking.compareAndSet(false, true)) {
                this.getConnection().getAmqpConnection().getEventLogger().message((LogSubject)this._logSubject, ChannelMessages.FLOW_ENFORCED((String)name));
                if (this.getState() == Session.State.OPEN) {
                    this.getConnection().notifyWork();
                }
            }
        }
    }

    public void unblock(Queue<?> queue) {
        this.unblock((Object)queue);
    }

    public void unblock() {
        this.unblock((Object)this);
    }

    private void unblock(Object queue) {
        if (this._blockingEntities.remove(queue) && this._blockingEntities.isEmpty() && this._blocking.compareAndSet(true, false) && !this.isClosing()) {
            this.getConnection().getAmqpConnection().getEventLogger().message((LogSubject)this._logSubject, ChannelMessages.FLOW_REMOVED());
            this.getConnection().notifyWork();
        }
    }

    boolean blockingTimeoutExceeded() {
        long blockTime = this._blockTime;
        boolean b = this._wireBlockingState && blockTime != 0L && System.currentTimeMillis() - blockTime > this._blockingTimeout;
        return b;
    }

    public void transportStateChanged() {
        for (ConsumerTarget_0_10 consumerTarget : this.getSubscriptions()) {
            consumerTarget.transportStateChanged();
        }
    }

    public Object getConnectionReference() {
        return this.getConnection().getReference();
    }

    public String toLogString() {
        long connectionId = super.getConnection() instanceof ServerConnection ? this.getConnection().getConnectionId() : -1L;
        String authorizedPrincipal = this.getAuthorizedPrincipal() == null ? "?" : this.getAuthorizedPrincipal().getName();
        String remoteAddress = String.valueOf(this.getConnection().getRemoteSocketAddress());
        return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})/ch:{4}", connectionId, authorizedPrincipal, remoteAddress, this.getAddressSpace().getName(), this.getChannel()) + "] ";
    }

    public void close(AMQConstant cause, String message) {
        if (cause == null) {
            this.close();
        } else {
            this.close(cause.getCode(), message);
        }
    }

    void close(int cause, String message) {
        this._forcedCloseLogMessage.compareAndSet(null, ChannelMessages.CLOSE_FORCED((Number)cause, (String)message));
        this.close();
    }

    public void close() {
        this.unregisterSubscriptions();
        if (this._modelObject != null) {
            this._modelObject.delete();
        }
        super.close();
    }

    void unregisterSubscriptions() {
        Collection<ConsumerTarget_0_10> subscriptions = this.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subscriptions) {
            this.unregister(subscription_0_10);
        }
    }

    void stopSubscriptions() {
        Collection<ConsumerTarget_0_10> subscriptions = this.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subscriptions) {
            subscription_0_10.stop();
        }
    }

    public void receivedComplete() {
        Collection<ConsumerTarget_0_10> subscriptions = this.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subscriptions) {
            subscription_0_10.flushCreditState(false);
        }
        this.awaitCommandCompletion();
    }

    public int getUnacknowledgedMessageCount() {
        return this._messageDispositionListenerMap.size();
    }

    public boolean getBlocking() {
        return this._blocking.get();
    }

    public void completeAsyncCommands() {
        AsyncCommand cmd;
        while ((cmd = this._unfinishedCommandsQueue.peek()) != null && cmd.isReadyForCompletion()) {
            cmd.complete();
            this._unfinishedCommandsQueue.poll();
        }
        while (this._unfinishedCommandsQueue.size() > 500) {
            cmd = this._unfinishedCommandsQueue.poll();
            cmd.complete();
        }
    }

    public void awaitCommandCompletion() {
        AsyncCommand cmd;
        while ((cmd = this._unfinishedCommandsQueue.poll()) != null) {
            cmd.complete();
        }
    }

    public Object getAsyncCommandMark() {
        return this._unfinishedCommandsQueue.isEmpty() ? null : this._unfinishedCommandsQueue.getLast();
    }

    public void recordFuture(ListenableFuture<Void> future, ServerTransaction.Action action) {
        this._unfinishedCommandsQueue.add(new AsyncCommand(future, action));
    }

    protected void setClose(boolean close) {
        super.setClose(close);
    }

    public int getConsumerCount() {
        return this._subscriptions.values().size();
    }

    public Collection<Consumer<?>> getConsumers() {
        return Collections.unmodifiableCollection(this._consumers);
    }

    public void addConsumerListener(ConsumerListener listener) {
        this._consumerListeners.add(listener);
    }

    public void removeConsumerListener(ConsumerListener listener) {
        this._consumerListeners.remove(listener);
    }

    public void setModelObject(org.apache.qpid.server.model.Session<?> session) {
        this._modelObject = session;
    }

    public org.apache.qpid.server.model.Session<?> getModelObject() {
        return this._modelObject;
    }

    public long getTransactionStartTime() {
        ServerTransaction serverTransaction = this._transaction;
        if (serverTransaction.isTransactional()) {
            return serverTransaction.getTransactionStartTime();
        }
        return 0L;
    }

    public long getTransactionUpdateTime() {
        ServerTransaction serverTransaction = this._transaction;
        if (serverTransaction.isTransactional()) {
            return serverTransaction.getTransactionUpdateTime();
        }
        return 0L;
    }

    private void consumerAdded(Consumer<?> consumer) {
        for (ConsumerListener l : this._consumerListeners) {
            l.consumerAdded(consumer);
        }
    }

    private void consumerRemoved(Consumer<?> consumer) {
        for (ConsumerListener l : this._consumerListeners) {
            l.consumerRemoved(consumer);
        }
    }

    public boolean processPending() {
        boolean consumerListNeedsRefreshing;
        if (!this.getAMQPConnection().isIOThread()) {
            return false;
        }
        boolean desiredBlockingState = this._blocking.get();
        if (desiredBlockingState != this._wireBlockingState) {
            this._wireBlockingState = desiredBlockingState;
            if (desiredBlockingState) {
                this.invokeBlock();
            } else {
                this.invokeUnblock();
            }
            long l = this._blockTime = desiredBlockingState ? System.currentTimeMillis() : 0L;
        }
        if (this._consumersWithPendingWork.isEmpty()) {
            this._consumersWithPendingWork.addAll(this.getSubscriptions());
            consumerListNeedsRefreshing = false;
        } else {
            consumerListNeedsRefreshing = true;
        }
        Iterator iter = this._consumersWithPendingWork.isEmpty() ? Collections.emptyIterator() : this._consumersWithPendingWork.iterator();
        boolean consumerHasMoreWork = false;
        while (iter.hasNext()) {
            ConsumerTarget target = (ConsumerTarget)iter.next();
            iter.remove();
            if (!target.hasPendingWork()) continue;
            consumerHasMoreWork = true;
            target.processPending();
            break;
        }
        return consumerHasMoreWork || consumerListNeedsRefreshing;
    }

    public void addTicker(Ticker ticker) {
        this.getConnection().getAmqpConnection().getAggregateTicker().addTicker(ticker);
        this.getAMQPConnection().notifyWork();
    }

    public void removeTicker(Ticker ticker) {
        this.getConnection().getAmqpConnection().getAggregateTicker().removeTicker(ticker);
    }

    public void notifyConsumerTargetCurrentStates() {
        Collection<ConsumerTarget_0_10> consumerTargets = this.getSubscriptions();
        for (ConsumerTarget_0_10 consumerTarget : consumerTargets) {
            if (consumerTarget.isPullOnly()) continue;
            consumerTarget.notifyCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureConsumersNoticedStateChange() {
        Collection<ConsumerTarget_0_10> consumerTargets = this.getSubscriptions();
        for (ConsumerTarget_0_10 consumerTarget : consumerTargets) {
            try {
                consumerTarget.getSendLock();
            }
            finally {
                consumerTarget.releaseSendLock();
            }
        }
    }

    public void doTimeoutAction(String reason) {
        this.getAMQPConnection().closeSessionAsync(this, AMQConstant.RESOURCE_ERROR, reason);
    }

    public final long getMaxUncommittedInMemorySize() {
        return this._maxUncommittedInMemorySize;
    }

    public int compareTo(AMQSessionModel o) {
        return this.getId().compareTo(o.getId());
    }

    private class ConsumerClosedListener
    implements ConfigurationChangeListener {
        private ConsumerClosedListener() {
        }

        public void stateChanged(ConfiguredObject object, State oldState, State newState) {
            if (newState == State.DELETED) {
                ServerSession.this.consumerRemoved((Consumer)object);
            }
        }

        public void childAdded(ConfiguredObject object, ConfiguredObject child) {
        }

        public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        }

        public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        }

        public void bulkChangeStart(ConfiguredObject<?> object) {
        }

        public void bulkChangeEnd(ConfiguredObject<?> object) {
        }
    }

    private class CheckCapacityAction
    implements Action<MessageInstance> {
        private CheckCapacityAction() {
        }

        public void performAction(MessageInstance entry) {
            TransactionLogResource queue = entry.getOwningResource();
            if (queue instanceof CapacityChecker) {
                ((CapacityChecker)queue).checkCapacity((AMQSessionModel)ServerSession.this);
            }
        }
    }

    private static class AsyncCommand {
        private final ListenableFuture<Void> _future;
        private ServerTransaction.Action _action;

        public AsyncCommand(ListenableFuture<Void> future, ServerTransaction.Action action) {
            this._future = future;
            this._action = action;
        }

        void complete() {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        this._future.get();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new ServerScopedRuntimeException(e.getCause());
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this._action.postCommit();
            this._action = null;
        }

        boolean isReadyForCompletion() {
            return this._future.isDone();
        }
    }

    private static interface MessageDispositionAction {
        public void performAction(MessageDispositionChangeListener var1);
    }

    public static interface MessageDispositionChangeListener {
        public void onAccept();

        public void onRelease(boolean var1);

        public void onReject();

        public boolean acquire();
    }
}

