/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.util.List;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.transport.codec.AbstractDecoder;

final class ServerDecoder
extends AbstractDecoder {
    private final List<QpidByteBuffer> _underlying;
    private int _bufferIndex;

    ServerDecoder(List<QpidByteBuffer> in) {
        this._underlying = in;
        this._bufferIndex = 0;
    }

    private void advanceIfNecessary() {
        while (!this.getCurrentBuffer().hasRemaining() && this._bufferIndex != this._underlying.size() - 1) {
            ++this._bufferIndex;
        }
    }

    private QpidByteBuffer getBuffer(int size) {
        this.advanceIfNecessary();
        QpidByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() >= size) {
            return currentBuffer;
        }
        return this.readAsQpidByteBuffer(size);
    }

    private QpidByteBuffer readAsQpidByteBuffer(int len) {
        QpidByteBuffer currentBuffer = this.getCurrentBuffer();
        if (currentBuffer.remaining() >= len) {
            QpidByteBuffer buf = currentBuffer.slice();
            buf.limit(len);
            currentBuffer.position(currentBuffer.position() + len);
            return buf;
        }
        QpidByteBuffer dest = QpidByteBuffer.allocate((int)len);
        while (dest.hasRemaining() && this.available() > 0) {
            this.advanceIfNecessary();
            currentBuffer = this.getCurrentBuffer();
            int remaining = dest.remaining();
            if (currentBuffer.remaining() >= remaining) {
                QpidByteBuffer buf = currentBuffer.slice();
                buf.limit(remaining);
                currentBuffer.position(currentBuffer.position() + remaining);
                dest.put(buf);
                buf.dispose();
                continue;
            }
            dest.put(currentBuffer);
        }
        dest.flip();
        return dest;
    }

    private int available() {
        int remaining = 0;
        for (int i = this._bufferIndex; i < this._underlying.size(); ++i) {
            remaining += this._underlying.get(i).remaining();
        }
        return remaining;
    }

    private QpidByteBuffer getCurrentBuffer() {
        return this._underlying.get(this._bufferIndex);
    }

    protected byte doGet() {
        return this.getBuffer(1).get();
    }

    protected void doGet(byte[] bytes) {
        this.getBuffer(bytes.length).get(bytes);
    }

    public boolean hasRemaining() {
        return this.available() != 0;
    }

    public short readUint8() {
        return (short)(0xFF & this.getBuffer(1).get());
    }

    public int readUint16() {
        return 0xFFFF & this.getBuffer(2).getShort();
    }

    public long readUint32() {
        return 0xFFFFFFFFL & (long)this.getBuffer(4).getInt();
    }

    public long readUint64() {
        return this.getBuffer(8).getLong();
    }

    public byte[] readBin128() {
        byte[] result = new byte[16];
        this.get(result);
        return result;
    }

    public byte[] readBytes(int howManyBytes) {
        byte[] result = new byte[howManyBytes];
        this.get(result);
        return result;
    }

    public double readDouble() {
        return this.getBuffer(8).getDouble();
    }

    public float readFloat() {
        return this.getBuffer(4).getFloat();
    }

    public short readInt16() {
        return this.getBuffer(2).getShort();
    }

    public int readInt32() {
        return this.getBuffer(4).getInt();
    }

    public byte readInt8() {
        return this.getBuffer(1).get();
    }

    public byte[] readRemainingBytes() {
        byte[] result = new byte[this.available()];
        this.get(result);
        return result;
    }

    public long readInt64() {
        return this.getBuffer(8).getLong();
    }
}

