/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImplicitAcceptDispositionChangeListener
implements ServerSession.MessageDispositionChangeListener {
    private static final Logger _logger = LoggerFactory.getLogger(ImplicitAcceptDispositionChangeListener.class);
    private final MessageInstance _entry;
    private final ConsumerTarget_0_10 _target;
    private final ConsumerImpl _consumer;

    public ImplicitAcceptDispositionChangeListener(MessageInstance entry, ConsumerTarget_0_10 target, ConsumerImpl consumer) {
        this._entry = entry;
        this._target = target;
        this._consumer = consumer;
    }

    @Override
    public void onAccept() {
        _logger.warn("MessageAccept received for message which is using NONE as the accept mode (likely client error)");
    }

    @Override
    public void onRelease(boolean setRedelivered) {
        this._target.release(this._consumer, this._entry, setRedelivered);
    }

    @Override
    public void onReject() {
        this._target.reject(this._consumer, this._entry);
    }

    @Override
    public boolean acquire() {
        boolean acquired = this._entry.acquire(this._consumer);
        if (acquired) {
            this._target.addUnacknowledgedMessage(this._entry);
        }
        return acquired;
    }
}

