/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.framing;

import java.util.Formatter;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.ConnectionHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ProtocolHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameHandler
implements ProtocolHandler {
    public static Logger LOGGER = LoggerFactory.getLogger(FrameHandler.class);
    private final boolean _isSasl;
    private ConnectionHandler _connection;
    private ValueHandler _typeHandler;
    private boolean _errored = false;

    public FrameHandler(AMQPConnection_1_0 connection, boolean sasl) {
        this._connection = connection;
        this._typeHandler = new ValueHandler(connection.getDescribedTypeRegistry());
        this._isSasl = sasl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProtocolHandler parse(QpidByteBuffer in) {
        try {
            int remaining;
            Error frameParsingError = null;
            while ((remaining = in.remaining()) >= 8 && frameParsingError == null) {
                int size = in.getInt();
                if (size < 8) {
                    frameParsingError = this.createFramingError("specified frame size %d smaller than minimum frame header size %d", size, 8);
                    break;
                }
                if (size > this._connection.getMaxFrameSize()) {
                    frameParsingError = this.createFramingError("specified frame size %d larger than maximum frame header size %d", size, this._connection.getMaxFrameSize());
                    break;
                }
                if (remaining < size) {
                    in.position(in.position() - 4);
                    break;
                }
                int dataOffset = in.get() << 2 & 0x3FF;
                if (dataOffset < 8) {
                    frameParsingError = this.createFramingError("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                    break;
                }
                if (dataOffset > size) {
                    frameParsingError = this.createFramingError("specified frame data offset %d larger than the frame size %d", dataOffset, size);
                    break;
                }
                byte type = in.get();
                switch (type) {
                    case 0: {
                        if (!this._isSasl) break;
                        frameParsingError = this.createFramingError("received an AMQP frame type when expecting an SASL frame", new Object[0]);
                        break;
                    }
                    case 1: {
                        if (this._isSasl) break;
                        frameParsingError = this.createFramingError("received a SASL frame type when expecting an AMQP frame", new Object[0]);
                        break;
                    }
                    default: {
                        frameParsingError = this.createFramingError("unknown frame type: %d", type);
                    }
                }
                if (frameParsingError != null) break;
                int channel = in.getShort() & 0xFFFF;
                if (dataOffset != 8) {
                    in.position(in.position() + dataOffset - 8);
                }
                QpidByteBuffer dup = in.slice();
                dup.limit(size - dataOffset);
                in.position(in.position() + size - dataOffset);
                try {
                    Object val;
                    Object object = val = dup.hasRemaining() ? this._typeHandler.parse(dup) : null;
                    if (dup.hasRemaining()) {
                        if (val instanceof Transfer) {
                            ((Transfer)val).setPayload(dup.slice());
                        } else {
                            frameParsingError = this.createFramingError("Frame length %d larger than contained frame body %s.", size, val);
                        }
                    }
                    this._connection.receive((short)channel, val);
                }
                catch (AmqpErrorException ex) {
                    frameParsingError = ex.getError();
                }
                finally {
                    dup.dispose();
                }
            }
            if (frameParsingError != null) {
                this._connection.handleError(frameParsingError);
                this._errored = true;
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Unexpected exception handling frame", (Throwable)e);
            this._connection.handleError(this.createError(ConnectionError.CONNECTION_FORCED, e.toString(), new Object[0]));
        }
        return this;
    }

    private Error createFramingError(String description, Object ... args) {
        return this.createError(ConnectionError.FRAMING_ERROR, description, args);
    }

    private Error createError(ErrorCondition framingError, String description, Object ... args) {
        Error error = new Error();
        error.setCondition(framingError);
        Formatter formatter = new Formatter();
        error.setDescription(formatter.format(description, args).toString());
        return error;
    }

    @Override
    public boolean isDone() {
        return this._errored || this._connection.closedForInput();
    }
}

