/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.framing;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.framing.TransportFrame;
import org.apache.qpid.server.protocol.v1_0.type.FrameBody;

public abstract class AMQFrame<T> {
    private T _frameBody;
    private QpidByteBuffer _payload;

    AMQFrame(T frameBody) {
        this._frameBody = frameBody;
    }

    protected AMQFrame(T frameBody, QpidByteBuffer payload) {
        this._frameBody = frameBody;
        this._payload = payload;
    }

    public QpidByteBuffer getPayload() {
        return this._payload;
    }

    public static TransportFrame createAMQFrame(short channel, FrameBody frameBody) {
        return AMQFrame.createAMQFrame(channel, frameBody, null);
    }

    public static TransportFrame createAMQFrame(short channel, FrameBody frameBody, QpidByteBuffer payload) {
        return new TransportFrame(channel, frameBody, payload);
    }

    public abstract short getChannel();

    public abstract byte getFrameType();

    public T getFrameBody() {
        return this._frameBody;
    }

    public String toString() {
        return "AMQFrame{frameBody=" + this._frameBody + '}';
    }
}

