/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedShort;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class UShortTypeConstructor
implements TypeConstructor {
    private static final UShortTypeConstructor INSTANCE = new UShortTypeConstructor();

    public static UShortTypeConstructor getInstance() {
        return INSTANCE;
    }

    private UShortTypeConstructor() {
    }

    public Object construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 2) {
            short s = in.getShort();
            return UnsignedShort.valueOf(s);
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct ushort: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

