/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.charset.Charset;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthWriter;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class SymbolWriter
extends VariableWidthWriter<Symbol> {
    private static final Charset ENCODING_CHARSET = Charset.forName("US-ASCII");
    public static final byte LARGE_ENCODING_CODE = -77;
    public static final byte SMALL_ENCODING_CODE = -93;
    private Symbol _value;
    private static ValueWriter.Factory<Symbol> FACTORY = new ValueWriter.Factory<Symbol>(){

        @Override
        public ValueWriter<Symbol> newInstance(ValueWriter.Registry registry) {
            return new SymbolWriter();
        }
    };

    @Override
    protected byte getFourOctetEncodingCode() {
        return -77;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -93;
    }

    @Override
    public void setValue(Symbol value) {
        this._value = value;
        super.setValue(value);
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    protected void clearValue() {
        this._value = null;
    }

    @Override
    protected boolean hasValue() {
        return this._value != null;
    }

    @Override
    protected int getLength() {
        return this._value.length();
    }

    @Override
    protected void writeBytes(QpidByteBuffer buf, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            buf.put((byte)this._value.charAt(i));
        }
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Symbol.class, FACTORY);
    }
}

