/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;

public class StringTypeConstructor
extends VariableWidthTypeConstructor {
    private Charset _charSet;

    public static StringTypeConstructor getInstance(int i, Charset c) {
        return new StringTypeConstructor(i, c);
    }

    private StringTypeConstructor(int size, Charset c) {
        super(size);
        this._charSet = c;
    }

    @Override
    public Object construct(QpidByteBuffer in, boolean isCopy, ValueHandler handler) throws AmqpErrorException {
        int size = this.getSize() == 1 ? in.get() & 0xFF : in.getInt();
        int origPosition = in.position();
        QpidByteBuffer dup = in.duplicate();
        try {
            dup.limit(dup.position() + size);
            CharBuffer charBuf = dup.decode(this._charSet);
            String str = charBuf.toString();
            in.position(origPosition + size);
            String string = str;
            return string;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("position: " + dup.position() + "size: " + size + " capacity: " + dup.capacity());
        }
        finally {
            dup.dispose();
        }
    }
}

