/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class SmallIntConstructor
implements TypeConstructor {
    private static final SmallIntConstructor INSTANCE = new SmallIntConstructor();

    public static SmallIntConstructor getInstance() {
        return INSTANCE;
    }

    private SmallIntConstructor() {
    }

    public Object construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining()) {
            byte b = in.get();
            return (int)b;
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct int: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

