/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.FixedEightWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class LongWriter
implements ValueWriter<Long> {
    private static final byte EIGHT_BYTE_FORMAT_CODE = -127;
    private static final byte ONE_BYTE_FORMAT_CODE = 85;
    private ValueWriter<Long> _delegate;
    private final FixedEightWriter<Long> _eightByteWriter = new FixedEightWriter<Long>(){

        @Override
        byte getFormatCode() {
            return -127;
        }

        @Override
        long convertValueToLong(Long value) {
            return value;
        }
    };
    private final ValueWriter<Long> _oneByteWriter = new FixedOneWriter<Long>(){

        @Override
        protected byte getFormatCode() {
            return 85;
        }

        @Override
        protected byte convertToByte(Long value) {
            return value.byteValue();
        }
    };
    private static ValueWriter.Factory<Long> FACTORY = new ValueWriter.Factory<Long>(){

        @Override
        public ValueWriter<Long> newInstance(ValueWriter.Registry registry) {
            return new LongWriter();
        }
    };

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        return this._delegate.writeToBuffer(buffer);
    }

    @Override
    public void setValue(Long l) {
        this._delegate = l >= -128L && l <= 127L ? this._oneByteWriter : this._eightByteWriter;
        this._delegate.setValue(l);
    }

    @Override
    public boolean isComplete() {
        return this._delegate.isComplete();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Long.class, FACTORY);
    }
}

