/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.FixedFourWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class IntegerWriter
implements ValueWriter<Integer> {
    private static final byte EIGHT_BYTE_FORMAT_CODE = 113;
    private static final byte ONE_BYTE_FORMAT_CODE = 84;
    private ValueWriter<Integer> _delegate;
    private final FixedFourWriter<Integer> _eightByteWriter = new FixedFourWriter<Integer>(){

        @Override
        byte getFormatCode() {
            return 113;
        }

        @Override
        int convertValueToInt(Integer value) {
            return value;
        }
    };
    private final ValueWriter<Integer> _oneByteWriter = new FixedOneWriter<Integer>(){

        @Override
        protected byte getFormatCode() {
            return 84;
        }

        @Override
        protected byte convertToByte(Integer value) {
            return value.byteValue();
        }
    };
    private static ValueWriter.Factory<Integer> FACTORY = new ValueWriter.Factory<Integer>(){

        @Override
        public ValueWriter<Integer> newInstance(ValueWriter.Registry registry) {
            return new IntegerWriter();
        }
    };

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        return this._delegate.writeToBuffer(buffer);
    }

    @Override
    public void setValue(Integer i) {
        this._delegate = i >= -128 && i <= 127 ? this._oneByteWriter : this._eightByteWriter;
        this._delegate.setValue(i);
    }

    @Override
    public boolean isComplete() {
        return this._delegate.isComplete();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Integer.class, FACTORY);
    }
}

