/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public abstract class CompoundWriter<V>
implements ValueWriter<V> {
    private int _length;
    private ValueWriter.Registry _registry;
    private static final int LARGE_COMPOUND_THRESHOLD_COUNT = 25;
    private ValueWriter _delegate;
    private State _state = State.FORMAT_CODE;

    public CompoundWriter(ValueWriter.Registry registry) {
        this._registry = registry;
    }

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        return this.writeToBuffer(buffer, false);
    }

    /*
     * Unable to fully structure code
     */
    public int writeToBuffer(QpidByteBuffer buffer, boolean large) {
        block24: {
            block23: {
                length = this._length;
                if (length != -1) break block23;
                this.writeFirstPass(buffer, large != false || this.getCount() > 25 ? 4 : 1);
                if (this._delegate != null && this._delegate.isComplete()) {
                    this._delegate = null;
                }
                break block24;
            }
            size = (length & -256) == 0 ? 1 : 4;
            count = this.getCount();
            typeLength = length - (1 + size);
            state = this._state;
            block0 : switch (1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[state.ordinal()]) {
                case 1: {
                    if (!buffer.hasRemaining()) break;
                    buffer.put(size == 1 ? this.getSingleOctetEncodingCode() : this.getFourOctetEncodingCode());
                    state = State.SIZE_0;
                }
                case 2: {
                    if (size != 4) ** GOTO lbl25
                    if (buffer.remaining() >= 4) {
                        buffer.putInt(typeLength);
                        state = State.COUNT_0;
                    }
                    ** GOTO lbl30
lbl25:
                    // 1 sources

                    if (size == 1) {
                        if (!buffer.hasRemaining()) break;
                        buffer.put((byte)typeLength);
                        state = State.COUNT_0;
                    }
                }
lbl30:
                // 5 sources

                case 3: 
                case 4: {
                    if (state != State.COUNT_0 && buffer.remaining() >= 2) {
                        buffer.putShort((short)(typeLength >> (3 - state.ordinal() << 3) & 65535));
                        state = state == State.SIZE_0 ? State.SIZE_2 : (state == State.SIZE_1 ? State.SIZE_3 : State.COUNT_0);
                    }
                }
                case 5: {
                    if (state != State.COUNT_0 && buffer.hasRemaining()) {
                        buffer.put((byte)(typeLength >> (4 - state.ordinal() << 3) & 255));
                        state = state == State.SIZE_0 ? State.SIZE_1 : (state == State.SIZE_1 ? State.SIZE_2 : (state == State.SIZE_2 ? State.SIZE_3 : State.COUNT_0));
                    }
                }
                case 6: {
                    if (size != 4) ** GOTO lbl47
                    if (buffer.remaining() >= 4) {
                        buffer.putInt(count);
                        state = State.DELEGATING;
                    }
                    ** GOTO lbl52
lbl47:
                    // 1 sources

                    if (size == 1) {
                        if (!buffer.hasRemaining()) break;
                        buffer.put((byte)count);
                        state = State.DELEGATING;
                    }
                }
lbl52:
                // 5 sources

                case 7: 
                case 8: {
                    if (state != State.DELEGATING && buffer.remaining() >= 2) {
                        buffer.putShort((short)(count >> (7 - state.ordinal() << 3) & 65535));
                        state = state == State.COUNT_0 ? State.COUNT_2 : (state == State.COUNT_1 ? State.COUNT_3 : State.DELEGATING);
                    }
                }
                case 9: {
                    if (state != State.DELEGATING && buffer.hasRemaining()) {
                        buffer.put((byte)(count >> (8 - state.ordinal() << 3) & 255));
                        state = state == State.COUNT_0 ? State.COUNT_1 : (state == State.COUNT_1 ? State.COUNT_2 : (state == State.COUNT_2 ? State.COUNT_3 : State.DELEGATING));
                    }
                }
                case 10: {
                    while (state == State.DELEGATING && buffer.hasRemaining()) {
                        if (this._delegate == null || this._delegate.isComplete()) {
                            if (this.hasNext()) {
                                val = this.next();
                                this._delegate = this._registry.getValueWriter(val);
                            } else {
                                state = State.DONE;
                                break block0;
                            }
                        }
                        this._delegate.writeToBuffer(buffer);
                    }
                    break;
                }
            }
            this._state = state;
        }
        return this._length;
    }

    private void writeFirstPass(QpidByteBuffer buffer, int size) {
        int length;
        State state = State.FORMAT_CODE;
        int origPosition = buffer.position();
        if (size == 4) {
            if (buffer.hasRemaining()) {
                buffer.put(this.getFourOctetEncodingCode());
                if (buffer.remaining() >= 4) {
                    buffer.position(buffer.position() + 4);
                    state = State.COUNT_0;
                } else {
                    state = State.values()[buffer.remaining() + 1];
                    buffer.position(buffer.limit());
                }
                switch (buffer.remaining()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        buffer.put((byte)(this.getCount() >> 24 & 0xFF));
                        state = State.COUNT_1;
                        break;
                    }
                    case 2: {
                        buffer.putShort((short)(this.getCount() >> 16 & 0xFFFF));
                        state = State.COUNT_2;
                        break;
                    }
                    case 3: {
                        buffer.putShort((short)(this.getCount() >> 16 & 0xFFFF));
                        buffer.put((byte)(this.getCount() >> 8 & 0xFF));
                        state = State.COUNT_3;
                        break;
                    }
                    default: {
                        buffer.putInt(this.getCount());
                        state = State.DELEGATING;
                    }
                }
            }
            length = 9;
        } else {
            if (buffer.hasRemaining()) {
                buffer.put(this.getSingleOctetEncodingCode());
                if (buffer.hasRemaining()) {
                    buffer.put((byte)0);
                    if (buffer.hasRemaining()) {
                        buffer.put((byte)this.getCount());
                        state = State.DELEGATING;
                    } else {
                        state = State.COUNT_0;
                    }
                } else {
                    state = State.SIZE_0;
                }
            }
            length = 3;
        }
        int iterPos = -1;
        for (int i = 0; i < this.getCount(); ++i) {
            Object val = this.next();
            ValueWriter<Object> writer = this._registry.getValueWriter(val);
            if (writer == null) {
                System.out.println("no writer for " + val);
            }
            length += writer.writeToBuffer(buffer);
            if (iterPos == -1 && !writer.isComplete()) {
                iterPos = i;
                this._delegate = writer;
            }
            if (size != 1 || length <= 255) continue;
            this.reset();
            buffer.position(origPosition);
            this.writeFirstPass(buffer, 4);
            return;
        }
        if (buffer.limit() - origPosition >= 2) {
            buffer.position(origPosition + 1);
            if (size == 1) {
                buffer.put((byte)((length & 0xFF) - 2));
            } else {
                switch (buffer.remaining()) {
                    case 1: {
                        buffer.put((byte)(length - 5 >> 24 & 0xFF));
                        break;
                    }
                    case 2: {
                        buffer.putShort((short)(length - 5 >> 16 & 0xFFFF));
                        break;
                    }
                    case 3: {
                        buffer.putShort((short)(length - 5 >> 16 & 0xFFFF));
                        buffer.put((byte)(length - 5 >> 8 & 0xFF));
                        break;
                    }
                    default: {
                        buffer.putInt(length - 5);
                    }
                }
            }
        }
        if (buffer.limit() - origPosition >= length) {
            buffer.position(origPosition + length);
            state = State.DONE;
        } else {
            this.reset();
            while (iterPos-- >= 0) {
                this.next();
            }
            buffer.position(buffer.limit());
        }
        this._state = state;
        this._length = length;
    }

    protected abstract byte getFourOctetEncodingCode();

    protected abstract byte getSingleOctetEncodingCode();

    @Override
    public void setValue(V value) {
        this._length = -1;
        this._delegate = null;
        this._state = State.FORMAT_CODE;
        this.onSetValue(value);
    }

    public void setRegistry(ValueWriter.Registry registry) {
        this._registry = registry;
    }

    public ValueWriter.Registry getRegistry() {
        return this._registry;
    }

    protected abstract void onSetValue(V var1);

    protected abstract int getCount();

    protected abstract boolean hasNext();

    protected abstract Object next();

    protected abstract void clear();

    protected abstract void reset();

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return this._state == State.DONE;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State;

        static {
            $SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State = new int[State.values().length];
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.FORMAT_CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.SIZE_0.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.SIZE_1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.SIZE_2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.SIZE_3.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.COUNT_0.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.COUNT_1.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.COUNT_2.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.COUNT_3.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$qpid$server$protocol$v1_0$codec$CompoundWriter$State[State.DELEGATING.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    static enum State {
        FORMAT_CODE,
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        COUNT_0,
        COUNT_1,
        COUNT_2,
        COUNT_3,
        DELEGATING,
        DONE;

    }
}

