/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.CompoundTypeAssembler;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class CompoundTypeConstructor
extends VariableWidthTypeConstructor {
    private final CompoundTypeAssembler.Factory _assemblerFactory;
    public static final CompoundTypeAssembler.Factory LIST_ASSEMBLER_FACTORY = new CompoundTypeAssembler.Factory(){

        @Override
        public CompoundTypeAssembler newInstance() {
            return new ListAssembler();
        }
    };
    public static final CompoundTypeAssembler.Factory MAP_ASSEMBLER_FACTORY = new CompoundTypeAssembler.Factory(){

        @Override
        public CompoundTypeAssembler newInstance() {
            return new MapAssembler();
        }
    };

    public static CompoundTypeConstructor getInstance(int i, CompoundTypeAssembler.Factory assemblerFactory) {
        return new CompoundTypeConstructor(i, assemblerFactory);
    }

    private CompoundTypeConstructor(int size, CompoundTypeAssembler.Factory assemblerFactory) {
        super(size);
        this._assemblerFactory = assemblerFactory;
    }

    @Override
    public Object construct(QpidByteBuffer in, boolean isCopy, ValueHandler delegate) throws AmqpErrorException {
        int count;
        int size;
        if (this.getSize() == 1) {
            size = in.get() & 0xFF;
            count = in.get() & 0xFF;
        } else {
            size = in.getInt();
            count = in.getInt();
        }
        CompoundTypeAssembler assembler = this._assemblerFactory.newInstance();
        assembler.init(count);
        for (int i = 0; i < count; ++i) {
            assembler.addItem(delegate.parse(in));
        }
        return assembler.complete();
    }

    private static class MapAssembler
    implements CompoundTypeAssembler {
        private Map _map;
        private Object _lastKey;
        private static final Object NOT_A_KEY = new Object();

        private MapAssembler() {
        }

        @Override
        public void init(int count) throws AmqpErrorException {
            if ((count & 1) == 1) {
                Error error = new Error();
                error.setCondition(AmqpError.DECODE_ERROR);
                Formatter formatter = new Formatter();
                formatter.format("map cannot have odd number of elements: %d", count);
                error.setDescription(formatter.toString());
                throw new AmqpErrorException(error);
            }
            this._map = new HashMap(count);
            this._lastKey = NOT_A_KEY;
        }

        @Override
        public void addItem(Object obj) throws AmqpErrorException {
            if (this._lastKey != NOT_A_KEY) {
                if (this._map.put(this._lastKey, obj) != null) {
                    Error error = new Error();
                    error.setCondition(AmqpError.DECODE_ERROR);
                    Formatter formatter = new Formatter();
                    formatter.format("map cannot have duplicate keys: %s has values (%s, %s)", this._lastKey, this._map.get(this._lastKey), obj);
                    error.setDescription(formatter.toString());
                    throw new AmqpErrorException(error);
                }
                this._lastKey = NOT_A_KEY;
            } else {
                this._lastKey = obj;
            }
        }

        @Override
        public Object complete() throws AmqpErrorException {
            return this._map;
        }
    }

    private static class ListAssembler
    implements CompoundTypeAssembler {
        private List _list;

        private ListAssembler() {
        }

        @Override
        public void init(int count) throws AmqpErrorException {
            this._list = new ArrayList(count);
        }

        @Override
        public void addItem(Object obj) throws AmqpErrorException {
            this._list.add(obj);
        }

        @Override
        public Object complete() throws AmqpErrorException {
            return this._list;
        }

        public String toString() {
            return "ListAssembler{_list=" + this._list + '}';
        }
    }
}

