/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class BooleanWriter
implements ValueWriter<Boolean> {
    private boolean _complete = true;
    private boolean _value;
    private static ValueWriter.Factory<Boolean> FACTORY = new ValueWriter.Factory<Boolean>(){

        @Override
        public ValueWriter<Boolean> newInstance(ValueWriter.Registry registry) {
            return new BooleanWriter();
        }
    };

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        if (!this._complete & buffer.hasRemaining()) {
            buffer.put(this._value ? (byte)65 : 66);
            this._complete = true;
        }
        return 1;
    }

    @Override
    public void setValue(Boolean value) {
        this._complete = false;
        this._value = value;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Boolean.class, FACTORY);
    }
}

