/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public abstract class AbstractDescribedTypeWriter<V>
implements ValueWriter<V> {
    private int _length;
    private ValueWriter.Registry _registry;
    private static final int LARGE_COMPOUND_THRESHOLD_COUNT = 10;
    private ValueWriter _delegate;
    private static final byte DESCRIBED_TYPE = 0;
    private State _state = State.FORMAT_CODE;

    public AbstractDescribedTypeWriter(ValueWriter.Registry registry) {
        this._registry = registry;
    }

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        int length = this._length;
        if (length == -1) {
            this.writeFirstPass(buffer);
        } else {
            State state = this._state;
            switch (state) {
                case FORMAT_CODE: {
                    if (!buffer.hasRemaining()) break;
                    buffer.put((byte)0);
                    state = State.DESCRIPTOR;
                    this._delegate = this.createDescriptorWriter();
                }
                case DESCRIPTOR: {
                    if (buffer.hasRemaining()) {
                        this._delegate.writeToBuffer(buffer);
                        if (!this._delegate.isComplete()) break;
                        state = State.DESCRIBED;
                        this._delegate = this.createDescribedWriter();
                    }
                }
                case DESCRIBED: {
                    if (!buffer.hasRemaining()) break;
                    this._delegate.writeToBuffer(buffer);
                    if (!this._delegate.isComplete()) break;
                    state = State.DONE;
                    this._delegate = null;
                }
            }
            this._state = state;
        }
        return this._length;
    }

    private void writeFirstPass(QpidByteBuffer buffer) {
        int length = 1;
        State state = State.FORMAT_CODE;
        ValueWriter descriptorWriter = this.createDescriptorWriter();
        if (buffer.hasRemaining()) {
            buffer.put((byte)0);
            state = State.DESCRIPTOR;
            this._delegate = descriptorWriter;
        }
        length += descriptorWriter.writeToBuffer(buffer);
        ValueWriter describedWriter = this.createDescribedWriter();
        if (descriptorWriter.isComplete()) {
            state = State.DESCRIBED;
            this._delegate = describedWriter;
        }
        length += describedWriter.writeToBuffer(buffer);
        if (describedWriter.isComplete()) {
            this._delegate = null;
            state = State.DONE;
        }
        this._state = state;
        this._length = length;
    }

    @Override
    public void setValue(V value) {
        this._length = -1;
        this._delegate = null;
        this._state = State.FORMAT_CODE;
        this.onSetValue(value);
    }

    public void setRegistry(ValueWriter.Registry registry) {
        this._registry = registry;
    }

    protected ValueWriter.Registry getRegistry() {
        return this._registry;
    }

    protected abstract void onSetValue(V var1);

    protected abstract void clear();

    protected abstract ValueWriter createDescribedWriter();

    protected abstract Object getDescriptor();

    protected final ValueWriter createDescriptorWriter() {
        return this.getRegistry().getValueWriter(this.getDescriptor());
    }

    @Override
    public boolean isComplete() {
        return this._state == State.DONE;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    static enum State {
        FORMAT_CODE,
        DESCRIPTOR,
        DESCRIBED,
        DONE;

    }
}

