/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.ConsumerListener;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.ConsumerTarget_1_0;
import org.apache.qpid.server.protocol.v1_0.Delivery;
import org.apache.qpid.server.protocol.v1_0.ExchangeDestination;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.LinkEventListener;
import org.apache.qpid.server.protocol.v1_0.MessageSourceDestination;
import org.apache.qpid.server.protocol.v1_0.NodeReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.QueueDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkListener;
import org.apache.qpid.server.protocol.v1_0.ReceivingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.SendingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.SendingLinkListener;
import org.apache.qpid.server.protocol.v1_0.SendingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.SequenceNumber;
import org.apache.qpid.server.protocol.v1_0.SessionState;
import org.apache.qpid.server.protocol.v1_0.TxnCoordinatorLink_1_0;
import org.apache.qpid.server.protocol.v1_0.framing.OversizeFrameException;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.FrameBody;
import org.apache.qpid.server.protocol.v1_0.type.LifetimePolicy;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnClose;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnNoLinks;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnNoLinksOrMessages;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeleteOnNoMessages;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Coordinator;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TxnCapability;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Begin;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Disposition;
import org.apache.qpid.server.protocol.v1_0.type.transport.End;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.LinkError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.QueueExistsException;
import org.apache.qpid.transport.network.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session_1_0
implements AMQSessionModel<Session_1_0>,
LogSubject {
    private static final Logger _logger = LoggerFactory.getLogger(Session_1_0.class);
    private static final Symbol LIFETIME_POLICY = Symbol.valueOf("lifetime-policy");
    private final AccessControlContext _accessControllerContext;
    private final SecurityToken _securityToken;
    private AutoCommitTransaction _transaction;
    private final LinkedHashMap<Integer, ServerTransaction> _openTransactions = new LinkedHashMap();
    private final CopyOnWriteArrayList<Action<? super Session_1_0>> _taskList = new CopyOnWriteArrayList();
    private final AMQPConnection_1_0 _connection;
    private UUID _id = UUID.randomUUID();
    private AtomicBoolean _closed = new AtomicBoolean();
    private final Subject _subject = new Subject();
    private final CopyOnWriteArrayList<Consumer<?>> _consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<SendingLink_1_0> _sendingLinks = new CopyOnWriteArrayList();
    private final ConfigurationChangeListener _consumerClosedListener = new ConsumerClosedListener();
    private final CopyOnWriteArrayList<ConsumerListener> _consumerListeners = new CopyOnWriteArrayList();
    private Session<?> _modelObject;
    private final List<ConsumerTarget_1_0> _consumersWithPendingWork = new ArrayList<ConsumerTarget_1_0>();
    private SessionState _state;
    private final Map<String, LinkEndpoint> _linkMap = new HashMap<String, LinkEndpoint>();
    private final Map<LinkEndpoint, UnsignedInteger> _localLinkEndpoints = new HashMap<LinkEndpoint, UnsignedInteger>();
    private final Map<UnsignedInteger, LinkEndpoint> _remoteLinkEndpoints = new HashMap<UnsignedInteger, LinkEndpoint>();
    private long _lastAttachedTime;
    private short _receivingChannel;
    private short _sendingChannel;
    private static final int DEFAULT_SESSION_BUFFER_SIZE = 2048;
    private static final int BUFFER_SIZE_MASK = 2047;
    private int _nextOutgoingDeliveryId;
    private UnsignedInteger _outgoingSessionCredit;
    private UnsignedInteger _initialOutgoingId = UnsignedInteger.valueOf(0);
    private SequenceNumber _nextIncomingTransferId;
    private SequenceNumber _nextOutgoingTransferId = new SequenceNumber(this._initialOutgoingId.intValue());
    private LinkedHashMap<UnsignedInteger, Delivery> _outgoingUnsettled = new LinkedHashMap(2048);
    private LinkedHashMap<UnsignedInteger, Delivery> _incomingUnsettled = new LinkedHashMap(2048);
    private int _availableIncomingCredit = 2048;
    private int _availableOutgoingCredit = 2048;
    private UnsignedInteger _lastSentIncomingLimit;
    private final Error _sessionEndedLinkError = new Error(LinkError.DETACH_FORCED, "Force detach the link because the session is remotely ended.");

    public Session_1_0(AMQPConnection_1_0 connection) {
        this(connection, SessionState.INACTIVE, null);
    }

    public Session_1_0(AMQPConnection_1_0 connection, Begin begin) {
        this(connection, SessionState.BEGIN_RECVD, new SequenceNumber(begin.getNextOutgoingId().intValue()));
    }

    private Session_1_0(AMQPConnection_1_0 connection, SessionState state, SequenceNumber nextIncomingId) {
        this._state = state;
        this._nextIncomingTransferId = nextIncomingId;
        this._connection = connection;
        this._subject.getPrincipals().addAll(connection.getSubject().getPrincipals());
        this._subject.getPrincipals().add((Principal)new SessionPrincipal((AMQSessionModel)this));
        this._accessControllerContext = connection.getAccessControlContextFromSubject(this._subject);
        this._securityToken = connection.getAddressSpace() instanceof ConfiguredObject ? ((ConfiguredObject)connection.getAddressSpace()).newToken(this._subject) : connection.getBroker().newToken(this._subject);
    }

    public void setReceivingChannel(short receivingChannel) {
        this._receivingChannel = receivingChannel;
        switch (this._state) {
            case INACTIVE: {
                this._state = SessionState.BEGIN_RECVD;
                break;
            }
            case BEGIN_SENT: {
                this._state = SessionState.ACTIVE;
                break;
            }
            case END_PIPE: {
                this._state = SessionState.END_SENT;
                break;
            }
        }
    }

    public void sendDetach(Detach detach) {
        this.send(detach);
    }

    public void receiveAttach(Attach attach) {
        UnsignedInteger handle;
        if (this._state == SessionState.ACTIVE && !this._remoteLinkEndpoints.containsKey(handle = attach.getHandle())) {
            LinkEndpoint endpoint = this._linkMap.get(attach.getName());
            if (endpoint == null) {
                endpoint = attach.getRole() == Role.RECEIVER ? new SendingLinkEndpoint(this, attach) : new ReceivingLinkEndpoint(this, attach);
                endpoint.setSource(attach.getSource());
                endpoint.setTarget(attach.getTarget());
            }
            if (attach.getRole() == Role.SENDER) {
                endpoint.setDeliveryCount(attach.getInitialDeliveryCount());
            }
            this._remoteLinkEndpoints.put(handle, endpoint);
            if (!this._localLinkEndpoints.containsKey(endpoint)) {
                UnsignedInteger localHandle = this.findNextAvailableHandle();
                endpoint.setLocalHandle(localHandle);
                this._localLinkEndpoints.put(endpoint, localHandle);
                this.remoteLinkCreation(endpoint);
            } else {
                endpoint.receiveAttach(attach);
            }
        }
    }

    public void updateDisposition(Role role, UnsignedInteger first, UnsignedInteger last, DeliveryState state, boolean settled) {
        Disposition disposition = new Disposition();
        disposition.setRole(role);
        disposition.setFirst(first);
        disposition.setLast(last);
        disposition.setSettled(settled);
        disposition.setState(state);
        if (settled && role == Role.RECEIVER) {
            SequenceNumber pos = new SequenceNumber(first.intValue());
            SequenceNumber end = new SequenceNumber(last.intValue());
            while (pos.compareTo(end) <= 0) {
                Delivery d = (Delivery)this._incomingUnsettled.remove(new UnsignedInteger(pos.intValue()));
                pos.incr();
            }
        }
        this.send(disposition);
    }

    public boolean hasCreditToSend() {
        boolean b = this._outgoingSessionCredit != null && this._outgoingSessionCredit.intValue() > 0;
        boolean b1 = this.getOutgoingWindowSize() != null && this.getOutgoingWindowSize().compareTo(UnsignedInteger.ZERO) > 0;
        return b && b1;
    }

    public void end() {
        this.end(new End());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTransfer(Transfer xfr, SendingLinkEndpoint endpoint, boolean newDelivery) {
        block10: {
            UnsignedInteger deliveryId;
            this._nextOutgoingTransferId.incr();
            if (newDelivery) {
                deliveryId = UnsignedInteger.valueOf(this._nextOutgoingDeliveryId++);
                endpoint.setLastDeliveryId(deliveryId);
            } else {
                deliveryId = endpoint.getLastDeliveryId();
            }
            xfr.setDeliveryId(deliveryId);
            if (!Boolean.TRUE.equals(xfr.getSettled())) {
                Delivery delivery = this._outgoingUnsettled.get(deliveryId);
                if (delivery == null) {
                    delivery = new Delivery(xfr, endpoint);
                    this._outgoingUnsettled.put(deliveryId, delivery);
                } else {
                    delivery.addTransfer(xfr);
                }
                this._outgoingSessionCredit = this._outgoingSessionCredit.subtract(UnsignedInteger.ONE);
                endpoint.addUnsettled(delivery);
            }
            try {
                QpidByteBuffer payload = xfr.getPayload();
                int payloadSent = this._connection.sendFrame(this._sendingChannel, xfr, payload);
                if (payload == null || payloadSent >= payload.remaining() || payloadSent < 0) break block10;
                payload = payload.duplicate();
                try {
                    payload.position(payload.position() + payloadSent);
                    Transfer secondTransfer = new Transfer();
                    secondTransfer.setDeliveryTag(xfr.getDeliveryTag());
                    secondTransfer.setHandle(xfr.getHandle());
                    secondTransfer.setSettled(xfr.getSettled());
                    secondTransfer.setState(xfr.getState());
                    secondTransfer.setMessageFormat(xfr.getMessageFormat());
                    secondTransfer.setPayload(payload);
                    this.sendTransfer(secondTransfer, endpoint, false);
                }
                finally {
                    payload.dispose();
                }
            }
            catch (OversizeFrameException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
        }
    }

    public boolean isActive() {
        return this._state == SessionState.ACTIVE;
    }

    public void receiveEnd(End end) {
        switch (this._state) {
            case END_SENT: {
                this._state = SessionState.ENDED;
                break;
            }
            case ACTIVE: {
                this.detachLinks();
                this.remoteEnd(end);
                short sendChannel = this._sendingChannel;
                this._connection.sendEnd(sendChannel, new End(), true);
                this._state = SessionState.ENDED;
                break;
            }
            default: {
                short sendChannel = this._sendingChannel;
                End reply = new End();
                Error error = new Error();
                error.setCondition(AmqpError.ILLEGAL_STATE);
                error.setDescription("END called on Session which has not been opened");
                reply.setError(error);
                this._connection.sendEnd(sendChannel, reply, true);
            }
        }
    }

    public UnsignedInteger getNextOutgoingId() {
        return UnsignedInteger.valueOf(this._nextOutgoingTransferId.intValue());
    }

    public void sendFlowConditional() {
        if (this._nextIncomingTransferId != null) {
            UnsignedInteger clientsCredit = this._lastSentIncomingLimit.subtract(UnsignedInteger.valueOf(this._nextIncomingTransferId.intValue()));
            int i = UnsignedInteger.valueOf(this._availableIncomingCredit).subtract(clientsCredit).compareTo(clientsCredit);
            if (i >= 0) {
                this.sendFlow();
            }
        }
    }

    public UnsignedInteger getOutgoingWindowSize() {
        return UnsignedInteger.valueOf(this._availableOutgoingCredit);
    }

    public void receiveFlow(Flow flow) {
        UnsignedInteger handle = flow.getHandle();
        LinkEndpoint endpoint = handle == null ? null : this._remoteLinkEndpoints.get(handle);
        UnsignedInteger nextOutgoingId = flow.getNextIncomingId() == null ? this._initialOutgoingId : flow.getNextIncomingId();
        int limit = nextOutgoingId.intValue() + flow.getIncomingWindow().intValue();
        this._outgoingSessionCredit = UnsignedInteger.valueOf(limit - this._nextOutgoingTransferId.intValue());
        if (endpoint != null) {
            endpoint.receiveFlow(flow);
        } else {
            Collection<LinkEndpoint> allLinkEndpoints = this._remoteLinkEndpoints.values();
            for (LinkEndpoint le : allLinkEndpoints) {
                le.flowStateChanged();
            }
        }
    }

    public void setNextIncomingId(UnsignedInteger nextIncomingId) {
        this._nextIncomingTransferId = new SequenceNumber(nextIncomingId.intValue());
    }

    public void receiveDisposition(Disposition disposition) {
        Role dispositionRole = disposition.getRole();
        LinkedHashMap<UnsignedInteger, Delivery> unsettledTransfers = dispositionRole == Role.RECEIVER ? this._outgoingUnsettled : this._incomingUnsettled;
        UnsignedInteger deliveryId = disposition.getFirst();
        UnsignedInteger last = disposition.getLast();
        if (last == null) {
            last = deliveryId;
        }
        while (deliveryId.compareTo(last) <= 0) {
            Delivery delivery = unsettledTransfers.get(deliveryId);
            if (delivery != null) {
                delivery.getLinkEndpoint().receiveDeliveryState(delivery, disposition.getState(), disposition.getSettled());
            }
            deliveryId = deliveryId.add(UnsignedInteger.ONE);
        }
        if (disposition.getSettled().booleanValue()) {
            // empty if block
        }
    }

    public SessionState getState() {
        return this._state;
    }

    public void sendFlow() {
        this.sendFlow(new Flow());
    }

    public void setSendingChannel(short sendingChannel) {
        this._sendingChannel = sendingChannel;
        switch (this._state) {
            case INACTIVE: {
                this._state = SessionState.BEGIN_SENT;
                break;
            }
            case BEGIN_RECVD: {
                this._state = SessionState.ACTIVE;
                break;
            }
        }
    }

    public void sendFlow(Flow flow) {
        if (this._nextIncomingTransferId != null) {
            int nextIncomingId = this._nextIncomingTransferId.intValue();
            flow.setNextIncomingId(UnsignedInteger.valueOf(nextIncomingId));
            this._lastSentIncomingLimit = UnsignedInteger.valueOf(nextIncomingId + this._availableIncomingCredit);
        }
        flow.setIncomingWindow(UnsignedInteger.valueOf(this._availableIncomingCredit));
        flow.setNextOutgoingId(UnsignedInteger.valueOf(this._nextOutgoingTransferId.intValue()));
        flow.setOutgoingWindow(UnsignedInteger.valueOf(this._availableOutgoingCredit));
        this.send(flow);
    }

    public void setOutgoingSessionCredit(UnsignedInteger outgoingSessionCredit) {
        this._outgoingSessionCredit = outgoingSessionCredit;
    }

    public void receiveDetach(Detach detach) {
        UnsignedInteger handle = detach.getHandle();
        this.detach(handle, detach);
    }

    public void sendAttach(Attach attach) {
        this.send(attach);
    }

    private void send(FrameBody frameBody) {
        this._connection.sendFrame(this._sendingChannel, frameBody);
    }

    public boolean isSyntheticError(Error error) {
        return error == this._sessionEndedLinkError;
    }

    public void end(End end) {
        switch (this._state) {
            case BEGIN_SENT: {
                this._connection.sendEnd(this._sendingChannel, end, false);
                this._state = SessionState.END_PIPE;
                break;
            }
            case ACTIVE: {
                this.detachLinks();
                short sendChannel = this._sendingChannel;
                this._connection.sendEnd(sendChannel, end, true);
                this._state = SessionState.END_SENT;
                break;
            }
            default: {
                short sendChannel = this._sendingChannel;
                End reply = new End();
                Error error = new Error();
                error.setCondition(AmqpError.ILLEGAL_STATE);
                error.setDescription("END called on Session which has not been opened");
                reply.setError(error);
                this._connection.sendEnd(sendChannel, reply, true);
            }
        }
    }

    public void receiveTransfer(Transfer transfer) {
        this._nextIncomingTransferId.incr();
        UnsignedInteger handle = transfer.getHandle();
        LinkEndpoint linkEndpoint = this._remoteLinkEndpoints.get(handle);
        if (linkEndpoint == null) {
            Error error = new Error();
            error.setCondition(AmqpError.ILLEGAL_STATE);
            error.setDescription("TRANSFER called on Session for link handle " + handle + " which is not attached");
            this._connection.close(error);
        } else if (!(linkEndpoint instanceof ReceivingLinkEndpoint)) {
            Error error = new Error();
            error.setCondition(ConnectionError.FRAMING_ERROR);
            error.setDescription("TRANSFER called on Session for link handle " + handle + " which is a sending ink not a receiving link");
            this._connection.close(error);
        } else {
            Delivery delivery;
            ReceivingLinkEndpoint endpoint = (ReceivingLinkEndpoint)linkEndpoint;
            UnsignedInteger deliveryId = transfer.getDeliveryId();
            if (deliveryId == null) {
                deliveryId = endpoint.getLastDeliveryId();
            }
            if ((delivery = this._incomingUnsettled.get(deliveryId)) == null) {
                delivery = new Delivery(transfer, endpoint);
                this._incomingUnsettled.put(deliveryId, delivery);
                if (Boolean.TRUE.equals(transfer.getMore())) {
                    endpoint.setLastDeliveryId(transfer.getDeliveryId());
                }
            } else if (delivery.getDeliveryId().equals(deliveryId)) {
                delivery.addTransfer(transfer);
                if (!Boolean.TRUE.equals(transfer.getMore())) {
                    endpoint.setLastDeliveryId(null);
                }
            } else {
                End reply = new End();
                Error error = new Error();
                error.setCondition(AmqpError.ILLEGAL_STATE);
                error.setDescription("TRANSFER called on Session for link handle " + handle + " with incorrect delivery id " + transfer.getDeliveryId());
                reply.setError(error);
                this._connection.sendEnd(this._sendingChannel, reply, true);
                return;
            }
            endpoint.receiveTransfer(transfer, delivery);
            if (delivery.isComplete() && delivery.isSettled() || Boolean.TRUE.equals(transfer.getAborted())) {
                this._incomingUnsettled.remove(deliveryId);
            }
        }
    }

    private Collection<LinkEndpoint> getLocalLinkEndpoints() {
        return new ArrayList<LinkEndpoint>(this._localLinkEndpoints.keySet());
    }

    boolean isEnded() {
        return this._state == SessionState.ENDED || this._connection.isClosed();
    }

    UnsignedInteger getIncomingWindowSize() {
        return UnsignedInteger.valueOf(this._availableIncomingCredit);
    }

    AccessControlContext getAccessControllerContext() {
        return this._accessControllerContext;
    }

    public void remoteLinkCreation(LinkEndpoint endpoint) {
        LinkEventListener link = null;
        Error error = null;
        LinkRegistry linkRegistry = this.getAddressSpace().getLinkRegistry(this.getConnection().getRemoteContainerId());
        if (endpoint.getRole() == Role.SENDER) {
            SendingLink_1_0 previousLink = (SendingLink_1_0)linkRegistry.getDurableSendingLink(endpoint.getName());
            if (previousLink == null) {
                SendingDestination destination;
                Target target = (Target)endpoint.getTarget();
                Source source = (Source)endpoint.getSource();
                if (source != null) {
                    String addr;
                    if (Boolean.TRUE.equals(source.getDynamic())) {
                        Queue<?> tempQueue = this.createTemporaryQueue(source.getDynamicNodeProperties());
                        source.setAddress(tempQueue.getName());
                    }
                    if (!(addr = source.getAddress()).startsWith("/") && addr.contains("/")) {
                        String[] parts = addr.split("/", 2);
                        Exchange<?> exchg = this.getExchange(parts[0]);
                        if (exchg != null) {
                            ExchangeDestination exchangeDestination = new ExchangeDestination(exchg, source.getDurable(), source.getExpiryPolicy(), parts[0], target.getCapabilities());
                            exchangeDestination.setInitialRoutingAddress(parts[1]);
                            destination = exchangeDestination;
                            target.setCapabilities(exchangeDestination.getCapabilities());
                        } else {
                            endpoint.setSource(null);
                            destination = null;
                        }
                    } else {
                        MessageSource queue = this.getAddressSpace().getAttainedMessageSource(addr);
                        if (queue != null) {
                            destination = new MessageSourceDestination(queue);
                        } else {
                            Exchange<?> exchg = this.getExchange(addr);
                            if (exchg != null) {
                                ExchangeDestination exchangeDestination = new ExchangeDestination(exchg, source.getDurable(), source.getExpiryPolicy(), addr, target.getCapabilities());
                                destination = exchangeDestination;
                                target.setCapabilities(exchangeDestination.getCapabilities());
                            } else {
                                endpoint.setSource(null);
                                destination = null;
                            }
                        }
                    }
                } else {
                    destination = null;
                }
                if (destination != null) {
                    SendingLinkEndpoint sendingLinkEndpoint = (SendingLinkEndpoint)endpoint;
                    try {
                        SendingLink_1_0 sendingLink = new SendingLink_1_0(new SendingLinkAttachment(this, sendingLinkEndpoint), this.getAddressSpace(), destination);
                        sendingLinkEndpoint.setLinkEventListener(new SubjectSpecificSendingLinkListener(sendingLink));
                        this.registerConsumer(sendingLink);
                        link = sendingLink;
                        if (TerminusDurability.UNSETTLED_STATE.equals(source.getDurable()) || TerminusDurability.CONFIGURATION.equals(source.getDurable())) {
                            linkRegistry.registerSendingLink(endpoint.getName(), (LinkModel)sendingLink);
                        }
                    }
                    catch (AmqpErrorException e) {
                        _logger.error("Error creating sending link", (Throwable)e);
                        destination = null;
                        sendingLinkEndpoint.setSource(null);
                        error = e.getError();
                    }
                }
            } else {
                TerminusDurability newSourceDurable;
                Source newSource = (Source)endpoint.getSource();
                Source oldSource = (Source)previousLink.getEndpoint().getSource();
                TerminusDurability terminusDurability = newSourceDurable = newSource == null ? null : newSource.getDurable();
                if (newSourceDurable != null) {
                    oldSource.setDurable(newSourceDurable);
                    if (newSourceDurable.equals(TerminusDurability.NONE)) {
                        linkRegistry.unregisterSendingLink(endpoint.getName());
                    }
                }
                endpoint.setSource(oldSource);
                SendingLinkEndpoint sendingLinkEndpoint = (SendingLinkEndpoint)endpoint;
                previousLink.setLinkAttachment(new SendingLinkAttachment(this, sendingLinkEndpoint));
                sendingLinkEndpoint.setLinkEventListener(new SubjectSpecificSendingLinkListener(previousLink));
                link = previousLink;
                endpoint.setLocalUnsettled(previousLink.getUnsettledOutcomeMap());
                this.registerConsumer(previousLink);
            }
        } else if (endpoint.getTarget() instanceof Coordinator) {
            Coordinator coordinator = (Coordinator)endpoint.getTarget();
            TxnCapability[] capabilities = coordinator.getCapabilities();
            boolean localTxn = false;
            boolean multiplePerSession = false;
            if (capabilities != null) {
                for (TxnCapability capability : capabilities) {
                    if (capability.equals(TxnCapability.LOCAL_TXN)) {
                        localTxn = true;
                        continue;
                    }
                    if (capability.equals(TxnCapability.MULTI_TXNS_PER_SSN)) {
                        multiplePerSession = true;
                        continue;
                    }
                    error = new Error();
                    error.setCondition(AmqpError.NOT_IMPLEMENTED);
                    error.setDescription("Unsupported capability: " + capability);
                    break;
                }
            }
            ReceivingLinkEndpoint receivingLinkEndpoint = (ReceivingLinkEndpoint)endpoint;
            TxnCoordinatorLink_1_0 coordinatorLink = new TxnCoordinatorLink_1_0(this.getAddressSpace(), this, receivingLinkEndpoint, this._openTransactions);
            receivingLinkEndpoint.setLinkEventListener(new SubjectSpecificReceivingLinkListener(coordinatorLink));
            link = coordinatorLink;
        } else {
            ReceivingLink_1_0 previousLink = (ReceivingLink_1_0)linkRegistry.getDurableReceivingLink(endpoint.getName());
            if (previousLink == null) {
                ReceivingDestination destination;
                Target target = (Target)endpoint.getTarget();
                if (target != null) {
                    MessageDestination messageDestination;
                    String addr;
                    if (Boolean.TRUE.equals(target.getDynamic())) {
                        Queue<?> tempQueue = this.createTemporaryQueue(target.getDynamicNodeProperties());
                        target.setAddress(tempQueue.getName());
                    }
                    if ((addr = target.getAddress()) == null || "".equals(addr.trim())) {
                        messageDestination = this.getAddressSpace().getDefaultDestination();
                        destination = new NodeReceivingDestination(messageDestination, target.getDurable(), target.getExpiryPolicy(), "", target.getCapabilities());
                        target.setCapabilities(destination.getCapabilities());
                    } else if (!addr.startsWith("/") && addr.contains("/")) {
                        String[] parts = addr.split("/", 2);
                        Exchange<?> exchange = this.getExchange(parts[0]);
                        if (exchange != null) {
                            ExchangeDestination exchangeDestination = new ExchangeDestination(exchange, target.getDurable(), target.getExpiryPolicy(), parts[0], target.getCapabilities());
                            exchangeDestination.setInitialRoutingAddress(parts[1]);
                            target.setCapabilities(exchangeDestination.getCapabilities());
                            destination = exchangeDestination;
                        } else {
                            endpoint.setTarget(null);
                            destination = null;
                        }
                    } else {
                        messageDestination = this.getAddressSpace().getAttainedMessageDestination(addr);
                        if (messageDestination != null) {
                            destination = new NodeReceivingDestination(messageDestination, target.getDurable(), target.getExpiryPolicy(), addr, target.getCapabilities());
                            target.setCapabilities(destination.getCapabilities());
                        } else {
                            Queue<?> queue = this.getQueue(addr);
                            if (queue != null) {
                                destination = new QueueDestination(queue, addr);
                            } else {
                                endpoint.setTarget(null);
                                destination = null;
                            }
                        }
                    }
                } else {
                    destination = null;
                }
                if (destination != null) {
                    ReceivingLinkEndpoint receivingLinkEndpoint = (ReceivingLinkEndpoint)endpoint;
                    ReceivingLink_1_0 receivingLink = new ReceivingLink_1_0(new ReceivingLinkAttachment(this, receivingLinkEndpoint), this.getAddressSpace(), destination);
                    receivingLinkEndpoint.setLinkEventListener(new SubjectSpecificReceivingLinkListener(receivingLink));
                    link = receivingLink;
                    if (TerminusDurability.UNSETTLED_STATE.equals(target.getDurable()) || TerminusDurability.CONFIGURATION.equals(target.getDurable())) {
                        linkRegistry.registerReceivingLink(endpoint.getName(), (LinkModel)receivingLink);
                    }
                }
            } else {
                ReceivingLinkEndpoint receivingLinkEndpoint = (ReceivingLinkEndpoint)endpoint;
                previousLink.setLinkAttachment(new ReceivingLinkAttachment(this, receivingLinkEndpoint));
                receivingLinkEndpoint.setLinkEventListener(previousLink);
                link = previousLink;
                endpoint.setLocalUnsettled(previousLink.getUnsettledOutcomeMap());
            }
        }
        endpoint.attach();
        if (link == null) {
            if (error == null) {
                error = new Error();
                error.setCondition(AmqpError.NOT_FOUND);
            }
            endpoint.close(error);
        } else {
            link.start();
        }
    }

    private void registerConsumer(SendingLink_1_0 link) {
        ConsumerImpl consumer = link.getConsumer();
        if (consumer instanceof Consumer) {
            Consumer modelConsumer = (Consumer)consumer;
            this._consumers.add(modelConsumer);
            this._sendingLinks.add(link);
            modelConsumer.addChangeListener(this._consumerClosedListener);
            this.consumerAdded(modelConsumer);
        }
    }

    private Queue<?> createTemporaryQueue(Map properties) {
        String queueName = UUID.randomUUID().toString();
        Queue queue = null;
        try {
            LifetimePolicy lifetimePolicy = properties == null ? null : (LifetimePolicy)properties.get(LIFETIME_POLICY);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("id", UUID.randomUUID());
            attributes.put("name", queueName);
            attributes.put("durable", false);
            if (lifetimePolicy instanceof DeleteOnNoLinks) {
                attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.DELETE_ON_NO_LINKS);
            } else if (lifetimePolicy instanceof DeleteOnNoLinksOrMessages) {
                attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.IN_USE);
            } else if (lifetimePolicy instanceof DeleteOnClose) {
                attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.DELETE_ON_CONNECTION_CLOSE);
            } else if (lifetimePolicy instanceof DeleteOnNoMessages) {
                attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.IN_USE);
            } else {
                attributes.put("lifetimePolicy", org.apache.qpid.server.model.LifetimePolicy.DELETE_ON_CONNECTION_CLOSE);
            }
            queue = (Queue)this.getAddressSpace().createMessageSource(Queue.class, attributes);
        }
        catch (AccessControlException e) {
            Error error = new Error();
            error.setCondition(AmqpError.UNAUTHORIZED_ACCESS);
            error.setDescription(e.getMessage());
            this._connection.close(error);
        }
        catch (QueueExistsException e) {
            _logger.error("A temporary queue was created with a name which collided with an existing queue name");
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
        return queue;
    }

    ServerTransaction getTransaction(Binary transactionId) {
        ServerTransaction transaction = this._openTransactions.get(this.binaryToInteger(transactionId));
        if (transaction == null) {
            if (this._transaction == null) {
                this._transaction = new AutoCommitTransaction(this._connection.getAddressSpace().getMessageStore());
            }
            transaction = this._transaction;
        }
        return transaction;
    }

    void remoteEnd(End end) {
        Iterator<Map.Entry<Integer, ServerTransaction>> iter = this._openTransactions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, ServerTransaction> entry = iter.next();
            entry.getValue().rollback();
            iter.remove();
        }
        for (LinkEndpoint linkEndpoint : this.getLocalLinkEndpoints()) {
            linkEndpoint.remoteDetached(new Detach());
        }
        this._connection.sessionEnded(this);
        this.performCloseTasks();
        if (this._modelObject != null) {
            this._modelObject.delete();
        }
    }

    Integer binaryToInteger(Binary txnId) {
        if (txnId == null) {
            return null;
        }
        if (txnId.getLength() > 4) {
            throw new IllegalArgumentException();
        }
        int id = 0;
        byte[] data = txnId.getArray();
        for (int i = 0; i < txnId.getLength(); ++i) {
            id <<= 8;
            id += data[i + txnId.getArrayOffset()] & 0xFF;
        }
        return id;
    }

    Binary integerToBinary(int txnId) {
        byte[] data = new byte[4];
        data[3] = (byte)(txnId & 0xFF);
        data[2] = (byte)((txnId & 0xFF00) >> 8);
        data[1] = (byte)((txnId & 0xFF0000) >> 16);
        data[0] = (byte)((txnId & 0xFF000000) >> 24);
        return new Binary(data);
    }

    public UUID getId() {
        return this._id;
    }

    public AMQPConnection<?> getAMQPConnection() {
        return this._connection;
    }

    public void close() {
        this.performCloseTasks();
        this.end();
        if (this._modelObject != null) {
            this._modelObject.delete();
        }
    }

    private void performCloseTasks() {
        if (this._closed.compareAndSet(false, true)) {
            ArrayList<Action<? super Session_1_0>> taskList = new ArrayList<Action<? super Session_1_0>>(this._taskList);
            this._taskList.clear();
            for (Action action : taskList) {
                action.performAction((Object)this);
            }
        }
    }

    public void close(AMQConstant cause, String message) {
        this.performCloseTasks();
        End end = new End();
        Error theError = new Error();
        theError.setDescription(message);
        theError.setCondition(ConnectionError.CONNECTION_FORCED);
        end.setError(theError);
        this.end(end);
    }

    public void transportStateChanged() {
        for (SendingLink_1_0 link : this._sendingLinks) {
            ConsumerTarget_1_0 target = link.getConsumerTarget();
            target.flowStateChanged();
        }
    }

    public LogSubject getLogSubject() {
        return this;
    }

    public void block(Queue<?> queue) {
    }

    public void unblock(Queue<?> queue) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public boolean getBlocking() {
        return false;
    }

    public Object getConnectionReference() {
        return this.getConnection().getReference();
    }

    public int getUnacknowledgedMessageCount() {
        return 0;
    }

    public Long getTxnCount() {
        return 0L;
    }

    public Long getTxnStart() {
        return 0L;
    }

    public Long getTxnCommits() {
        return 0L;
    }

    public Long getTxnRejects() {
        return 0L;
    }

    public int getChannelId() {
        return this._sendingChannel;
    }

    public int getConsumerCount() {
        return this.getConsumers().size();
    }

    public String toLogString() {
        AMQPConnection<?> amqpConnection = this.getAMQPConnection();
        long connectionId = amqpConnection.getConnectionId();
        String remoteAddress = amqpConnection.getRemoteAddressString();
        String authorizedPrincipal = amqpConnection.getAuthorizedPrincipal() == null ? "?" : amqpConnection.getAuthorizedPrincipal().getName();
        return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})/ch:{4}", connectionId, authorizedPrincipal, remoteAddress, this.getAddressSpace().getName(), this._sendingChannel) + "] ";
    }

    public int compareTo(AMQSessionModel o) {
        return this.getId().compareTo(o.getId());
    }

    public AMQPConnection_1_0 getConnection() {
        return this._connection;
    }

    public void addDeleteTask(Action<? super Session_1_0> task) {
        if (!this._closed.get()) {
            this._taskList.add(task);
        }
    }

    public void removeDeleteTask(Action<? super Session_1_0> task) {
        this._taskList.remove(task);
    }

    public Subject getSubject() {
        return this._subject;
    }

    private NamedAddressSpace getAddressSpace() {
        return this._connection.getAddressSpace();
    }

    public SecurityToken getSecurityToken() {
        return this._securityToken;
    }

    public Collection<Consumer<?>> getConsumers() {
        return Collections.unmodifiableCollection(this._consumers);
    }

    public void addConsumerListener(ConsumerListener listener) {
        this._consumerListeners.add(listener);
    }

    public void removeConsumerListener(ConsumerListener listener) {
        this._consumerListeners.remove(listener);
    }

    public void setModelObject(Session<?> session) {
        this._modelObject = session;
    }

    public Session<?> getModelObject() {
        return this._modelObject;
    }

    public long getTransactionStartTime() {
        return 0L;
    }

    public long getTransactionUpdateTime() {
        return 0L;
    }

    public boolean processPending() {
        boolean consumerListNeedsRefreshing;
        if (!this.getAMQPConnection().isIOThread()) {
            return false;
        }
        if (this._consumersWithPendingWork.isEmpty()) {
            for (SendingLink_1_0 link : this._sendingLinks) {
                this._consumersWithPendingWork.add(link.getConsumerTarget());
            }
            consumerListNeedsRefreshing = false;
        } else {
            consumerListNeedsRefreshing = true;
        }
        Iterator iter = this._consumersWithPendingWork.isEmpty() ? Collections.emptyIterator() : this._consumersWithPendingWork.iterator();
        boolean consumerHasMoreWork = false;
        while (iter.hasNext()) {
            ConsumerTarget target = (ConsumerTarget)iter.next();
            iter.remove();
            if (!target.hasPendingWork()) continue;
            consumerHasMoreWork = true;
            target.processPending();
            break;
        }
        return consumerHasMoreWork || consumerListNeedsRefreshing;
    }

    public void addTicker(Ticker ticker) {
        this.getConnection().getAggregateTicker().addTicker(ticker);
        this.getAMQPConnection().notifyWork();
    }

    public void removeTicker(Ticker ticker) {
        this.getConnection().getAggregateTicker().removeTicker(ticker);
    }

    public void notifyConsumerTargetCurrentStates() {
        for (SendingLink_1_0 link : this._sendingLinks) {
            ConsumerTarget_1_0 consumerTarget = link.getConsumerTarget();
            if (consumerTarget.isPullOnly()) continue;
            consumerTarget.notifyCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureConsumersNoticedStateChange() {
        for (SendingLink_1_0 link : this._sendingLinks) {
            ConsumerTarget_1_0 consumerTarget = link.getConsumerTarget();
            try {
                consumerTarget.getSendLock();
            }
            finally {
                consumerTarget.releaseSendLock();
            }
        }
    }

    public void doTimeoutAction(String reason) {
        this.getAMQPConnection().closeSessionAsync((AMQSessionModel)this, AMQConstant.RESOURCE_ERROR, reason);
    }

    private void consumerAdded(Consumer<?> consumer) {
        for (ConsumerListener l : this._consumerListeners) {
            l.consumerAdded(consumer);
        }
    }

    private void consumerRemoved(Consumer<?> consumer) {
        for (ConsumerListener l : this._consumerListeners) {
            l.consumerRemoved(consumer);
        }
    }

    public String toString() {
        return "Session_1_0[" + this._connection + ": " + this._sendingChannel + ']';
    }

    private void detach(UnsignedInteger handle, Detach detach) {
        if (this._remoteLinkEndpoints.containsKey(handle)) {
            LinkEndpoint endpoint = this._remoteLinkEndpoints.remove(handle);
            endpoint.remoteDetached(detach);
            this._localLinkEndpoints.remove(endpoint);
        }
    }

    private void detachLinks() {
        ArrayList<UnsignedInteger> handles = new ArrayList<UnsignedInteger>(this._remoteLinkEndpoints.keySet());
        for (UnsignedInteger handle : handles) {
            Detach detach = new Detach();
            detach.setClosed(false);
            detach.setHandle(handle);
            detach.setError(this._sessionEndedLinkError);
            this.detach(handle, detach);
        }
    }

    private UnsignedInteger findNextAvailableHandle() {
        int i = 0;
        do {
            if (this._localLinkEndpoints.containsValue(UnsignedInteger.valueOf(i))) continue;
            return UnsignedInteger.valueOf(i);
        } while (++i != 0);
        throw new RuntimeException();
    }

    private Exchange<?> getExchange(String name) {
        MessageDestination destination = this.getAddressSpace().getAttainedMessageDestination(name);
        return destination instanceof Exchange ? (Exchange)destination : null;
    }

    private Queue<?> getQueue(String name) {
        MessageSource source = this.getAddressSpace().getAttainedMessageSource(name);
        return source instanceof Queue ? (Queue)source : null;
    }

    private class ConsumerClosedListener
    implements ConfigurationChangeListener {
        private ConsumerClosedListener() {
        }

        public void stateChanged(ConfiguredObject object, State oldState, State newState) {
            if (newState == State.DELETED) {
                Session_1_0.this.consumerRemoved((Consumer)object);
            }
        }

        public void childAdded(ConfiguredObject object, ConfiguredObject child) {
        }

        public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        }

        public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        }

        public void bulkChangeStart(ConfiguredObject<?> object) {
        }

        public void bulkChangeEnd(ConfiguredObject<?> object) {
        }
    }

    private class SubjectSpecificSendingLinkListener
    implements SendingLinkListener {
        private final SendingLink_1_0 _previousLink;

        public SubjectSpecificSendingLinkListener(SendingLink_1_0 previousLink) {
            this._previousLink = previousLink;
        }

        @Override
        public void flowStateChanged() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SubjectSpecificSendingLinkListener.this._previousLink.flowStateChanged();
                    return null;
                }
            }, Session_1_0.this._accessControllerContext);
        }

        @Override
        public void remoteDetached(final LinkEndpoint endpoint, final Detach detach) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SubjectSpecificSendingLinkListener.this._previousLink.remoteDetached(endpoint, detach);
                    return null;
                }
            }, Session_1_0.this._accessControllerContext);
        }
    }

    private class SubjectSpecificReceivingLinkListener
    implements ReceivingLinkListener {
        private final ReceivingLinkListener _linkListener;

        public SubjectSpecificReceivingLinkListener(ReceivingLinkListener linkListener) {
            this._linkListener = linkListener;
        }

        @Override
        public void messageTransfer(final Transfer xfr) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SubjectSpecificReceivingLinkListener.this._linkListener.messageTransfer(xfr);
                    return null;
                }
            }, Session_1_0.this._accessControllerContext);
        }

        @Override
        public void remoteDetached(final LinkEndpoint endpoint, final Detach detach) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SubjectSpecificReceivingLinkListener.this._linkListener.remoteDetached(endpoint, detach);
                    return null;
                }
            }, Session_1_0.this._accessControllerContext);
        }
    }
}

