/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v1_0.ConsumerTarget_1_0;
import org.apache.qpid.server.protocol.v1_0.DeliveryStateHandler;
import org.apache.qpid.server.protocol.v1_0.ExchangeDestination;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageSourceDestination;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.QueueDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.SendingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.SendingLinkListener;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnsettledAction;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ExactSubjectFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Filter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.JMSSelectorFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MatchingSubjectFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Modified;
import org.apache.qpid.server.protocol.v1_0.type.messaging.NoLocalFilter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Released;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.StdDistMode;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.QueueExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingLink_1_0
implements SendingLinkListener,
Link_1_0,
DeliveryStateHandler {
    private static final Logger _logger = LoggerFactory.getLogger(SendingLink_1_0.class);
    private NamedAddressSpace _addressSpace;
    private SendingDestination _destination;
    private ConsumerImpl _consumer;
    private ConsumerTarget_1_0 _target;
    private boolean _draining;
    private final Map<Binary, MessageInstance> _unsettledMap = new HashMap<Binary, MessageInstance>();
    private final ConcurrentMap<Binary, UnsettledAction> _unsettledActionMap = new ConcurrentHashMap<Binary, UnsettledAction>();
    private volatile SendingLinkAttachment _linkAttachment;
    private TerminusDurability _durability;
    private List<MessageInstance> _resumeFullTransfers = new ArrayList<MessageInstance>();
    private List<Binary> _resumeAcceptedTransfers = new ArrayList<Binary>();
    private Runnable _closeAction;
    private final MessageSource _queue;

    public SendingLink_1_0(SendingLinkAttachment linkAttachment, NamedAddressSpace addressSpace, SendingDestination destination) throws AmqpErrorException {
        this._addressSpace = addressSpace;
        this._destination = destination;
        this._linkAttachment = linkAttachment;
        Source source = (Source)linkAttachment.getSource();
        this._durability = source.getDurable();
        linkAttachment.setDeliveryStateHandler(this);
        QueueDestination qd = null;
        EnumSet<ConsumerImpl.Option> options = EnumSet.noneOf(ConsumerImpl.Option.class);
        boolean noLocal = false;
        org.apache.qpid.server.filter.JMSSelectorFilter messageFilter = null;
        if (destination instanceof MessageSourceDestination) {
            this._queue = ((MessageSourceDestination)this._destination).getQueue();
            if (this._queue instanceof Queue && ((Queue)this._queue).getAvailableAttributes().contains("topic")) {
                source.setDistributionMode(StdDistMode.COPY);
            }
            Map filters = source.getFilter();
            HashMap actualFilters = new HashMap();
            if (filters != null) {
                for (Map.Entry entry : filters.entrySet()) {
                    if (entry.getValue() instanceof NoLocalFilter) {
                        actualFilters.put(entry.getKey(), entry.getValue());
                        noLocal = true;
                        continue;
                    }
                    if (messageFilter != null || !(entry.getValue() instanceof JMSSelectorFilter)) continue;
                    JMSSelectorFilter selectorFilter = (JMSSelectorFilter)entry.getValue();
                    try {
                        messageFilter = new org.apache.qpid.server.filter.JMSSelectorFilter(selectorFilter.getValue());
                        actualFilters.put(entry.getKey(), entry.getValue());
                    }
                    catch (SelectorParsingException | ParseException | TokenMgrError e) {
                        Error error = new Error();
                        error.setCondition(AmqpError.INVALID_FIELD);
                        error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                        error.setInfo(Collections.singletonMap(Symbol.valueOf("field"), Symbol.valueOf("filter")));
                        throw new AmqpErrorException(error);
                    }
                }
            }
            source.setFilter(actualFilters.isEmpty() ? null : actualFilters);
            this._target = new ConsumerTarget_1_0(this, source.getDistributionMode() != StdDistMode.COPY);
            if (source.getDistributionMode() != StdDistMode.COPY) {
                options.add(ConsumerImpl.Option.ACQUIRES);
                options.add(ConsumerImpl.Option.SEES_REQUEUES);
            }
        } else if (destination instanceof ExchangeDestination) {
            try {
                String name;
                boolean isDurable;
                ExchangeDestination exchangeDestination = (ExchangeDestination)destination;
                boolean bl = isDurable = exchangeDestination.getDurability() == TerminusDurability.CONFIGURATION || exchangeDestination.getDurability() == TerminusDurability.UNSETTLED_STATE;
                if (isDurable) {
                    String remoteContainerId = this.getEndpoint().getSession().getConnection().getRemoteContainerId();
                    remoteContainerId = remoteContainerId.replace("_", "__").replace(".", "_:");
                    String endpointName = linkAttachment.getEndpoint().getName();
                    endpointName = endpointName.replace("_", "__").replace(".", "_:").replace("(", "_O").replace(")", "_C").replace("<", "_L").replace(">", "_R");
                    name = "qpid_/" + remoteContainerId + "_/" + endpointName;
                } else {
                    name = UUID.randomUUID().toString();
                }
                Queue queue = this.getQueue(name);
                Exchange<?> exchange = exchangeDestination.getExchange();
                if (queue == null) {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("id", UUID.randomUUID());
                    attributes.put("name", name);
                    attributes.put("durable", isDurable);
                    attributes.put("lifetimePolicy", LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS);
                    attributes.put("exclusive", ExclusivityPolicy.LINK);
                    queue = (Queue)this._addressSpace.createMessageSource(Queue.class, attributes);
                } else {
                    Collection bindings = queue.getBindings();
                    ArrayList<Binding> bindingsToRemove = new ArrayList<Binding>();
                    for (Binding existingBinding : bindings) {
                        if (existingBinding.getExchange() == exchange) continue;
                        bindingsToRemove.add(existingBinding);
                    }
                    for (Binding existingBinding : bindingsToRemove) {
                        existingBinding.delete();
                    }
                }
                String binding = null;
                Map filters = source.getFilter();
                HashMap actualFilters = new HashMap();
                boolean hasBindingFilter = false;
                if (filters != null && !filters.isEmpty()) {
                    for (Map.Entry entry : filters.entrySet()) {
                        Filter filter;
                        if (!hasBindingFilter && entry.getValue() instanceof ExactSubjectFilter && exchange.getType().equals("direct")) {
                            filter = (ExactSubjectFilter)filters.values().iterator().next();
                            source.setFilter(filters);
                            binding = ((ExactSubjectFilter)filter).getValue();
                            actualFilters.put(entry.getKey(), entry.getValue());
                            hasBindingFilter = true;
                            continue;
                        }
                        if (!hasBindingFilter && entry.getValue() instanceof MatchingSubjectFilter && exchange.getType().equals("topic")) {
                            filter = (MatchingSubjectFilter)filters.values().iterator().next();
                            source.setFilter(filters);
                            binding = ((MatchingSubjectFilter)filter).getValue();
                            actualFilters.put(entry.getKey(), entry.getValue());
                            hasBindingFilter = true;
                            continue;
                        }
                        if (entry.getValue() instanceof NoLocalFilter) {
                            actualFilters.put(entry.getKey(), entry.getValue());
                            noLocal = true;
                            continue;
                        }
                        if (messageFilter != null || !(entry.getValue() instanceof JMSSelectorFilter)) continue;
                        JMSSelectorFilter selectorFilter = (JMSSelectorFilter)entry.getValue();
                        try {
                            messageFilter = new org.apache.qpid.server.filter.JMSSelectorFilter(selectorFilter.getValue());
                            actualFilters.put(entry.getKey(), entry.getValue());
                        }
                        catch (SelectorParsingException | ParseException | TokenMgrError e) {
                            Error error = new Error();
                            error.setCondition(AmqpError.INVALID_FIELD);
                            error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                            error.setInfo(Collections.singletonMap(Symbol.valueOf("field"), Symbol.valueOf("filter")));
                            throw new AmqpErrorException(error);
                        }
                    }
                }
                this._queue = queue;
                source.setFilter(actualFilters.isEmpty() ? null : actualFilters);
                if (binding != null) {
                    exchange.addBinding(binding, queue, null);
                }
                if (exchangeDestination.getInitialRoutingAddress() != null) {
                    exchange.addBinding(exchangeDestination.getInitialRoutingAddress(), queue, null);
                }
                if (binding == null && exchangeDestination.getInitialRoutingAddress() == null && exchange.getType().equals("fanout")) {
                    exchange.addBinding(queue.getName(), queue, null);
                } else if (binding == null && exchangeDestination.getInitialRoutingAddress() == null && exchange.getType().equals("topic")) {
                    exchange.addBinding("#", queue, null);
                }
                source.setDistributionMode(StdDistMode.COPY);
                qd = new QueueDestination(queue, name);
            }
            catch (QueueExistsException e) {
                _logger.error("A randomly generated temporary queue name collided with an existing queue", (Throwable)e);
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
            this._target = new ConsumerTarget_1_0(this, true);
            options.add(ConsumerImpl.Option.ACQUIRES);
            options.add(ConsumerImpl.Option.SEES_REQUEUES);
        } else {
            throw new ConnectionScopedRuntimeException("Unknown destination type");
        }
        if (this._target != null) {
            if (noLocal) {
                options.add(ConsumerImpl.Option.NO_LOCAL);
            }
            if (this._durability == TerminusDurability.CONFIGURATION || this._durability == TerminusDurability.UNSETTLED_STATE) {
                options.add(ConsumerImpl.Option.DURABLE);
            }
            try {
                Target target;
                String name = this.getEndpoint().getTarget() instanceof Target ? ((target = (Target)this.getEndpoint().getTarget()).getAddress() == null ? this.getEndpoint().getName() : target.getAddress()) : this.getEndpoint().getName();
                FilterManager filters = null;
                if (messageFilter != null) {
                    filters = new FilterManager();
                    filters.add(messageFilter.getName(), (MessageFilter)messageFilter);
                }
                this._consumer = this._queue.addConsumer((ConsumerTarget)this._target, filters, Message_1_0.class, name, options, this.getEndpoint().getPriority());
            }
            catch (MessageSource.ExistingExclusiveConsumer e) {
                _logger.info("Cannot add a consumer to the destination as there is already an exclusive consumer");
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
            catch (MessageSource.ExistingConsumerPreventsExclusive e) {
                _logger.info("Cannot add an exclusive consumer to the destination as there is already a consumer");
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
            catch (MessageSource.ConsumerAccessRefused e) {
                _logger.info("Cannot add an exclusive consumer to the destination as there is an incompatible exclusivity policy");
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
        }
    }

    public void resume(SendingLinkAttachment linkAttachment) {
        this._linkAttachment = linkAttachment;
    }

    @Override
    public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
        if (Boolean.TRUE.equals(detach.getClosed()) || !TerminusDurability.UNSETTLED_STATE.equals(this._durability) && !TerminusDurability.CONFIGURATION.equals(this._durability)) {
            this._consumer.close();
            Modified state = new Modified();
            state.setDeliveryFailed(true);
            for (UnsettledAction action : this._unsettledActionMap.values()) {
                action.process(state, Boolean.TRUE);
            }
            this._unsettledActionMap.clear();
            endpoint.close();
            if (this._destination instanceof ExchangeDestination && (this._durability == TerminusDurability.CONFIGURATION || this._durability == TerminusDurability.UNSETTLED_STATE)) {
                try {
                    ((ConfiguredObject)this._queue).delete();
                }
                catch (AccessControlException e) {
                    _logger.error("Error unregistering subscription", (Throwable)e);
                }
            }
            if (this._closeAction != null) {
                this._closeAction.run();
            }
        } else if (detach.getError() != null && !this._linkAttachment.getEndpoint().getSession().isSyntheticError(detach.getError())) {
            this._linkAttachment = null;
            this._target.flowStateChanged();
        } else {
            endpoint.detach();
        }
    }

    @Override
    public void start() {
    }

    public SendingLinkEndpoint getEndpoint() {
        return this._linkAttachment == null ? null : this._linkAttachment.getEndpoint();
    }

    public Session_1_0 getSession() {
        return this._linkAttachment == null ? null : this._linkAttachment.getSession();
    }

    @Override
    public void flowStateChanged() {
        if (Boolean.TRUE.equals(this.getEndpoint().getDrain()) && this.hasCredit()) {
            this._draining = true;
            this._target.flush();
        }
        while (!this._resumeAcceptedTransfers.isEmpty() && this.getEndpoint().hasCreditToSend()) {
            Accepted accepted = new Accepted();
            Transfer xfr = new Transfer();
            Binary dt = this._resumeAcceptedTransfers.remove(0);
            xfr.setDeliveryTag(dt);
            xfr.setState(accepted);
            xfr.setResume(Boolean.TRUE);
            this.getEndpoint().transfer(xfr, true);
        }
        if (this._resumeAcceptedTransfers.isEmpty()) {
            this._target.flowStateChanged();
        }
    }

    boolean hasCredit() {
        return this.getEndpoint().getLinkCredit().compareTo(UnsignedInteger.ZERO) > 0;
    }

    public boolean isDraining() {
        return false;
    }

    public boolean drained() {
        if (this.getEndpoint() != null) {
            if (this._draining) {
                this.getEndpoint().drained();
                this._draining = false;
                return true;
            }
            return false;
        }
        return false;
    }

    public void addUnsettled(Binary tag, UnsettledAction unsettledAction, MessageInstance queueEntry) {
        this._unsettledActionMap.put(tag, unsettledAction);
        if (this.getTransactionId() == null) {
            this._unsettledMap.put(tag, queueEntry);
        }
    }

    public void removeUnsettled(Binary tag) {
        this._unsettledActionMap.remove(tag);
    }

    @Override
    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        UnsettledAction action = (UnsettledAction)this._unsettledActionMap.get(deliveryTag);
        boolean localSettle = false;
        if (action != null && (localSettle = action.process(state, settled)) && !Boolean.TRUE.equals(settled)) {
            this._linkAttachment.updateDisposition(deliveryTag, state, true);
        }
        if (Boolean.TRUE.equals(settled) || localSettle) {
            this._unsettledActionMap.remove(deliveryTag);
            this._unsettledMap.remove(deliveryTag);
        }
    }

    ServerTransaction getTransaction(Binary transactionId) {
        return this._linkAttachment.getSession().getTransaction(transactionId);
    }

    public Binary getTransactionId() {
        SendingLinkEndpoint endpoint = this.getEndpoint();
        return endpoint == null ? null : endpoint.getTransactionId();
    }

    public boolean isDetached() {
        return this._linkAttachment == null || this.getEndpoint().isDetached();
    }

    public boolean isAttached() {
        return this._linkAttachment != null && this.getEndpoint().isAttached();
    }

    public synchronized void setLinkAttachment(SendingLinkAttachment linkAttachment) {
        if (this._consumer.isActive()) {
            this._target.suspend();
        }
        this._linkAttachment = linkAttachment;
        SendingLinkEndpoint endpoint = linkAttachment.getEndpoint();
        endpoint.setDeliveryStateHandler(this);
        Map initialUnsettledMap = endpoint.getInitialUnsettledMap();
        HashMap<Binary, MessageInstance> unsettledCopy = new HashMap<Binary, MessageInstance>(this._unsettledMap);
        this._resumeAcceptedTransfers.clear();
        this._resumeFullTransfers.clear();
        for (Map.Entry entry : unsettledCopy.entrySet()) {
            Binary deliveryTag = (Binary)entry.getKey();
            final MessageInstance queueEntry = (MessageInstance)entry.getValue();
            if (initialUnsettledMap == null || !initialUnsettledMap.containsKey(deliveryTag)) {
                queueEntry.setRedelivered();
                queueEntry.release(this._consumer);
                this._unsettledMap.remove(deliveryTag);
                continue;
            }
            if (initialUnsettledMap.get(deliveryTag) instanceof Outcome) {
                AutoCommitTransaction txn;
                Outcome outcome = (Outcome)initialUnsettledMap.get(deliveryTag);
                if (outcome instanceof Accepted) {
                    txn = new AutoCommitTransaction(this._addressSpace.getMessageStore());
                    if (this._consumer.acquires() && (queueEntry.acquire() || queueEntry.isAcquired())) {
                        txn.dequeue(Collections.singleton(queueEntry), new ServerTransaction.Action(){

                            public void postCommit() {
                                queueEntry.delete();
                            }

                            public void onRollback() {
                            }
                        });
                    }
                } else if (outcome instanceof Released) {
                    txn = new AutoCommitTransaction(this._addressSpace.getMessageStore());
                    if (this._consumer.acquires()) {
                        txn.dequeue(Collections.singleton(queueEntry), new ServerTransaction.Action(){

                            public void postCommit() {
                                queueEntry.release(SendingLink_1_0.this._consumer);
                            }

                            public void onRollback() {
                            }
                        });
                    }
                }
                initialUnsettledMap.remove(deliveryTag);
                this._resumeAcceptedTransfers.add(deliveryTag);
                continue;
            }
            this._resumeFullTransfers.add(queueEntry);
        }
    }

    public Map getUnsettledOutcomeMap() {
        HashMap<Binary, MessageInstance> unsettled = new HashMap<Binary, MessageInstance>(this._unsettledMap);
        for (Map.Entry entry : unsettled.entrySet()) {
            entry.setValue(null);
        }
        return unsettled;
    }

    public void setCloseAction(Runnable action) {
        this._closeAction = action;
    }

    public NamedAddressSpace getAddressSpace() {
        return this._addressSpace;
    }

    public ConsumerImpl getConsumer() {
        return this._consumer;
    }

    public ConsumerTarget_1_0 getConsumerTarget() {
        return this._target;
    }

    private Queue<?> getQueue(String name) {
        MessageSource source = this.getAddressSpace().getAttainedMessageSource(name);
        return source instanceof Queue ? (Queue)source : null;
    }
}

