/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v1_0.Delivery;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.SendingLinkListener;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;

public class SendingLinkEndpoint
extends LinkEndpoint<SendingLinkListener> {
    public static final Symbol PRIORITY = Symbol.valueOf("priority");
    private UnsignedInteger _lastDeliveryId;
    private Binary _lastDeliveryTag;
    private Map<Binary, UnsignedInteger> _unsettledMap = new HashMap<Binary, UnsignedInteger>();
    private Binary _transactionId;
    private Integer _priority;

    public SendingLinkEndpoint(Session_1_0 sessionEndpoint, Attach attach) {
        super(sessionEndpoint, attach);
        this.setSendingSettlementMode(attach.getSndSettleMode());
        this.setReceivingSettlementMode(attach.getRcvSettleMode());
        this.init();
    }

    @Override
    protected Map<Symbol, Object> initProperties(Attach attach) {
        Map peerProperties = attach.getProperties();
        if (peerProperties != null) {
            HashMap<Symbol, Object> actualProperties = new HashMap<Symbol, Object>();
            if (peerProperties.containsKey(PRIORITY)) {
                Object value = peerProperties.get(PRIORITY);
                if (value instanceof Number) {
                    this._priority = ((Number)value).intValue();
                } else if (value instanceof String) {
                    try {
                        this._priority = Integer.parseInt(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this._priority != null) {
                    actualProperties.put(PRIORITY, this._priority);
                }
            }
            return actualProperties;
        }
        return Collections.emptyMap();
    }

    private void init() {
        this.setDeliveryCount(UnsignedInteger.valueOf(0));
        this.setAvailable(UnsignedInteger.valueOf(0));
        this.setLinkEventListener(SendingLinkListener.DEFAULT);
    }

    @Override
    public Role getRole() {
        return Role.SENDER;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public boolean transfer(Transfer xfr, boolean decrementCredit) {
        Session_1_0 s = this.getSession();
        xfr.setMessageFormat(UnsignedInteger.ZERO);
        if (decrementCredit) {
            this.setLinkCredit(this.getLinkCredit().subtract(UnsignedInteger.ONE));
        }
        this.setDeliveryCount(UnsignedInteger.valueOf(this.getDeliveryCount().intValue() + 1));
        xfr.setHandle(this.getLocalHandle());
        s.sendTransfer(xfr, this, !xfr.getDeliveryTag().equals(this._lastDeliveryTag));
        if (!Boolean.TRUE.equals(xfr.getSettled())) {
            this._unsettledMap.put(xfr.getDeliveryTag(), xfr.getDeliveryId());
        }
        this._lastDeliveryTag = Boolean.TRUE.equals(xfr.getMore()) ? xfr.getDeliveryTag() : null;
        return true;
    }

    public void drained() {
        this.setDeliveryCount(this.getDeliveryCount().add(this.getLinkCredit()));
        this.setLinkCredit(UnsignedInteger.ZERO);
        this.sendFlow();
    }

    @Override
    public void receiveFlow(Flow flow) {
        super.receiveFlow(flow);
        UnsignedInteger t = flow.getDeliveryCount();
        UnsignedInteger c = flow.getLinkCredit();
        this.setDrain(flow.getDrain());
        Map options = flow.getProperties();
        if (options != null) {
            this._transactionId = (Binary)options.get(Symbol.valueOf("txn-id"));
        }
        if (t == null) {
            this.setLinkCredit(c);
        } else {
            UnsignedInteger limit = t.add(c);
            if (limit.compareTo(this.getDeliveryCount()) <= 0) {
                this.setLinkCredit(UnsignedInteger.valueOf(0));
            } else {
                this.setLinkCredit(limit.subtract(this.getDeliveryCount()));
            }
        }
        this.flowStateChanged();
    }

    @Override
    public void flowStateChanged() {
        ((SendingLinkListener)this.getLinkEventListener()).flowStateChanged();
    }

    public boolean hasCreditToSend() {
        UnsignedInteger linkCredit = this.getLinkCredit();
        return linkCredit != null && linkCredit.compareTo(UnsignedInteger.valueOf(0)) > 0 && this.getSession().hasCreditToSend();
    }

    @Override
    public void receiveDeliveryState(Delivery unsettled, DeliveryState state, Boolean settled) {
        super.receiveDeliveryState(unsettled, state, settled);
        if (settled.booleanValue()) {
            this._unsettledMap.remove(unsettled.getDeliveryTag());
        }
    }

    public UnsignedInteger getLastDeliveryId() {
        return this._lastDeliveryId;
    }

    public void setLastDeliveryId(UnsignedInteger deliveryId) {
        this._lastDeliveryId = deliveryId;
    }

    public void updateDisposition(Binary deliveryTag, DeliveryState state, boolean settled) {
        UnsignedInteger deliveryId;
        if (settled && (deliveryId = this._unsettledMap.remove(deliveryTag)) != null) {
            this.settle(deliveryTag);
            this.getSession().updateDisposition(this.getRole(), deliveryId, deliveryId, state, settled);
        }
    }

    public Binary getTransactionId() {
        return this._transactionId;
    }
}

