/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.protocol.v1_0.DeliveryStateHandler;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkListener;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionalState;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;

public class ReceivingLink_1_0
implements ReceivingLinkListener,
Link_1_0,
DeliveryStateHandler {
    private NamedAddressSpace _addressSpace;
    private ReceivingDestination _destination;
    private SectionDecoderImpl _sectionDecoder;
    private volatile ReceivingLinkAttachment _attachment;
    private ArrayList<Transfer> _incompleteMessage;
    private TerminusDurability _durability;
    private Map<Binary, Outcome> _unsettledMap = Collections.synchronizedMap(new HashMap());
    private boolean _resumedMessage;
    private Binary _messageDeliveryTag;
    private ReceiverSettleMode _receivingSettlementMode;

    public ReceivingLink_1_0(ReceivingLinkAttachment receivingLinkAttachment, NamedAddressSpace addressSpace, ReceivingDestination destination) {
        this._addressSpace = addressSpace;
        this._destination = destination;
        this._attachment = receivingLinkAttachment;
        this._receivingSettlementMode = receivingLinkAttachment.getEndpoint().getReceivingSettlementMode();
        receivingLinkAttachment.setDeliveryStateHandler(this);
        this._durability = ((Target)receivingLinkAttachment.getTarget()).getDurable();
        this._sectionDecoder = new SectionDecoderImpl(receivingLinkAttachment.getEndpoint().getSession().getConnection().getDescribedTypeRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageTransfer(Transfer xfr) {
        List<QpidByteBuffer> fragments = null;
        DeliveryState xfrState = xfr.getState();
        final Binary deliveryTag = xfr.getDeliveryTag();
        if (Boolean.TRUE.equals(xfr.getMore()) && this._incompleteMessage == null) {
            this._incompleteMessage = new ArrayList();
            this._incompleteMessage.add(xfr);
            this._resumedMessage = Boolean.TRUE.equals(xfr.getResume());
            this._messageDeliveryTag = deliveryTag;
            return;
        }
        if (this._incompleteMessage != null) {
            this._incompleteMessage.add(xfr);
            if (Boolean.TRUE.equals(xfr.getMore())) {
                return;
            }
            fragments = new ArrayList<QpidByteBuffer>(this._incompleteMessage.size());
            for (Transfer t : this._incompleteMessage) {
                fragments.add(t.getPayload().duplicate());
                t.dispose();
            }
            this._incompleteMessage = null;
        } else {
            this._resumedMessage = Boolean.TRUE.equals(xfr.getResume());
            this._messageDeliveryTag = deliveryTag;
            fragments = Collections.singletonList(xfr.getPayload().duplicate());
            xfr.dispose();
        }
        if (this._resumedMessage) {
            if (this._unsettledMap.containsKey(this._messageDeliveryTag)) {
                Outcome outcome = this._unsettledMap.get(this._messageDeliveryTag);
                boolean settled = ReceiverSettleMode.FIRST.equals(this.getReceivingSettlementMode());
                this.getEndpoint().updateDisposition(this._messageDeliveryTag, (DeliveryState)((Object)outcome), settled);
                if (settled) {
                    this._unsettledMap.remove(this._messageDeliveryTag);
                }
            } else {
                System.err.println("UNEXPECTED!!");
                System.err.println("Delivery Tag: " + this._messageDeliveryTag);
                System.err.println("_unsettledMap: " + this._unsettledMap);
            }
        } else {
            MessageMetaData_1_0 mmd = null;
            ArrayList<QpidByteBuffer> immutableSections = new ArrayList<QpidByteBuffer>(3);
            mmd = new MessageMetaData_1_0(fragments.toArray(new QpidByteBuffer[fragments.size()]), this._sectionDecoder, immutableSections);
            MessageHandle handle = this._addressSpace.getMessageStore().addMessage((StorableMessageMetaData)mmd);
            for (QpidByteBuffer bareMessageBuf : immutableSections) {
                handle.addContent(bareMessageBuf);
            }
            StoredMessage storedMessage = handle.allContentAdded();
            Message_1_0 message = new Message_1_0((StoredMessage<MessageMetaData_1_0>)storedMessage, this.getSession().getConnection().getReference());
            for (QpidByteBuffer fragment : fragments) {
                fragment.dispose();
            }
            fragments = null;
            MessageReference reference = message.newReference();
            try {
                Session_1_0 session;
                Binary transactionId = null;
                if (xfrState != null && xfrState instanceof TransactionalState) {
                    transactionId = ((TransactionalState)xfrState).getTxnId();
                }
                Object transaction = null;
                transaction = transactionId != null ? this.getSession().getTransaction(transactionId) : ((session = this.getSession()) != null ? session.getTransaction(null) : new AutoCommitTransaction(this._addressSpace.getMessageStore()));
                try {
                    boolean settled;
                    DeliveryState resultantState;
                    session = this.getSession();
                    long arrivalTime = message.getArrivalTime();
                    session.getAMQPConnection().checkAuthorizedMessagePrincipal(message.getMessageHeader().getUserId());
                    this._destination.authorizePublish(session.getSecurityToken(), message);
                    Outcome outcome = this._destination.send(message, (ServerTransaction)transaction);
                    if (transactionId == null) {
                        resultantState = (DeliveryState)((Object)outcome);
                    } else {
                        TransactionalState transactionalState = new TransactionalState();
                        transactionalState.setOutcome(outcome);
                        transactionalState.setTxnId(transactionId);
                        resultantState = transactionalState;
                    }
                    boolean bl = settled = transaction instanceof AutoCommitTransaction && ReceiverSettleMode.FIRST.equals(this.getReceivingSettlementMode());
                    if (!settled) {
                        this._unsettledMap.put(deliveryTag, outcome);
                    }
                    this.getEndpoint().updateDisposition(deliveryTag, resultantState, settled);
                    this.getSession().getAMQPConnection().registerMessageReceived(message.getSize(), arrivalTime);
                    if (!(transaction instanceof AutoCommitTransaction)) {
                        transaction.addPostTransactionAction(new ServerTransaction.Action(){

                            public void postCommit() {
                                ReceivingLink_1_0.this.getEndpoint().updateDisposition(deliveryTag, null, true);
                            }

                            public void onRollback() {
                                ReceivingLink_1_0.this.getEndpoint().updateDisposition(deliveryTag, null, true);
                            }
                        });
                    }
                }
                catch (AccessControlException e) {
                    Error err = new Error();
                    err.setCondition(AmqpError.NOT_ALLOWED);
                    err.setDescription(e.getMessage());
                    this._attachment.getEndpoint().close(err);
                }
            }
            finally {
                reference.release();
            }
        }
    }

    private ReceiverSettleMode getReceivingSettlementMode() {
        return this._receivingSettlementMode;
    }

    @Override
    public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
        if (!TerminusDurability.UNSETTLED_STATE.equals(this._durability) || detach != null && Boolean.TRUE.equals(detach.getClosed())) {
            endpoint.close();
        } else if (detach == null || detach.getError() != null) {
            this._attachment = null;
        }
    }

    @Override
    public void start() {
        this.getEndpoint().setLinkCredit(UnsignedInteger.valueOf(this._destination.getCredit()));
        this.getEndpoint().setCreditWindow();
    }

    public ReceivingLinkEndpoint getEndpoint() {
        return this._attachment.getEndpoint();
    }

    public Session_1_0 getSession() {
        ReceivingLinkAttachment attachment = this._attachment;
        return attachment == null ? null : attachment.getSession();
    }

    @Override
    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        if (Boolean.TRUE.equals(settled)) {
            this._unsettledMap.remove(deliveryTag);
        }
    }

    public void setLinkAttachment(ReceivingLinkAttachment linkAttachment) {
        this._attachment = linkAttachment;
        this._receivingSettlementMode = linkAttachment.getEndpoint().getReceivingSettlementMode();
        ReceivingLinkEndpoint endpoint = linkAttachment.getEndpoint();
        Map initialUnsettledMap = endpoint.getInitialUnsettledMap();
        HashMap<Binary, Outcome> unsettledCopy = new HashMap<Binary, Outcome>(this._unsettledMap);
        for (Map.Entry entry : unsettledCopy.entrySet()) {
            Binary deliveryTag = (Binary)entry.getKey();
            if (initialUnsettledMap.containsKey(deliveryTag)) continue;
            this._unsettledMap.remove(deliveryTag);
        }
    }

    public Map getUnsettledOutcomeMap() {
        return this._unsettledMap;
    }
}

