/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Collections;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v1_0.MessageSourceDestination;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.txn.ServerTransaction;

public class QueueDestination
extends MessageSourceDestination
implements SendingDestination,
ReceivingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED};
    private final String _address;
    private final Queue<?> _queue;

    public QueueDestination(Queue<?> queue, String address) {
        super((MessageSource)queue);
        this._queue = queue;
        this._address = address;
    }

    @Override
    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    @Override
    public Outcome send(final Message_1_0 message, ServerTransaction txn) {
        txn.enqueue(this.getQueue(), (EnqueueableMessage)message, new ServerTransaction.EnqueueAction(){
            MessageReference _reference;
            {
                this._reference = message.newReference();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void postCommit(MessageEnqueueRecord ... records) {
                try {
                    QueueDestination.this.getQueue().enqueue((ServerMessage)message, null, records[0]);
                }
                finally {
                    this._reference.release();
                }
            }

            public void onRollback() {
                this._reference.release();
            }
        });
        return ACCEPTED;
    }

    @Override
    public int getCredit() {
        return 100;
    }

    public Queue<?> getQueue() {
        return (Queue)super.getQueue();
    }

    @Override
    public String getRoutingAddress(Message_1_0 message) {
        return "";
    }

    @Override
    public void authorizePublish(SecurityToken securityToken, Message_1_0 message) {
        this._queue.authorisePublish(securityToken, Collections.singletonMap("routingKey", this.getRoutingAddress(message)));
    }

    @Override
    public String getAddress() {
        return this._address;
    }
}

