/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.HashSet;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.ProtocolEngineCreator_1_0_0_SASL;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class ProtocolEngineCreator_1_0_0
implements ProtocolEngineCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolEngineCreator_1_0_0.class);
    private static final byte[] AMQP_1_0_0_HEADER = new byte[]{65, 77, 81, 80, 0, 1, 0, 0};
    private static ProtocolEngineCreator INSTANCE = new ProtocolEngineCreator_1_0_0();

    public Protocol getVersion() {
        return Protocol.AMQP_1_0;
    }

    public byte[] getHeaderIdentifier() {
        return AMQP_1_0_0_HEADER;
    }

    public ProtocolEngine newProtocolEngine(Broker<?> broker, ServerNetworkConnection network, AmqpPort<?> port, Transport transport, long id, AggregateTicker aggregateTicker) {
        AuthenticationProvider authenticationProvider = port.getAuthenticationProvider();
        HashSet supportedMechanisms = new HashSet(authenticationProvider.getMechanisms());
        supportedMechanisms.removeAll(authenticationProvider.getDisabledMechanisms());
        if (!transport.isSecure()) {
            supportedMechanisms.removeAll(authenticationProvider.getSecureOnlyMechanisms());
        }
        if (supportedMechanisms.contains("ANONYMOUS") || supportedMechanisms.contains("EXTERNAL") && network.getPeerPrincipal() != null) {
            AMQPConnection_1_0 amqpConnection_1_0 = new AMQPConnection_1_0(broker, network, port, transport, id, aggregateTicker, false);
            amqpConnection_1_0.create();
            return amqpConnection_1_0;
        }
        LOGGER.info("Attempt to connect using AMQP 1.0 without using SASL authentication on a port which does not support ANONYMOUS or EXTERNAL by " + network.getRemoteAddress());
        return null;
    }

    public byte[] getSuggestedAlternativeHeader() {
        return ProtocolEngineCreator_1_0_0_SASL.getInstance().getHeaderIdentifier();
    }

    public static ProtocolEngineCreator getInstance() {
        return INSTANCE;
    }

    public String getType() {
        return this.getVersion().toString();
    }
}

