/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Arrays;
import java.util.Collections;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.txn.ServerTransaction;

public class NodeReceivingDestination
implements ReceivingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    public static final Rejected REJECTED = new Rejected();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED, REJECTED};
    private final boolean _discardUnroutable;
    private MessageDestination _destination;
    private TerminusDurability _durability;
    private TerminusExpiryPolicy _expiryPolicy;
    private final String _address;

    public NodeReceivingDestination(MessageDestination destination, TerminusDurability durable, TerminusExpiryPolicy expiryPolicy, String address, Symbol[] capabilities) {
        this._destination = destination;
        this._durability = durable;
        this._expiryPolicy = expiryPolicy;
        this._address = address;
        this._discardUnroutable = destination instanceof Exchange && (capabilities != null && Arrays.asList(capabilities).contains(DISCARD_UNROUTABLE) || ((Exchange)destination).getUnroutableMessageBehaviour() == Exchange.UnroutableMessageBehaviour.DISCARD);
    }

    @Override
    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    @Override
    public Outcome send(final Message_1_0 message, ServerTransaction txn) {
        InstanceProperties instanceProperties = new InstanceProperties(){

            public Object getProperty(InstanceProperties.Property prop) {
                switch (prop) {
                    case MANDATORY: {
                        return false;
                    }
                    case REDELIVERED: {
                        return false;
                    }
                    case PERSISTENT: {
                        return message.isPersistent();
                    }
                    case IMMEDIATE: {
                        return false;
                    }
                    case EXPIRATION: {
                        return message.getExpiration();
                    }
                }
                return null;
            }
        };
        String routingAddress = this.getRoutingAddress(message);
        int enqueues = this._destination.send((ServerMessage)message, routingAddress, instanceProperties, txn, null);
        return enqueues == 0 && !this._discardUnroutable ? REJECTED : ACCEPTED;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public void authorizePublish(SecurityToken securityToken, Message_1_0 message) {
        this._destination.authorisePublish(securityToken, Collections.singletonMap("routingKey", this.getRoutingAddress(message)));
    }

    @Override
    public String getRoutingAddress(Message_1_0 message) {
        MessageMetaData_1_0.MessageHeader_1_0 messageHeader = message.getMessageHeader();
        String routingAddress = messageHeader.getSubject();
        if (routingAddress == null) {
            routingAddress = messageHeader.getHeader("routing-key") instanceof String ? (String)messageHeader.getHeader("routing-key") : (messageHeader.getHeader("routing_key") instanceof String ? (String)messageHeader.getHeader("routing_key") : (messageHeader.getTo() != null && messageHeader.getTo().startsWith(this._destination.getName() + "/") ? messageHeader.getTo().substring(1 + this._destination.getName().length()) : ""));
        }
        return routingAddress;
    }

    TerminusDurability getDurability() {
        return this._durability;
    }

    TerminusExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    @Override
    public int getCredit() {
        return 20000;
    }

    public MessageDestination getDestination() {
        return this._destination;
    }

    @Override
    public Symbol[] getCapabilities() {
        Symbol[] capabilities = new Symbol[]{this._discardUnroutable ? DISCARD_UNROUTABLE : REJECT_UNROUTABLE};
        return capabilities;
    }
}

