/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.store.StoredMessage;

public class Message_1_0
extends AbstractServerMessageImpl<Message_1_0, MessageMetaData_1_0> {
    private static final AMQPDescribedTypeRegistry DESCRIBED_TYPE_REGISTRY = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();
    public static final MessageMetaData_1_0 DELETED_MESSAGE_METADATA = new MessageMetaData_1_0(Collections.emptyList(), new SectionEncoderImpl(DESCRIBED_TYPE_REGISTRY));
    private long _arrivalTime;
    private final long _size;

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage) {
        super(storedMessage, null);
        this._size = ((MessageMetaData_1_0)storedMessage.getMetaData()).getContentSize();
    }

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage, Object connectionReference) {
        super(storedMessage, connectionReference);
        this._size = ((MessageMetaData_1_0)storedMessage.getMetaData()).getContentSize();
        this._arrivalTime = System.currentTimeMillis();
    }

    public String getInitialRoutingAddress() {
        Object routingKey = this.getMessageHeader().getHeader("routing-key");
        if (routingKey != null) {
            return routingKey.toString();
        }
        return this.getMessageHeader().getTo();
    }

    private MessageMetaData_1_0 getMessageMetaData() {
        MessageMetaData_1_0 metaData = (MessageMetaData_1_0)this.getStoredMessage().getMetaData();
        return metaData == null ? DELETED_MESSAGE_METADATA : metaData;
    }

    public MessageMetaData_1_0.MessageHeader_1_0 getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    public long getSize() {
        return this._size;
    }

    public long getExpiration() {
        return this.getMessageHeader().getExpiration();
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public Collection<QpidByteBuffer> getFragments() {
        return this.getContent(0, (int)this.getSize());
    }
}

