/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.protocol.v1_0.MessageMetaDataType_1_0;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoder;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Section;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequence;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Data;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Footer;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaData_1_0
implements StorableMessageMetaData {
    private static final Logger _logger = LoggerFactory.getLogger(MessageMetaData_1_0.class);
    public static final Symbol JMS_TYPE = Symbol.valueOf("x-opt-jms-type");
    public static final MessageMetaDataType.Factory<MessageMetaData_1_0> FACTORY = new MetaDataFactory();
    private static final MessageMetaDataType_1_0 TYPE = new MessageMetaDataType_1_0();
    private Header _header;
    private Properties _properties;
    private Map _deliveryAnnotations;
    private Map _messageAnnotations;
    private Map _appProperties;
    private Map _footer;
    private volatile List<QpidByteBuffer> _encodedSections = new ArrayList<QpidByteBuffer>(3);
    private volatile QpidByteBuffer _encoded;
    private MessageHeader_1_0 _messageHeader;

    public MessageMetaData_1_0(List<Section> sections, SectionEncoder encoder) {
        this(sections, MessageMetaData_1_0.encodeSections(sections, encoder));
    }

    public Properties getPropertiesSection() {
        return this._properties;
    }

    public Header getHeaderSection() {
        return this._header;
    }

    private static ArrayList<QpidByteBuffer> encodeSections(List<Section> sections, SectionEncoder encoder) {
        ArrayList<QpidByteBuffer> encodedSections = new ArrayList<QpidByteBuffer>(sections.size());
        for (Section section : sections) {
            encoder.encodeObject(section);
            encodedSections.add(QpidByteBuffer.wrap((ByteBuffer)encoder.getEncoding().asByteBuffer()));
            encoder.reset();
        }
        return encodedSections;
    }

    public MessageMetaData_1_0(QpidByteBuffer[] fragments, SectionDecoder decoder) {
        this(fragments, decoder, new ArrayList<QpidByteBuffer>(3));
    }

    public MessageMetaData_1_0(QpidByteBuffer[] fragments, SectionDecoder decoder, List<QpidByteBuffer> immutableSections) {
        this(MessageMetaData_1_0.constructSections(fragments, decoder, immutableSections), immutableSections);
    }

    private MessageMetaData_1_0(List<Section> sections, List<QpidByteBuffer> encodedSections) {
        Section section;
        this._encodedSections = encodedSections;
        Iterator<Section> sectIter = sections.iterator();
        Section section2 = section = sectIter.hasNext() ? sectIter.next() : null;
        if (section instanceof Header) {
            this._header = (Header)section;
            Section section3 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof DeliveryAnnotations) {
            this._deliveryAnnotations = ((DeliveryAnnotations)section).getValue();
            Section section4 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof MessageAnnotations) {
            this._messageAnnotations = ((MessageAnnotations)section).getValue();
            Section section5 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof Properties) {
            this._properties = (Properties)section;
            Section section6 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof ApplicationProperties) {
            this._appProperties = ((ApplicationProperties)section).getValue();
            Section section7 = section = sectIter.hasNext() ? sectIter.next() : null;
        }
        if (section instanceof Footer) {
            this._footer = ((Footer)section).getValue();
            section = sectIter.hasNext() ? sectIter.next() : null;
        }
        this._messageHeader = new MessageHeader_1_0();
    }

    private static List<Section> constructSections(QpidByteBuffer[] fragments, SectionDecoder decoder, List<QpidByteBuffer> encodedSections) {
        QpidByteBuffer src;
        ArrayList<Section> sections = new ArrayList<Section>(3);
        if (fragments.length == 1) {
            src = fragments[0].duplicate();
        } else {
            int size = 0;
            for (QpidByteBuffer buf : fragments) {
                size += buf.remaining();
            }
            src = QpidByteBuffer.allocateDirect((int)size);
            for (QpidByteBuffer buf : fragments) {
                QpidByteBuffer duplicate = buf.duplicate();
                src.put(duplicate);
                duplicate.dispose();
            }
            src.flip();
        }
        try {
            int startBarePos = -1;
            int lastPos = src.position();
            Section s = decoder.readSection(src);
            if (s instanceof Header) {
                sections.add(s);
                lastPos = src.position();
                Section section = s = src.hasRemaining() ? decoder.readSection(src) : null;
            }
            if (s instanceof DeliveryAnnotations) {
                sections.add(s);
                lastPos = src.position();
                Section section = s = src.hasRemaining() ? decoder.readSection(src) : null;
            }
            if (s instanceof MessageAnnotations) {
                sections.add(s);
                lastPos = src.position();
                Section section = s = src.hasRemaining() ? decoder.readSection(src) : null;
            }
            if (s instanceof Properties) {
                sections.add(s);
                if (startBarePos == -1) {
                    startBarePos = lastPos;
                }
                Section section = s = src.hasRemaining() ? decoder.readSection(src) : null;
            }
            if (s instanceof ApplicationProperties) {
                sections.add(s);
                if (startBarePos == -1) {
                    startBarePos = lastPos;
                }
                Section section = s = src.hasRemaining() ? decoder.readSection(src) : null;
            }
            if (s instanceof AmqpValue) {
                if (startBarePos == -1) {
                    startBarePos = lastPos;
                }
                s = src.hasRemaining() ? decoder.readSection(src) : null;
            } else if (s instanceof Data) {
                if (startBarePos == -1) {
                    startBarePos = lastPos;
                }
                while ((s = src.hasRemaining() ? decoder.readSection(src) : null) instanceof Data) {
                }
            } else if (s instanceof AmqpSequence) {
                if (startBarePos == -1) {
                    startBarePos = lastPos;
                }
                while ((s = src.hasRemaining() ? decoder.readSection(src) : null) instanceof AmqpSequence) {
                }
            }
            if (s instanceof Footer) {
                sections.add(s);
            }
            for (QpidByteBuffer buf : fragments) {
                encodedSections.add(buf.duplicate());
            }
            ArrayList<Section> arrayList = sections;
            return arrayList;
        }
        catch (AmqpErrorException e) {
            _logger.error("Decoding read section error", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        finally {
            src.dispose();
        }
    }

    public MessageMetaDataType getType() {
        return TYPE;
    }

    public int getStorableSize() {
        int size = 0;
        for (QpidByteBuffer bin : this._encodedSections) {
            size += bin.limit();
        }
        return size;
    }

    private QpidByteBuffer encodeAsBuffer() {
        QpidByteBuffer buf = QpidByteBuffer.allocateDirect((int)this.getStorableSize());
        for (QpidByteBuffer bin : this._encodedSections) {
            QpidByteBuffer duplicate = bin.duplicate();
            buf.put(duplicate);
            duplicate.dispose();
        }
        buf.flip();
        return buf;
    }

    public int writeToBuffer(QpidByteBuffer dest) {
        QpidByteBuffer buf = this._encoded;
        if (buf == null) {
            this._encoded = buf = this.encodeAsBuffer();
        }
        buf = buf.duplicate();
        buf.position(0);
        if (dest.remaining() < buf.limit()) {
            buf.limit(dest.remaining());
        }
        int length = buf.limit();
        dest.putCopyOf(buf);
        buf.dispose();
        return length;
    }

    public int getContentSize() {
        QpidByteBuffer buf = this._encoded;
        if (buf == null) {
            this._encoded = buf = this.encodeAsBuffer();
        }
        return buf.remaining();
    }

    public boolean isPersistent() {
        return this._header != null && Boolean.TRUE.equals(this._header.getDurable());
    }

    public MessageHeader_1_0 getMessageHeader() {
        return this._messageHeader;
    }

    public void dispose() {
        for (QpidByteBuffer bin : this._encodedSections) {
            bin.dispose();
        }
        this._encodedSections = null;
        this._encoded.dispose();
        this._encoded = null;
    }

    public void clearEncodedForm() {
    }

    public class MessageHeader_1_0
    implements AMQMessageHeader {
        public String getCorrelationId() {
            if (MessageMetaData_1_0.this._properties == null || MessageMetaData_1_0.this._properties.getCorrelationId() == null) {
                return null;
            }
            return MessageMetaData_1_0.this._properties.getCorrelationId().toString();
        }

        public long getExpiration() {
            return 0L;
        }

        public String getMessageId() {
            if (MessageMetaData_1_0.this._properties == null || MessageMetaData_1_0.this._properties.getMessageId() == null) {
                return null;
            }
            return MessageMetaData_1_0.this._properties.getMessageId().toString();
        }

        public String getMimeType() {
            if (MessageMetaData_1_0.this._properties == null || MessageMetaData_1_0.this._properties.getContentType() == null) {
                return null;
            }
            return MessageMetaData_1_0.this._properties.getContentType().toString();
        }

        public String getEncoding() {
            return null;
        }

        public byte getPriority() {
            if (MessageMetaData_1_0.this._header == null || MessageMetaData_1_0.this._header.getPriority() == null) {
                return 4;
            }
            return MessageMetaData_1_0.this._header.getPriority().byteValue();
        }

        public long getTimestamp() {
            if (MessageMetaData_1_0.this._properties == null || MessageMetaData_1_0.this._properties.getCreationTime() == null) {
                return 0L;
            }
            return MessageMetaData_1_0.this._properties.getCreationTime().getTime();
        }

        public long getNotValidBefore() {
            Object annotation;
            long notValidBefore = MessageMetaData_1_0.this._messageAnnotations != null && (annotation = MessageMetaData_1_0.this._messageAnnotations.get(Symbol.valueOf("x-qpid-not-valid-before"))) instanceof Number ? ((Number)annotation).longValue() : 0L;
            return notValidBefore;
        }

        public String getType() {
            String subject = this.getSubject();
            if (subject != null) {
                return subject;
            }
            if (MessageMetaData_1_0.this._messageAnnotations == null || MessageMetaData_1_0.this._messageAnnotations.get(JMS_TYPE) == null) {
                return null;
            }
            return MessageMetaData_1_0.this._messageAnnotations.get(JMS_TYPE).toString();
        }

        public String getReplyTo() {
            if (MessageMetaData_1_0.this._properties == null || MessageMetaData_1_0.this._properties.getReplyTo() == null) {
                return null;
            }
            return MessageMetaData_1_0.this._properties.getReplyTo();
        }

        public String getAppId() {
            return null;
        }

        public String getUserId() {
            return null;
        }

        public Object getHeader(String name) {
            return MessageMetaData_1_0.this._appProperties == null ? null : MessageMetaData_1_0.this._appProperties.get(name);
        }

        public boolean containsHeaders(Set<String> names) {
            if (MessageMetaData_1_0.this._appProperties == null) {
                return false;
            }
            for (String key : names) {
                if (MessageMetaData_1_0.this._appProperties.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public Collection<String> getHeaderNames() {
            if (MessageMetaData_1_0.this._appProperties == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableCollection(MessageMetaData_1_0.this._appProperties.keySet());
        }

        public boolean containsHeader(String name) {
            return MessageMetaData_1_0.this._appProperties != null && MessageMetaData_1_0.this._appProperties.containsKey(name);
        }

        public String getSubject() {
            return MessageMetaData_1_0.this._properties == null ? null : MessageMetaData_1_0.this._properties.getSubject();
        }

        public String getTo() {
            return MessageMetaData_1_0.this._properties == null ? null : MessageMetaData_1_0.this._properties.getTo();
        }

        public Map<String, Object> getHeadersAsMap() {
            return MessageMetaData_1_0.this._appProperties == null ? new HashMap<String, Object>() : new HashMap(MessageMetaData_1_0.this._appProperties);
        }
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MessageMetaData_1_0> {
        private final AMQPDescribedTypeRegistry _typeRegistry = AMQPDescribedTypeRegistry.newInstance();

        private MetaDataFactory() {
            this._typeRegistry.registerTransportLayer();
            this._typeRegistry.registerMessagingLayer();
            this._typeRegistry.registerTransactionLayer();
            this._typeRegistry.registerSecurityLayer();
        }

        public MessageMetaData_1_0 createMetaData(QpidByteBuffer buf) {
            ValueHandler valueHandler = new ValueHandler(this._typeRegistry);
            ArrayList<Section> sections = new ArrayList<Section>(3);
            ArrayList<QpidByteBuffer> encodedSections = new ArrayList<QpidByteBuffer>(3);
            while (buf.hasRemaining()) {
                try {
                    int start = buf.position();
                    QpidByteBuffer encodedBuf = buf.slice();
                    Object parse = valueHandler.parse(buf);
                    sections.add((Section)parse);
                    encodedBuf.limit(buf.position() - start);
                    encodedSections.add(encodedBuf);
                }
                catch (AmqpErrorException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
            }
            return new MessageMetaData_1_0(sections, encodedSections);
        }
    }
}

