/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Section;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Data;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.typedmessage.TypedBytesContentReader;
import org.apache.qpid.typedmessage.TypedBytesFormatException;
import org.apache.qpid.util.GZIPUtils;

public abstract class MessageConverter_to_1_0<M extends ServerMessage>
implements MessageConverter<M, Message_1_0> {
    private final AMQPDescribedTypeRegistry _typeRegistry = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();

    public final Class<Message_1_0> getOutputClass() {
        return Message_1_0.class;
    }

    public final Message_1_0 convert(M message, NamedAddressSpace addressSpace) {
        SectionEncoderImpl sectionEncoder = new SectionEncoderImpl(this._typeRegistry);
        return new Message_1_0(this.convertToStoredMessage(message, sectionEncoder));
    }

    private StoredMessage<MessageMetaData_1_0> convertToStoredMessage(M serverMessage, SectionEncoder sectionEncoder) {
        Section bodySection = this.getBodySection(serverMessage);
        MessageMetaData_1_0 metaData = this.convertMetaData(serverMessage, bodySection, sectionEncoder);
        return this.convertServerMessage(metaData, serverMessage);
    }

    protected abstract MessageMetaData_1_0 convertMetaData(M var1, Section var2, SectionEncoder var3);

    private static Section convertMessageBody(String mimeType, byte[] data) {
        if ("text/plain".equals(mimeType) || "text/xml".equals(mimeType)) {
            String text = new String(data);
            return new AmqpValue(text);
        }
        if ("jms/map-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int entries = reader.readIntImpl();
            for (int i = 0; i < entries; ++i) {
                try {
                    String propName = reader.readStringImpl();
                    Object value = reader.readObject();
                    map.put(propName, value);
                    continue;
                }
                catch (EOFException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (TypedBytesFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return new AmqpValue(MessageConverter_to_1_0.fixMapValues(map));
        }
        if ("amqp/map".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            Map map = decoder.readMap();
            return new AmqpValue(MessageConverter_to_1_0.fixMapValues(map));
        }
        if ("amqp/list".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return new AmqpValue(MessageConverter_to_1_0.fixListValues(decoder.readList()));
        }
        if ("jms/stream-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            ArrayList<Object> list = new ArrayList<Object>();
            while (reader.remaining() != 0) {
                try {
                    list.add(MessageConverter_to_1_0.fixValue(reader.readObject()));
                }
                catch (TypedBytesFormatException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                catch (EOFException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
            }
            return new AmqpValue(list);
        }
        return new Data(new Binary(data));
    }

    static Map fixMapValues(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entry.setValue(MessageConverter_to_1_0.fixValue(entry.getValue()));
        }
        return map;
    }

    static Object fixValue(Object value) {
        if (value instanceof byte[]) {
            return new Binary((byte[])value);
        }
        if (value instanceof Map) {
            return MessageConverter_to_1_0.fixMapValues((Map)value);
        }
        if (value instanceof List) {
            return MessageConverter_to_1_0.fixListValues((List)value);
        }
        return value;
    }

    static List fixListValues(List list) {
        ListIterator<Object> iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            iterator.set(MessageConverter_to_1_0.fixValue(value));
        }
        return list;
    }

    private StoredMessage<MessageMetaData_1_0> convertServerMessage(final MessageMetaData_1_0 metaData, final M serverMessage) {
        final QpidByteBuffer allData = QpidByteBuffer.allocateDirect((int)metaData.getStorableSize());
        metaData.writeToBuffer(allData);
        allData.rewind();
        if (metaData.getPropertiesSection() != null) {
            metaData.getPropertiesSection().setContentEncoding(null);
        }
        return new StoredMessage<MessageMetaData_1_0>(){

            public MessageMetaData_1_0 getMetaData() {
                return metaData;
            }

            public long getMessageNumber() {
                return serverMessage.getMessageNumber();
            }

            public Collection<QpidByteBuffer> getContent(int offset, int length) {
                return Collections.singleton(allData.view(offset, length));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    protected Section getBodySection(M serverMessage) {
        byte[] uncompressed;
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        int total = 0;
        for (QpidByteBuffer b : serverMessage.getContent(0, (int)serverMessage.getSize())) {
            int len = b.remaining();
            b.get(data, total, len);
            b.dispose();
            total += len;
        }
        if (Symbol.valueOf("gzip").equals(serverMessage.getMessageHeader().getEncoding()) && (uncompressed = GZIPUtils.uncompressBufferToArray((ByteBuffer)ByteBuffer.wrap(data))) != null) {
            data = uncompressed;
        }
        return MessageConverter_to_1_0.convertMessageBody(mimeType, data);
    }
}

