/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_v1_0_to_Internal;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Section;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedShort;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequence;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Data;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.transport.codec.BBEncoder;
import org.apache.qpid.typedmessage.TypedBytesContentWriter;
import org.apache.qpid.typedmessage.TypedBytesFormatException;

public class MessageConverter_from_1_0 {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Set<Class> STANDARD_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, byte[].class, UUID.class));

    public static Object convertBodyToObject(Message_1_0 serverMessage) {
        Object bodyObject;
        byte[] data = new byte[(int)serverMessage.getSize()];
        Collection allData = serverMessage.getContent(0, (int)serverMessage.getSize());
        int offset = 0;
        for (QpidByteBuffer buf : allData) {
            int len = buf.remaining();
            buf.get(data, offset, len);
            offset += len;
            buf.dispose();
        }
        SectionDecoderImpl sectionDecoder = new SectionDecoderImpl(MessageConverter_v1_0_to_Internal.TYPE_REGISTRY);
        try {
            List<Section> sections = sectionDecoder.parseAll(QpidByteBuffer.wrap((byte[])data));
            ListIterator<Section> iterator = sections.listIterator();
            Object previousSection = null;
            while (iterator.hasNext()) {
                Section section = iterator.next();
                if (!(section instanceof AmqpValue || section instanceof Data || section instanceof AmqpSequence)) {
                    iterator.remove();
                    continue;
                }
                if (previousSection != null && (previousSection.getClass() != section.getClass() || section instanceof AmqpValue)) {
                    throw new ConnectionScopedRuntimeException("Message is badly formed and has multiple body section which are not all Data or not all AmqpSequence");
                }
                previousSection = section;
            }
            if (sections.isEmpty()) {
                bodyObject = new byte[]{};
            } else {
                Section firstBodySection = sections.get(0);
                if (firstBodySection instanceof AmqpValue) {
                    bodyObject = MessageConverter_from_1_0.convertValue(((AmqpValue)firstBodySection).getValue());
                } else if (firstBodySection instanceof Data) {
                    int totalSize = 0;
                    for (Section section : sections) {
                        totalSize += ((Data)section).getValue().getLength();
                    }
                    byte[] bodyData = new byte[totalSize];
                    ByteBuffer buf = ByteBuffer.wrap(bodyData);
                    for (Section section : sections) {
                        buf.put(((Data)section).getValue().asByteBuffer());
                    }
                    bodyObject = bodyData;
                } else {
                    ArrayList totalSequence = new ArrayList();
                    for (Section section : sections) {
                        totalSequence.addAll(((AmqpSequence)section).getValue());
                    }
                    bodyObject = MessageConverter_from_1_0.convertValue(totalSequence);
                }
            }
        }
        catch (AmqpErrorException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
        return bodyObject;
    }

    private static Map convertMap(Map map) {
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            resultMap.put(MessageConverter_from_1_0.convertValue(entry.getKey()), MessageConverter_from_1_0.convertValue(entry.getValue()));
        }
        return resultMap;
    }

    public static Object convertValue(Object value) {
        if (value != null && !STANDARD_TYPES.contains(value.getClass())) {
            if (value instanceof Map) {
                return MessageConverter_from_1_0.convertMap((Map)value);
            }
            if (value instanceof List) {
                return MessageConverter_from_1_0.convertList((List)value);
            }
            if (value instanceof UnsignedByte) {
                return ((UnsignedByte)value).shortValue();
            }
            if (value instanceof UnsignedShort) {
                return ((UnsignedShort)value).intValue();
            }
            if (value instanceof UnsignedInteger) {
                return ((UnsignedInteger)value).longValue();
            }
            if (value instanceof UnsignedLong) {
                return ((UnsignedLong)value).longValue();
            }
            if (value instanceof Symbol) {
                return value.toString();
            }
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                byte[] data = new byte[binary.getLength()];
                binary.asByteBuffer().get(data);
                return data;
            }
            return value.toString();
        }
        return value;
    }

    private static List convertList(List list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object entry : list) {
            result.add(MessageConverter_from_1_0.convertValue(entry));
        }
        return result;
    }

    public static byte[] convertToBody(Object object) {
        if (object instanceof String) {
            return ((String)object).getBytes(UTF_8);
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Map) {
            BBEncoder encoder = new BBEncoder(1024);
            encoder.writeMap((Map)object);
            ByteBuffer buf = encoder.segment();
            int remaining = buf.remaining();
            byte[] data = new byte[remaining];
            buf.get(data);
            return data;
        }
        if (object instanceof List) {
            try {
                ByteBuffer buf;
                if (MessageConverter_from_1_0.onlyPrimitiveTypes((List)object)) {
                    TypedBytesContentWriter writer = new TypedBytesContentWriter();
                    for (Object value : (List)object) {
                        writer.writeObject(value);
                    }
                    buf = writer.getData();
                } else {
                    BBEncoder encoder = new BBEncoder(1024);
                    encoder.writeList((List)object);
                    buf = encoder.segment();
                }
                int remaining = buf.remaining();
                byte[] data = new byte[remaining];
                buf.get(data);
                return data;
            }
            catch (TypedBytesFormatException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bytesOut);
            os.writeObject(object);
            return bytesOut.toByteArray();
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    public static boolean onlyPrimitiveTypes(List list) {
        for (Object value : list) {
            if (value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Boolean || value instanceof byte[]) continue;
            return false;
        }
        return true;
    }

    public static String getBodyMimeType(Object object) {
        if (object instanceof String) {
            return "text/plain";
        }
        if (object instanceof byte[]) {
            return "application/octet-stream";
        }
        if (object instanceof Map) {
            return "amqp/map";
        }
        if (object instanceof List) {
            return MessageConverter_from_1_0.onlyPrimitiveTypes((List)object) ? "jms/stream-message" : "amqp/list";
        }
        return "application/java-object-stream";
    }
}

