/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Arrays;
import java.util.Collections;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Rejected;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeDestination
implements ReceivingDestination,
SendingDestination {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExchangeDestination.class);
    private static final Accepted ACCEPTED = new Accepted();
    public static final Rejected REJECTED = new Rejected();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED, REJECTED};
    private final String _address;
    private Exchange<?> _exchange;
    private TerminusDurability _durability;
    private TerminusExpiryPolicy _expiryPolicy;
    private String _initialRoutingAddress;
    private final boolean _discardUnroutable;

    public ExchangeDestination(Exchange<?> exchange, TerminusDurability durable, TerminusExpiryPolicy expiryPolicy, String address, Symbol[] capabilities) {
        this._exchange = exchange;
        this._durability = durable;
        this._expiryPolicy = expiryPolicy;
        this._address = address;
        this._discardUnroutable = capabilities != null && Arrays.asList(capabilities).contains(DISCARD_UNROUTABLE) || exchange.getUnroutableMessageBehaviour() == Exchange.UnroutableMessageBehaviour.DISCARD;
    }

    @Override
    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    @Override
    public Outcome send(final Message_1_0 message, ServerTransaction txn) {
        InstanceProperties instanceProperties = new InstanceProperties(){

            public Object getProperty(InstanceProperties.Property prop) {
                switch (prop) {
                    case MANDATORY: {
                        return false;
                    }
                    case REDELIVERED: {
                        return false;
                    }
                    case PERSISTENT: {
                        return message.isPersistent();
                    }
                    case IMMEDIATE: {
                        return false;
                    }
                    case EXPIRATION: {
                        return message.getExpiration();
                    }
                }
                return null;
            }
        };
        int enqueues = this._exchange.send((ServerMessage)message, this.getRoutingAddress(message), instanceProperties, txn, null);
        return enqueues == 0 && !this._discardUnroutable ? REJECTED : ACCEPTED;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    @Override
    public void authorizePublish(SecurityToken securityToken, Message_1_0 message) {
        this._exchange.authorisePublish(securityToken, Collections.singletonMap("routingKey", this.getRoutingAddress(message)));
    }

    @Override
    public String getRoutingAddress(Message_1_0 message) {
        String routingAddress;
        MessageMetaData_1_0.MessageHeader_1_0 messageHeader = message.getMessageHeader();
        if (this._initialRoutingAddress == null) {
            routingAddress = messageHeader.getSubject();
            if (routingAddress == null) {
                routingAddress = messageHeader.getHeader("routing-key") instanceof String ? (String)messageHeader.getHeader("routing-key") : (messageHeader.getHeader("routing_key") instanceof String ? (String)messageHeader.getHeader("routing_key") : (messageHeader.getTo() != null && messageHeader.getTo().startsWith(this._exchange.getName() + "/") ? messageHeader.getTo().substring(1 + this._exchange.getName().length()) : ""));
            }
        } else {
            routingAddress = messageHeader.getTo() != null && messageHeader.getTo().startsWith(this._exchange.getName() + "/" + this._initialRoutingAddress + "/") ? messageHeader.getTo().substring(2 + this._exchange.getName().length() + this._initialRoutingAddress.length()) : this._initialRoutingAddress;
        }
        return routingAddress;
    }

    TerminusDurability getDurability() {
        return this._durability;
    }

    TerminusExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    @Override
    public int getCredit() {
        return 20000;
    }

    public Exchange<?> getExchange() {
        return this._exchange;
    }

    public void setInitialRoutingAddress(String initialRoutingAddress) {
        this._initialRoutingAddress = initialRoutingAddress;
    }

    public String getInitialRoutingAddress() {
        return this._initialRoutingAddress;
    }

    @Override
    public Symbol[] getCapabilities() {
        Symbol[] capabilities = new Symbol[]{this._discardUnroutable ? DISCARD_UNROUTABLE : REJECT_UNROUTABLE};
        return capabilities;
    }
}

