/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.consumer.AbstractConsumerTarget;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.LinkRegistry;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.SendingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.SendingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnsettledAction;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.Target;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Modified;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Released;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionalState;
import org.apache.qpid.server.protocol.v1_0.type.transport.SenderSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerTarget_1_0
extends AbstractConsumerTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerTarget_1_0.class);
    private final boolean _acquires;
    private SendingLink_1_0 _link;
    private long _deliveryTag = 0L;
    private Binary _transactionId;
    private final AMQPDescribedTypeRegistry _typeRegistry;
    private final SectionEncoder _sectionEncoder;
    private boolean _queueEmpty;

    public ConsumerTarget_1_0(SendingLink_1_0 link, boolean acquires) {
        super(ConsumerTarget.State.SUSPENDED, ConsumerTarget_1_0.isPullOnly(link), false, link.getSession().getAMQPConnection());
        this._link = link;
        this._typeRegistry = link.getEndpoint().getSession().getConnection().getDescribedTypeRegistry();
        this._sectionEncoder = new SectionEncoderImpl(this._typeRegistry);
        this._acquires = acquires;
    }

    private static boolean isPullOnly(SendingLink_1_0 link) {
        Source source = (Source)link.getEndpoint().getSource();
        return source.getCapabilities() != null && Arrays.asList(source.getCapabilities()).contains(Symbol.getSymbol("QPID:PULL-ONLY"));
    }

    private SendingLinkEndpoint getEndpoint() {
        return this._link.getEndpoint();
    }

    public boolean isFlowSuspended() {
        return this._link.getSession().getAMQPConnection().isConnectionStopped() || this.getState() != ConsumerTarget.State.ACTIVE;
    }

    protected void doCloseInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(final ConsumerImpl consumer, final MessageInstance entry, boolean batch) {
        Message_1_0 message;
        ServerMessage serverMessage = entry.getMessage();
        if (serverMessage instanceof Message_1_0) {
            message = (Message_1_0)serverMessage;
        } else {
            MessageConverter converter = MessageConverterRegistry.getConverter(serverMessage.getClass(), Message_1_0.class);
            message = (Message_1_0)converter.convert(serverMessage, this._link.getAddressSpace());
        }
        Transfer transfer = new Transfer();
        try {
            QpidByteBuffer payload = null;
            Collection<QpidByteBuffer> fragments = message.getFragments();
            if (fragments.size() == 1) {
                payload = fragments.iterator().next();
            } else {
                int size = 0;
                for (QpidByteBuffer fragment : fragments) {
                    size += fragment.remaining();
                }
                payload = QpidByteBuffer.allocateDirect((int)size);
                for (QpidByteBuffer fragment : fragments) {
                    payload.put(fragment);
                    fragment.dispose();
                }
                payload.flip();
            }
            if (entry.getDeliveryCount() != 0) {
                ValueHandler valueHandler = new ValueHandler(this._typeRegistry);
                Header oldHeader = null;
                try {
                    Object value = valueHandler.parse(payload);
                    if (value instanceof Header) {
                        oldHeader = (Header)value;
                    } else {
                        payload.position(0);
                    }
                }
                catch (AmqpErrorException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                Header header = new Header();
                if (oldHeader != null) {
                    header.setDurable(oldHeader.getDurable());
                    header.setPriority(oldHeader.getPriority());
                    header.setTtl(oldHeader.getTtl());
                }
                header.setDeliveryCount(UnsignedInteger.valueOf(entry.getDeliveryCount()));
                this._sectionEncoder.reset();
                this._sectionEncoder.encodeObject(header);
                Binary encodedHeader = this._sectionEncoder.getEncoding();
                QpidByteBuffer oldPayload = payload;
                payload = QpidByteBuffer.allocateDirect((int)(oldPayload.remaining() + encodedHeader.getLength()));
                payload.put(encodedHeader.getArray(), encodedHeader.getArrayOffset(), encodedHeader.getLength());
                payload.put(oldPayload);
                oldPayload.dispose();
                payload.flip();
            }
            transfer.setPayload(payload);
            byte[] data = new byte[8];
            ByteBuffer.wrap(data).putLong(this._deliveryTag++);
            final Binary tag = new Binary(data);
            transfer.setDeliveryTag(tag);
            if (this._link.isAttached()) {
                ServerTransaction txn;
                if (SenderSettleMode.SETTLED.equals(this.getEndpoint().getSendingSettlementMode())) {
                    transfer.setSettled(true);
                } else {
                    UnsettledAction action = this._acquires ? new DispositionAction(tag, entry, consumer) : new DoNothingAction(tag, entry);
                    this._link.addUnsettled(tag, action, entry);
                }
                if (this._transactionId != null) {
                    TransactionalState state = new TransactionalState();
                    state.setTxnId(this._transactionId);
                    transfer.setState(state);
                }
                if (this._acquires && this._transactionId != null && (txn = this._link.getTransaction(this._transactionId)) != null) {
                    txn.addPostTransactionAction(new ServerTransaction.Action(){

                        public void postCommit() {
                        }

                        public void onRollback() {
                            entry.release(consumer);
                            ConsumerTarget_1_0.this._link.getEndpoint().updateDisposition(tag, null, true);
                        }
                    });
                }
                this.getSession().getAMQPConnection().registerMessageDelivered(message.getSize());
                this.getEndpoint().transfer(transfer, false);
            } else {
                entry.release(consumer);
            }
        }
        finally {
            transfer.dispose();
        }
    }

    public void flushBatched() {
    }

    public void queueDeleted() {
        this.getEndpoint().setSource(null);
        this.getEndpoint().close();
        LinkRegistry linkReg = this.getSession().getConnection().getAddressSpace().getLinkRegistry(this.getEndpoint().getSession().getConnection().getRemoteContainerId());
        linkReg.unregisterSendingLink(this.getEndpoint().getName());
    }

    public boolean allocateCredit(ServerMessage msg) {
        boolean hasCredit;
        AMQPConnection_1_0 protocolEngine = this.getSession().getConnection();
        boolean bl = hasCredit = this._link.isAttached() && this.getEndpoint().hasCreditToSend() && !protocolEngine.isTransportBlockedForWriting();
        if (!hasCredit && this.getState() == ConsumerTarget.State.ACTIVE) {
            this.suspend();
        }
        if (hasCredit) {
            SendingLinkEndpoint linkEndpoint = this._link.getEndpoint();
            linkEndpoint.setLinkCredit(linkEndpoint.getLinkCredit().subtract(UnsignedInteger.ONE));
        }
        return hasCredit;
    }

    public void suspend() {
        this.updateState(ConsumerTarget.State.ACTIVE, ConsumerTarget.State.SUSPENDED);
    }

    public void restoreCredit(ServerMessage message) {
        SendingLinkEndpoint endpoint = this._link.getEndpoint();
        endpoint.setLinkCredit(endpoint.getLinkCredit().add(UnsignedInteger.ONE));
    }

    public void queueEmpty() {
        this._queueEmpty = true;
    }

    public void flowStateChanged() {
        AMQPConnection_1_0 protocolEngine = this.getSession().getConnection();
        if (this.isFlowSuspended() && this.getEndpoint() != null && !protocolEngine.isTransportBlockedForWriting()) {
            this.updateState(ConsumerTarget.State.SUSPENDED, ConsumerTarget.State.ACTIVE);
            this._transactionId = this._link.getTransactionId();
        }
    }

    public Session_1_0 getSession() {
        return this._link.getSession();
    }

    public void flush() {
        for (ConsumerImpl consumer : this.getConsumers()) {
            consumer.flush();
        }
    }

    public AMQSessionModel getSessionModel() {
        return this.getSession();
    }

    public void acquisitionRemoved(MessageInstance node) {
    }

    public String getTargetAddress() {
        Target target = this._link.getEndpoint().getTarget();
        return target instanceof org.apache.qpid.server.protocol.v1_0.type.messaging.Target ? ((org.apache.qpid.server.protocol.v1_0.type.messaging.Target)target).getAddress() : this._link.getEndpoint().getName();
    }

    public long getUnacknowledgedBytes() {
        return 0L;
    }

    public long getUnacknowledgedMessages() {
        return 0L;
    }

    protected void processClosed() {
    }

    protected void processStateChanged() {
        if (this._queueEmpty) {
            this._queueEmpty = false;
            if (this._link.drained()) {
                this.updateState(ConsumerTarget.State.ACTIVE, ConsumerTarget.State.SUSPENDED);
            }
        }
    }

    protected boolean hasStateChanged() {
        return this._queueEmpty;
    }

    protected boolean hasClosed() {
        return false;
    }

    public String toString() {
        return "ConsumerTarget_1_0[linkSession=" + this._link.getSession().toLogString() + "]";
    }

    private class DoNothingAction
    implements UnsettledAction {
        public DoNothingAction(Binary tag, MessageInstance queueEntry) {
        }

        @Override
        public boolean process(DeliveryState state, Boolean settled) {
            Binary transactionId = null;
            Outcome outcome = null;
            if (state instanceof TransactionalState) {
                transactionId = ((TransactionalState)state).getTxnId();
                outcome = ((TransactionalState)state).getOutcome();
            } else if (state instanceof Outcome) {
                outcome = (Outcome)((Object)state);
            }
            return true;
        }
    }

    private class DispositionAction
    implements UnsettledAction {
        private final MessageInstance _queueEntry;
        private final Binary _deliveryTag;
        private final ConsumerImpl _consumer;

        public DispositionAction(Binary tag, MessageInstance queueEntry, ConsumerImpl consumer) {
            this._deliveryTag = tag;
            this._queueEntry = queueEntry;
            this._consumer = consumer;
        }

        public ConsumerImpl getConsumer() {
            return this._consumer;
        }

        @Override
        public boolean process(DeliveryState state, final Boolean settled) {
            Outcome outcome;
            Binary transactionId = null;
            if (state instanceof TransactionalState) {
                transactionId = ((TransactionalState)state).getTxnId();
                outcome = ((TransactionalState)state).getOutcome();
            } else {
                outcome = state instanceof Outcome ? (Outcome)((Object)state) : null;
            }
            ServerTransaction txn = ConsumerTarget_1_0.this._link.getTransaction(transactionId);
            if (outcome instanceof Accepted) {
                if (this._queueEntry.makeAcquisitionUnstealable(this.getConsumer())) {
                    txn.dequeue(this._queueEntry.getEnqueueRecord(), new ServerTransaction.Action(){

                        public void postCommit() {
                            if (DispositionAction.this._queueEntry.isAcquiredBy(DispositionAction.this.getConsumer())) {
                                DispositionAction.this._queueEntry.delete();
                            }
                        }

                        public void onRollback() {
                        }
                    });
                }
                txn.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        if (Boolean.TRUE.equals(settled)) {
                            ConsumerTarget_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                        } else {
                            ConsumerTarget_1_0.this._link.getEndpoint().updateDisposition(DispositionAction.this._deliveryTag, (DeliveryState)((Object)outcome), true);
                        }
                        ConsumerTarget_1_0.this._link.getEndpoint().sendFlowConditional();
                    }

                    public void onRollback() {
                        if (Boolean.TRUE.equals(settled)) {
                            Modified modified = new Modified();
                            modified.setDeliveryFailed(true);
                            ConsumerTarget_1_0.this._link.getEndpoint().updateDisposition(DispositionAction.this._deliveryTag, modified, true);
                            ConsumerTarget_1_0.this._link.getEndpoint().sendFlowConditional();
                            DispositionAction.this._queueEntry.incrementDeliveryCount();
                            DispositionAction.this._queueEntry.release(DispositionAction.this.getConsumer());
                        }
                    }
                });
            } else if (outcome instanceof Released) {
                txn.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        DispositionAction.this._queueEntry.release(DispositionAction.this.getConsumer());
                        ConsumerTarget_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                    }

                    public void onRollback() {
                        ConsumerTarget_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                    }
                });
            } else if (outcome instanceof Modified) {
                txn.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        DispositionAction.this._queueEntry.release(DispositionAction.this.getConsumer());
                        if (Boolean.TRUE.equals(((Modified)outcome).getDeliveryFailed())) {
                            DispositionAction.this._queueEntry.incrementDeliveryCount();
                        }
                        ConsumerTarget_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                    }

                    public void onRollback() {
                        if (Boolean.TRUE.equals(settled)) {
                            Modified modified = new Modified();
                            modified.setDeliveryFailed(true);
                            ConsumerTarget_1_0.this._link.getEndpoint().updateDisposition(DispositionAction.this._deliveryTag, modified, true);
                            ConsumerTarget_1_0.this._link.getEndpoint().sendFlowConditional();
                        }
                    }
                });
            }
            return transactionId == null && outcome != null;
        }
    }
}

