/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.util.ClassLoadingAwareObjectInputStream;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.util.ByteBufferInputStream;

public class JMSObjectMessage
extends AbstractJMSMessage
implements ObjectMessage {
    public static final String MIME_TYPE = "application/java-object-stream";
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 256;
    private final ClassLoadingAwareObjectInputStream.TrustedClassFilter _trustedClassFilter;
    private Serializable _readData;
    private ByteBuffer _data;
    private Exception _exception;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    public JMSObjectMessage(ClassLoadingAwareObjectInputStream.TrustedClassFilter trustedClassFilter, AMQMessageDelegateFactory delegateFactory) {
        super(delegateFactory, false);
        this._trustedClassFilter = trustedClassFilter;
    }

    JMSObjectMessage(ClassLoadingAwareObjectInputStream.TrustedClassFilter trustedClassFilter, AMQMessageDelegate delegate, ByteBuffer data) throws QpidException {
        super(delegate, data != null);
        this._trustedClassFilter = trustedClassFilter;
        try {
            this._readData = this.read(data);
        }
        catch (IOException e) {
            this._exception = e;
        }
        catch (ClassNotFoundException e) {
            this._exception = e;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._exception = null;
        this._readData = null;
        this._data = null;
    }

    @Override
    public String toBodyString() throws JMSException {
        return String.valueOf(this.getObject());
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public ByteBuffer getData() throws JMSException {
        if (this._exception != null) {
            throw JMSExceptionHelper.chainJMSException((JMSException)((Object)new MessageFormatException("Unable to deserialize message")), this._exception);
        }
        if (this._readData == null) {
            return this._data == null ? EMPTY_BYTE_BUFFER : this._data.duplicate();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._readData);
            oos.flush();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Unable to encode object of type: " + this._readData.getClass().getName() + ", value " + this._readData), e);
        }
    }

    public void setObject(Serializable serializable) throws JMSException {
        this.checkWritable();
        this.clearBody();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            oos.flush();
            this._data = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Unable to encode object of type: " + serializable.getClass().getName() + ", value " + serializable), e);
        }
    }

    public Serializable getObject() throws JMSException {
        if (this._exception != null) {
            throw JMSExceptionHelper.chainJMSException((JMSException)((Object)new MessageFormatException("Unable to deserialize message")), this._exception);
        }
        if (this._readData != null || this._data == null) {
            return this._readData;
        }
        Exception exception = null;
        ByteBuffer data = this._data.duplicate();
        try {
            return this.read(data);
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        throw JMSExceptionHelper.chainJMSException(new JMSException("Could not deserialize object"), exception);
    }

    private Serializable read(ByteBuffer data) throws IOException, ClassNotFoundException {
        Serializable result = null;
        if (data != null && data.hasRemaining()) {
            try (ClassLoadingAwareObjectInputStream in = new ClassLoadingAwareObjectInputStream((InputStream)new ByteBufferInputStream(data), this._trustedClassFilter);){
                result = (Serializable)in.readObject();
            }
        }
        return result;
    }
}

