/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.Map;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQHeadersExchange;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.RejectBehaviour;
import org.apache.qpid.client.messaging.address.AddressHelper;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.client.messaging.address.Node;
import org.apache.qpid.configuration.ClientProperties;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.jndi.ObjectFactory;
import org.apache.qpid.messaging.Address;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.BindingURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQDestination
implements Destination,
Referenceable,
Externalizable {
    public static final String JNDI_ADDRESS_DESTINATION_ADDRESS = "address";
    private static final Logger _logger = LoggerFactory.getLogger(AMQDestination.class);
    private static final long serialVersionUID = -3152767926421156400L;
    private String _exchangeName;
    private String _exchangeClass;
    private boolean _exchangeAutoDelete;
    private boolean _exchangeDurable;
    private boolean _exchangeInternal;
    private boolean _isDurable;
    private boolean _isExclusive;
    private boolean _isAutoDelete;
    private boolean _browseOnly;
    private String _queueName;
    private String _routingKey;
    private String[] _bindingKeys;
    private String _url;
    private AMQShortString _urlAsShortString;
    private boolean _checkedForQueueBinding;
    private RejectBehaviour _rejectBehaviour;
    private Map<String, Object> _consumerArguments;
    public static final int QUEUE_TYPE = 1;
    public static final int TOPIC_TYPE = 2;
    public static final int UNKNOWN_TYPE = 3;
    private boolean _sendEncrypted;
    private String _encryptedRecipients;
    private long _deliveryDelay;
    private String _localAddress;
    private static final DestSyntax defaultDestSyntax;
    private DestSyntax _destSyntax = DestSyntax.ADDR;
    private AddressHelper _addrHelper;
    private Address _address;
    private int _addressType = 3;
    private String _name;
    private String _subject;
    private AddressOption _create = AddressOption.NEVER;
    private AddressOption _assert = AddressOption.NEVER;
    private AddressOption _delete = AddressOption.NEVER;
    private Node _node;
    private Link _link;

    protected void setExclusive(boolean exclusive) {
        this._isExclusive = exclusive;
    }

    protected String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public boolean neverDeclare() {
        return false;
    }

    public boolean sendEncrypted() {
        return this._sendEncrypted;
    }

    public String getEncryptedRecipients() {
        return this._encryptedRecipients;
    }

    public long getDeliveryDelay() {
        return this._deliveryDelay;
    }

    public String getLocalAddress() {
        return this._localAddress;
    }

    public static DestSyntax getDefaultDestSyntax() {
        return defaultDestSyntax;
    }

    protected AMQDestination() {
    }

    protected AMQDestination(Address address) {
        this._address = address;
        this.getInfoFromAddress();
        this._destSyntax = DestSyntax.ADDR;
        _logger.debug("Based on " + address + " the selected destination syntax is " + (Object)((Object)this._destSyntax));
    }

    public static DestSyntax getDestType(String str) {
        if (str.startsWith("BURL:") || !str.startsWith("ADDR:") && defaultDestSyntax == DestSyntax.BURL) {
            return DestSyntax.BURL;
        }
        return DestSyntax.ADDR;
    }

    public static String stripSyntaxPrefix(String str) {
        if (str.startsWith("BURL:") || str.startsWith("ADDR:")) {
            return str.substring(5, str.length());
        }
        return str;
    }

    protected AMQDestination(String str) throws URISyntaxException {
        this.parseDestinationString(str);
    }

    protected void parseDestinationString(String str) throws URISyntaxException {
        this._destSyntax = AMQDestination.getDestType(str);
        str = AMQDestination.stripSyntaxPrefix(str);
        if (this._destSyntax == DestSyntax.BURL) {
            this.getInfoFromBindingURL((BindingURL)new AMQBindingURL(str));
        } else {
            this._address = AMQDestination.createAddressFromString(str);
            try {
                this.getInfoFromAddress();
            }
            catch (Exception e) {
                URISyntaxException ex = new URISyntaxException(str, "Error parsing address");
                ex.initCause(e);
                throw ex;
            }
        }
        _logger.debug("Based on " + str + " the selected destination syntax is " + (Object)((Object)this._destSyntax));
    }

    protected AMQDestination(BindingURL binding) {
        this.getInfoFromBindingURL(binding);
        this._destSyntax = DestSyntax.BURL;
        _logger.debug("Based on " + binding + " the selected destination syntax is " + (Object)((Object)this._destSyntax));
    }

    protected void getInfoFromBindingURL(BindingURL binding) {
        this._exchangeName = binding.getExchangeName();
        this._exchangeClass = binding.getExchangeClass();
        this._exchangeDurable = Boolean.parseBoolean(binding.getOption("exchangedurable"));
        this._exchangeAutoDelete = Boolean.parseBoolean(binding.getOption("exchangeautodelete"));
        this._exchangeInternal = Boolean.parseBoolean(binding.getOption("exchangeinternal"));
        this._isExclusive = Boolean.parseBoolean(binding.getOption("exclusive"));
        this._isAutoDelete = Boolean.parseBoolean(binding.getOption("autodelete"));
        this._isDurable = Boolean.parseBoolean(binding.getOption("durable"));
        this._browseOnly = Boolean.parseBoolean(binding.getOption("browse"));
        this._queueName = binding.getQueueName() == null ? null : binding.getQueueName();
        this._routingKey = binding.getRoutingKey() == null ? null : binding.getRoutingKey();
        this._bindingKeys = binding.getBindingKeys() == null || binding.getBindingKeys().length == 0 ? new String[]{} : binding.getBindingKeys();
        String rejectBehaviourValue = binding.getOption("rejectbehaviour");
        this._rejectBehaviour = rejectBehaviourValue == null ? null : RejectBehaviour.valueOf(rejectBehaviourValue.toUpperCase());
        this._consumerArguments = binding.getConsumerOptions();
        this._sendEncrypted = Boolean.parseBoolean(binding.getOption("sendencrypted"));
        this._encryptedRecipients = binding.getOption("encryptedrecipients");
        String deliveryDelayVal = binding.getOption("deliveryDelay");
        this._deliveryDelay = deliveryDelayVal == null ? 0L : Long.parseLong(deliveryDelayVal);
        this._localAddress = binding.getOption("localAddress");
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, String queueName) {
        this(exchangeName, exchangeClass, routingKey, false, false, queueName, null);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, String queueName, String[] bindingKeys) {
        this(exchangeName, exchangeClass, routingKey, false, false, queueName, bindingKeys);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String destinationName) {
        this(exchangeName, exchangeClass, destinationName, false, false, null, null);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName) {
        this(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, false, null);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName, String[] bindingKeys) {
        this(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, false, bindingKeys);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName, boolean isDurable) {
        this(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, isDurable, null);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName, boolean isDurable, String[] bindingKeys) {
        this(exchangeName, exchangeClass, routingKey, isExclusive, isAutoDelete, queueName, isDurable, bindingKeys, false);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String routingKey, boolean isExclusive, boolean isAutoDelete, String queueName, boolean isDurable, String[] bindingKeys, boolean browseOnly) {
        if (exchangeName == null) {
            throw new IllegalArgumentException("Exchange name must not be null");
        }
        if (exchangeClass == null) {
            throw new IllegalArgumentException("Exchange class must not be null");
        }
        this._exchangeName = exchangeName;
        this._exchangeClass = exchangeClass;
        this._routingKey = routingKey;
        this._isExclusive = isExclusive;
        this._isAutoDelete = isAutoDelete;
        this._queueName = queueName;
        this._isDurable = isDurable;
        this._bindingKeys = bindingKeys == null || bindingKeys.length == 0 ? new String[]{} : bindingKeys;
        this._destSyntax = DestSyntax.BURL;
        this._browseOnly = browseOnly;
        this._rejectBehaviour = null;
        this._exchangeAutoDelete = false;
        this._exchangeDurable = false;
        this._exchangeInternal = false;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Based on " + this.toString() + " the selected destination syntax is " + (Object)((Object)this._destSyntax));
        }
    }

    public void setDestinationString(String str) throws Exception {
        this.parseDestinationString(str);
    }

    public String getDestinationString() {
        return this.toString();
    }

    public DestSyntax getDestSyntax() {
        return this._destSyntax;
    }

    protected void setDestSyntax(DestSyntax syntax) {
        this._destSyntax = syntax;
    }

    public AMQShortString getEncodedName() {
        if (this._urlAsShortString == null) {
            if (this._url == null) {
                this.toURL();
            }
            this._urlAsShortString = new AMQShortString(this._url);
        }
        return this._urlAsShortString;
    }

    public boolean isDurable() {
        return this._isDurable;
    }

    public String getExchangeName() {
        return this._exchangeName;
    }

    public boolean isDefaultExchange() {
        return this._exchangeName == null || "".equals(this._exchangeName);
    }

    public String getExchangeClass() {
        return this._exchangeClass;
    }

    public boolean isExchangeDurable() {
        return this._exchangeDurable;
    }

    public boolean isExchangeAutoDelete() {
        return this._exchangeAutoDelete;
    }

    public boolean isExchangeInternal() {
        return this._exchangeInternal;
    }

    public boolean isTopic() {
        return "topic".equals(this._exchangeClass);
    }

    public boolean isQueue() {
        return "direct".equals(this._exchangeClass);
    }

    public String getQueueName() {
        return this._queueName;
    }

    public String getAMQQueueName() {
        return this._queueName;
    }

    public void setQueueName(String queueName) {
        this._queueName = queueName;
        this._url = null;
        this._urlAsShortString = null;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public String[] getBindingKeys() {
        if (this._bindingKeys != null && this._bindingKeys.length > 0) {
            return this._bindingKeys;
        }
        if (this._routingKey != null) {
            return new String[]{this._routingKey};
        }
        return new String[0];
    }

    public boolean isExclusive() {
        return this._isExclusive;
    }

    public boolean isAutoDelete() {
        return this._isAutoDelete;
    }

    public abstract boolean isNameRequired();

    public String toString() {
        if (this._destSyntax == DestSyntax.BURL) {
            return this.toURL();
        }
        return this._address.toString();
    }

    public boolean isCheckedForQueueBinding() {
        return this._checkedForQueueBinding;
    }

    public void setCheckedForQueueBinding(boolean checkedForQueueBinding) {
        this._checkedForQueueBinding = checkedForQueueBinding;
    }

    public String toURL() {
        String url = this._url;
        if (url == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this._exchangeClass);
            sb.append("://");
            sb.append(this._exchangeName);
            sb.append("/");
            if (this._routingKey != null) {
                sb.append(this._routingKey);
            }
            sb.append("/");
            if (this._queueName != null) {
                sb.append(this._queueName);
            }
            sb.append('?');
            if (this._routingKey != null) {
                sb.append("routingkey");
                sb.append("='");
                sb.append(this._routingKey).append("'");
                sb.append('&');
            }
            if (this._routingKey == null && this._bindingKeys != null && this._bindingKeys.length > 0) {
                for (String bindingKey : this._bindingKeys) {
                    sb.append("bindingkey");
                    sb.append("='");
                    sb.append(bindingKey);
                    sb.append("'");
                    sb.append('&');
                }
            }
            if (this._isDurable) {
                sb.append("durable");
                sb.append("='true'");
                sb.append('&');
            }
            if (this._isExclusive) {
                sb.append("exclusive");
                sb.append("='true'");
                sb.append('&');
            }
            if (this._isAutoDelete) {
                sb.append("autodelete");
                sb.append("='true'");
                sb.append('&');
            }
            if (this._rejectBehaviour != null) {
                sb.append("rejectbehaviour");
                sb.append("='" + (Object)((Object)this._rejectBehaviour) + "'");
                sb.append('&');
            }
            if (this._exchangeDurable) {
                sb.append("exchangedurable");
                sb.append("='true'");
                sb.append('&');
            }
            if (this._exchangeAutoDelete) {
                sb.append("exchangeautodelete");
                sb.append("='true'");
                sb.append('&');
            }
            if (this._exchangeInternal) {
                sb.append("exchangeinternal");
                sb.append("='true'");
                sb.append('&');
            }
            sb.deleteCharAt(sb.length() - 1);
            this._url = url = sb.toString();
        }
        return url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AMQDestination)) {
            return false;
        }
        AMQDestination that = (AMQDestination)o;
        if (this._destSyntax != that.getDestSyntax()) {
            return false;
        }
        if (this._destSyntax == DestSyntax.ADDR) {
            if (this._addressType != that.getAddressType()) {
                return false;
            }
            if (!this._name.equals(that.getAddressName())) {
                return false;
            }
            if (this._subject == null ? that.getSubject() != null : !this._subject.equals(that.getSubject())) {
                return false;
            }
        } else {
            if (!this._exchangeClass.equals(that._exchangeClass)) {
                return false;
            }
            if (!this._exchangeName.equals(that._exchangeName)) {
                return false;
            }
            if (this._queueName == null && that._queueName != null || this._queueName != null && !this._queueName.equals(that._queueName)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result;
        if (this._destSyntax == DestSyntax.ADDR) {
            result = 29 * this._addressType + this._name.hashCode();
            if (this._subject != null) {
                result = 29 * result + this._subject.hashCode();
            }
        } else {
            result = this._exchangeName == null ? "".hashCode() : this._exchangeName.hashCode();
            result = 29 * result + (this._exchangeClass == null ? "".hashCode() : this._exchangeClass.hashCode());
            if (this._queueName != null) {
                result = 29 * result + this._queueName.hashCode();
            }
        }
        return result;
    }

    public Map<String, Object> getConsumerArguments() {
        return this._consumerArguments;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), new StringRefAddr(JNDI_ADDRESS_DESTINATION_ADDRESS, this._destSyntax == DestSyntax.ADDR ? this.getAddress().toString() : DestSyntax.BURL.asPrefix() + this.toURL()), ObjectFactory.class.getName(), null);
    }

    public static Destination createDestination(BindingURL binding) {
        String type = binding.getExchangeClass();
        if ("direct".equals(type)) {
            return new AMQQueue(binding);
        }
        if ("topic".equals(type)) {
            return new AMQTopic(binding);
        }
        if ("headers".equals(type)) {
            return new AMQHeadersExchange(binding);
        }
        return new AMQAnyDestination(binding);
    }

    public static Destination createDestination(String str, boolean useNodeTypeForDestinationType) throws URISyntaxException {
        DestSyntax syntax = AMQDestination.getDestType(str);
        str = AMQDestination.stripSyntaxPrefix(str);
        if (syntax == DestSyntax.BURL) {
            return AMQDestination.createDestination((BindingURL)new AMQBindingURL(str));
        }
        Address address = AMQDestination.createAddressFromString(str);
        if (useNodeTypeForDestinationType) {
            AddressHelper helper = new AddressHelper(address);
            switch (helper.getNodeType()) {
                case 1: {
                    return new AMQQueue(address);
                }
                case 2: {
                    return new AMQTopic(address);
                }
            }
            return new AMQAnyDestination(address);
        }
        return new AMQAnyDestination(address);
    }

    public Address getAddress() {
        return this._address;
    }

    protected void setAddress(Address addr) {
        this._address = addr;
    }

    public int getAddressType() {
        return this._addressType;
    }

    public void setAddressType(int addressType) {
        this._addressType = addressType;
    }

    public String getAddressName() {
        return this._name;
    }

    public void setAddressName(String name) {
        this._name = name;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public AddressOption getCreate() {
        return this._create;
    }

    public void setCreate(AddressOption option) {
        this._create = option;
    }

    public AddressOption getAssert() {
        return this._assert;
    }

    public void setAssert(AddressOption option) {
        this._assert = option;
    }

    public AddressOption getDelete() {
        return this._delete;
    }

    public void setDelete(AddressOption option) {
        this._delete = option;
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public Link getLink() {
        return this._link;
    }

    public void setLink(Link link) {
        this._link = link;
    }

    public void setExchangeName(String name) {
        this._exchangeName = name;
    }

    public void setExchangeClass(String type) {
        this._exchangeClass = type;
    }

    public void setRoutingKey(String rk) {
        this._routingKey = rk;
    }

    private static Address createAddressFromString(String str) {
        return Address.parse((String)str);
    }

    private void getInfoFromAddress() {
        this._name = this._address.getName();
        this._subject = this._address.getSubject();
        this._addrHelper = new AddressHelper(this._address);
        this._create = this._addrHelper.getCreate() != null ? AddressOption.getOption(this._addrHelper.getCreate()) : AddressOption.NEVER;
        this._assert = this._addrHelper.getAssert() != null ? AddressOption.getOption(this._addrHelper.getAssert()) : AddressOption.NEVER;
        this._delete = this._addrHelper.getDelete() != null ? AddressOption.getOption(this._addrHelper.getDelete()) : AddressOption.NEVER;
        this._browseOnly = this._addrHelper.isBrowseOnly();
        this._addressType = this._addrHelper.getNodeType();
        this._node = this._addrHelper.getNode();
        this._link = this._addrHelper.getLink();
        this._deliveryDelay = this._link.getDelay();
        this._localAddress = this._link.getLocalAddress();
        this._sendEncrypted = this._addrHelper.getSendEncrypted();
        this._encryptedRecipients = this._addrHelper.getEncryptedRecipients();
    }

    public boolean isBrowseOnly() {
        return this._browseOnly;
    }

    private void setBrowseOnly(boolean b) {
        this._browseOnly = b;
    }

    public AMQDestination copyDestination() {
        AMQAnyDestination dest = new AMQAnyDestination(this._exchangeName, this._exchangeClass, this._routingKey, this._isExclusive, this._isAutoDelete, this._queueName, this._isDurable, this._bindingKeys);
        dest.setDestSyntax(this._destSyntax);
        dest.setAddress(this._address);
        dest.setAddressName(this._name);
        dest.setSubject(this._subject);
        dest.setCreate(this._create);
        dest.setAssert(this._assert);
        dest.setDelete(this._delete);
        super.setBrowseOnly(this._browseOnly);
        dest.setAddressType(this._addressType);
        dest.setNode(this._node);
        dest.setLink(this._link);
        return dest;
    }

    protected void setAutoDelete(boolean b) {
        this._isAutoDelete = b;
    }

    protected void setDurable(boolean b) {
        this._isDurable = b;
    }

    public RejectBehaviour getRejectBehaviour() {
        return this._rejectBehaviour;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this._destSyntax);
        if (this._destSyntax == DestSyntax.BURL) {
            out.writeObject(this.toURL());
        } else {
            out.writeObject(this._address);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._destSyntax = (DestSyntax)((Object)in.readObject());
        if (this._destSyntax == DestSyntax.BURL) {
            AMQBindingURL binding;
            String burl = (String)in.readObject();
            try {
                binding = new AMQBindingURL(burl);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Cannot convert url " + burl + " into a BindingURL", e);
            }
            this.getInfoFromBindingURL((BindingURL)binding);
        } else {
            this._address = (Address)in.readObject();
            try {
                this.getInfoFromAddress();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert get info from  " + this._address, e);
            }
        }
    }

    static {
        ClientProperties.ensureIsLoaded();
        defaultDestSyntax = DestSyntax.getSyntaxType(System.getProperty("qpid.dest_syntax", DestSyntax.ADDR.toString()));
    }

    public static class Binding {
        private String exchange;
        private String bindingKey;
        private String queue;
        private Map<String, Object> args;

        public Binding(String exchange, String queue, String bindingKey, Map<String, Object> args) {
            this.exchange = exchange;
            this.queue = queue;
            this.bindingKey = bindingKey;
            this.args = args;
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getQueue() {
            return this.queue;
        }

        public String getBindingKey() {
            return this.bindingKey;
        }

        public Map<String, Object> getArgs() {
            return this.args;
        }
    }

    public static enum AddressOption {
        ALWAYS,
        NEVER,
        SENDER,
        RECEIVER;


        public static AddressOption getOption(String str) {
            if ("always".equals(str)) {
                return ALWAYS;
            }
            if ("never".equals(str)) {
                return NEVER;
            }
            if ("sender".equals(str)) {
                return SENDER;
            }
            if ("receiver".equals(str)) {
                return RECEIVER;
            }
            throw new IllegalArgumentException(str + " is not an allowed value");
        }
    }

    public static enum DestSyntax {
        BURL,
        ADDR;


        public static DestSyntax getSyntaxType(String s) {
            if ("BURL".equals(s)) {
                return BURL;
            }
            if ("ADDR".equals(s)) {
                return ADDR;
            }
            throw new IllegalArgumentException("Invalid Destination Syntax Type should be one of {BURL|ADDR}");
        }

        public String asPrefix() {
            return this.name() + ":";
        }
    }
}

