/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.bytebuffer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.qpid.bytebuffer.QpidByteBuffer;

public class QpidByteBufferOutputStream
extends OutputStream {
    private final LinkedList<QpidByteBuffer> _buffers = new LinkedList();
    private final boolean _isDirect;
    private final int _maximumBufferSize;
    private boolean _closed;

    public QpidByteBufferOutputStream(boolean isDirect, int maximumBufferSize) {
        if (maximumBufferSize <= 0) {
            throw new IllegalArgumentException("Negative or zero maximumBufferSize illegal : " + maximumBufferSize);
        }
        this._isDirect = isDirect;
        this._maximumBufferSize = maximumBufferSize;
    }

    @Override
    public void write(int b) throws IOException {
        int size = 1;
        byte[] data = new byte[]{(byte)b};
        this.allocateDataBuffers(data, 0, size);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        this.allocateDataBuffers(data, offset, len);
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        for (QpidByteBuffer buffer : this._buffers) {
            buffer.dispose();
        }
        this._buffers.clear();
    }

    public Collection<QpidByteBuffer> fetchAccumulatedBuffers() {
        ArrayList<QpidByteBuffer> bufs = new ArrayList<QpidByteBuffer>(this._buffers);
        this._buffers.clear();
        return bufs;
    }

    private void allocateDataBuffers(byte[] data, int offset, int len) throws IOException {
        if (this._closed) {
            throw new IOException("Stream is closed");
        }
        int size = Math.min(this._maximumBufferSize, len);
        QpidByteBuffer current = this._isDirect ? QpidByteBuffer.allocateDirect(len) : QpidByteBuffer.allocate(len);
        current.put(data, offset, size);
        current.flip();
        this._buffers.add(current);
        if (len > size) {
            this.allocateDataBuffers(data, offset + size, len - size);
        }
    }
}

