/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToIntegerConverter;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToLongConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToMillisConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToSecondsConverter;
import org.apache.pulsar.client.admin.ListTopicsOptions;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.TransactionIsolationLevel;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.MarkerType;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations on persistent topics"})
public class CmdTopics
extends CmdBase {
    private final PartitionedLookup partitionedLookup = new PartitionedLookup();
    private final DeleteCmd deleteCmd = new DeleteCmd();

    public CmdTopics(Supplier<PulsarAdmin> admin) {
        super("topics", admin);
        this.addCommand("list", new ListCmd());
        this.addCommand("list-partitioned-topics", new PartitionedTopicListCmd());
        this.addCommand("permissions", new Permissions());
        this.addCommand("grant-permission", new GrantPermissions());
        this.addCommand("revoke-permission", new RevokePermissions());
        this.addCommand("lookup", new Lookup());
        this.addCommand("partitioned-lookup", this.partitionedLookup);
        this.addCommand("bundle-range", new GetBundleRange());
        this.addCommand("delete", this.deleteCmd);
        this.addCommand("truncate", new TruncateCmd());
        this.addCommand("unload", new UnloadCmd());
        this.addCommand("subscriptions", new ListSubscriptions());
        this.addCommand("unsubscribe", new DeleteSubscription());
        this.addCommand("create-subscription", new CreateSubscription());
        this.addCommand("update-subscription-properties", new UpdateSubscriptionProperties());
        this.addCommand("get-subscription-properties", new GetSubscriptionProperties());
        this.addCommand("stats", new GetStats());
        this.addCommand("stats-internal", new GetInternalStats());
        this.addCommand("info-internal", new GetInternalInfo());
        this.addCommand("partitioned-stats", new GetPartitionedStats());
        this.addCommand("partitioned-stats-internal", new GetPartitionedStatsInternal());
        this.addCommand("skip", new Skip());
        this.addCommand("clear-backlog", new ClearBacklog());
        this.addCommand("expire-messages", new ExpireMessages());
        this.addCommand("expire-messages-all-subscriptions", new ExpireMessagesForAllSubscriptions());
        this.addCommand("create-partitioned-topic", new CreatePartitionedCmd());
        this.addCommand("create-missed-partitions", new CreateMissedPartitionsCmd());
        this.addCommand("create", new CreateNonPartitionedCmd());
        this.addCommand("update-partitioned-topic", new UpdatePartitionedCmd());
        this.addCommand("get-partitioned-topic-metadata", new GetPartitionedTopicMetadataCmd());
        this.addCommand("get-properties", new GetPropertiesCmd());
        this.addCommand("update-properties", new UpdateProperties());
        this.addCommand("remove-properties", new RemoveProperties());
        this.addCommand("delete-partitioned-topic", new DeletePartitionedCmd());
        this.addCommand("peek-messages", new PeekMessages());
        this.addCommand("examine-messages", new ExamineMessages());
        this.addCommand("get-message-by-id", new GetMessageById());
        this.addCommand("get-message-id", new GetMessageId());
        this.addCommand("reset-cursor", new ResetCursor());
        this.addCommand("terminate", new Terminate());
        this.addCommand("partitioned-terminate", new PartitionedTerminate());
        this.addCommand("compact", new Compact());
        this.addCommand("compaction-status", new CompactionStatusCmd());
        this.addCommand("offload", new Offload());
        this.addCommand("offload-status", new OffloadStatusCmd());
        this.addCommand("last-message-id", new GetLastMessageId());
        this.addCommand("get-backlog-quotas", new GetBacklogQuotaMap());
        this.addCommand("set-backlog-quota", new SetBacklogQuota());
        this.addCommand("remove-backlog-quota", new RemoveBacklogQuota());
        this.addCommand("get-message-ttl", new GetMessageTTL());
        this.addCommand("set-message-ttl", new SetMessageTTL());
        this.addCommand("remove-message-ttl", new RemoveMessageTTL());
        this.addCommand("get-retention", new GetRetention());
        this.addCommand("set-retention", new SetRetention());
        this.addCommand("remove-retention", new RemoveRetention());
        this.addCommand("enable-deduplication", new EnableDeduplication());
        this.addCommand("disable-deduplication", new DisableDeduplication());
        this.addCommand("get-deduplication-enabled", new GetDeduplicationStatus());
        this.addCommand("set-deduplication", new SetDeduplicationStatus());
        this.addCommand("get-deduplication", new GetDeduplicationStatus());
        this.addCommand("remove-deduplication", new RemoveDeduplicationStatus());
        this.addCommand("get-deduplication-snapshot-interval", new GetDeduplicationSnapshotInterval());
        this.addCommand("set-deduplication-snapshot-interval", new SetDeduplicationSnapshotInterval());
        this.addCommand("remove-deduplication-snapshot-interval", new RemoveDeduplicationSnapshotInterval());
        this.addCommand("get-delayed-delivery", new GetDelayedDelivery());
        this.addCommand("set-delayed-delivery", new SetDelayedDelivery());
        this.addCommand("remove-delayed-delivery", new RemoveDelayedDelivery());
        this.addCommand("get-persistence", new GetPersistence());
        this.addCommand("set-persistence", new SetPersistence());
        this.addCommand("remove-persistence", new RemovePersistence());
        this.addCommand("get-offload-policies", new GetOffloadPolicies());
        this.addCommand("set-offload-policies", new SetOffloadPolicies());
        this.addCommand("remove-offload-policies", new RemoveOffloadPolicies());
        this.addCommand("get-dispatch-rate", new GetDispatchRate());
        this.addCommand("set-dispatch-rate", new SetDispatchRate());
        this.addCommand("remove-dispatch-rate", new RemoveDispatchRate());
        this.addCommand("get-subscription-dispatch-rate", new GetSubscriptionDispatchRate());
        this.addCommand("set-subscription-dispatch-rate", new SetSubscriptionDispatchRate());
        this.addCommand("remove-subscription-dispatch-rate", new RemoveSubscriptionDispatchRate());
        this.addCommand("get-replicator-dispatch-rate", new GetReplicatorDispatchRate());
        this.addCommand("set-replicator-dispatch-rate", new SetReplicatorDispatchRate());
        this.addCommand("remove-replicator-dispatch-rate", new RemoveReplicatorDispatchRate());
        this.addCommand("get-compaction-threshold", new GetCompactionThreshold());
        this.addCommand("set-compaction-threshold", new SetCompactionThreshold());
        this.addCommand("remove-compaction-threshold", new RemoveCompactionThreshold());
        this.addCommand("get-max-unacked-messages-on-consumer", new GetMaxUnackedMessagesOnConsumer());
        this.addCommand("set-max-unacked-messages-on-consumer", new SetMaxUnackedMessagesOnConsumer());
        this.addCommand("remove-max-unacked-messages-on-consumer", new RemoveMaxUnackedMessagesOnConsumer());
        this.addCommand("get-max-unacked-messages-on-subscription", new GetMaxUnackedMessagesOnSubscription());
        this.addCommand("set-max-unacked-messages-on-subscription", new SetMaxUnackedMessagesOnSubscription());
        this.addCommand("remove-max-unacked-messages-on-subscription", new RemoveMaxUnackedMessagesOnSubscription());
        this.addCommand("get-max-unacked-messages-per-consumer", new GetMaxUnackedMessagesOnConsumer());
        this.addCommand("set-max-unacked-messages-per-consumer", new SetMaxUnackedMessagesOnConsumer());
        this.addCommand("remove-max-unacked-messages-per-consumer", new RemoveMaxUnackedMessagesOnConsumer());
        this.addCommand("get-max-unacked-messages-per-subscription", new GetMaxUnackedMessagesOnSubscription());
        this.addCommand("set-max-unacked-messages-per-subscription", new SetMaxUnackedMessagesOnSubscription());
        this.addCommand("remove-max-unacked-messages-per-subscription", new RemoveMaxUnackedMessagesOnSubscription());
        this.addCommand("get-publish-rate", new GetPublishRate());
        this.addCommand("set-publish-rate", new SetPublishRate());
        this.addCommand("remove-publish-rate", new RemovePublishRate());
        this.addCommand("set-subscription-types-enabled", new SetSubscriptionTypesEnabled());
        this.addCommand("get-subscription-types-enabled", new GetSubscriptionTypesEnabled());
        this.addCommand("remove-subscription-types-enabled", new RemoveSubscriptionTypesEnabled());
        this.addCommand("get-maxProducers", new GetMaxProducers());
        this.addCommand("set-maxProducers", new SetMaxProducers());
        this.addCommand("remove-maxProducers", new RemoveMaxProducers());
        this.addCommand("get-max-producers", new GetMaxProducers());
        this.addCommand("set-max-producers", new SetMaxProducers());
        this.addCommand("remove-max-producers", new RemoveMaxProducers());
        this.addCommand("get-max-subscriptions", new GetMaxSubscriptionsPerTopic());
        this.addCommand("set-max-subscriptions", new SetMaxSubscriptionsPerTopic());
        this.addCommand("remove-max-subscriptions", new RemoveMaxSubscriptionsPerTopic());
        this.addCommand("get-max-message-size", new GetMaxMessageSize());
        this.addCommand("set-max-message-size", new SetMaxMessageSize());
        this.addCommand("remove-max-message-size", new RemoveMaxMessageSize());
        this.addCommand("get-max-consumers-per-subscription", new GetMaxConsumersPerSubscription());
        this.addCommand("set-max-consumers-per-subscription", new SetMaxConsumersPerSubscription());
        this.addCommand("remove-max-consumers-per-subscription", new RemoveMaxConsumersPerSubscription());
        this.addCommand("get-inactive-topic-policies", new GetInactiveTopicPolicies());
        this.addCommand("set-inactive-topic-policies", new SetInactiveTopicPolicies());
        this.addCommand("remove-inactive-topic-policies", new RemoveInactiveTopicPolicies());
        this.addCommand("get-max-consumers", new GetMaxConsumers());
        this.addCommand("set-max-consumers", new SetMaxConsumers());
        this.addCommand("remove-max-consumers", new RemoveMaxConsumers());
        this.addCommand("get-subscribe-rate", new GetSubscribeRate());
        this.addCommand("set-subscribe-rate", new SetSubscribeRate());
        this.addCommand("remove-subscribe-rate", new RemoveSubscribeRate());
        this.addCommand("set-replicated-subscription-status", new SetReplicatedSubscriptionStatus());
        this.addCommand("get-replicated-subscription-status", new GetReplicatedSubscriptionStatus());
        this.addCommand("get-backlog-size", new GetBacklogSizeByMessageId());
        this.addCommand("analyze-backlog", new AnalyzeBacklog());
        this.addCommand("get-replication-clusters", new GetReplicationClusters());
        this.addCommand("set-replication-clusters", new SetReplicationClusters());
        this.addCommand("remove-replication-clusters", new RemoveReplicationClusters());
        this.addCommand("get-shadow-topics", new GetShadowTopics());
        this.addCommand("set-shadow-topics", new SetShadowTopics());
        this.addCommand("remove-shadow-topics", new RemoveShadowTopics());
        this.addCommand("create-shadow-topic", new CreateShadowTopic());
        this.addCommand("get-shadow-source", new GetShadowSource());
        this.addCommand("get-schema-validation-enforce", new GetSchemaValidationEnforced());
        this.addCommand("set-schema-validation-enforce", new SetSchemaValidationEnforced());
        this.addCommand("trim-topic", new TrimTopic());
    }

    static MessageId findFirstLedgerWithinThreshold(List<ManagedLedgerInternalStats.LedgerInfo> ledgers, long sizeThreshold) {
        long suffixSize = 0L;
        ledgers = Lists.reverse(ledgers);
        long previousLedger = ((ManagedLedgerInternalStats.LedgerInfo)ledgers.get((int)0)).ledgerId;
        for (ManagedLedgerInternalStats.LedgerInfo l : ledgers) {
            if ((suffixSize += l.size) > sizeThreshold) {
                return new MessageIdImpl(previousLedger, 0L, -1);
            }
            previousLedger = l.ledgerId;
        }
        return null;
    }

    private Topics getTopics() {
        return this.getAdmin().topics();
    }

    @Generated
    public PartitionedLookup getPartitionedLookup() {
        return this.partitionedLookup;
    }

    @Generated
    public DeleteCmd getDeleteCmd() {
        return this.deleteCmd;
    }

    @CommandLine.Command(description={"Lookup a partitioned topic from the current serving broker"})
    protected class PartitionedLookup
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        protected String topicName;
        @CommandLine.Option(names={"-s", "--sort-by-broker"}, description={"Sort partitioned-topic by Broker Url"})
        protected boolean sortByBroker = false;

        protected PartitionedLookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = PartitionedLookup.validateTopicName(this.topicName);
            if (this.sortByBroker) {
                Map partitionLookup = CmdTopics.this.getAdmin().lookups().lookupPartitionedTopic(topic);
                HashMap<String, List> result = new HashMap<String, List>();
                for (Map.Entry entry : partitionLookup.entrySet()) {
                    List topics = result.getOrDefault(entry.getValue(), new ArrayList());
                    topics.add((String)entry.getKey());
                    result.put((String)entry.getValue(), topics);
                }
                this.print(result);
            } else {
                this.print(CmdTopics.this.getAdmin().lookups().lookupPartitionedTopic(topic));
            }
        }
    }

    @CommandLine.Command(description={"Delete a topic. The topic cannot be deleted if there's any active subscription or producers connected to it.And the application is not able to connect to the topic(delete then re-create with same name) again if the schema auto uploading is disabled. Besides, users should to use the truncate cmd to clean up data of the topic instead of delete cmd if users continue to use this topic later."})
    protected class DeleteCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"Provide either a single topic in the format 'persistent://tenant/namespace/topic', or a path to a file containing a list of topics, e.g., 'path://resources/topics.txt'. This parameter is required."}, arity="1")
        protected String topic;
        @CommandLine.Option(names={"-f", "--force"}, description={"Close all producer/consumer/replicator and delete topic forcefully"})
        private boolean force = false;
        @CommandLine.Option(names={"-d", "--deleteSchema"}, description={"Delete schema while deleting topic, but the parameter is invalid and the schema is always deleted"}, hidden=true)
        private boolean deleteSchema = false;
        @CommandLine.Option(names={"-r", "regex"}, description={"Use a regex expression to match multiple topics for deletion."})
        boolean regex = false;
        @CommandLine.Option(names={"--from-file"}, description={"Read a list of topics from a file for deletion."})
        boolean readFromFile;

        protected DeleteCmd() {
        }

        @Override
        void run() throws PulsarAdminException, IOException {
            if (this.readFromFile && this.regex) {
                throw new CliCommand.ParameterException("Could not apply regex when read topics from file.");
            }
            if (this.readFromFile) {
                List<String> topicsFromFile = Files.readAllLines(Path.of(this.topic, new String[0]));
                for (String t : topicsFromFile) {
                    try {
                        CmdTopics.this.getTopics().delete(t, this.force);
                    }
                    catch (Exception e) {
                        this.print("Failed to delete topic: " + t + ". Exception: " + String.valueOf(e));
                    }
                }
            } else {
                String topicName = DeleteCmd.validateTopicName(this.topic);
                if (this.regex) {
                    String namespace = TopicName.get((String)this.topic).getNamespace();
                    List<String> topics = CmdTopics.this.getTopics().getList(namespace);
                    topics = topics.stream().filter(s -> s.matches(topicName)).toList();
                    for (String t : topics) {
                        try {
                            CmdTopics.this.getTopics().delete(t, this.force);
                        }
                        catch (Exception e) {
                            this.print("Failed to delete topic: " + t + ". Exception: " + String.valueOf(e));
                        }
                    }
                } else {
                    try {
                        CmdTopics.this.getTopics().delete(topicName, this.force);
                    }
                    catch (Exception e) {
                        this.print("Failed to delete topic: " + this.topic + ". Exception: " + String.valueOf(e));
                    }
                }
            }
        }
    }

    @CommandLine.Command(description={"Get the list of topics under a namespace."})
    private class ListCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-td", "--topic-domain"}, description={"Allowed topic domain (persistent, non_persistent)."})
        private TopicDomain topicDomain;
        @CommandLine.Option(names={"-b", "--bundle"}, description={"Namespace bundle to get list of topics"})
        private String bundle;
        @CommandLine.Option(names={"-ist", "--include-system-topic"}, description={"Include system topic"})
        private boolean includeSystemTopic;

        private ListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ListCmd.validateNamespace(this.namespaceName);
            ListTopicsOptions options = ListTopicsOptions.builder().bundle(this.bundle).includeSystemTopic(this.includeSystemTopic).build();
            this.print(CmdTopics.this.getTopics().getList(namespace, this.topicDomain, options));
        }
    }

    @CommandLine.Command(description={"Get the list of partitioned topics under a namespace."})
    private class PartitionedTopicListCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-ist", "--include-system-topic"}, description={"Include system topic"})
        private boolean includeSystemTopic;

        private PartitionedTopicListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = PartitionedTopicListCmd.validateNamespace(this.namespaceName);
            ListTopicsOptions options = ListTopicsOptions.builder().includeSystemTopic(this.includeSystemTopic).build();
            this.print(CmdTopics.this.getTopics().getPartitionedTopicList(namespace, options));
        }
    }

    @CommandLine.Command(description={"Get the permissions on a topic. Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at the namespace level combined (union) with any eventual specific permission set on the topic."})
    private class Permissions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Permissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Permissions.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getPermissions(topic));
        }
    }

    @CommandLine.Command(description={"Grant a new permission to a client role on a single topic."})
    private class GrantPermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-r", "--role"}, description={"Client role to which grant permissions"}, required=true)
        private String role;
        @CommandLine.Option(names={"-a", "--actions"}, description={"Actions to be granted (produce,consume,sources,sinks,functions,packages)"}, required=true, split=",")
        private List<String> actions;

        private GrantPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GrantPermissions.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().grantPermission(topic, this.role, this.getAuthActions(this.actions));
        }
    }

    @CommandLine.Command(description={"Revoke permissions on a topic. Revoke permissions to a client role on a single topic. If the permission was not set at the topic level, but rather at the namespace level, this operation will return an error (HTTP status code 412)."})
    private class RevokePermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-r", "--role"}, description={"Client role to which revoke permissions"}, required=true)
        private String role;

        private RevokePermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = RevokePermissions.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().revokePermissions(topic, this.role);
        }
    }

    @CommandLine.Command(description={"Lookup a topic from the current serving broker"})
    private class Lookup
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Lookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Lookup.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getAdmin().lookups().lookupTopic(topic));
        }
    }

    @CommandLine.Command(description={"Get Namespace bundle range of a topic"})
    private class GetBundleRange
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetBundleRange() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetBundleRange.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getAdmin().lookups().getBundleRange(topic));
        }
    }

    @CommandLine.Command(description={"Truncate a topic. \n\t\tThe truncate operation will move all cursors to the end of the topic and delete all inactive ledgers. "})
    private class TruncateCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private TruncateCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = TruncateCmd.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().truncate(topic);
        }
    }

    @CommandLine.Command(description={"Unload a topic."})
    private class UnloadCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private UnloadCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = UnloadCmd.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().unload(topic);
        }
    }

    @CommandLine.Command(description={"Get the list of subscriptions on the topic"})
    private class ListSubscriptions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private ListSubscriptions() {
        }

        @Override
        void run() throws Exception {
            String topic = ListSubscriptions.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getSubscriptions(topic));
        }
    }

    @CommandLine.Command(description={"Delete a durable subscriber from a topic. The subscription cannot be deleted if there are any active consumers attached to it"})
    private class DeleteSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-f", "--force"}, description={"Disconnect and close all consumers and delete subscription forcefully"})
        private boolean force = false;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be deleted"}, required=true)
        private String subName;

        private DeleteSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = DeleteSubscription.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().deleteSubscription(topic, this.subName, this.force);
        }
    }

    @CommandLine.Command(description={"Create a new subscription on a topic"})
    private class CreateSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Name of subscription to be created"}, required=true)
        private String subscriptionName;
        @CommandLine.Option(names={"-m", "--messageId"}, description={"messageId where to create the subscription. It can be either 'latest', 'earliest' or (ledgerId:entryId)"}, required=false)
        private String messageIdStr = "latest";
        @CommandLine.Option(names={"-r", "--replicated"}, description={"replicated subscriptions"}, required=false)
        private boolean replicated = false;
        @CommandLine.Option(names={"--property", "-p"}, description={"key value pair properties(-p a=b -p c=d)"}, required=false)
        private Map<String, String> properties;

        private CreateSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = CreateSubscription.validateTopicName(this.topicName);
            MessageId messageId = this.messageIdStr.equals("latest") ? MessageId.latest : (this.messageIdStr.equals("earliest") ? MessageId.earliest : CreateSubscription.validateMessageIdString(this.messageIdStr));
            CmdTopics.this.getTopics().createSubscription(topic, this.subscriptionName, messageId, this.replicated, this.properties);
        }
    }

    @CommandLine.Command(description={"Update the properties of a subscription on a topic"})
    private class UpdateSubscriptionProperties
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to update"}, required=true)
        private String subscriptionName;
        @CommandLine.Option(names={"--property", "-p"}, description={"key value pair properties(-p a=b -p c=d)"}, required=false)
        private Map<String, String> properties;
        @CommandLine.Option(names={"--clear", "-c"}, description={"Remove all properties"}, required=false)
        private boolean clear;

        private UpdateSubscriptionProperties() {
        }

        @Override
        void run() throws Exception {
            String topic = UpdateSubscriptionProperties.validateTopicName(this.topicName);
            if (this.properties == null) {
                this.properties = Collections.emptyMap();
            }
            if (this.properties.isEmpty() && !this.clear) {
                throw new IllegalArgumentException("If you want to clear the properties you have to use --clear");
            }
            if (this.clear && !this.properties.isEmpty()) {
                throw new IllegalArgumentException("If you set --clear then you should not pass any properties");
            }
            CmdTopics.this.getTopics().updateSubscriptionProperties(topic, this.subscriptionName, this.properties);
        }
    }

    @CommandLine.Command(description={"Get the properties of a subscription on a topic"})
    private class GetSubscriptionProperties
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to describe"}, required=true)
        private String subscriptionName;

        private GetSubscriptionProperties() {
        }

        @Override
        void run() throws Exception {
            String topic = GetSubscriptionProperties.validateTopicName(this.topicName);
            Map result = CmdTopics.this.getTopics().getSubscriptionProperties(topic, this.subscriptionName);
            System.out.println(ObjectMapperFactory.getMapper().writer().writeValueAsString((Object)result));
        }
    }

    @CommandLine.Command(name="stats", description={"Get the stats for the topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetStats
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-gpb", "--get-precise-backlog"}, description={"Set true to get precise backlog"})
        private boolean getPreciseBacklog = false;
        @CommandLine.Option(names={"-sbs", "--get-subscription-backlog-size"}, description={"Set true to get backlog size for each subscription, locking required. If set to false, the attribute 'backlogSize' in the response will be -1"})
        private boolean subscriptionBacklogSize = true;
        @CommandLine.Option(names={"-etb", "--get-earliest-time-in-backlog"}, description={"Set true to get earliest time in backlog"})
        private boolean getEarliestTimeInBacklog = false;

        private GetStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetStats.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getStats(topic, this.getPreciseBacklog, this.subscriptionBacklogSize, this.getEarliestTimeInBacklog));
        }
    }

    @CommandLine.Command(description={"Get the internal stats for the topic"})
    private class GetInternalStats
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-m", "--metadata"}, description={"Flag to include ledger metadata"})
        private boolean metadata = false;

        private GetInternalStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetInternalStats.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getInternalStats(topic, this.metadata));
        }
    }

    @CommandLine.Command(description={"Get the internal metadata info for the topic"})
    private class GetInternalInfo
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetInternalInfo() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetInternalInfo.validateTopicName(this.topicName);
            String internalInfo = CmdTopics.this.getTopics().getInternalInfo(topic);
            if (internalInfo == null) {
                System.out.println("Did not find any internal metadata info");
                return;
            }
            JsonObject result = JsonParser.parseString((String)internalInfo).getAsJsonObject();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((JsonElement)result));
        }
    }

    @CommandLine.Command(description={"Get the stats for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetPartitionedStats
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--per-partition"}, description={"Get per partition stats"})
        private boolean perPartition = false;
        @CommandLine.Option(names={"-gpb", "--get-precise-backlog"}, description={"Set true to get precise backlog"})
        private boolean getPreciseBacklog = false;
        @CommandLine.Option(names={"-sbs", "--get-subscription-backlog-size"}, description={"Set true to get backlog size for each subscription, locking required."})
        private boolean subscriptionBacklogSize = true;
        @CommandLine.Option(names={"-etb", "--get-earliest-time-in-backlog"}, description={"Set true to get earliest time in backlog"})
        private boolean getEarliestTimeInBacklog = false;

        private GetPartitionedStats() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPartitionedStats.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getPartitionedStats(topic, this.perPartition, this.getPreciseBacklog, this.subscriptionBacklogSize, this.getEarliestTimeInBacklog));
        }
    }

    @CommandLine.Command(description={"Get the internal stats for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetPartitionedStatsInternal
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPartitionedStatsInternal() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPartitionedStatsInternal.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getPartitionedInternalStats(topic));
        }
    }

    @CommandLine.Command(description={"Skip some messages for the subscription"})
    private class Skip
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be skip messages on"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-n", "--count"}, description={"Number of messages to skip"}, required=true)
        private long numMessages;

        private Skip() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Skip.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().skipMessages(topic, this.subName, this.numMessages);
        }
    }

    @CommandLine.Command(description={"Skip all the messages for the subscription"})
    private class ClearBacklog
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be cleared"}, required=true)
        private String subName;

        private ClearBacklog() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = ClearBacklog.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().skipAllMessages(topic, this.subName);
        }
    }

    @CommandLine.Command(description={"Expire messages that older than given expiry time (in seconds) for the subscription"})
    private class ExpireMessages
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be skip messages on"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-t", "--expireTime"}, description={"Expire messages older than time in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w)"}, converter={TimeUnitToSecondsConverter.class})
        private Long expireTimeInSeconds = -1L;
        @CommandLine.Option(names={"--position", "-p"}, description={"message position to reset back to (ledgerId:entryId)"}, required=false)
        private String messagePosition;
        @CommandLine.Option(names={"-e", "--exclude-reset-position"}, description={"Exclude the reset position, start consume messages from the next position."})
        private boolean excludeResetPosition = false;

        private ExpireMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.expireTimeInSeconds >= 0L && StringUtils.isNotBlank((CharSequence)this.messagePosition)) {
                throw new CliCommand.ParameterException(String.format("Can't expire message by time and by message position at the same time.", new Object[0]));
            }
            String topic = ExpireMessages.validateTopicName(this.topicName);
            if (this.expireTimeInSeconds >= 0L) {
                CmdTopics.this.getTopics().expireMessages(topic, this.subName, this.expireTimeInSeconds.longValue());
            } else if (StringUtils.isNotBlank((CharSequence)this.messagePosition)) {
                int partitionIndex = TopicName.get((String)topic).getPartitionIndex();
                MessageId messageId = ExpireMessages.validateMessageIdString(this.messagePosition, partitionIndex);
                CmdTopics.this.getTopics().expireMessages(topic, this.subName, messageId, this.excludeResetPosition);
            } else {
                throw new CliCommand.ParameterException("Either time (--expireTime) or message position (--position) has to be provided to expire messages");
            }
        }
    }

    @CommandLine.Command(description={"Expire messages that older than given expiry time (in seconds) for all subscriptions"})
    private class ExpireMessagesForAllSubscriptions
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-t", "--expireTime"}, description={"Expire messages older than time in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w)"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long expireTimeInSeconds;

        private ExpireMessagesForAllSubscriptions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = ExpireMessagesForAllSubscriptions.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().expireMessagesForAllSubscriptions(topic, this.expireTimeInSeconds.longValue());
        }
    }

    @CommandLine.Command(description={"Create a partitioned topic. The partitioned topic has to be created before creating a producer on it."})
    private class CreatePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-p", "--partitions"}, description={"Number of partitions for the topic"}, required=true)
        private int numPartitions;
        @CommandLine.Option(names={"--metadata", "-m"}, description={"key value pair properties(a=a,b=b,c=c)"})
        private List<String> metadata;

        private CreatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = CreatePartitionedCmd.validateTopicName(this.topicName);
            Map<String, String> map = CmdTopics.this.parseListKeyValueMap(this.metadata);
            CmdTopics.this.getTopics().createPartitionedTopic(topic, this.numPartitions, map);
        }
    }

    @CommandLine.Command(description={"Try to create partitions for partitioned topic. The partitions of partition topic has to be created, can be used by repair partitions when topic auto creation is disabled"})
    private class CreateMissedPartitionsCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private CreateMissedPartitionsCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = CreateMissedPartitionsCmd.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().createMissedPartitions(topic);
        }
    }

    @CommandLine.Command(description={"Create a non-partitioned topic."})
    private class CreateNonPartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--metadata", "-m"}, description={"key value pair properties(a=a,b=b,c=c)"})
        private List<String> metadata;

        private CreateNonPartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = CreateNonPartitionedCmd.validateTopicName(this.topicName);
            Map<String, String> map = CmdTopics.this.parseListKeyValueMap(this.metadata);
            CmdTopics.this.getTopics().createNonPartitionedTopic(topic, map);
        }
    }

    @CommandLine.Command(description={"Update existing partitioned topic. New updating number of partitions must be greater than existing number of partitions."})
    private class UpdatePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-p", "--partitions"}, description={"Number of partitions for the topic"}, required=true)
        private int numPartitions;
        @CommandLine.Option(names={"-ulo", "--update-local-only"}, description={"Update partitions number for topic in local cluster only"})
        private boolean updateLocalOnly = false;
        @CommandLine.Option(names={"-f", "--force"}, description={"Update forcefully without validating existing partitioned topic"})
        private boolean force;

        private UpdatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = UpdatePartitionedCmd.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().updatePartitionedTopic(topic, this.numPartitions, this.updateLocalOnly, this.force);
        }
    }

    @CommandLine.Command(description={"Get the partitioned topic metadata. If the topic is not created or is a non-partitioned topic, it returns empty topic with 0 partitions"})
    private class GetPartitionedTopicMetadataCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPartitionedTopicMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPartitionedTopicMetadataCmd.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getPartitionedTopicMetadata(topic));
        }
    }

    @CommandLine.Command(description={"Get the topic properties."})
    private class GetPropertiesCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPropertiesCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPropertiesCmd.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getProperties(topic));
        }
    }

    @CommandLine.Command(description={"Update the properties of on a topic"})
    private class UpdateProperties
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--property", "-p"}, description={"key value pair properties(-p a=b -p c=d)"}, required=false)
        private Map<String, String> properties;

        private UpdateProperties() {
        }

        @Override
        void run() throws Exception {
            String topic = UpdateProperties.validateTopicName(this.topicName);
            if (this.properties == null) {
                this.properties = Collections.emptyMap();
            }
            CmdTopics.this.getTopics().updateProperties(topic, this.properties);
        }
    }

    @CommandLine.Command(description={"Remove the key in properties of a topic"})
    private class RemoveProperties
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--key", "-k"}, description={"The key to remove in the properties of topic"})
        private String key;

        private RemoveProperties() {
        }

        @Override
        void run() throws Exception {
            String topic = RemoveProperties.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().removeProperties(topic, this.key);
        }
    }

    @CommandLine.Command(description={"Delete a partitioned topic. It will also delete all the partitions of the topic if it exists.And the application is not able to connect to the topic(delete then re-create with same name) again if the schema auto uploading is disabled. Besides, users should to use the truncate cmd to clean up data of the topic instead of delete cmd if users continue to use this topic later."})
    private class DeletePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-f", "--force"}, description={"Close all producer/consumer/replicator and delete topic forcefully"})
        private boolean force = false;
        @CommandLine.Option(names={"-d", "--deleteSchema"}, description={"Delete schema while deleting topic, but the parameter is invalid and the schema is always deleted"}, hidden=true)
        private boolean deleteSchema = false;

        private DeletePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = DeletePartitionedCmd.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().deletePartitionedTopic(topic, this.force);
        }
    }

    @CommandLine.Command(description={"Peek some messages for the subscription"})
    private class PeekMessages
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to get messages from"}, required=true)
        private String subName;
        @CommandLine.Option(names={"-n", "--count"}, description={"Number of messages (default 1)"}, required=false)
        private int numMessages = 1;
        @CommandLine.Option(names={"-ssm", "--show-server-marker"}, description={"Enables the display of internal server write markers."}, required=false)
        private boolean showServerMarker = false;
        @CommandLine.Option(names={"-til", "--transaction-isolation-level"}, description={"Sets the isolation level for peeking messages within transactions. 'READ_COMMITTED' allows peeking only committed transactional messages. 'READ_UNCOMMITTED' allows peeking all messages, even transactional messages which have been aborted."}, required=false)
        private TransactionIsolationLevel transactionIsolationLevel = TransactionIsolationLevel.READ_COMMITTED;

        private PeekMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = PeekMessages.validatePersistentTopic(this.topicName);
            List messages = CmdTopics.this.getTopics().peekMessages(persistentTopic, this.subName, this.numMessages, this.showServerMarker, this.transactionIsolationLevel);
            int position = 0;
            for (Message msg : messages) {
                MessageImpl message = (MessageImpl)msg;
                if (++position != 1) {
                    System.out.println("-------------------------------------------------------------------------\n");
                }
                if (message.getMessageId() instanceof BatchMessageIdImpl) {
                    msgId = (BatchMessageIdImpl)message.getMessageId();
                    System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
                } else {
                    msgId = (MessageIdImpl)msg.getMessageId();
                    System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
                }
                System.out.println("Publish time: " + message.getPublishTime());
                System.out.println("Event time: " + message.getEventTime());
                if (message.getDeliverAtTime() != 0L) {
                    System.out.println("Deliver at time: " + message.getDeliverAtTime());
                }
                MessageMetadata msgMetaData = message.getMessageBuilder();
                if (this.showServerMarker && msgMetaData.hasMarkerType()) {
                    System.out.println("Marker Type: " + String.valueOf(MarkerType.valueOf((int)msgMetaData.getMarkerType())));
                }
                if (message.getBrokerEntryMetadata() != null) {
                    if (message.getBrokerEntryMetadata().hasBrokerTimestamp()) {
                        System.out.println("Broker entry metadata timestamp: " + message.getBrokerEntryMetadata().getBrokerTimestamp());
                    }
                    if (message.getBrokerEntryMetadata().hasIndex()) {
                        System.out.println("Broker entry metadata index: " + message.getBrokerEntryMetadata().getIndex());
                    }
                }
                if (message.getProperties().size() > 0) {
                    System.out.println("Properties:");
                    this.print(msg.getProperties());
                }
                ByteBuf data = Unpooled.wrappedBuffer((byte[])msg.getData());
                System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)data));
            }
        }
    }

    @CommandLine.Command(description={"Examine a specific message on a topic by position relative to the earliest or the latest message."})
    private class ExamineMessages
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-i", "--initialPosition"}, description={"Relative start position to examine message.It can be 'latest' or 'earliest', default is latest"})
        private String initialPosition = "latest";
        @CommandLine.Option(names={"-m", "--messagePosition"}, description={"The position of messages (default 1)"}, required=false)
        private long messagePosition = 1L;

        private ExamineMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ExamineMessages.validatePersistentTopic(this.topicName);
            MessageImpl message = (MessageImpl)CmdTopics.this.getTopics().examineMessage(persistentTopic, this.initialPosition, this.messagePosition);
            if (message.getMessageId() instanceof BatchMessageIdImpl) {
                msgId = (BatchMessageIdImpl)message.getMessageId();
                System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
            } else {
                msgId = (MessageIdImpl)message.getMessageId();
                System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
            }
            System.out.println("Publish time: " + message.getPublishTime());
            System.out.println("Event time: " + message.getEventTime());
            if (message.getDeliverAtTime() != 0L) {
                System.out.println("Deliver at time: " + message.getDeliverAtTime());
            }
            if (message.getBrokerEntryMetadata() != null) {
                if (message.getBrokerEntryMetadata().hasBrokerTimestamp()) {
                    System.out.println("Broker entry metadata timestamp: " + message.getBrokerEntryMetadata().getBrokerTimestamp());
                }
                if (message.getBrokerEntryMetadata().hasIndex()) {
                    System.out.println("Broker entry metadata index: " + message.getBrokerEntryMetadata().getIndex());
                }
            }
            if (message.getProperties().size() > 0) {
                System.out.println("Properties:");
                this.print(message.getProperties());
            }
            ByteBuf data = Unpooled.wrappedBuffer((byte[])message.getData());
            System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)data));
        }
    }

    @CommandLine.Command(description={"Get message by its ledgerId and entryId"})
    private class GetMessageById
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-l", "--ledgerId"}, description={"ledger id pointing to the desired ledger"}, required=true)
        private long ledgerId;
        @CommandLine.Option(names={"-e", "--entryId"}, description={"entry id pointing to the desired entry"}, required=true)
        private long entryId;

        private GetMessageById() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageById.validatePersistentTopic(this.topicName);
            MessageImpl message = (MessageImpl)CmdTopics.this.getTopics().getMessageById(persistentTopic, this.ledgerId, this.entryId);
            if (message == null) {
                System.out.println("Cannot find any messages based on ledgerId:" + this.ledgerId + " entryId:" + this.entryId);
            } else {
                if (message.getMessageId() instanceof BatchMessageIdImpl) {
                    msgId = (BatchMessageIdImpl)message.getMessageId();
                    System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
                } else {
                    msgId = (MessageIdImpl)message.getMessageId();
                    System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
                }
                System.out.println("Publish time: " + message.getPublishTime());
                System.out.println("Event time: " + message.getEventTime());
                System.out.println("Redelivery count: " + message.getRedeliveryCount());
                if (message.getDeliverAtTime() != 0L) {
                    System.out.println("Deliver at time: " + message.getDeliverAtTime());
                }
                if (message.getBrokerEntryMetadata() != null) {
                    if (message.getBrokerEntryMetadata().hasBrokerTimestamp()) {
                        System.out.println("Broker entry metadata timestamp: " + message.getBrokerEntryMetadata().getBrokerTimestamp());
                    }
                    if (message.getBrokerEntryMetadata().hasIndex()) {
                        System.out.println("Broker entry metadata index: " + message.getBrokerEntryMetadata().getIndex());
                    }
                }
                if (message.getProperties().size() > 0) {
                    System.out.println("Properties:");
                    this.print(message.getProperties());
                }
                ByteBuf date = Unpooled.wrappedBuffer((byte[])message.getData());
                System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)date));
            }
        }
    }

    @CommandLine.Command(description={"Get message ID"})
    private class GetMessageId
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-d", "--datetime"}, description={"datetime at or before this messageId. This datetime is in format of ISO_OFFSET_DATE_TIME, e.g. 2021-06-28T16:53:08Z or 2021-06-28T16:53:08.123456789+08:00"}, required=true)
        private String datetime;

        private GetMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageId.validatePersistentTopic(this.topicName);
            long timestamp = DateFormatter.parse((String)this.datetime);
            MessageId messageId = CmdTopics.this.getTopics().getMessageIdByTimestamp(persistentTopic, timestamp);
            if (messageId == null) {
                System.out.println("Cannot find any messages based on timestamp " + timestamp);
            } else {
                this.print(messageId);
            }
        }
    }

    @CommandLine.Command(description={"Reset position for subscription to a position that is closest to timestamp or messageId."})
    private class ResetCursor
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to reset position on"}, required=true)
        private String subName;
        @CommandLine.Option(names={"--time", "-t"}, description={"time in minutes to reset back to (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w)"}, required=false, converter={TimeUnitToMillisConverter.class})
        private Long resetTimeInMillis = null;
        @CommandLine.Option(names={"--messageId", "-m"}, description={"messageId to reset back to ('latest', 'earliest', or 'ledgerId:entryId')"})
        private String resetMessageIdStr;
        @CommandLine.Option(names={"-e", "--exclude-reset-position"}, description={"Exclude the reset position, start consume messages from the next position."})
        private boolean excludeResetPosition = false;

        private ResetCursor() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ResetCursor.validatePersistentTopic(this.topicName);
            if (StringUtils.isNotBlank((CharSequence)this.resetMessageIdStr)) {
                MessageId messageId = "earliest".equals(this.resetMessageIdStr) ? MessageId.earliest : ("latest".equals(this.resetMessageIdStr) ? MessageId.latest : ResetCursor.validateMessageIdString(this.resetMessageIdStr));
                if (this.excludeResetPosition) {
                    CmdTopics.this.getTopics().resetCursor(persistentTopic, this.subName, messageId, true);
                } else {
                    CmdTopics.this.getTopics().resetCursor(persistentTopic, this.subName, messageId);
                }
            } else if (Objects.nonNull(this.resetTimeInMillis)) {
                long timestamp = System.currentTimeMillis() - this.resetTimeInMillis;
                CmdTopics.this.getTopics().resetCursor(persistentTopic, this.subName, timestamp);
            } else {
                throw new PulsarAdminException("Either Timestamp (--time) or messageId (--messageId) has to be provided to reset cursor");
            }
        }
    }

    @CommandLine.Command(description={"Terminate a topic and don't allow any more messages to be published"})
    private class Terminate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Terminate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Terminate.validatePersistentTopic(this.topicName);
            try {
                MessageId lastMessageId = (MessageId)CmdTopics.this.getTopics().terminateTopicAsync(persistentTopic).get();
                System.out.println("Topic successfully terminated at " + String.valueOf(lastMessageId));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @CommandLine.Command(description={"Terminate a partitioned topic and don't allow any more messages to be published"})
    private class PartitionedTerminate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private PartitionedTerminate() {
        }

        @Override
        void run() throws PulsarAdminException, TimeoutException {
            String persistentTopic = PartitionedTerminate.validatePersistentTopic(this.topicName);
            Map messageIds = CmdTopics.this.getTopics().terminatePartitionedTopic(persistentTopic);
            for (Map.Entry entry : messageIds.entrySet()) {
                String topicName = persistentTopic + "-partition-" + String.valueOf(entry.getKey());
                System.out.println("Topic " + topicName + " successfully terminated at " + String.valueOf(entry.getValue()));
            }
        }
    }

    @CommandLine.Command(description={"Compact a topic"})
    private class Compact
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Compact() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Compact.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().triggerCompaction(persistentTopic);
            System.out.println("Topic compaction requested for " + persistentTopic);
        }
    }

    @CommandLine.Command(description={"Status of compaction on a topic"})
    private class CompactionStatusCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-w", "--wait-complete"}, description={"Wait for compaction to complete"}, required=false)
        private boolean wait = false;

        private CompactionStatusCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = CompactionStatusCmd.validatePersistentTopic(this.topicName);
            try {
                LongRunningProcessStatus status = CmdTopics.this.getTopics().compactionStatus(persistentTopic);
                while (this.wait && status.status == LongRunningProcessStatus.Status.RUNNING) {
                    Thread.sleep(1000L);
                    status = CmdTopics.this.getTopics().compactionStatus(persistentTopic);
                }
                switch (status.status) {
                    case NOT_RUN: {
                        System.out.println("Compaction has not been run for " + persistentTopic + " since broker startup");
                        break;
                    }
                    case RUNNING: {
                        System.out.println("Compaction is currently running");
                        break;
                    }
                    case SUCCESS: {
                        System.out.println("Compaction was a success");
                        break;
                    }
                    case ERROR: {
                        System.out.println("Error in compaction");
                        throw new PulsarAdminException("Error compacting: " + status.lastError);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @CommandLine.Command(description={"Trigger offload of data from a topic to long-term storage (e.g. Amazon S3)"})
    private class Offload
    extends CliCommand {
        @CommandLine.Option(names={"-s", "--size-threshold"}, description={"Maximum amount of data to keep in BookKeeper for the specified topic (e.g. 10M, 5G)."}, required=true, converter={ByteUnitToLongConverter.class})
        private Long sizeThreshold;
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Offload() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Offload.validatePersistentTopic(this.topicName);
            PersistentTopicInternalStats stats = CmdTopics.this.getTopics().getInternalStats(persistentTopic, false);
            if (stats.ledgers.size() < 1) {
                throw new PulsarAdminException("Topic doesn't have any data");
            }
            LinkedList<ManagedLedgerInternalStats.LedgerInfo> ledgers = new LinkedList<ManagedLedgerInternalStats.LedgerInfo>(stats.ledgers);
            ((ManagedLedgerInternalStats.LedgerInfo)ledgers.get((int)(ledgers.size() - 1))).size = stats.currentLedgerSize;
            MessageId messageId = CmdTopics.findFirstLedgerWithinThreshold(ledgers, this.sizeThreshold);
            if (messageId == null) {
                System.out.println("Nothing to offload");
                return;
            }
            CmdTopics.this.getTopics().triggerOffload(persistentTopic, messageId);
            System.out.println("Offload triggered for " + persistentTopic + " for messages before " + String.valueOf(messageId));
        }
    }

    @CommandLine.Command(description={"Check the status of data offloading from a topic to long-term storage"})
    private class OffloadStatusCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-w", "--wait-complete"}, description={"Wait for offloading to complete"}, required=false)
        private boolean wait = false;

        private OffloadStatusCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = OffloadStatusCmd.validatePersistentTopic(this.topicName);
            try {
                OffloadProcessStatus status = CmdTopics.this.getTopics().offloadStatus(persistentTopic);
                while (this.wait && status.getStatus() == LongRunningProcessStatus.Status.RUNNING) {
                    Thread.sleep(1000L);
                    status = CmdTopics.this.getTopics().offloadStatus(persistentTopic);
                }
                switch (status.getStatus()) {
                    case NOT_RUN: {
                        System.out.println("Offload has not been run for " + persistentTopic + " since broker startup");
                        break;
                    }
                    case RUNNING: {
                        System.out.println("Offload is currently running");
                        break;
                    }
                    case SUCCESS: {
                        System.out.println("Offload was a success");
                        break;
                    }
                    case ERROR: {
                        System.out.println("Error in offload");
                        throw new PulsarAdminException("Error offloading: " + status.getLastError());
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @CommandLine.Command(description={"get the last commit message id of topic"})
    private class GetLastMessageId
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetLastMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetLastMessageId.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getLastMessageId(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Get the backlog quota policies for a topic"}, hidden=true)
    private class GetBacklogQuotaMap
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetBacklogQuotaMap.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getBacklogQuotaMap(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set a backlog quota policy for a topic"}, hidden=true)
    private class SetBacklogQuota
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-l", "--limit"}, description={"Size limit (eg: 10M, 16G)"}, converter={ByteUnitToLongConverter.class})
        private Long limit = -1L;
        @CommandLine.Option(names={"-lt", "--limitTime"}, description={"Time limit in second (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), non-positive number for disabling time limit."}, converter={TimeUnitToSecondsConverter.class})
        private Long limitTimeInSec = -1L;
        @CommandLine.Option(names={"-p", "--policy"}, description={"Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]"}, required=true)
        private String policyStr;
        @CommandLine.Option(names={"-t", "--type"}, description={"Backlog quota type to set. Valid options are: destination_storage and message_age. destination_storage limits backlog by size (in bytes). message_age limits backlog by time, that is, message timestamp (broker or publish timestamp). You can set size or time to control the backlog, or combine them together to control the backlog. "})
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            String persistentTopic = SetBacklogQuota.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setBacklogQuota(persistentTopic, BacklogQuota.builder().limitSize(this.limit.longValue()).limitTime(this.limitTimeInSec.intValue()).retentionPolicy(policy).build(), backlogQuotaType);
        }
    }

    @CommandLine.Command(description={"Remove a backlog quota policy from a topic"}, hidden=true)
    private class RemoveBacklogQuota
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-t", "--type"}, description={"Backlog quota type to remove"})
        private String backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage.name();

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveBacklogQuota.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeBacklogQuota(persistentTopic, BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaType));
        }
    }

    @CommandLine.Command(description={"Get the message TTL for a topic"}, hidden=true)
    private class GetMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageTTL.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMessageTTL(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set message TTL for a topic"}, hidden=true)
    private class SetMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-t", "--ttl"}, description={"Message TTL for topic in second (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), allowed range from 1 to Integer.MAX_VALUE"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long messageTTLInSecond;

        private SetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMessageTTL.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMessageTTL(persistentTopic, this.messageTTLInSecond.intValue());
        }
    }

    @CommandLine.Command(description={"Remove message TTL for a topic"}, hidden=true)
    private class RemoveMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMessageTTL.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMessageTTL(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the retention policy for a topic"})
    private class GetRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetRetention.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getRetention(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the retention policy for a topic"}, hidden=true)
    private class SetRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--time", "-t"}, description={"Retention time with optional time unit suffix. For example, 100m, 3h, 2d, 5w. If the time unit is not specified, the default unit is seconds. For example, -t 120 will set retention to 2 minutes. 0 means no retention and -1 means infinite time retention."}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long retentionTimeInSec;
        @CommandLine.Option(names={"--size", "-s"}, description={"Retention size limit with optional size unit suffix. For example, 4096, 10M, 16G, 3T.  The size unit suffix character can be k/K, m/M, g/G, or t/T.  If the size unit suffix is not specified, the default unit is bytes. 0 or less than 1MB means no retention and -1 means infinite size retention"}, required=true, converter={ByteUnitToLongConverter.class})
        private Long sizeLimit;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetRetention.validatePersistentTopic(this.topicName);
            int retentionTimeInMin = this.retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(this.retentionTimeInSec) : this.retentionTimeInSec.intValue();
            long retentionSizeInMB = this.sizeLimit != -1L ? this.sizeLimit / 0x100000L : this.sizeLimit;
            CmdTopics.this.getTopics().setRetention(persistentTopic, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @CommandLine.Command(description={"Remove the retention policy for a topic"}, hidden=true)
    private class RemoveRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveRetention.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeRetention(persistentTopic);
        }
    }

    @Deprecated
    @CommandLine.Command(description={"Enable the deduplication policy for a topic"}, hidden=true)
    private class EnableDeduplication
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private EnableDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = EnableDeduplication.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().enableDeduplication(persistentTopic, true);
        }
    }

    @Deprecated
    @CommandLine.Command(description={"Disable the deduplication policy for a topic"}, hidden=true)
    private class DisableDeduplication
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private DisableDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DisableDeduplication.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().enableDeduplication(persistentTopic, false);
        }
    }

    @CommandLine.Command(description={"Get the deduplication policy for a topic"}, hidden=true)
    private class GetDeduplicationStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationStatus.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getDeduplicationStatus(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Enable or disable deduplication for a topic"}, hidden=true)
    private class SetDeduplicationStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable deduplication"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable deduplication"})
        private boolean disable = false;

        private SetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDeduplicationStatus.validatePersistentTopic(this.topicName);
            if (this.enable == this.disable) {
                throw new IllegalArgumentException("Need to specify either --enable or --disable");
            }
            CmdTopics.this.getTopics().setDeduplicationStatus(persistentTopic, this.enable);
        }
    }

    @CommandLine.Command(description={"Remove the deduplication policy for a topic"}, hidden=true)
    private class RemoveDeduplicationStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationStatus.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeDeduplicationStatus(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get deduplication snapshot interval for a topic"}, hidden=true)
    private class GetDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationSnapshotInterval.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getDeduplicationSnapshotInterval(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set deduplication snapshot interval for a topic"}, hidden=true)
    private class SetDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-i", "--interval"}, description={"Deduplication snapshot interval for topic in second, allowed range from 0 to Integer.MAX_VALUE"}, required=true)
        private int interval;

        private SetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.interval < 0) {
                throw new IllegalArgumentException(String.format("Invalid interval '%d'. ", this.interval));
            }
            String persistentTopic = SetDeduplicationSnapshotInterval.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setDeduplicationSnapshotInterval(persistentTopic, this.interval);
        }
    }

    @CommandLine.Command(description={"Remove deduplication snapshot interval for a topic"}, hidden=true)
    private class RemoveDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationSnapshotInterval.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeDeduplicationSnapshotInterval(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the delayed delivery policy for a topic"}, hidden=true)
    private class GetDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetDelayedDelivery.validateTopicName(this.topicName);
            this.print(CmdTopics.this.getTopics().getDelayedDeliveryPolicy(topic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the delayed delivery policy on a topic"}, hidden=true)
    private class SetDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable delayed delivery messages"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable delayed delivery messages"})
        private boolean disable = false;
        @CommandLine.Option(names={"--time", "-t"}, description={"The tick time for when retrying on delayed delivery messages, affecting the accuracy of the delivery time compared to the scheduled time. (eg: 1s, 10s, 1m, 5h, 3d)"}, converter={TimeUnitToMillisConverter.class})
        private Long delayedDeliveryTimeInMills = 1000L;
        @CommandLine.Option(names={"--maxDelay", "-md"}, description={"The max allowed delay for delayed delivery. (eg: 1s, 10s, 1m, 5h, 3d)"}, converter={TimeUnitToMillisConverter.class})
        private Long delayedDeliveryMaxDelayInMillis = 0L;

        private SetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = SetDelayedDelivery.validateTopicName(this.topicName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopics.this.getTopics().setDelayedDeliveryPolicy(topic, DelayedDeliveryPolicies.builder().tickTime(this.delayedDeliveryTimeInMills.longValue()).active(this.enable).maxDeliveryDelayInMillis(this.delayedDeliveryMaxDelayInMillis.longValue()).build());
        }
    }

    @CommandLine.Command(description={"Remove the delayed delivery policy on a topic"}, hidden=true)
    private class RemoveDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topic;

        private RemoveDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topicName = RemoveDelayedDelivery.validateTopicName(this.topic);
            CmdTopics.this.getTopics().removeDelayedDeliveryPolicy(topicName);
        }
    }

    @CommandLine.Command(description={"Get the persistence policies for a topic"}, hidden=true)
    private class GetPersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPersistence.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getPersistence(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set the persistence policies for a topic"}, hidden=true)
    private class SetPersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-e", "--bookkeeper-ensemble"}, description={"Number of bookies to use for a topic"})
        private int bookkeeperEnsemble = 2;
        @CommandLine.Option(names={"-w", "--bookkeeper-write-quorum"}, description={"How many writes to make of each entry"})
        private int bookkeeperWriteQuorum = 2;
        @CommandLine.Option(names={"-a", "--bookkeeper-ack-quorum"}, description={"Number of acks (guaranteed copies) to wait for each entry"})
        private int bookkeeperAckQuorum = 2;
        @CommandLine.Option(names={"-r", "--ml-mark-delete-max-rate"}, description={"Throttling rate of mark-delete operation (0 means no throttle)"})
        private double managedLedgerMaxMarkDeleteRate = 0.0;
        @CommandLine.Option(names={"-c", "--ml-storage-class"}, description={"Managed ledger storage class name"})
        private String managedLedgerStorageClassName;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPersistence.validatePersistentTopic(this.topicName);
            if (this.bookkeeperEnsemble <= 0 || this.bookkeeperWriteQuorum <= 0 || this.bookkeeperAckQuorum <= 0) {
                throw new CliCommand.ParameterException("[--bookkeeper-ensemble], [--bookkeeper-write-quorum] and [--bookkeeper-ack-quorum] must greater than 0.");
            }
            if (this.managedLedgerMaxMarkDeleteRate < 0.0) {
                throw new CliCommand.ParameterException("[--ml-mark-delete-max-rate] cannot less than 0.");
            }
            CmdTopics.this.getTopics().setPersistence(persistentTopic, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate, this.managedLedgerStorageClassName));
        }
    }

    @CommandLine.Command(description={"Remove the persistence policy for a topic"}, hidden=true)
    private class RemovePersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePersistence.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removePersistence(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the offload policies for a topic"}, hidden=true)
    private class GetOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetOffloadPolicies.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getOffloadPolicies(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the offload policies for a topic"}, hidden=true)
    private class SetOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-d", "--driver"}, description={"ManagedLedger offload driver"}, required=true)
        private String driver;
        @CommandLine.Option(names={"-r", "--region"}, description={"ManagedLedger offload region, s3 and google-cloud-storage requires this parameter"})
        private String region;
        @CommandLine.Option(names={"-b", "--bucket"}, description={"ManagedLedger offload bucket, s3 and google-cloud-storage requires this parameter"})
        private String bucket;
        @CommandLine.Option(names={"-e", "--endpoint"}, description={"ManagedLedger offload service endpoint, only s3 requires this parameter"})
        private String endpoint;
        @CommandLine.Option(names={"-i", "--aws-id"}, description={"AWS Credential Id to use when using driver S3 or aws-s3"})
        private String awsId;
        @CommandLine.Option(names={"-s", "--aws-secret"}, description={"AWS Credential Secret to use when using driver S3 or aws-s3"})
        private String awsSecret;
        @CommandLine.Option(names={"--ro", "--s3-role"}, description={"S3 Role used for STSAssumeRoleSessionCredentialsProvider"})
        private String s3Role;
        @CommandLine.Option(names={"--s3-role-session-name", "-rsn"}, description={"S3 role session name used for STSAssumeRoleSessionCredentialsProvider"})
        private String s3RoleSessionName;
        @CommandLine.Option(names={"-m", "--maxBlockSizeInBytes", "--maxBlockSize", "-mbs"}, description={"Max block size (eg: 32M, 64M), default is 64MBs3 and google-cloud-storage requires this parameter"}, required=false, converter={ByteUnitToIntegerConverter.class})
        private Integer maxBlockSizeInBytes = 0x4000000;
        @CommandLine.Option(names={"-rb", "--readBufferSizeInBytes", "--readBufferSize", "-rbs"}, description={"Read buffer size (eg: 1M, 5M), default is 1MBs3 and google-cloud-storage requires this parameter"}, required=false, converter={ByteUnitToIntegerConverter.class})
        private Integer readBufferSizeInBytes = 0x100000;
        @CommandLine.Option(names={"-t", "--offloadThresholdInBytes", "--offloadAfterThreshold", "-oat"}, description={"Offload after threshold size (eg: 1M, 5M)"}, required=false, converter={ByteUnitToLongConverter.class})
        private Long offloadAfterThresholdInBytes = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
        @CommandLine.Option(names={"-ts", "--offloadThresholdInSeconds", "--offloadAfterThresholdInSeconds", "-oats"}, description={"Offload after threshold seconds (or minutes,hours,days,weeks eg: 100m, 3h, 2d, 5w)."}, converter={TimeUnitToSecondsConverter.class})
        private Long offloadThresholdInSeconds = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_SECONDS;
        @CommandLine.Option(names={"-dl", "--offloadDeletionLagInMillis", "--offloadAfterElapsed", "-oae"}, description={"Delay time in Millis for deleting the bookkeeper ledger after offload (or seconds,minutes,hours,days,weeks eg: 10s, 100m, 3h, 2d, 5w)."}, converter={TimeUnitToMillisConverter.class})
        private Long offloadAfterElapsedInMillis = OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
        @CommandLine.Option(names={"--offloadedReadPriority", "-orp"}, description={"Read priority for offloaded messages. By default, once messages are offloaded to long-term storage, brokers read messages from long-term storage, but messages can still exist in BookKeeper for a period depends on your configuration. For messages that exist in both long-term storage and BookKeeper, you can set where to read messages from with the option `tiered-storage-first` or `bookkeeper-first`."})
        private String offloadReadPriorityStr;
        public final List<String> driverNames = OffloadPoliciesImpl.DRIVER_NAMES;

        private SetOffloadPolicies() {
        }

        public boolean driverSupported(String driver) {
            return this.driverNames.stream().anyMatch(d -> d.equalsIgnoreCase(driver));
        }

        public boolean isS3Driver(String driver) {
            if (StringUtils.isEmpty((CharSequence)driver)) {
                return false;
            }
            return driver.equalsIgnoreCase(this.driverNames.get(0)) || driver.equalsIgnoreCase(this.driverNames.get(1));
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetOffloadPolicies.validatePersistentTopic(this.topicName);
            if (!this.driverSupported(this.driver)) {
                throw new CliCommand.ParameterException("The driver " + this.driver + " is not supported, (Possible values: " + String.join((CharSequence)",", this.driverNames) + ").");
            }
            if (this.isS3Driver(this.driver) && Strings.isNullOrEmpty((String)this.region) && Strings.isNullOrEmpty((String)this.endpoint)) {
                throw new CliCommand.ParameterException("Either s3ManagedLedgerOffloadRegion or s3ManagedLedgerOffloadServiceEndpoint must be set if s3 offload enabled");
            }
            OffloadedReadPriority offloadedReadPriority = OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY;
            if (this.offloadReadPriorityStr != null) {
                try {
                    offloadedReadPriority = OffloadedReadPriority.fromString((String)this.offloadReadPriorityStr);
                }
                catch (Exception e) {
                    throw new CliCommand.ParameterException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + this.offloadReadPriorityStr, e);
                }
            }
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)this.driver, (String)this.region, (String)this.bucket, (String)this.endpoint, (String)this.s3Role, (String)this.s3RoleSessionName, (String)this.awsId, (String)this.awsSecret, (Integer)this.maxBlockSizeInBytes, (Integer)this.readBufferSizeInBytes, (Long)this.offloadAfterThresholdInBytes, (Long)this.offloadThresholdInSeconds, (Long)this.offloadAfterElapsedInMillis, (OffloadedReadPriority)offloadedReadPriority);
            CmdTopics.this.getTopics().setOffloadPolicies(persistentTopic, (OffloadPolicies)offloadPolicies);
        }
    }

    @CommandLine.Command(description={"Remove the offload policies for a topic"}, hidden=true)
    private class RemoveOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveOffloadPolicies.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeOffloadPolicies(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get message dispatch rate for a topic"}, hidden=true)
    private class GetDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDispatchRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getDispatchRate(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set message dispatch rate for a topic"}, hidden=true)
    private class SetDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"})
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"})
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"}, required=false)
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"}, required=false)
        private boolean relativeToPublishRate = false;

        private SetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Remove message dispatch rate for a topic"}, hidden=true)
    private class RemoveDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeDispatchRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get subscription message-dispatch-rate for a topic"}, hidden=true)
    private class GetSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionDispatchRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getSubscriptionDispatchRate(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set subscription message-dispatch-rate for a topic"}, hidden=true)
    private class SetSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"})
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"})
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"})
        private boolean relativeToPublishRate = false;

        private SetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setSubscriptionDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Remove subscription message-dispatch-rate for a topic"}, hidden=true)
    private class RemoveSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeSubscriptionDispatchRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get replicator message-dispatch-rate for a topic"}, hidden=true)
    private class GetReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetReplicatorDispatchRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getReplicatorDispatchRate(topic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set replicator message-dispatch-rate for a topic"}, hidden=true)
    private class SetReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"})
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"})
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"})
        private boolean relativeToPublishRate = false;

        private SetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicatorDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setReplicatorDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Remove replicator message-dispatch-rate for a topic"}, hidden=true)
    private class RemoveReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveReplicatorDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeReplicatorDispatchRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get compaction threshold for a topic"}, hidden=true)
    private class GetCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetCompactionThreshold.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getCompactionThreshold(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set compaction threshold for a topic"}, hidden=true)
    private class SetCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--threshold", "-t"}, description={"Maximum number of bytes in a topic backlog before compaction is triggered (eg: 10M, 16G, 3T). 0 disables automatic compaction"}, required=true, converter={ByteUnitToLongConverter.class})
        private Long threshold = 0L;

        private SetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetCompactionThreshold.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setCompactionThreshold(persistentTopic, this.threshold.longValue());
        }
    }

    @CommandLine.Command(description={"Remove compaction threshold for a topic"}, hidden=true)
    private class RemoveCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveCompactionThreshold.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeCompactionThreshold(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max unacked messages policy on consumer for a topic"}, hidden=true)
    private class GetMaxUnackedMessagesOnConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetMaxUnackedMessagesOnConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesOnConsumer.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxUnackedMessagesOnConsumer(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max unacked messages policy on consumer for a topic"}, hidden=true)
    private class SetMaxUnackedMessagesOnConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-m", "--maxNum"}, description={"max unacked messages num on consumer"}, required=true)
        private int maxNum;

        private SetMaxUnackedMessagesOnConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesOnConsumer.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxUnackedMessagesOnConsumer(persistentTopic, this.maxNum);
        }
    }

    @CommandLine.Command(description={"Remove max unacked messages policy on consumer for a topic"}, hidden=true)
    private class RemoveMaxUnackedMessagesOnConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxUnackedMessagesOnConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesOnConsumer.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxUnackedMessagesOnConsumer(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max unacked messages policy on subscription for a topic"}, hidden=true)
    private class GetMaxUnackedMessagesOnSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetMaxUnackedMessagesOnSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesOnSubscription.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxUnackedMessagesOnSubscription(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max unacked messages policy on subscription for a topic"}, hidden=true)
    private class SetMaxUnackedMessagesOnSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-m", "--maxNum"}, description={"max unacked messages num on subscription"}, required=true)
        private int maxNum;

        private SetMaxUnackedMessagesOnSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesOnSubscription.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxUnackedMessagesOnSubscription(persistentTopic, this.maxNum);
        }
    }

    @CommandLine.Command(description={"Remove max unacked messages policy on subscription for a topic"}, hidden=true)
    private class RemoveMaxUnackedMessagesOnSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxUnackedMessagesOnSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesOnSubscription.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxUnackedMessagesOnSubscription(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get publish rate for a topic"}, hidden=true)
    private class GetPublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPublishRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getPublishRate(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set publish rate for a topic"}, hidden=true)
    private class SetPublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-publish-rate", "-m"}, description={"message-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgPublishRate = -1;
        @CommandLine.Option(names={"--byte-publish-rate", "-b"}, description={"byte-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long bytePublishRate = -1L;

        private SetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPublishRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setPublishRate(persistentTopic, new PublishRate(this.msgPublishRate, this.bytePublishRate));
        }
    }

    @CommandLine.Command(description={"Remove publish rate for a topic"}, hidden=true)
    private class RemovePublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemovePublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePublishRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removePublishRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Set subscription types enabled for a topic"}, hidden=true)
    private class SetSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--types", "-t"}, description={"Subscription types enabled list (comma separated values). Possible values: (Exclusive, Shared, Failover, Key_Shared)."}, required=true, split=",")
        private List<String> subTypes;

        private SetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionTypesEnabled.validatePersistentTopic(this.topicName);
            HashSet types = new HashSet();
            this.subTypes.forEach(s -> {
                SubscriptionType subType;
                try {
                    subType = SubscriptionType.valueOf((String)s);
                }
                catch (IllegalArgumentException exception) {
                    throw new CliCommand.ParameterException(String.format("Illegal subscription type %s. Possible values: %s.", s, Arrays.toString(SubscriptionType.values())));
                }
                types.add(subType);
            });
            CmdTopics.this.getTopics().setSubscriptionTypesEnabled(persistentTopic, types);
        }
    }

    @CommandLine.Command(description={"Get subscription types enabled for a topic"}, hidden=true)
    private class GetSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionTypesEnabled.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getSubscriptionTypesEnabled(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Remove subscription types enabled for a topic"}, hidden=true)
    private class RemoveSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionTypesEnabled.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeSubscriptionTypesEnabled(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max number of producers for a topic"}, hidden=true)
    private class GetMaxProducers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxProducers.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxProducers(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max number of producers for a topic"}, hidden=true)
    private class SetMaxProducers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-producers", "-p"}, description={"Max producers for a topic"}, required=true)
        private int maxProducers;

        private SetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxProducers.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxProducers(persistentTopic, this.maxProducers);
        }
    }

    @CommandLine.Command(description={"Remove max number of producers for a topic"}, hidden=true)
    private class RemoveMaxProducers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxProducers.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxProducers(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max number of subscriptions for a topic"}, hidden=true)
    private class GetMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxSubscriptionsPerTopic.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxSubscriptionsPerTopic(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set max number of subscriptions for a topic"}, hidden=true)
    private class SetMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-subscriptions-per-topic", "-m"}, description={"Maximum subscription limit for a topic"}, required=true)
        private int maxSubscriptionsPerTopic;

        private SetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxSubscriptionsPerTopic.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxSubscriptionsPerTopic(persistentTopic, this.maxSubscriptionsPerTopic);
        }
    }

    @CommandLine.Command(description={"Remove max number of subscriptions for a topic"}, hidden=true)
    private class RemoveMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxSubscriptionsPerTopic.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxSubscriptionsPerTopic(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max message size for a topic"}, hidden=true)
    private class GetMaxMessageSize
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxMessageSize.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxMessageSize(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set max message size for a topic"}, hidden=true)
    private class SetMaxMessageSize
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-message-size", "-m"}, description={"Max message size for a topic"}, required=true)
        private int maxMessageSize;

        private SetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxMessageSize.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxMessageSize(persistentTopic, this.maxMessageSize);
        }
    }

    @CommandLine.Command(description={"Remove max message size for a topic"}, hidden=true)
    private class RemoveMaxMessageSize
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxMessageSize.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxMessageSize(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max consumers per subscription for a topic"}, hidden=true)
    private class GetMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumersPerSubscription.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxConsumersPerSubscription(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set max consumers per subscription for a topic"}, hidden=true)
    private class SetMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-consumers-per-subscription", "-c"}, description={"maxConsumersPerSubscription for a namespace"}, required=true)
        private int maxConsumersPerSubscription;

        private SetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumersPerSubscription.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxConsumersPerSubscription(persistentTopic, this.maxConsumersPerSubscription);
        }
    }

    @CommandLine.Command(description={"Remove max consumers per subscription for a topic"}, hidden=true)
    private class RemoveMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumersPerSubscription.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxConsumersPerSubscription(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the inactive topic policies on a topic"}, hidden=true)
    private class GetInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInactiveTopicPolicies.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getInactiveTopicPolicies(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the inactive topic policies on a topic"}, hidden=true)
    private class SetInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable-delete-while-inactive", "-e"}, description={"Enable delete while inactive"})
        private boolean enableDeleteWhileInactive = false;
        @CommandLine.Option(names={"--disable-delete-while-inactive", "-d"}, description={"Disable delete while inactive"})
        private boolean disableDeleteWhileInactive = false;
        @CommandLine.Option(names={"--max-inactive-duration", "-t"}, description={"Max duration of topic inactivity in seconds, topics that are inactive for longer than this value will be deleted (eg: 1s, 10s, 1m, 5h, 3d)"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long maxInactiveDurationInSeconds;
        @CommandLine.Option(names={"--delete-mode", "-m"}, description={"Mode of delete inactive topic, Valid options are: [delete_when_no_subscriptions, delete_when_subscriptions_caught_up]"}, required=true)
        private String inactiveTopicDeleteMode;

        private SetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetInactiveTopicPolicies.validatePersistentTopic(this.topicName);
            if (this.enableDeleteWhileInactive == this.disableDeleteWhileInactive) {
                throw new IllegalArgumentException("Need to specify either enable-delete-while-inactive or disable-delete-while-inactive");
            }
            InactiveTopicDeleteMode deleteMode = null;
            try {
                deleteMode = InactiveTopicDeleteMode.valueOf((String)this.inactiveTopicDeleteMode);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException("delete mode can only be set to delete_when_no_subscriptions or delete_when_subscriptions_caught_up");
            }
            CmdTopics.this.getTopics().setInactiveTopicPolicies(persistentTopic, new InactiveTopicPolicies(deleteMode, this.maxInactiveDurationInSeconds.intValue(), this.enableDeleteWhileInactive));
        }
    }

    @CommandLine.Command(description={"Remove inactive topic policies from a topic"}, hidden=true)
    private class RemoveInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveInactiveTopicPolicies.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeInactiveTopicPolicies(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max number of consumers for a topic"}, hidden=true)
    private class GetMaxConsumers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumers.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getMaxConsumers(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max number of consumers for a topic"}, hidden=true)
    private class SetMaxConsumers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-consumers", "-c"}, description={"Max consumers for a topic"}, required=true)
        private int maxConsumers;

        private SetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumers.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setMaxConsumers(persistentTopic, this.maxConsumers);
        }
    }

    @CommandLine.Command(description={"Remove max number of consumers for a topic"}, hidden=true)
    private class RemoveMaxConsumers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumers.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeMaxConsumers(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get consumer subscribe rate for a topic"}, hidden=true)
    private class GetSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscribeRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getSubscribeRate(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set consumer subscribe rate for a topic"}, hidden=true)
    private class SetSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--subscribe-rate", "-sr"}, description={"subscribe-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int subscribeRate = -1;
        @CommandLine.Option(names={"--subscribe-rate-period", "-st"}, description={"subscribe-rate-period in second type (default 30 second will be overwrite if not passed)"})
        private int subscribeRatePeriodSec = 30;

        private SetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscribeRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().setSubscribeRate(persistentTopic, new SubscribeRate(this.subscribeRate, this.subscribeRatePeriodSec));
        }
    }

    @CommandLine.Command(description={"Remove consumer subscribe rate for a topic"}, hidden=true)
    private class RemoveSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscribeRate.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeSubscribeRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Enable or disable a replicated subscription on a topic"})
    private class SetReplicatedSubscriptionStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription name to enable or disable replication"}, required=true)
        private String subName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable replication"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable replication"})
        private boolean disable = false;

        private SetReplicatedSubscriptionStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicatedSubscriptionStatus.validatePersistentTopic(this.topicName);
            if (this.enable == this.disable) {
                throw new IllegalArgumentException("Need to specify either --enable or --disable");
            }
            CmdTopics.this.getTopics().setReplicatedSubscriptionStatus(persistentTopic, this.subName, this.enable);
        }
    }

    @CommandLine.Command(description={"Get replicated subscription status on a topic"})
    private class GetReplicatedSubscriptionStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription name"}, required=true)
        private String subName;

        private GetReplicatedSubscriptionStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetReplicatedSubscriptionStatus.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getReplicatedSubscriptionStatus(persistentTopic, this.subName));
        }
    }

    @CommandLine.Command(description={"Calculate backlog size by a message ID (in bytes)."})
    private class GetBacklogSizeByMessageId
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--messageId", "-m"}, description={"messageId used to calculate backlog size. It can be (ledgerId:entryId)."})
        private String messagePosition = "-1:-1";

        private GetBacklogSizeByMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetBacklogSizeByMessageId.validatePersistentTopic(this.topicName);
            MessageId messageId = "-1:-1".equals(this.messagePosition) ? MessageId.earliest : GetBacklogSizeByMessageId.validateMessageIdString(this.messagePosition);
            this.print(CmdTopics.this.getTopics().getBacklogSizeByMessageId(persistentTopic, messageId));
        }
    }

    @CommandLine.Command(description={"Analyze the backlog of a subscription."})
    private class AnalyzeBacklog
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription to be analyzed"}, required=true)
        private String subName;
        @CommandLine.Option(names={"--position", "-p"}, description={"message position to start the scan from (ledgerId:entryId)"}, required=false)
        private String messagePosition;

        private AnalyzeBacklog() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = AnalyzeBacklog.validatePersistentTopic(this.topicName);
            Optional<Object> startPosition = Optional.empty();
            if (StringUtils.isNotBlank((CharSequence)this.messagePosition)) {
                int partitionIndex = TopicName.get((String)persistentTopic).getPartitionIndex();
                MessageId messageId = AnalyzeBacklog.validateMessageIdString(this.messagePosition, partitionIndex);
                startPosition = Optional.of(messageId);
            }
            this.print(CmdTopics.this.getTopics().analyzeSubscriptionBacklog(persistentTopic, this.subName, startPosition));
        }
    }

    @CommandLine.Command(description={"Get the replication clusters for a topic"})
    private class GetReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetReplicationClusters.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getReplicationClusters(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the replication clusters for a topic"})
    private class SetReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--clusters", "-c"}, description={"Replication Cluster Ids list (comma separated values)"}, required=true)
        private String clusterIds;

        private SetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicationClusters.validatePersistentTopic(this.topicName);
            ArrayList clusters = Lists.newArrayList((Object[])this.clusterIds.split(","));
            CmdTopics.this.getTopics().setReplicationClusters(persistentTopic, (List)clusters);
        }
    }

    @CommandLine.Command(description={"Remove the replication clusters for a topic"})
    private class RemoveReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveReplicationClusters.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeReplicationClusters(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the shadow topics for a topic"})
    private class GetShadowTopics
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetShadowTopics() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetShadowTopics.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getShadowTopics(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set the shadow topics for a topic"})
    private class SetShadowTopics
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--topics", "-t"}, description={"Shadow topic list (comma separated values)"}, required=true)
        private String shadowTopics;

        private SetShadowTopics() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetShadowTopics.validatePersistentTopic(this.topicName);
            ArrayList topics = Lists.newArrayList((Object[])this.shadowTopics.split(","));
            CmdTopics.this.getTopics().setShadowTopics(persistentTopic, (List)topics);
        }
    }

    @CommandLine.Command(description={"Remove the shadow topics for a topic"})
    private class RemoveShadowTopics
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveShadowTopics() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveShadowTopics.validatePersistentTopic(this.topicName);
            CmdTopics.this.getTopics().removeShadowTopics(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Create a shadow topic for an existing source topic."})
    private class CreateShadowTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--source", "-s"}, description={"source topic name"}, required=true)
        private String sourceTopic;
        @CommandLine.Option(names={"--properties", "-p"}, description={"key value pair properties(eg: a=a,b=b,c=c)"}, split=",")
        private Map<String, String> properties;

        private CreateShadowTopic() {
        }

        @Override
        void run() throws Exception {
            String topic = CreateShadowTopic.validateTopicName(this.topicName);
            CmdTopics.this.getTopics().createShadowTopic(topic, TopicName.get((String)this.sourceTopic).toString(), this.properties);
        }
    }

    @CommandLine.Command(description={"Get the source topic for a shadow topic"})
    private class GetShadowSource
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetShadowSource() {
        }

        @Override
        void run() throws PulsarAdminException {
            String shadowTopic = GetShadowSource.validatePersistentTopic(this.topicName);
            this.print(CmdTopics.this.getTopics().getShadowSource(shadowTopic));
        }
    }

    @CommandLine.Command(description={"Get the schema validation enforced"})
    private class GetSchemaValidationEnforced
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetSchemaValidationEnforced() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetSchemaValidationEnforced.validateTopicName(this.topicName);
            System.out.println(CmdTopics.this.getAdmin().topics().getSchemaValidationEnforced(topic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the schema whether open schema validation enforced"})
    private class SetSchemaValidationEnforced
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable schema validation enforced"})
        private boolean enable = false;

        private SetSchemaValidationEnforced() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = SetSchemaValidationEnforced.validateTopicName(this.topicName);
            CmdTopics.this.getAdmin().topics().setSchemaValidationEnforced(topic, this.enable);
        }
    }

    @CommandLine.Command(description={"Trim a topic"})
    private class TrimTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private TrimTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = TrimTopic.validateTopicName(this.topicName);
            CmdTopics.this.getAdmin().topics().trimTopic(topic);
        }
    }
}

