/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.ClusterPolicies;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about clusters"})
public class CmdClusters
extends CmdBase {
    protected static void validateClusterData(ClusterData clusterData) {
        if (clusterData.isBrokerClientTlsEnabled() && clusterData.isBrokerClientTlsEnabledWithKeyStore() && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{clusterData.getBrokerClientTlsTrustStoreType(), clusterData.getBrokerClientTlsTrustStore(), clusterData.getBrokerClientTlsTrustStorePassword()})) {
            throw new RuntimeException("You must specify tls-trust-store-type, tls-trust-store and tls-trust-store-pwd when enable tls-enable-keystore");
        }
    }

    public CmdClusters(Supplier<PulsarAdmin> admin) {
        super("clusters", admin);
        this.addCommand("get", new Get());
        this.addCommand("create", new Create());
        this.addCommand("update", new Update());
        this.addCommand("delete", new Delete());
        this.addCommand("list", new List());
        this.addCommand("update-peer-clusters", new UpdatePeerClusters());
        this.addCommand("get-cluster-migration", new GetClusterMigration());
        this.addCommand("update-cluster-migration", new UpdateClusterMigration());
        this.addCommand("get-peer-clusters", new GetPeerClusters());
        this.addCommand("get-failure-domain", new GetFailureDomain());
        this.addCommand("create-failure-domain", new CreateFailureDomain());
        this.addCommand("update-failure-domain", new UpdateFailureDomain());
        this.addCommand("delete-failure-domain", new DeleteFailureDomain());
        this.addCommand("list-failure-domains", new ListFailureDomains());
    }

    @CommandLine.Command(description={"Get the configuration data for the specified cluster"})
    private class Get
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;

        private Get() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdClusters.this.getAdmin().clusters().getCluster(this.cluster));
        }
    }

    @CommandLine.Command(description={"Provisions a new cluster. This operation requires Pulsar super-user privileges"})
    private class Create
    extends CliCommand {
        @CommandLine.ArgGroup(exclusive=false)
        ClusterDetails clusterDetails = new ClusterDetails();

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException, IOException {
            CmdClusters.this.getAdmin().clusters().createCluster(this.clusterDetails.clusterName, this.clusterDetails.getClusterData());
        }
    }

    @CommandLine.Command(description={"Update the configuration for a cluster"})
    private class Update
    extends CliCommand {
        @CommandLine.ArgGroup(exclusive=false)
        ClusterDetails clusterDetails = new ClusterDetails();

        private Update() {
        }

        @Override
        void run() throws PulsarAdminException, IOException {
            CmdClusters.this.getAdmin().clusters().updateCluster(this.clusterDetails.clusterName, this.clusterDetails.getClusterData());
        }
    }

    @CommandLine.Command(description={"Deletes an existing cluster"})
    private class Delete
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, index="0", arity="1")
        private String cluster;
        @CommandLine.Option(names={"-a", "--all"}, description={"Delete all data (tenants) of the cluster"}, required=false, defaultValue="false")
        private boolean deleteAll;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.deleteAll) {
                for (String tenant : CmdClusters.this.getAdmin().tenants().getTenants()) {
                    for (String namespace : CmdClusters.this.getAdmin().namespaces().getNamespaces(tenant)) {
                        for (String topic : CmdClusters.this.getAdmin().topics().getPartitionedTopicList(namespace)) {
                            CmdClusters.this.getAdmin().topics().deletePartitionedTopic(topic, true, true);
                        }
                        for (String topic : CmdClusters.this.getAdmin().topics().getList(namespace)) {
                            CmdClusters.this.getAdmin().topics().delete(topic, true, true);
                        }
                        CmdClusters.this.getAdmin().namespaces().deleteNamespace(namespace, true);
                    }
                    CmdClusters.this.getAdmin().tenants().deleteTenant(tenant);
                }
            }
            CmdClusters.this.getAdmin().clusters().deleteCluster(this.cluster);
        }
    }

    @CommandLine.Command(description={"List the existing clusters"})
    private class List
    extends CliCommand {
        @CommandLine.Option(names={"-c", "--current"}, description={"Print the current cluster with (*)"}, required=false, defaultValue="false")
        private boolean current;

        private List() {
        }

        @Override
        void run() throws Exception {
            java.util.List clusters = CmdClusters.this.getAdmin().clusters().getClusters();
            String clusterName = (String)CmdClusters.this.getAdmin().brokers().getRuntimeConfigurations().get("clusterName");
            java.util.List result = clusters.stream().map(c -> c.equals(clusterName) ? (this.current ? c + "(*)" : c) : c).collect(Collectors.toList());
            this.print(result);
        }
    }

    @CommandLine.Command(description={"Update peer cluster names"})
    private class UpdatePeerClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"--peer-clusters"}, description={"Comma separated peer-cluster names [Pass empty string \"\" to delete list]"}, required=true)
        private String peerClusterNames;

        private UpdatePeerClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            LinkedHashSet clusters = StringUtils.isBlank((CharSequence)this.peerClusterNames) ? null : Sets.newLinkedHashSet(Arrays.asList(this.peerClusterNames.split(",")));
            CmdClusters.this.getAdmin().clusters().updatePeerClusterNames(this.cluster, clusters);
        }
    }

    @CommandLine.Command(description={"Get the cluster migration configuration data for the specified cluster"})
    private class GetClusterMigration
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;

        private GetClusterMigration() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdClusters.this.getAdmin().clusters().getClusterMigration(this.cluster));
        }
    }

    @CommandLine.Command(description={"Update cluster migration"})
    private class UpdateClusterMigration
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"--migrated"}, description={"Is cluster migrated"})
        private boolean migrated;
        @CommandLine.Option(names={"--service-url"}, description={"New migrated cluster service url"})
        private String serviceUrl;
        @CommandLine.Option(names={"--service-url-secure"}, description={"New migrated cluster service url secure"})
        private String serviceUrlTls;
        @CommandLine.Option(names={"--broker-url"}, description={"New migrated cluster broker service url"})
        private String brokerServiceUrl;
        @CommandLine.Option(names={"--broker-url-secure"}, description={"New migrated cluster broker service url secure"})
        private String brokerServiceUrlTls;

        private UpdateClusterMigration() {
        }

        @Override
        void run() throws PulsarAdminException {
            ClusterPolicies.ClusterUrl clusterUrl = new ClusterPolicies.ClusterUrl(this.serviceUrl, this.serviceUrlTls, this.brokerServiceUrl, this.brokerServiceUrlTls);
            CmdClusters.this.getAdmin().clusters().updateClusterMigration(this.cluster, this.migrated, clusterUrl);
        }
    }

    @CommandLine.Command(description={"Get list of peer-clusters"})
    private class GetPeerClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;

        private GetPeerClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdClusters.this.getAdmin().clusters().getPeerClusterNames(this.cluster));
        }
    }

    @CommandLine.Command(description={"Get the configuration brokers of a failure-domain"})
    private class GetFailureDomain
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"--domain-name"}, description={"domain-name"}, required=true)
        private String domainName;

        private GetFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdClusters.this.getAdmin().clusters().getFailureDomain(this.cluster, this.domainName));
        }
    }

    @CommandLine.Command(description={"Create a new failure-domain for a cluster. updates it if already created."})
    private class CreateFailureDomain
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"--domain-name"}, description={"domain-name"}, required=true)
        private String domainName;
        @CommandLine.Option(names={"--broker-list"}, description={"Comma separated broker list"}, required=false)
        private String brokerList;

        private CreateFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            FailureDomainImpl domain = FailureDomainImpl.builder().brokers(StringUtils.isNotBlank((CharSequence)this.brokerList) ? Sets.newHashSet((Object[])this.brokerList.split(",")) : null).build();
            CmdClusters.this.getAdmin().clusters().createFailureDomain(this.cluster, this.domainName, (FailureDomain)domain);
        }
    }

    @CommandLine.Command(description={"Update failure-domain for a cluster. Creates a new one if not exist."})
    private class UpdateFailureDomain
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"--domain-name"}, description={"domain-name"}, required=true)
        private String domainName;
        @CommandLine.Option(names={"--broker-list"}, description={"Comma separated broker list"}, required=false)
        private String brokerList;

        private UpdateFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            FailureDomainImpl domain = FailureDomainImpl.builder().brokers(StringUtils.isNotBlank((CharSequence)this.brokerList) ? Sets.newHashSet((Object[])this.brokerList.split(",")) : null).build();
            CmdClusters.this.getAdmin().clusters().updateFailureDomain(this.cluster, this.domainName, (FailureDomain)domain);
        }
    }

    @CommandLine.Command(description={"Deletes an existing failure-domain"})
    private class DeleteFailureDomain
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;
        @CommandLine.Option(names={"--domain-name"}, description={"domain-name"}, required=true)
        private String domainName;

        private DeleteFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            CmdClusters.this.getAdmin().clusters().deleteFailureDomain(this.cluster, this.domainName);
        }
    }

    @CommandLine.Command(description={"List the existing failure-domains for a cluster"})
    private class ListFailureDomains
    extends CliCommand {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        private String cluster;

        private ListFailureDomains() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdClusters.this.getAdmin().clusters().getFailureDomains(this.cluster));
        }
    }

    private static class ClusterDetails {
        @CommandLine.Parameters(description={"cluster-name"}, arity="1")
        protected String clusterName;
        @CommandLine.Option(names={"--url"}, description={"service-url"}, required=false)
        protected String serviceUrl;
        @CommandLine.Option(names={"--url-secure"}, description={"service-url for secure connection"}, required=false)
        protected String serviceUrlTls;
        @CommandLine.Option(names={"--broker-url"}, description={"broker-service-url"}, required=false)
        protected String brokerServiceUrl;
        @CommandLine.Option(names={"--broker-url-secure"}, description={"broker-service-url for secure connection"}, required=false)
        protected String brokerServiceUrlTls;
        @CommandLine.Option(names={"--proxy-url"}, description={"Proxy-service url when client would like to connect to broker via proxy."})
        protected String proxyServiceUrl;
        @CommandLine.Option(names={"--auth-plugin"}, description={"authentication plugin"}, required=false)
        protected String authenticationPlugin;
        @CommandLine.Option(names={"--auth-parameters"}, description={"authentication parameters"}, required=false)
        protected String authenticationParameters;
        @CommandLine.Option(names={"--proxy-protocol"}, description={"protocol to decide type of proxy routing eg: SNI"}, required=false)
        protected ProxyProtocol proxyProtocol;
        @CommandLine.Option(names={"--tls-enable"}, description={"Enable tls connection"}, required=false)
        protected Boolean brokerClientTlsEnabled;
        @CommandLine.Option(names={"--tls-allow-insecure"}, description={"Allow insecure tls connection"}, required=false)
        protected Boolean tlsAllowInsecureConnection;
        @CommandLine.Option(names={"--tls-enable-keystore"}, description={"Whether use KeyStore type to authenticate"}, required=false)
        protected Boolean brokerClientTlsEnabledWithKeyStore;
        @CommandLine.Option(names={"--tls-trust-store-type"}, description={"TLS TrustStore type configuration for internal client eg: JKS"}, required=false)
        protected String brokerClientTlsTrustStoreType;
        @CommandLine.Option(names={"--tls-trust-store"}, description={"TLS TrustStore path for internal client"}, required=false)
        protected String brokerClientTlsTrustStore;
        @CommandLine.Option(names={"--tls-trust-store-pwd"}, description={"TLS TrustStore password for internal client"}, required=false)
        protected String brokerClientTlsTrustStorePassword;
        @CommandLine.Option(names={"--tls-key-store-type"}, description={"TLS TrustStore type configuration for internal client eg: JKS"}, required=false)
        protected String brokerClientTlsKeyStoreType;
        @CommandLine.Option(names={"--tls-key-store"}, description={"TLS KeyStore path for internal client"}, required=false)
        protected String brokerClientTlsKeyStore;
        @CommandLine.Option(names={"--tls-key-store-pwd"}, description={"TLS KeyStore password for internal client"}, required=false)
        protected String brokerClientTlsKeyStorePassword;
        @CommandLine.Option(names={"--tls-trust-certs-filepath"}, description={"path for the trusted TLS certificate file"}, required=false)
        protected String brokerClientTrustCertsFilePath;
        @CommandLine.Option(names={"--tls-key-filepath"}, description={"path for the TLS private key file"}, required=false)
        protected String brokerClientKeyFilePath;
        @CommandLine.Option(names={"--tls-certs-filepath"}, description={"path for the TLS certificate file"}, required=false)
        protected String brokerClientCertificateFilePath;
        @CommandLine.Option(names={"--listener-name"}, description={"listenerName when client would like to connect to cluster"}, required=false)
        protected String listenerName;
        @CommandLine.Option(names={"--cluster-config-file"}, description={"The path to a YAML config file specifying the cluster's configuration"})
        protected String clusterConfigFile;

        private ClusterDetails() {
        }

        protected ClusterData getClusterData() throws IOException {
            ClusterData.Builder builder = null != this.clusterConfigFile ? (ClusterData.Builder)CmdUtils.loadConfig(this.clusterConfigFile, ClusterDataImpl.ClusterDataImplBuilder.class) : ClusterData.builder();
            if (this.serviceUrl != null) {
                builder.serviceUrl(this.serviceUrl);
            }
            if (this.serviceUrlTls != null) {
                builder.serviceUrlTls(this.serviceUrlTls);
            }
            if (this.brokerServiceUrl != null) {
                builder.brokerServiceUrl(this.brokerServiceUrl);
            }
            if (this.brokerServiceUrlTls != null) {
                builder.brokerServiceUrlTls(this.brokerServiceUrlTls);
            }
            if (this.proxyServiceUrl != null) {
                builder.proxyServiceUrl(this.proxyServiceUrl);
            }
            if (this.authenticationPlugin != null) {
                builder.authenticationPlugin(this.authenticationPlugin);
            }
            if (this.authenticationParameters != null) {
                builder.authenticationParameters(this.authenticationParameters);
            }
            if (this.proxyProtocol != null) {
                builder.proxyProtocol(this.proxyProtocol);
            }
            if (this.brokerClientTlsEnabled != null) {
                builder.brokerClientTlsEnabled(this.brokerClientTlsEnabled.booleanValue());
            }
            if (this.tlsAllowInsecureConnection != null) {
                builder.tlsAllowInsecureConnection(this.tlsAllowInsecureConnection.booleanValue());
            }
            if (this.brokerClientTlsEnabledWithKeyStore != null) {
                builder.brokerClientTlsEnabledWithKeyStore(this.brokerClientTlsEnabledWithKeyStore.booleanValue());
            }
            if (this.brokerClientTlsTrustStoreType != null) {
                builder.brokerClientTlsTrustStoreType(this.brokerClientTlsTrustStoreType);
            }
            if (this.brokerClientTlsTrustStore != null) {
                builder.brokerClientTlsTrustStore(this.brokerClientTlsTrustStore);
            }
            if (this.brokerClientTlsTrustStorePassword != null) {
                builder.brokerClientTlsTrustStorePassword(this.brokerClientTlsTrustStorePassword);
            }
            if (this.brokerClientTlsKeyStoreType != null) {
                builder.brokerClientTlsKeyStoreType(this.brokerClientTlsKeyStoreType);
            }
            if (this.brokerClientTlsKeyStore != null) {
                builder.brokerClientTlsKeyStore(this.brokerClientTlsKeyStore);
            }
            if (this.brokerClientTlsKeyStorePassword != null) {
                builder.brokerClientTlsKeyStorePassword(this.brokerClientTlsKeyStorePassword);
            }
            if (this.brokerClientTrustCertsFilePath != null) {
                builder.brokerClientTrustCertsFilePath(this.brokerClientTrustCertsFilePath);
            }
            if (this.brokerClientKeyFilePath != null) {
                builder.brokerClientKeyFilePath(this.brokerClientKeyFilePath);
            }
            if (this.brokerClientCertificateFilePath != null) {
                builder.brokerClientCertificateFilePath(this.brokerClientCertificateFilePath);
            }
            if (this.listenerName != null) {
                builder.listenerName(this.listenerName);
            }
            ClusterData clusterData = builder.build();
            CmdClusters.validateClusterData(clusterData);
            return clusterData;
        }
    }
}

