/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.topics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;

public final class TopicList {
    public static final String ALL_TOPICS_PATTERN = ".*";
    private static final String SCHEME_SEPARATOR = "://";
    private static final Pattern SCHEME_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("://"));

    public static List<String> filterTopics(List<String> original, String regex) {
        Pattern topicsPattern = Pattern.compile(regex);
        return TopicList.filterTopics(original, topicsPattern);
    }

    public static List<String> filterTopics(List<String> original, Pattern topicsPattern) {
        Pattern shortenedTopicsPattern = Pattern.compile(TopicList.removeTopicDomainScheme(topicsPattern.toString()));
        return original.stream().map(TopicName::get).filter(topicName -> {
            String partitionedTopicName = topicName.getPartitionedTopicName();
            String removedScheme = SCHEME_SEPARATOR_PATTERN.split(partitionedTopicName)[1];
            return shortenedTopicsPattern.matcher(removedScheme).matches();
        }).map(TopicName::toString).collect(Collectors.toList());
    }

    public static List<String> filterSystemTopic(List<String> original) {
        return original.stream().filter(topic -> !SystemTopicNames.isSystemTopic(TopicName.get(topic))).collect(Collectors.toList());
    }

    public static String calculateHash(List<String> topics) {
        return Hashing.crc32c().hashBytes(topics.stream().sorted().collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8)).toString();
    }

    public static Set<String> minus(Collection<String> list1, Collection<String> list2) {
        HashSet<String> s1 = new HashSet<String>(list1);
        s1.removeAll(list2);
        return s1;
    }

    @VisibleForTesting
    static String removeTopicDomainScheme(String originalRegexp) {
        if (!originalRegexp.toString().contains(SCHEME_SEPARATOR)) {
            return originalRegexp;
        }
        String[] parts = SCHEME_SEPARATOR_PATTERN.split(originalRegexp.toString());
        String prefix = parts[0];
        String removedTopicDomain = parts[1];
        if (prefix.equals(TopicDomain.persistent.value()) || prefix.equals(TopicDomain.non_persistent.value())) {
            prefix = "";
        } else if (prefix.endsWith(TopicDomain.non_persistent.value())) {
            prefix = prefix.substring(0, prefix.length() - TopicDomain.non_persistent.value().length());
        } else if (prefix.endsWith(TopicDomain.persistent.value())) {
            prefix = prefix.substring(0, prefix.length() - TopicDomain.persistent.value().length());
        } else {
            throw new IllegalArgumentException("Does not support topic domain: " + prefix);
        }
        return String.format("%s%s", prefix, removedTopicDomain);
    }

    @Generated
    private TopicList() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

