/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.pulsar.internal.CommanderFactory;
import org.apache.pulsar.internal.ShellCommandsProvider;
import org.apache.pulsar.shell.AdminShell;
import org.apache.pulsar.shell.ClientShell;
import org.apache.pulsar.shell.ConfigShell;
import org.apache.pulsar.shell.config.ConfigStore;
import org.apache.pulsar.shell.config.FileConfigStore;
import org.jline.console.CommandRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

@CommandLine.Command
public class PulsarShell {
    private static final String EXIT_MESSAGE = "Goodbye!";
    private static final String PROPERTY_PULSAR_SHELL_DIR = "shellHistoryDirectory";
    private static final String PROPERTY_PERSIST_HISTORY_ENABLED = "shellHistoryPersistEnabled";
    private static final String CHECKMARK = new String(Character.toChars(10004));
    private static final String XMARK = new String(Character.toChars(10006));
    private static final AttributedStyle LOG_STYLE = AttributedStyle.DEFAULT.foreground(25, 143, 255).background(230, 241, 255);
    private static final Substitutor[] SUBSTITUTORS = new Substitutor[]{(str, vars) -> new StringSubstitutor(vars, "${", "}", '\\').replace(str), (str, vars) -> {
        if (str.startsWith("\\$")) {
            return str.substring(1);
        }
        if (str.startsWith("$")) {
            String key = str.substring(1);
            if (!vars.containsKey(key)) {
                return str;
            }
            return (String)vars.get(key);
        }
        return str;
    }};
    private static final String DEFAULT_PULSAR_SHELL_ROOT_DIRECTORY = PulsarShell.computeDefaultPulsarShellRootDirectory();
    private SystemRegistryImpl systemRegistry;
    private final DefaultParser parser = new DefaultParser().eofOnUnclosedQuote(true);
    private Terminal terminal;
    private Properties properties;
    private final ConfigStore configStore;
    private final File pulsarShellDir;
    private final CommandLine mainCommander;
    @CommandLine.ArgGroup(exclusive=false)
    private final MainOptions mainOptions = new MainOptions();
    private CommandLine shellCommander;
    private Function<Map<String, ShellCommandsProvider>, InteractiveLineReader> readerBuilder;
    private InteractiveLineReader reader;
    private final ConfigShell configShell;
    private ExecState execState = ExecState.IDLE;

    public PulsarShell(String[] args) throws IOException {
        this(args, new Properties());
    }

    public PulsarShell(String[] args, Properties props) throws IOException {
        this.properties = props;
        this.mainCommander = new CommandLine((Object)this);
        this.mainCommander.setCommandName("pulsar-shell");
        try {
            this.mainCommander.parseArgs(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.mainCommander.usage(System.out);
            this.exit(1);
            throw new IllegalArgumentException(e);
        }
        this.pulsarShellDir = PulsarShell.computePulsarShellFile();
        Files.createDirectories(this.pulsarShellDir.toPath(), new FileAttribute[0]);
        System.out.println(String.format("Using directory: %s", this.pulsarShellDir.getAbsolutePath()));
        ConfigStore.ConfigEntry defaultConfig = null;
        String configFile = this.mainOptions.configFile != null ? this.mainOptions.configFile : System.getProperty("pulsar.shell.config.default");
        if (configFile != null) {
            String defaultConfigValue = new String(Files.readAllBytes(new File(configFile).toPath()), StandardCharsets.UTF_8);
            defaultConfig = new ConfigStore.ConfigEntry("default", defaultConfigValue);
        }
        this.configStore = new FileConfigStore(Paths.get(this.pulsarShellDir.getAbsolutePath(), "configs.json").toFile(), defaultConfig);
        ConfigStore.ConfigEntry lastUsed = this.configStore.getLastUsed();
        String configName = "default";
        if (lastUsed != null) {
            this.properties.load(new StringReader(lastUsed.getValue()));
            configName = lastUsed.getName();
        } else if (defaultConfig != null) {
            this.properties.load(new StringReader(defaultConfig.getValue()));
        }
        this.configShell = new ConfigShell(this, configName);
    }

    private static File computePulsarShellFile() {
        String dir = System.getProperty(PROPERTY_PULSAR_SHELL_DIR, null);
        if (dir == null) {
            return Paths.get(DEFAULT_PULSAR_SHELL_ROOT_DIRECTORY, ".pulsar-shell").toFile();
        }
        return new File(dir);
    }

    private static String computeDefaultPulsarShellRootDirectory() {
        String userHome = System.getProperty("user.home");
        if (!StringUtils.isBlank((CharSequence)userHome) && !"?".equals(userHome)) {
            return userHome;
        }
        return System.getProperty("user.dir");
    }

    public static void main(String[] args) throws Exception {
        new PulsarShell(args).run();
    }

    public void reload(Properties properties) throws Exception {
        this.properties = properties;
        Map<String, ShellCommandsProvider> providersMap = this.registerProviders(properties);
        this.reader = this.readerBuilder.apply(providersMap);
    }

    public void run() throws Exception {
        Terminal terminal = TerminalBuilder.builder().nativeSignals(true).signalHandler(signal -> {
            if (signal == Terminal.Signal.INT || signal == Terminal.Signal.QUIT) {
                if (this.execState == ExecState.RUNNING) {
                    throw new InterruptShellException();
                }
                this.exit(0);
            }
        }).build();
        this.run(providersMap -> {
            String serviceUrl = "";
            String adminUrl = "";
            for (ShellCommandsProvider provider : providersMap.values()) {
                String providerAdminUrl;
                String providerServiceUrl = provider.getServiceUrl();
                if (providerServiceUrl != null) {
                    serviceUrl = providerServiceUrl;
                }
                if ((providerAdminUrl = provider.getAdminUrl()) == null) continue;
                adminUrl = providerAdminUrl;
            }
            LineReaderBuilder readerBuilder = LineReaderBuilder.builder().terminal(terminal).parser((Parser)this.parser).completer(this.systemRegistry.completer()).variable("indentation", (Object)2).option(LineReader.Option.INSERT_BRACKET, true);
            this.configureHistory(this.properties, readerBuilder);
            final LineReader reader = readerBuilder.build();
            String welcomeMessage = String.format("Welcome to Pulsar shell!\n  %s: %s\n  %s: %s\n\nType %s to get started or try the autocompletion (TAB button).\nType %s or %s to end the shell session.\n", new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"Service URL").toAnsi(), serviceUrl, new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"Admin URL").toAnsi(), adminUrl, new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"help").toAnsi(), new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"exit").toAnsi(), new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"quit").toAnsi());
            PulsarShell.output(welcomeMessage, terminal);
            String promptMessage = this.configShell.getCurrentConfig() != null ? String.format("%s(%s)", this.configShell.getCurrentConfig(), PulsarShell.getHostFromUrl(serviceUrl)) : PulsarShell.getHostFromUrl(serviceUrl);
            final String prompt = PulsarShell.createPrompt(promptMessage);
            return new InteractiveLineReader(){

                @Override
                public String readLine() {
                    return reader.readLine(prompt);
                }

                @Override
                public List<String> parseLine(String line) {
                    return reader.getParser().parse(line, 0).words();
                }
            };
        }, () -> terminal);
    }

    private void configureHistory(Properties properties, LineReaderBuilder readerBuilder) {
        boolean isPersistHistoryEnabled = Boolean.parseBoolean(properties.getProperty(PROPERTY_PERSIST_HISTORY_ENABLED, "true"));
        if (isPersistHistoryEnabled) {
            String historyPath = Paths.get(this.pulsarShellDir.getAbsolutePath(), "history").toFile().getAbsolutePath();
            readerBuilder.variable("history-file", (Object)historyPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(Function<Map<String, ShellCommandsProvider>, InteractiveLineReader> readerBuilder, Supplier<Terminal> terminalBuilder) throws Exception {
        this.readerBuilder = readerBuilder;
        this.terminal = terminalBuilder.get();
        providersMap = this.registerProviders(this.properties);
        this.reader = readerBuilder.apply(providersMap);
        variables = System.getenv();
        commandsInfo = null;
        isNonInteractiveMode = this.isNonInteractiveMode();
        if (isNonInteractiveMode) {
            if (this.mainOptions.filename != null) {
                lines = Files.readAllLines(Paths.get(this.mainOptions.filename, new String[0])).stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, filterLine(java.lang.String ), (Ljava/lang/String;)Z)()).collect(Collectors.toList());
            } else {
                if (this.mainOptions.readFromStdin) {
                    stdinReader = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        lines = stdinReader.lines().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, filterLine(java.lang.String ), (Ljava/lang/String;)Z)()).collect(Collectors.toList());
                    }
                    finally {
                        stdinReader.close();
                    }
                }
                lines = new ArrayList<E>();
                scanner = new Scanner(this.mainOptions.inlineCommand);
                try {
                    while (scanner.hasNextLine()) {
                        line = scanner.nextLine().trim();
                        lines.add(line);
                    }
                }
                finally {
                    scanner.close();
                }
            }
            if (!this.mainOptions.noProgress) {
                commandsInfo = new CommandsInfo();
                commandsInfo.totalCommands = lines.size();
            }
            finalCommandsInfo = commandsInfo;
            commandReader = new CommandReader(){
                private int index = 0;

                @Override
                public List<String> readCommand() {
                    if (this.index == lines.size()) {
                        throw new InterruptShellException();
                    }
                    String command = ((String)lines.get(this.index++)).trim();
                    List<String> words = PulsarShell.substituteVariables(PulsarShell.this.reader.parseLine(command), (Map<String, String>)variables);
                    command = words.stream().collect(Collectors.joining(" "));
                    if (finalCommandsInfo != null) {
                        finalCommandsInfo.executingCommand = command;
                    } else {
                        PulsarShell.output(String.format("[%d/%d] Executing %s", this.index, lines.size(), command), PulsarShell.this.terminal);
                    }
                    return words;
                }
            };
        } else {
            commandReader = (CommandReader)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/List;, lambda$run$5(java.util.Map ), ()Ljava/util/List;)((PulsarShell)this, variables);
        }
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$6(), ()V)((PulsarShell)this)));
        while (true) {
            this.execState = ExecState.IDLE;
            try {
                words = commandReader.readCommand();
            }
            catch (InterruptShellException interruptShellException) {
                this.exit(0);
                return;
            }
            this.execState = ExecState.RUNNING;
            line = words.stream().collect(Collectors.joining(" "));
            if (StringUtils.isBlank((CharSequence)line)) continue;
            if (PulsarShell.isQuitCommand(line)) {
                this.exit(0);
                return;
            }
            if (PulsarShell.isHelp(line)) {
                this.shellCommander.usage(System.out);
                continue;
            }
            pulsarShellCommandsProvider = PulsarShell.getProviderFromArgs(this.shellCommander, words);
            if (pulsarShellCommandsProvider == null) {
                this.shellCommander.usage(System.out);
                continue;
            }
            commandOk = false;
            try {
                this.printExecutingCommands(this.terminal, commandsInfo, false);
                this.systemRegistry.execute(line);
            }
            catch (InterruptShellException willExitWithError) {
                v1 = willExitWithError = this.mainOptions.failOnError != false && commandOk == false;
                if (commandsInfo != null && !willExitWithError) {
                    commandsInfo.executingCommand = null;
                    commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                    this.printExecutingCommands(this.terminal, commandsInfo, true);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(this.terminal.writer());
                v2 = willExitWithError = this.mainOptions.failOnError != false && commandOk == false;
                {
                    catch (Throwable var13_20) {
                        v3 = willExitWithError = this.mainOptions.failOnError != false && commandOk == false;
                        if (commandsInfo != null && !willExitWithError) {
                            commandsInfo.executingCommand = null;
                            commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                            this.printExecutingCommands(this.terminal, commandsInfo, true);
                        }
                        throw var13_20;
                    }
                }
                if (commandsInfo != null && !willExitWithError) {
                    commandsInfo.executingCommand = null;
                    commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                    this.printExecutingCommands(this.terminal, commandsInfo, true);
                } else {
                    ** GOTO lbl100
                }
            }
            v0 = willExitWithError = this.mainOptions.failOnError != false && commandOk == false;
            if (commandsInfo != null && !willExitWithError) {
                commandsInfo.executingCommand = null;
                commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                this.printExecutingCommands(this.terminal, commandsInfo, true);
            }
            if (this.mainOptions.failOnError && !commandOk) break;
        }
        this.exit(1);
    }

    private boolean isNonInteractiveMode() {
        boolean commandOk = true;
        if (this.mainOptions.inlineCommand != null) {
            if (this.mainOptions.readFromStdin || this.mainOptions.filename != null) {
                commandOk = false;
            }
        } else if (this.mainOptions.readFromStdin && this.mainOptions.filename != null) {
            commandOk = false;
        }
        if (!commandOk) {
            throw new IllegalArgumentException("Cannot use stdin, -e/--execute-command and -f/--filename option at the same time");
        }
        return this.mainOptions.filename != null || this.mainOptions.readFromStdin || this.mainOptions.inlineCommand != null;
    }

    private void printExecutingCommands(Terminal terminal, CommandsInfo commandsInfo, boolean printExecuted) {
        if (commandsInfo == null) {
            return;
        }
        terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        terminal.flush();
        int index = 1;
        if (printExecuted) {
            for (CommandsInfo.ExecutedCommandInfo executedCommand : commandsInfo.executedCommands) {
                String icon = executedCommand.ok ? CHECKMARK : XMARK;
                String ansiLog = new AttributedStringBuilder().style(LOG_STYLE).append((CharSequence)String.format("[%d/%d] %s %s", index++, commandsInfo.totalCommands, icon, executedCommand.command)).toAnsi();
                PulsarShell.output(ansiLog, terminal);
            }
        } else {
            index = commandsInfo.executedCommands.size() + 1;
        }
        if (commandsInfo.executingCommand != null) {
            String ansiLog = new AttributedStringBuilder().style(LOG_STYLE).append((CharSequence)String.format("[%d/%d] Executing %s", index, commandsInfo.totalCommands, commandsInfo.executingCommand)).toAnsi();
            PulsarShell.output(ansiLog, terminal);
        }
    }

    private static ShellCommandsProvider getProviderFromArgs(CommandLine mainCommander, List<String> words) {
        String providerCmd = words.get(0);
        CommandLine commander = (CommandLine)mainCommander.getSubcommands().get(providerCmd);
        if (commander == null) {
            return null;
        }
        return (ShellCommandsProvider)commander.getCommand();
    }

    private static String createPrompt(String hostname) {
        String string = (hostname == null ? "pulsar" : hostname) + ">";
        return new AttributedStringBuilder().style(LOG_STYLE).append((CharSequence)string).style(AttributedStyle.DEFAULT).append((CharSequence)" ").toAnsi();
    }

    static List<String> substituteVariables(List<String> line, Map<String, String> vars) {
        return line.stream().map(s -> PulsarShell.substituteVariables(s, vars)).collect(Collectors.toList());
    }

    private static String substituteVariables(String string, Map<String, String> vars) {
        for (Substitutor stringSubstitutor : SUBSTITUTORS) {
            string = stringSubstitutor.replace(string, vars);
        }
        return string;
    }

    private static void quit(Terminal terminal) {
        PulsarShell.output(EXIT_MESSAGE, terminal);
    }

    private static void output(String message, Terminal terminal) {
        terminal.writer().println(message);
        terminal.writer().flush();
    }

    private static boolean isQuitCommand(String line) {
        return line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit");
    }

    private static boolean isHelp(String line) {
        return line.equalsIgnoreCase("help");
    }

    private Map<String, ShellCommandsProvider> registerProviders(Properties properties) throws Exception {
        this.shellCommander = CommanderFactory.createRootCommanderWithHook(this, null);
        HashMap<String, ShellCommandsProvider> providerMap = new HashMap<String, ShellCommandsProvider>();
        PulsarShell.registerProvider(this.createAdminShell(properties), this.shellCommander, providerMap);
        PulsarShell.registerProvider(this.createClientShell(properties), this.shellCommander, providerMap);
        PulsarShell.registerProvider(this.configShell, this.shellCommander, providerMap);
        Supplier<Path> workDir = () -> Paths.get(DEFAULT_PULSAR_SHELL_ROOT_DIRECTORY, new String[0]);
        PicocliCommands picocliCommands = new PicocliCommands(this.shellCommander);
        this.systemRegistry = new SystemRegistryImpl((Parser)this.parser, this.terminal, workDir, null);
        this.systemRegistry.setCommandRegistries(new CommandRegistry[]{picocliCommands});
        this.systemRegistry.register("help", (CommandRegistry)picocliCommands);
        return providerMap;
    }

    protected AdminShell createAdminShell(Properties properties) throws Exception {
        return new AdminShell(properties);
    }

    protected ClientShell createClientShell(Properties properties) {
        return new ClientShell(properties);
    }

    private static void registerProvider(ShellCommandsProvider provider, CommandLine commander, Map<String, ShellCommandsProvider> providerMap) {
        String name = provider.getName();
        commander.addSubcommand(name, (Object)provider.getCommander());
        providerMap.put(name, provider);
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    private static boolean filterLine(String line) {
        return !StringUtils.isBlank((CharSequence)line) && !line.startsWith("#");
    }

    private static String getHostFromUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URI.create(url).getHost();
        }
        catch (IllegalArgumentException iea) {
            return null;
        }
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    private /* synthetic */ void lambda$run$6() {
        PulsarShell.quit(this.terminal);
    }

    private /* synthetic */ List lambda$run$5(Map variables) throws InterruptShellException {
        try {
            String line = this.reader.readLine().trim();
            return PulsarShell.substituteVariables(this.reader.parseLine(line), (Map<String, String>)variables);
        }
        catch (EndOfFileException | UserInterruptException userInterruptException) {
            throw new InterruptShellException();
        }
    }

    static final class MainOptions {
        @CommandLine.Option(names={"-c", "--config"}, description={"Client configuration file."})
        String configFile;
        @CommandLine.Option(names={"-f", "--filename"}, description={"Input filename with a list of commands to be executed. Each command must be separated by a newline."})
        String filename;
        @CommandLine.Option(names={"--fail-on-error"}, description={"If true, the shell will be interrupted if a command throws an exception."})
        boolean failOnError;
        @CommandLine.Option(names={"-"}, description={"Read commands from the standard input."})
        boolean readFromStdin;
        @CommandLine.Option(names={"-e", "--execute-command"}, description={"Execute this command and exit."})
        String inlineCommand;
        @CommandLine.Option(names={"-np", "--no-progress"}, description={"Display raw output of the commands without the fancy progress visualization."})
        boolean noProgress;

        MainOptions() {
        }
    }

    static enum ExecState {
        IDLE,
        RUNNING;

    }

    static interface InteractiveLineReader {
        public String readLine();

        public List<String> parseLine(String var1);
    }

    private static class CommandsInfo {
        int totalCommands;
        List<ExecutedCommandInfo> executedCommands = new ArrayList<ExecutedCommandInfo>();
        String executingCommand;

        private CommandsInfo() {
        }

        static class ExecutedCommandInfo {
            String command;
            boolean ok;

            public ExecutedCommandInfo(String command, boolean ok) {
                this.command = command;
                this.ok = ok;
            }
        }
    }

    private static interface CommandReader {
        public List<String> readCommand() throws InterruptShellException;
    }

    private static class InterruptShellException
    extends RuntimeException {
        private InterruptShellException() {
        }
    }

    static interface Substitutor {
        public String replace(String var1, Map<String, String> var2);
    }
}

