/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.functions.WindowConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Interface for managing Pulsar Functions (lightweight, Lambda-style compute processes that work with Pulsar)"})
public class CmdFunctions
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdFunctions.class);
    private final LocalRunner localRunner = new LocalRunner();
    private final CreateFunction creater = new CreateFunction();
    private final DeleteFunction deleter = new DeleteFunction();
    private final UpdateFunction updater = new UpdateFunction();
    private final GetFunction getter = new GetFunction();
    private final GetFunctionStatus functionStatus = new GetFunctionStatus();
    private final GetFunctionStats functionStats = new GetFunctionStats();
    private final RestartFunction restart;
    private final StopFunction stop;
    private final StartFunction start;
    private final ListFunctions lister = new ListFunctions();
    private final StateGetter stateGetter = new StateGetter();
    private final StatePutter statePutter = new StatePutter();
    private final TriggerFunction triggerer = new TriggerFunction();
    private final UploadFunction uploader = new UploadFunction();
    private final DownloadFunction downloader = new DownloadFunction();

    public CmdFunctions(Supplier<PulsarAdmin> admin) throws PulsarClientException {
        super("functions", admin);
        this.restart = new RestartFunction();
        this.stop = new StopFunction();
        this.start = new StartFunction();
        this.addCommand("localrun", this.getLocalRunner());
        this.addCommand("create", this.getCreater());
        this.addCommand("delete", this.getDeleter());
        this.addCommand("update", this.getUpdater());
        this.addCommand("get", this.getGetter());
        this.addCommand("restart", this.getRestarter());
        this.addCommand("stop", this.getStopper());
        this.addCommand("start", this.getStarter());
        this.addCommand("status", this.getStatuser(), "getstatus");
        this.addCommand("stats", this.getFunctionStats());
        this.addCommand("list", this.getLister());
        this.addCommand("querystate", this.getStateGetter());
        this.addCommand("putstate", this.getStatePutter());
        this.addCommand("trigger", this.getTriggerer());
        this.addCommand("upload", this.getUploader());
        this.addCommand("download", this.getDownloader());
        this.addCommand("reload", new ReloadBuiltInFunctions());
        this.addCommand("available-functions", new ListBuiltInFunctions());
    }

    @VisibleForTesting
    LocalRunner getLocalRunner() {
        return this.localRunner;
    }

    @VisibleForTesting
    CreateFunction getCreater() {
        return this.creater;
    }

    @VisibleForTesting
    DeleteFunction getDeleter() {
        return this.deleter;
    }

    @VisibleForTesting
    UpdateFunction getUpdater() {
        return this.updater;
    }

    @VisibleForTesting
    GetFunction getGetter() {
        return this.getter;
    }

    @VisibleForTesting
    GetFunctionStatus getStatuser() {
        return this.functionStatus;
    }

    @VisibleForTesting
    ListFunctions getLister() {
        return this.lister;
    }

    @VisibleForTesting
    StatePutter getStatePutter() {
        return this.statePutter;
    }

    @VisibleForTesting
    StateGetter getStateGetter() {
        return this.stateGetter;
    }

    @VisibleForTesting
    TriggerFunction getTriggerer() {
        return this.triggerer;
    }

    @VisibleForTesting
    UploadFunction getUploader() {
        return this.uploader;
    }

    @VisibleForTesting
    DownloadFunction getDownloader() {
        return this.downloader;
    }

    @VisibleForTesting
    RestartFunction getRestarter() {
        return this.restart;
    }

    @VisibleForTesting
    StopFunction getStopper() {
        return this.stop;
    }

    @VisibleForTesting
    StartFunction getStarter() {
        return this.start;
    }

    public GetFunctionStats getFunctionStats() {
        return this.functionStats;
    }

    @CommandLine.Command(description={"Run a Pulsar Function locally, rather than deploy to a Pulsar cluster)"})
    class LocalRunner
    extends FunctionDetailsCommand {
        @CommandLine.Option(names={"--stateStorageServiceUrl"}, description={"The URL for the state storage service (the default is Apache BookKeeper)"}, hidden=true)
        protected String deprecatedStateStorageServiceUrl;
        @CommandLine.Option(names={"--state-storage-service-url"}, description={"The URL for the state storage service (the default is Apache BookKeeper) #Java, Python"})
        protected String stateStorageServiceUrl;
        @CommandLine.Option(names={"--brokerServiceUrl"}, description={"The URL for Pulsar broker"}, hidden=true)
        protected String deprecatedBrokerServiceUrl;
        @CommandLine.Option(names={"--broker-service-url"}, description={"The URL for Pulsar broker #Java, Python, Go"})
        protected String brokerServiceUrl;
        @CommandLine.Option(names={"--web-service-url"}, description={"The URL for Pulsar web service #Java, Python"})
        protected String webServiceUrl;
        @CommandLine.Option(names={"--clientAuthPlugin"}, description={"Client authentication plugin using which function-process can connect to broker"}, hidden=true)
        protected String deprecatedClientAuthPlugin;
        @CommandLine.Option(names={"--client-auth-plugin"}, description={"Client authentication plugin using which function-process can connect to broker #Java, Python"})
        protected String clientAuthPlugin;
        @CommandLine.Option(names={"--clientAuthParams"}, description={"Client authentication param"}, hidden=true)
        protected String deprecatedClientAuthParams;
        @CommandLine.Option(names={"--client-auth-params"}, description={"Client authentication param #Java, Python"})
        protected String clientAuthParams;
        @CommandLine.Option(names={"--use_tls"}, description={"Use tls connection"}, hidden=true)
        protected Boolean deprecatedUseTls;
        @CommandLine.Option(names={"--use-tls"}, description={"Use tls connection #Java, Python"})
        protected boolean useTls;
        @CommandLine.Option(names={"--tls_allow_insecure"}, description={"Allow insecure tls connection"}, hidden=true)
        protected Boolean deprecatedTlsAllowInsecureConnection;
        @CommandLine.Option(names={"--tls-allow-insecure"}, description={"Allow insecure tls connection #Java, Python"})
        protected boolean tlsAllowInsecureConnection;
        @CommandLine.Option(names={"--hostname_verification_enabled"}, description={"Enable hostname verification"}, hidden=true)
        protected Boolean deprecatedTlsHostNameVerificationEnabled;
        @CommandLine.Option(names={"--hostname-verification-enabled"}, description={"Enable hostname verification #Java, Python"})
        protected boolean tlsHostNameVerificationEnabled;
        @CommandLine.Option(names={"--tls_trust_cert_path"}, description={"tls trust cert file path"}, hidden=true)
        protected String deprecatedTlsTrustCertFilePath;
        @CommandLine.Option(names={"--tls-trust-cert-path"}, description={"tls trust cert file path #Java, Python"})
        protected String tlsTrustCertFilePath;
        @CommandLine.Option(names={"--instanceIdOffset"}, description={"Start the instanceIds from this offset"}, hidden=true)
        protected Integer deprecatedInstanceIdOffset;
        @CommandLine.Option(names={"--instance-id-offset"}, description={"Start the instanceIds from this offset #Java, Python"})
        protected Integer instanceIdOffset;
        @CommandLine.Option(names={"--runtime"}, description={"either THREAD or PROCESS. Only applies for Java functions #Java"})
        protected String runtime;
        @CommandLine.Option(names={"--secrets-provider-classname"}, description={"Whats the classname for secrets provider #Java, Python"})
        protected String secretsProviderClassName;
        @CommandLine.Option(names={"--secrets-provider-config"}, description={"Config that needs to be passed to secrets provider #Java, Python"})
        protected String secretsProviderConfig;
        @CommandLine.Option(names={"--metrics-port-start"}, description={"The starting port range for metrics server #Java, Python, Go"})
        protected String metricsPortStart;

        LocalRunner() {
            this.webServiceUrl = null;
            this.deprecatedUseTls = null;
            this.deprecatedTlsAllowInsecureConnection = null;
            this.deprecatedTlsHostNameVerificationEnabled = null;
            this.deprecatedInstanceIdOffset = null;
            this.instanceIdOffset = 0;
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.stateStorageServiceUrl) && !StringUtils.isBlank((String)this.deprecatedStateStorageServiceUrl)) {
                this.stateStorageServiceUrl = this.deprecatedStateStorageServiceUrl;
            }
            if (StringUtils.isBlank((String)this.brokerServiceUrl) && !StringUtils.isBlank((String)this.deprecatedBrokerServiceUrl)) {
                this.brokerServiceUrl = this.deprecatedBrokerServiceUrl;
            }
            if (StringUtils.isBlank((String)this.clientAuthPlugin) && !StringUtils.isBlank((String)this.deprecatedClientAuthPlugin)) {
                this.clientAuthPlugin = this.deprecatedClientAuthPlugin;
            }
            if (StringUtils.isBlank((String)this.clientAuthParams) && !StringUtils.isBlank((String)this.deprecatedClientAuthParams)) {
                this.clientAuthParams = this.deprecatedClientAuthParams;
            }
            if (!this.useTls && this.deprecatedUseTls != null) {
                this.useTls = this.deprecatedUseTls;
            }
            if (!this.tlsAllowInsecureConnection && this.deprecatedTlsAllowInsecureConnection != null) {
                this.tlsAllowInsecureConnection = this.deprecatedTlsAllowInsecureConnection;
            }
            if (!this.tlsHostNameVerificationEnabled && this.deprecatedTlsHostNameVerificationEnabled != null) {
                this.tlsHostNameVerificationEnabled = this.deprecatedTlsHostNameVerificationEnabled;
            }
            if (StringUtils.isBlank((String)this.tlsTrustCertFilePath) && !StringUtils.isBlank((String)this.deprecatedTlsTrustCertFilePath)) {
                this.tlsTrustCertFilePath = this.deprecatedTlsTrustCertFilePath;
            }
            if (this.instanceIdOffset == null && this.deprecatedInstanceIdOffset != null) {
                this.instanceIdOffset = this.deprecatedInstanceIdOffset;
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            LinkedList<String> localRunArgs = new LinkedList<String>();
            localRunArgs.add(System.getenv("PULSAR_HOME") + "/bin/function-localrunner");
            localRunArgs.add("--functionConfig");
            localRunArgs.add(new Gson().toJson((Object)this.functionConfig));
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (field.getName().toUpperCase().startsWith("DEPRECATED") || field.getName().contains("$") || (value = field.get(this)) == null) continue;
                localRunArgs.add("--" + field.getName());
                localRunArgs.add(value.toString());
            }
            ProcessBuilder processBuilder = new ProcessBuilder(localRunArgs).inheritIO();
            Process process = processBuilder.start();
            process.waitFor();
        }
    }

    @CommandLine.Command(description={"Create a Pulsar Function in cluster mode (deploy it on a Pulsar cluster)"})
    class CreateFunction
    extends FunctionDetailsCommand {
        CreateFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getJar())) {
                CmdFunctions.this.getAdmin().functions().createFunctionWithUrl(this.functionConfig, this.functionConfig.getJar());
            } else if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getPy())) {
                CmdFunctions.this.getAdmin().functions().createFunctionWithUrl(this.functionConfig, this.functionConfig.getPy());
            } else if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getGo())) {
                CmdFunctions.this.getAdmin().functions().createFunctionWithUrl(this.functionConfig, this.functionConfig.getGo());
            } else {
                CmdFunctions.this.getAdmin().functions().createFunction(this.functionConfig, this.userCodeFile);
            }
            this.print("Created successfully");
        }
    }

    @CommandLine.Command(description={"Delete a Pulsar Function that is running on a Pulsar cluster"})
    class DeleteFunction
    extends FunctionCommand {
        DeleteFunction() {
        }

        @Override
        void runCmd() throws Exception {
            CmdFunctions.this.getAdmin().functions().deleteFunction(this.tenant, this.namespace, this.functionName);
            this.print("Deleted successfully");
        }
    }

    @CommandLine.Command(description={"Update a Pulsar Function that has been deployed to a Pulsar cluster"})
    class UpdateFunction
    extends FunctionDetailsCommand {
        @CommandLine.Option(names={"--update-auth-data"}, description={"Whether or not to update the auth data #Java, Python"})
        protected boolean updateAuthData;

        UpdateFunction() {
        }

        @Override
        protected void validateFunctionConfigs(FunctionConfig functionConfig) {
            if (StringUtils.isEmpty((String)functionConfig.getName())) {
                Utils.inferMissingFunctionName((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getName())) {
                throw new CliCommand.ParameterException("Function Name not provided");
            }
            if (StringUtils.isEmpty((String)functionConfig.getTenant())) {
                Utils.inferMissingTenant((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getNamespace())) {
                Utils.inferMissingNamespace((FunctionConfig)functionConfig);
            }
        }

        @Override
        void runCmd() throws Exception {
            UpdateOptionsImpl updateOptions = new UpdateOptionsImpl();
            updateOptions.setUpdateAuthData(this.updateAuthData);
            if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getJar())) {
                CmdFunctions.this.getAdmin().functions().updateFunctionWithUrl(this.functionConfig, this.functionConfig.getJar(), (UpdateOptions)updateOptions);
            } else if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getPy())) {
                CmdFunctions.this.getAdmin().functions().updateFunctionWithUrl(this.functionConfig, this.functionConfig.getPy(), (UpdateOptions)updateOptions);
            } else if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getGo())) {
                CmdFunctions.this.getAdmin().functions().updateFunctionWithUrl(this.functionConfig, this.functionConfig.getGo(), (UpdateOptions)updateOptions);
            } else {
                CmdFunctions.this.getAdmin().functions().updateFunction(this.functionConfig, this.userCodeFile, (UpdateOptions)updateOptions);
            }
            this.print("Updated successfully");
        }
    }

    @CommandLine.Command(description={"Fetch information about a Pulsar Function"})
    class GetFunction
    extends FunctionCommand {
        GetFunction() {
        }

        @Override
        void runCmd() throws Exception {
            FunctionConfig functionConfig = CmdFunctions.this.getAdmin().functions().getFunction(this.tenant, this.namespace, this.functionName);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)functionConfig));
        }
    }

    @CommandLine.Command(aliases={"getstatus"}, description={"Check the current status of a Pulsar Function"})
    class GetFunctionStatus
    extends FunctionCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The function instanceId (Get-status of all instances if instance-id is not provided)"})
        protected String instanceId;

        GetFunctionStatus() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((String)this.instanceId)) {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStatus(this.tenant, this.namespace, this.functionName));
            } else {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStatus(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId)));
            }
        }
    }

    @CommandLine.Command(description={"Get the current stats of a Pulsar Function"})
    class GetFunctionStats
    extends FunctionCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The function instanceId (Get-stats of all instances if instance-id is not provided)"})
        protected String instanceId;

        GetFunctionStats() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((String)this.instanceId)) {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStats(this.tenant, this.namespace, this.functionName));
            } else {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStats(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId)));
            }
        }
    }

    @CommandLine.Command(description={"List all Pulsar Functions running under a specific tenant and namespace"})
    class ListFunctions
    extends NamespaceCommand {
        ListFunctions() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctions.this.getAdmin().functions().getFunctions(this.tenant, this.namespace));
        }
    }

    @CommandLine.Command(description={"Fetch the current state associated with a Pulsar Function"})
    class StateGetter
    extends FunctionCommand {
        @CommandLine.Option(names={"-k", "--key"}, description={"Key name of State"})
        private String key;
        @CommandLine.Option(names={"-w", "--watch"}, description={"Watch for changes in the value associated with a key for a Pulsar Function"})
        private boolean watch;

        StateGetter() {
            this.key = null;
            this.watch = false;
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((String)this.key)) {
                throw new CliCommand.ParameterException("State key needs to be specified");
            }
            do {
                try {
                    FunctionState functionState = CmdFunctions.this.getAdmin().functions().getFunctionState(this.tenant, this.namespace, this.functionName, this.key);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    System.out.println(gson.toJson((Object)functionState));
                }
                catch (PulsarAdminException pae) {
                    if (pae.getStatusCode() == 404 && this.watch) {
                        System.err.println(pae.getMessage());
                    }
                    throw pae;
                }
                if (!this.watch) continue;
                Thread.sleep(1000L);
            } while (this.watch);
        }
    }

    @CommandLine.Command(description={"Put the state associated with a Pulsar Function"})
    class StatePutter
    extends FunctionCommand {
        @CommandLine.Option(names={"-s", "--state"}, description={"The FunctionState that needs to be put"}, required=true)
        private String state;

        StatePutter() {
            this.state = null;
        }

        @Override
        void runCmd() throws Exception {
            FunctionState stateRepr = (FunctionState)ObjectMapperFactory.getMapper().reader().readValue(this.state, FunctionState.class);
            CmdFunctions.this.getAdmin().functions().putFunctionState(this.tenant, this.namespace, this.functionName, stateRepr);
        }
    }

    @CommandLine.Command(description={"Trigger the specified Pulsar Function with a supplied value"})
    class TriggerFunction
    extends FunctionCommand {
        @CommandLine.Option(names={"--triggerValue"}, description={"The value with which you want to trigger the function"}, hidden=true)
        protected String deprecatedTriggerValue;
        @CommandLine.Option(names={"--trigger-value"}, description={"The value with which you want to trigger the function"})
        protected String triggerValue;
        @CommandLine.Option(names={"--triggerFile"}, description={"The path to the file that contains the data with which you want to trigger the function"}, hidden=true)
        protected String deprecatedTriggerFile;
        @CommandLine.Option(names={"--trigger-file"}, description={"The path to the file that contains the data with which you want to trigger the function"})
        protected String triggerFile;
        @CommandLine.Option(names={"--topic"}, description={"The specific topic name that the function consumes from that you want to inject the data to"})
        protected String topic;

        TriggerFunction() {
        }

        public void mergeArgs() {
            if (StringUtils.isBlank((String)this.triggerValue) && !StringUtils.isBlank((String)this.deprecatedTriggerValue)) {
                this.triggerValue = this.deprecatedTriggerValue;
            }
            if (StringUtils.isBlank((String)this.triggerFile) && !StringUtils.isBlank((String)this.deprecatedTriggerFile)) {
                this.triggerFile = this.deprecatedTriggerFile;
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            if (this.triggerFile == null && this.triggerValue == null) {
                throw new CliCommand.ParameterException("Either a trigger value or a trigger filepath needs to be specified");
            }
            String retval = CmdFunctions.this.getAdmin().functions().triggerFunction(this.tenant, this.namespace, this.functionName, this.topic, this.triggerValue, this.triggerFile);
            System.out.println(retval);
        }
    }

    @CommandLine.Command(description={"Upload File Data to Pulsar"})
    class UploadFunction
    extends BaseCommand {
        @CommandLine.Option(names={"--sourceFile"}, description={"The file whose contents need to be uploaded"}, hidden=true)
        protected String deprecatedSourceFile;
        @CommandLine.Option(names={"--source-file"}, description={"The file whose contents need to be uploaded"})
        protected String sourceFile;
        @CommandLine.Option(names={"--path"}, description={"Path or functionPkgUrl where the contents need to be stored"}, required=true)
        protected String path;

        UploadFunction() {
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.sourceFile) && !StringUtils.isBlank((String)this.deprecatedSourceFile)) {
                this.sourceFile = this.deprecatedSourceFile;
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            if (StringUtils.isBlank((String)this.sourceFile)) {
                throw new CliCommand.ParameterException("--source-file needs to be specified");
            }
            CmdFunctions.this.getAdmin().functions().uploadFunction(this.sourceFile, this.path);
            this.print("Uploaded successfully");
        }
    }

    @CommandLine.Command(description={"Download File Data from Pulsar"})
    class DownloadFunction
    extends FunctionCommand {
        @CommandLine.Option(names={"--destinationFile"}, description={"The file to store downloaded content"}, hidden=true)
        protected String deprecatedDestinationFile;
        @CommandLine.Option(names={"--destination-file"}, description={"The file to store downloaded content"})
        protected String destinationFile;
        @CommandLine.Option(names={"--path"}, description={"Path or functionPkgUrl to store the content"}, required=false, hidden=true)
        protected String path;
        @CommandLine.Option(names={"--transform-function"}, description={"Download the transform Function of the connector"})
        protected Boolean transformFunction;

        DownloadFunction() {
            this.transformFunction = false;
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.destinationFile) && !StringUtils.isBlank((String)this.deprecatedDestinationFile)) {
                this.destinationFile = this.deprecatedDestinationFile;
            }
        }

        @Override
        void processArguments() throws Exception {
            if (this.path == null) {
                super.processArguments();
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            if (StringUtils.isBlank((String)this.destinationFile)) {
                throw new CliCommand.ParameterException("--destination-file needs to be specified");
            }
            if (this.path != null) {
                CmdFunctions.this.getAdmin().functions().downloadFunction(this.destinationFile, this.path);
            } else {
                CmdFunctions.this.getAdmin().functions().downloadFunction(this.destinationFile, this.tenant, this.namespace, this.functionName, this.transformFunction.booleanValue());
            }
            this.print("Downloaded successfully");
        }
    }

    @CommandLine.Command(description={"Restart function instance"})
    class RestartFunction
    extends FunctionCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The function instanceId (restart all instances if instance-id is not provided)"})
        protected String instanceId;

        RestartFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((String)this.instanceId)) {
                try {
                    CmdFunctions.this.getAdmin().functions().restartFunction(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdFunctions.this.getAdmin().functions().restartFunction(this.tenant, this.namespace, this.functionName);
            }
            System.out.println("Restarted successfully");
        }
    }

    @CommandLine.Command(description={"Stops function instance"})
    class StopFunction
    extends FunctionCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The function instanceId (stop all instances if instance-id is not provided)"})
        protected String instanceId;

        StopFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((String)this.instanceId)) {
                try {
                    CmdFunctions.this.getAdmin().functions().stopFunction(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdFunctions.this.getAdmin().functions().stopFunction(this.tenant, this.namespace, this.functionName);
            }
            System.out.println("Stopped successfully");
        }
    }

    @CommandLine.Command(description={"Starts a stopped function instance"})
    class StartFunction
    extends FunctionCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The function instanceId (start all instances if instance-id is not provided)"})
        protected String instanceId;

        StartFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((String)this.instanceId)) {
                try {
                    CmdFunctions.this.getAdmin().functions().startFunction(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdFunctions.this.getAdmin().functions().startFunction(this.tenant, this.namespace, this.functionName);
            }
            System.out.println("Started successfully");
        }
    }

    @CommandLine.Command(description={"Reload the available built-in functions"})
    public class ReloadBuiltInFunctions
    extends BaseCommand {
        @Override
        void runCmd() throws Exception {
            CmdFunctions.this.getAdmin().functions().reloadBuiltInFunctions();
        }
    }

    @CommandLine.Command(description={"Get the list of Pulsar Functions supported by Pulsar cluster"})
    public class ListBuiltInFunctions
    extends BaseCommand {
        @Override
        void runCmd() throws Exception {
            CmdFunctions.this.getAdmin().functions().getBuiltInFunctions().forEach(function -> {
                this.print(function.getName());
                this.print(WordUtils.wrap((String)function.getDescription(), (int)80));
                this.print("----------------------------------------");
            });
        }
    }

    abstract class FunctionDetailsCommand
    extends BaseCommand {
        @CommandLine.Option(names={"--fqfn"}, description={"The Fully Qualified Function Name (FQFN) for the function #Java, Python"})
        protected String fqfn;
        @CommandLine.Option(names={"--tenant"}, description={"The tenant of a Pulsar Function #Java, Python, Go"})
        protected String tenant;
        @CommandLine.Option(names={"--namespace"}, description={"The namespace of a Pulsar Function #Java, Python, Go"})
        protected String namespace;
        @CommandLine.Option(names={"--name"}, description={"The name of a Pulsar Function #Java, Python, Go"})
        protected String functionName;
        @CommandLine.Option(names={"--className"}, description={"The class name of a Pulsar Function"}, hidden=true)
        protected String deprecatedClassName;
        @CommandLine.Option(names={"--classname"}, description={"The class name of a Pulsar Function #Java, Python"})
        protected String className;
        @CommandLine.Option(names={"-t", "--function-type"}, description={"The built-in Pulsar Function type"})
        protected String functionType;
        @CommandLine.Option(names={"--cleanup-subscription"}, description={"Whether delete the subscription when function is deleted"})
        protected Boolean cleanupSubscription;
        @CommandLine.Option(names={"--jar"}, description={"Path to the JAR file for the function (if the function is written in Java). It also supports URL path [http/https/file (file protocol assumes that file already exists on worker host)/function (package URL from packages management service)] from which worker can download the package. #Java"})
        protected String jarFile;
        @CommandLine.Option(names={"--py"}, description={"Path to the main Python file/Python Wheel file for the function (if the function is written in Python). It also supports URL path [http/https/file (file protocol assumes that file already exists on worker host)/function (package URL from packages management service)] from which worker can download the package. #Python"})
        protected String pyFile;
        @CommandLine.Option(names={"--go"}, description={"Path to the main Go executable binary for the function (if the function is written in Go). It also supports URL path [http/https/file (file protocol assumes that file already exists on worker host)/function (package URL from packages management service)] from which worker can download the package. #Go"})
        protected String goFile;
        @CommandLine.Option(names={"-i", "--inputs"}, description={"The input topic or topics (multiple topics can be specified as a comma-separated list) of a Pulsar Function #Java, Python, Go"})
        protected String inputs;
        @CommandLine.Option(names={"--topicsPattern"}, description={"TopicsPattern to consume from list of topics under a namespace that match the pattern. [--input] and [--topic-pattern] are mutually exclusive. Add SerDe class name for a pattern in --custom-serde-inputs (supported for java fun only)"}, hidden=true)
        protected String deprecatedTopicsPattern;
        @CommandLine.Option(names={"--topics-pattern"}, description={"The topic pattern to consume from a list of topics under a namespace that matches the pattern. [--input] and [--topics-pattern] are mutually exclusive. Add SerDe class name for a pattern in --custom-serde-inputs (supported for java functions only) #Java, Python"})
        protected String topicsPattern;
        @CommandLine.Option(names={"-o", "--output"}, description={"The output topic of a Pulsar Function (If none is specified, no output is written) #Java, Python, Go"})
        protected String output;
        @CommandLine.Option(names={"--producer-config"}, description={"The custom producer configuration (as a JSON string) #Java"})
        protected String producerConfig;
        @CommandLine.Option(names={"--logTopic"}, description={"The topic to which the logs of a Pulsar Function are produced"}, hidden=true)
        protected String deprecatedLogTopic;
        @CommandLine.Option(names={"--log-topic"}, description={"The topic to which the logs of a Pulsar Function are produced #Java, Python, Go"})
        protected String logTopic;
        @CommandLine.Option(names={"-st", "--schema-type"}, description={"The builtin schema type or custom schema class name to be used for messages output by the function #Java"})
        protected String schemaType;
        @CommandLine.Option(names={"--customSerdeInputs"}, description={"The map of input topics to SerDe class names (as a JSON string)"}, hidden=true)
        protected String deprecatedCustomSerdeInputString;
        @CommandLine.Option(names={"--custom-serde-inputs"}, description={"The map of input topics to SerDe class names (as a JSON string) #Java, Python"})
        protected String customSerdeInputString;
        @CommandLine.Option(names={"--custom-schema-inputs"}, description={"The map of input topics to Schema properties (as a JSON string) #Java, Python"})
        protected String customSchemaInputString;
        @CommandLine.Option(names={"--custom-schema-outputs"}, description={"The map of input topics to Schema properties (as a JSON string) #Java"})
        protected String customSchemaOutputString;
        @CommandLine.Option(names={"--input-specs"}, description={"The map of inputs to custom configuration (as a JSON string) #Java, Python, Go"})
        protected String inputSpecs;
        @CommandLine.Option(names={"--input-type-class-name"}, description={"The class name of input type class #Java, Python, Go"})
        protected String inputTypeClassName;
        @CommandLine.Option(names={"--outputSerdeClassName"}, description={"The SerDe class to be used for messages output by the function"}, hidden=true)
        protected String deprecatedOutputSerdeClassName;
        @CommandLine.Option(names={"--output-serde-classname"}, description={"The SerDe class to be used for messages output by the function #Java, Python"})
        protected String outputSerdeClassName;
        @CommandLine.Option(names={"--output-type-class-name"}, description={"The class name of output type class #Java, Python, Go"})
        protected String outputTypeClassName;
        @CommandLine.Option(names={"--functionConfigFile"}, description={"The path to a YAML config file that specifies the configuration of a Pulsar Function"}, hidden=true)
        protected String deprecatedFnConfigFile;
        @CommandLine.Option(names={"--function-config-file"}, description={"The path to a YAML config file that specifies the configuration of a Pulsar Function #Java, Python, Go"})
        protected String fnConfigFile;
        @CommandLine.Option(names={"--processingGuarantees"}, description={"The processing guarantees (aka delivery semantics) applied to the function"}, hidden=true)
        protected FunctionConfig.ProcessingGuarantees deprecatedProcessingGuarantees;
        @CommandLine.Option(names={"--processing-guarantees"}, description={"The processing guarantees (as known as delivery semantics) applied to the function. Available values are: `ATLEAST_ONCE`, `ATMOST_ONCE`, `EFFECTIVELY_ONCE`. If it is not specified, the `ATLEAST_ONCE` delivery guarantee is used. #Java, Python, Go"})
        protected FunctionConfig.ProcessingGuarantees processingGuarantees;
        @CommandLine.Option(names={"--userConfig"}, description={"User-defined config key/values"}, hidden=true)
        protected String deprecatedUserConfigString;
        @CommandLine.Option(names={"--user-config"}, description={"User-defined config key/values #Java, Python, Go"})
        protected String userConfigString;
        @CommandLine.Option(names={"--retainOrdering"}, description={"Function consumes and processes messages in order"}, hidden=true)
        protected Boolean deprecatedRetainOrdering;
        @CommandLine.Option(names={"--retain-ordering"}, description={"Function consumes and processes messages in order #Java"})
        protected Boolean retainOrdering;
        @CommandLine.Option(names={"--retain-key-ordering"}, description={"Function consumes and processes messages in key order #Java"})
        protected Boolean retainKeyOrdering;
        @CommandLine.Option(names={"--batch-builder"}, description={"BatcherBuilder provides two types of batch construction methods, DEFAULT and KEY_BASED. The default value is: DEFAULT"})
        protected String batchBuilder;
        @CommandLine.Option(names={"--forward-source-message-property"}, description={"Forwarding input message's properties to output topic when processing (use false to disable it) #Java"}, arity="1")
        protected Boolean forwardSourceMessageProperty;
        @CommandLine.Option(names={"--subs-name"}, description={"Pulsar source subscription name if user wants a specific subscription-name for input-topic consumer #Java, Python, Go"})
        protected String subsName;
        @CommandLine.Option(names={"--subs-position"}, description={"Pulsar source subscription position if user wants to consume messages from the specified location #Java"})
        protected SubscriptionInitialPosition subsPosition;
        @CommandLine.Option(names={"--skip-to-latest"}, description={"Whether or not the consumer skip to latest message upon function instance restart"}, arity="1")
        protected Boolean skipToLatest;
        @CommandLine.Option(names={"--parallelism"}, description={"The parallelism factor of a Pulsar Function (i.e. the number of function instances to run) #Java"})
        protected Integer parallelism;
        @CommandLine.Option(names={"--cpu"}, description={"The cpu in cores that need to be allocated per function instance(applicable only to docker runtime) #Java(Process & K8s),Python(K8s),Go(K8s)"})
        protected Double cpu;
        @CommandLine.Option(names={"--ram"}, description={"The ram in bytes that need to be allocated per function instance(applicable only to process/docker runtime) #Java(Process & K8s),Python(K8s),Go(K8s)"})
        protected Long ram;
        @CommandLine.Option(names={"--disk"}, description={"The disk in bytes that need to be allocated per function instance(applicable only to docker runtime) #Java(Process & K8s),Python(K8s),Go(K8s)"})
        protected Long disk;
        @CommandLine.Option(names={"--windowLengthCount"}, description={"The number of messages per window"}, hidden=true)
        protected Integer deprecatedWindowLengthCount;
        @CommandLine.Option(names={"--window-length-count"}, description={"The number of messages per window #Java"})
        protected Integer windowLengthCount;
        @CommandLine.Option(names={"--windowLengthDurationMs"}, description={"The time duration of the window in milliseconds"}, hidden=true)
        protected Long deprecatedWindowLengthDurationMs;
        @CommandLine.Option(names={"--window-length-duration-ms"}, description={"The time duration of the window in milliseconds #Java"})
        protected Long windowLengthDurationMs;
        @CommandLine.Option(names={"--slidingIntervalCount"}, description={"The number of messages after which the window slides"}, hidden=true)
        protected Integer deprecatedSlidingIntervalCount;
        @CommandLine.Option(names={"--sliding-interval-count"}, description={"The number of messages after which the window slides #Java"})
        protected Integer slidingIntervalCount;
        @CommandLine.Option(names={"--slidingIntervalDurationMs"}, description={"The time duration after which the window slides"}, hidden=true)
        protected Long deprecatedSlidingIntervalDurationMs;
        @CommandLine.Option(names={"--sliding-interval-duration-ms"}, description={"The time duration after which the window slides #Java"})
        protected Long slidingIntervalDurationMs;
        @CommandLine.Option(names={"--autoAck"}, description={"Whether or not the framework acknowledges messages automatically"}, hidden=true)
        protected Boolean deprecatedAutoAck;
        @CommandLine.Option(names={"--auto-ack"}, description={"Whether or not the framework acknowledges messages automatically #Java, Python, Go"}, arity="1")
        protected Boolean autoAck;
        @CommandLine.Option(names={"--timeoutMs"}, description={"The message timeout in milliseconds"}, hidden=true)
        protected Long deprecatedTimeoutMs;
        @CommandLine.Option(names={"--timeout-ms"}, description={"The message timeout in milliseconds #Java, Python"})
        protected Long timeoutMs;
        @CommandLine.Option(names={"--max-message-retries"}, description={"How many times should we try to process a message before giving up #Java"})
        protected Integer maxMessageRetries;
        @CommandLine.Option(names={"--custom-runtime-options"}, description={"A string that encodes options to customize the runtime, see docs for configured runtime for details #Java"})
        protected String customRuntimeOptions;
        @CommandLine.Option(names={"--secrets"}, description={"The map of secretName to an object that encapsulates how the secret is fetched by the underlying secrets provider #Java, Python"})
        protected String secretsString;
        @CommandLine.Option(names={"--dead-letter-topic"}, description={"The topic where messages that are not processed successfully are sent to #Java"})
        protected String deadLetterTopic;
        @CommandLine.Option(names={"--runtime-flags"}, description={"Any flags that you want to pass to a runtime (for process & Kubernetes runtime only)."})
        protected String runtimeFlags;
        protected FunctionConfig functionConfig;
        protected String userCodeFile;

        FunctionDetailsCommand() {
            this.schemaType = "";
            this.forwardSourceMessageProperty = true;
            this.deprecatedAutoAck = null;
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.className) && !StringUtils.isBlank((String)this.deprecatedClassName)) {
                this.className = this.deprecatedClassName;
            }
            if (StringUtils.isBlank((String)this.topicsPattern) && !StringUtils.isBlank((String)this.deprecatedTopicsPattern)) {
                this.topicsPattern = this.deprecatedTopicsPattern;
            }
            if (StringUtils.isBlank((String)this.logTopic) && !StringUtils.isBlank((String)this.deprecatedLogTopic)) {
                this.logTopic = this.deprecatedLogTopic;
            }
            if (StringUtils.isBlank((String)this.outputSerdeClassName) && !StringUtils.isBlank((String)this.deprecatedOutputSerdeClassName)) {
                this.outputSerdeClassName = this.deprecatedOutputSerdeClassName;
            }
            if (StringUtils.isBlank((String)this.customSerdeInputString) && !StringUtils.isBlank((String)this.deprecatedCustomSerdeInputString)) {
                this.customSerdeInputString = this.deprecatedCustomSerdeInputString;
            }
            if (StringUtils.isBlank((String)this.fnConfigFile) && !StringUtils.isBlank((String)this.deprecatedFnConfigFile)) {
                this.fnConfigFile = this.deprecatedFnConfigFile;
            }
            if (this.processingGuarantees == null && this.deprecatedProcessingGuarantees != null) {
                this.processingGuarantees = this.deprecatedProcessingGuarantees;
            }
            if (StringUtils.isBlank((String)this.userConfigString) && !StringUtils.isBlank((String)this.deprecatedUserConfigString)) {
                this.userConfigString = this.deprecatedUserConfigString;
            }
            if (this.retainOrdering == null && this.deprecatedRetainOrdering != null) {
                this.retainOrdering = this.deprecatedRetainOrdering;
            }
            if (this.windowLengthCount == null && this.deprecatedWindowLengthCount != null) {
                this.windowLengthCount = this.deprecatedWindowLengthCount;
            }
            if (this.windowLengthDurationMs == null && this.deprecatedWindowLengthDurationMs != null) {
                this.windowLengthDurationMs = this.deprecatedWindowLengthDurationMs;
            }
            if (this.slidingIntervalCount == null && this.deprecatedSlidingIntervalCount != null) {
                this.slidingIntervalCount = this.deprecatedSlidingIntervalCount;
            }
            if (this.slidingIntervalDurationMs == null && this.deprecatedSlidingIntervalDurationMs != null) {
                this.slidingIntervalDurationMs = this.deprecatedSlidingIntervalDurationMs;
            }
            if (this.autoAck == null && this.deprecatedAutoAck != null) {
                this.autoAck = this.deprecatedAutoAck;
            }
            if (this.timeoutMs == null && this.deprecatedTimeoutMs != null) {
                this.timeoutMs = this.deprecatedTimeoutMs;
            }
        }

        @Override
        void processArguments() throws Exception {
            Type type;
            this.mergeArgs();
            this.functionConfig = null != this.fnConfigFile ? CmdUtils.loadConfig(this.fnConfigFile, FunctionConfig.class) : new FunctionConfig();
            if (null != this.fqfn) {
                String[] args = this.fqfn.split("/");
                if (args.length != 3) {
                    throw new CliCommand.ParameterException("Fully qualified function names (FQFNs) must be of the form tenant/namespace/name");
                }
                this.functionConfig.setTenant(args[0]);
                this.functionConfig.setNamespace(args[1]);
                this.functionConfig.setName(args[2]);
            } else {
                if (null != this.tenant) {
                    this.functionConfig.setTenant(this.tenant);
                }
                if (null != this.namespace) {
                    this.functionConfig.setNamespace(this.namespace);
                }
                if (null != this.functionName) {
                    this.functionConfig.setName(this.functionName);
                }
            }
            if (null != this.cleanupSubscription) {
                this.functionConfig.setCleanupSubscription(this.cleanupSubscription);
            }
            if (null != this.inputs) {
                List<String> inputTopics = Arrays.asList(this.inputs.split(","));
                this.functionConfig.setInputs(inputTopics);
            }
            if (null != this.customSerdeInputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customSerdeInputMap = (Map)new Gson().fromJson(this.customSerdeInputString, type);
                this.functionConfig.setCustomSerdeInputs(customSerdeInputMap);
            }
            if (null != this.customSchemaInputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customschemaInputMap = (Map)new Gson().fromJson(this.customSchemaInputString, type);
                this.functionConfig.setCustomSchemaInputs(customschemaInputMap);
            }
            if (null != this.customSchemaOutputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customSchemaOutputMap = (Map)new Gson().fromJson(this.customSchemaOutputString, type);
                this.functionConfig.setCustomSchemaOutputs(customSchemaOutputMap);
            }
            if (null != this.inputSpecs) {
                type = new TypeToken<Map<String, ConsumerConfig>>(){}.getType();
                this.functionConfig.setInputSpecs((Map)new Gson().fromJson(this.inputSpecs, type));
            }
            if (null != this.inputTypeClassName) {
                this.functionConfig.setInputTypeClassName(this.inputTypeClassName);
            }
            if (null != this.topicsPattern) {
                this.functionConfig.setTopicsPattern(this.topicsPattern);
            }
            if (null != this.output) {
                this.functionConfig.setOutput(this.output);
            }
            if (null != this.outputTypeClassName) {
                this.functionConfig.setOutputTypeClassName(this.outputTypeClassName);
            }
            if (null != this.producerConfig) {
                type = new TypeToken<ProducerConfig>(){}.getType();
                this.functionConfig.setProducerConfig((ProducerConfig)new Gson().fromJson(this.producerConfig, type));
            }
            if (null != this.logTopic) {
                this.functionConfig.setLogTopic(this.logTopic);
            }
            if (null != this.className) {
                this.functionConfig.setClassName(this.className);
            }
            if (null != this.outputSerdeClassName) {
                this.functionConfig.setOutputSerdeClassName(this.outputSerdeClassName);
            }
            if (null != this.schemaType) {
                this.functionConfig.setOutputSchemaType(this.schemaType);
            }
            if (null != this.processingGuarantees) {
                this.functionConfig.setProcessingGuarantees(this.processingGuarantees);
            }
            if (null != this.retainOrdering) {
                this.functionConfig.setRetainOrdering(this.retainOrdering);
            }
            if (null != this.retainKeyOrdering) {
                this.functionConfig.setRetainKeyOrdering(this.retainKeyOrdering);
            }
            if (StringUtils.isNotBlank((String)this.batchBuilder)) {
                this.functionConfig.setBatchBuilder(this.batchBuilder);
            }
            if (null != this.forwardSourceMessageProperty) {
                this.functionConfig.setForwardSourceMessageProperty(this.forwardSourceMessageProperty);
            }
            if (StringUtils.isNotBlank((String)this.subsName)) {
                this.functionConfig.setSubName(this.subsName);
            }
            if (null != this.subsPosition) {
                this.functionConfig.setSubscriptionPosition(this.subsPosition);
            }
            if (null != this.skipToLatest) {
                this.functionConfig.setSkipToLatest(this.skipToLatest);
            }
            if (null != this.userConfigString) {
                type = new TypeToken<Map<String, Object>>(){}.getType();
                HashMap userConfigMap = (HashMap)new Gson().fromJson(this.userConfigString, type);
                if (userConfigMap == null) {
                    userConfigMap = new HashMap();
                }
                this.functionConfig.setUserConfig(userConfigMap);
            }
            if (this.parallelism != null) {
                this.functionConfig.setParallelism(this.parallelism);
            }
            Resources resources = this.functionConfig.getResources();
            if (this.cpu != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setCpu(this.cpu);
            }
            if (this.ram != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setRam(this.ram);
            }
            if (this.disk != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setDisk(this.disk);
            }
            if (resources != null) {
                this.functionConfig.setResources(resources);
            }
            if (this.timeoutMs != null) {
                this.functionConfig.setTimeoutMs(this.timeoutMs);
            }
            if (this.customRuntimeOptions != null) {
                this.functionConfig.setCustomRuntimeOptions(this.customRuntimeOptions);
            }
            if (this.secretsString != null) {
                Type type2 = new TypeToken<Map<String, Object>>(){}.getType();
                Map secretsMap = (Map)new Gson().fromJson(this.secretsString, type2);
                if (secretsMap == null) {
                    secretsMap = Collections.emptyMap();
                }
                this.functionConfig.setSecrets(secretsMap);
            }
            WindowConfig windowConfig = this.functionConfig.getWindowConfig();
            if (null != this.windowLengthCount) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setWindowLengthCount(this.windowLengthCount);
            }
            if (null != this.windowLengthDurationMs) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setWindowLengthDurationMs(this.windowLengthDurationMs);
            }
            if (null != this.slidingIntervalCount) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setSlidingIntervalCount(this.slidingIntervalCount);
            }
            if (null != this.slidingIntervalDurationMs) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setSlidingIntervalDurationMs(this.slidingIntervalDurationMs);
            }
            this.functionConfig.setWindowConfig(windowConfig);
            if (this.autoAck != null) {
                this.functionConfig.setAutoAck(this.autoAck);
            }
            if (null != this.maxMessageRetries) {
                this.functionConfig.setMaxMessageRetries(this.maxMessageRetries);
            }
            if (null != this.deadLetterTopic) {
                this.functionConfig.setDeadLetterTopic(this.deadLetterTopic);
            }
            if (this.jarFile != null && this.functionType != null) {
                throw new CliCommand.ParameterException("Cannot specify both jar and function-type");
            }
            if (null != this.jarFile) {
                this.functionConfig.setJar(this.jarFile);
            }
            if (this.functionType != null) {
                this.functionConfig.setJar("builtin://" + this.functionType);
            } else if (this.functionConfig.getFunctionType() != null) {
                this.functionConfig.setJar("builtin://" + this.functionConfig.getFunctionType());
            }
            if (null != this.pyFile) {
                this.functionConfig.setPy(this.pyFile);
            }
            if (null != this.goFile) {
                this.functionConfig.setGo(this.goFile);
            }
            if (this.functionConfig.getJar() != null) {
                this.userCodeFile = this.functionConfig.getJar();
            } else if (this.functionConfig.getPy() != null) {
                this.userCodeFile = this.functionConfig.getPy();
            } else if (this.functionConfig.getGo() != null) {
                this.userCodeFile = this.functionConfig.getGo();
            }
            if (null != this.runtimeFlags) {
                this.functionConfig.setRuntimeFlags(this.runtimeFlags);
            }
            this.validateFunctionConfigs(this.functionConfig);
        }

        protected void validateFunctionConfigs(FunctionConfig functionConfig) {
            if ((functionConfig.getPy() != null || functionConfig.getJar() != null && !functionConfig.getJar().startsWith("builtin://")) && StringUtils.isEmpty((String)functionConfig.getClassName())) {
                throw new CliCommand.ParameterException("No Function Classname specified");
            }
            if (StringUtils.isEmpty((String)functionConfig.getName())) {
                Utils.inferMissingFunctionName((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getName())) {
                throw new IllegalArgumentException("No Function name specified");
            }
            if (StringUtils.isEmpty((String)functionConfig.getTenant())) {
                Utils.inferMissingTenant((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getNamespace())) {
                Utils.inferMissingNamespace((FunctionConfig)functionConfig);
            }
            if (StringUtils.isNotBlank((String)functionConfig.getJar()) && StringUtils.isNotBlank((String)functionConfig.getPy()) && StringUtils.isNotBlank((String)functionConfig.getGo())) {
                throw new CliCommand.ParameterException("Either a Java jar or a Python file or a Go executable binary needs to be specified for the function. Cannot specify both.");
            }
            if (StringUtils.isBlank((String)functionConfig.getJar()) && StringUtils.isBlank((String)functionConfig.getPy()) && StringUtils.isBlank((String)functionConfig.getGo())) {
                throw new CliCommand.ParameterException("Either a Java jar or a Python file or a Go executable binary needs to be specified for the function. Please specify one.");
            }
            if (!(StringUtils.isBlank((String)functionConfig.getJar()) || functionConfig.getJar().startsWith("builtin://") || Utils.isFunctionPackageUrlSupported((String)functionConfig.getJar()) || new File(functionConfig.getJar()).exists())) {
                throw new CliCommand.ParameterException("The specified jar file does not exist");
            }
            if (!(StringUtils.isBlank((String)functionConfig.getPy()) || Utils.isFunctionPackageUrlSupported((String)functionConfig.getPy()) || new File(functionConfig.getPy()).exists())) {
                throw new CliCommand.ParameterException("The specified python file does not exist");
            }
            if (!(StringUtils.isBlank((String)functionConfig.getGo()) || Utils.isFunctionPackageUrlSupported((String)functionConfig.getGo()) || new File(functionConfig.getGo()).exists())) {
                throw new CliCommand.ParameterException("The specified go executable binary does not exist");
            }
        }

        public String getFqfn() {
            return this.fqfn;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getDeprecatedClassName() {
            return this.deprecatedClassName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFunctionType() {
            return this.functionType;
        }

        public Boolean getCleanupSubscription() {
            return this.cleanupSubscription;
        }

        public String getJarFile() {
            return this.jarFile;
        }

        public String getPyFile() {
            return this.pyFile;
        }

        public String getGoFile() {
            return this.goFile;
        }

        public String getInputs() {
            return this.inputs;
        }

        public String getDeprecatedTopicsPattern() {
            return this.deprecatedTopicsPattern;
        }

        public String getTopicsPattern() {
            return this.topicsPattern;
        }

        public String getOutput() {
            return this.output;
        }

        public String getProducerConfig() {
            return this.producerConfig;
        }

        public String getDeprecatedLogTopic() {
            return this.deprecatedLogTopic;
        }

        public String getLogTopic() {
            return this.logTopic;
        }

        public String getSchemaType() {
            return this.schemaType;
        }

        public String getDeprecatedCustomSerdeInputString() {
            return this.deprecatedCustomSerdeInputString;
        }

        public String getCustomSerdeInputString() {
            return this.customSerdeInputString;
        }

        public String getCustomSchemaInputString() {
            return this.customSchemaInputString;
        }

        public String getCustomSchemaOutputString() {
            return this.customSchemaOutputString;
        }

        public String getInputSpecs() {
            return this.inputSpecs;
        }

        public String getInputTypeClassName() {
            return this.inputTypeClassName;
        }

        public String getDeprecatedOutputSerdeClassName() {
            return this.deprecatedOutputSerdeClassName;
        }

        public String getOutputSerdeClassName() {
            return this.outputSerdeClassName;
        }

        public String getOutputTypeClassName() {
            return this.outputTypeClassName;
        }

        public String getDeprecatedFnConfigFile() {
            return this.deprecatedFnConfigFile;
        }

        public String getFnConfigFile() {
            return this.fnConfigFile;
        }

        public FunctionConfig.ProcessingGuarantees getDeprecatedProcessingGuarantees() {
            return this.deprecatedProcessingGuarantees;
        }

        public FunctionConfig.ProcessingGuarantees getProcessingGuarantees() {
            return this.processingGuarantees;
        }

        public String getDeprecatedUserConfigString() {
            return this.deprecatedUserConfigString;
        }

        public String getUserConfigString() {
            return this.userConfigString;
        }

        public Boolean getDeprecatedRetainOrdering() {
            return this.deprecatedRetainOrdering;
        }

        public Boolean getRetainOrdering() {
            return this.retainOrdering;
        }

        public Boolean getRetainKeyOrdering() {
            return this.retainKeyOrdering;
        }

        public String getBatchBuilder() {
            return this.batchBuilder;
        }

        public Boolean getForwardSourceMessageProperty() {
            return this.forwardSourceMessageProperty;
        }

        public String getSubsName() {
            return this.subsName;
        }

        public SubscriptionInitialPosition getSubsPosition() {
            return this.subsPosition;
        }

        public Boolean getSkipToLatest() {
            return this.skipToLatest;
        }

        public Integer getParallelism() {
            return this.parallelism;
        }

        public Double getCpu() {
            return this.cpu;
        }

        public Long getRam() {
            return this.ram;
        }

        public Long getDisk() {
            return this.disk;
        }

        public Integer getDeprecatedWindowLengthCount() {
            return this.deprecatedWindowLengthCount;
        }

        public Integer getWindowLengthCount() {
            return this.windowLengthCount;
        }

        public Long getDeprecatedWindowLengthDurationMs() {
            return this.deprecatedWindowLengthDurationMs;
        }

        public Long getWindowLengthDurationMs() {
            return this.windowLengthDurationMs;
        }

        public Integer getDeprecatedSlidingIntervalCount() {
            return this.deprecatedSlidingIntervalCount;
        }

        public Integer getSlidingIntervalCount() {
            return this.slidingIntervalCount;
        }

        public Long getDeprecatedSlidingIntervalDurationMs() {
            return this.deprecatedSlidingIntervalDurationMs;
        }

        public Long getSlidingIntervalDurationMs() {
            return this.slidingIntervalDurationMs;
        }

        public Boolean getDeprecatedAutoAck() {
            return this.deprecatedAutoAck;
        }

        public Boolean getAutoAck() {
            return this.autoAck;
        }

        public Long getDeprecatedTimeoutMs() {
            return this.deprecatedTimeoutMs;
        }

        public Long getTimeoutMs() {
            return this.timeoutMs;
        }

        public Integer getMaxMessageRetries() {
            return this.maxMessageRetries;
        }

        public String getCustomRuntimeOptions() {
            return this.customRuntimeOptions;
        }

        public String getSecretsString() {
            return this.secretsString;
        }

        public String getDeadLetterTopic() {
            return this.deadLetterTopic;
        }

        public String getRuntimeFlags() {
            return this.runtimeFlags;
        }

        public FunctionConfig getFunctionConfig() {
            return this.functionConfig;
        }

        public String getUserCodeFile() {
            return this.userCodeFile;
        }
    }

    abstract class FunctionCommand
    extends BaseCommand {
        @CommandLine.Option(names={"--fqfn"}, description={"The Fully Qualified Function Name (FQFN) for the function"})
        protected String fqfn;
        @CommandLine.Option(names={"--tenant"}, description={"The tenant of a Pulsar Function"})
        protected String tenant;
        @CommandLine.Option(names={"--namespace"}, description={"The namespace of a Pulsar Function"})
        protected String namespace;
        @CommandLine.Option(names={"--name"}, description={"The name of a Pulsar Function"})
        protected String functionName;

        FunctionCommand() {
        }

        @Override
        void processArguments() throws Exception {
            boolean usesFqfn;
            boolean usesSetters = null != this.tenant || null != this.namespace || null != this.functionName;
            boolean bl = usesFqfn = null != this.fqfn;
            if (usesFqfn && usesSetters) {
                throw new RuntimeException("You must specify either a Fully Qualified Function Name (FQFN) or tenant, namespace, and function name");
            }
            if (usesFqfn) {
                String[] fqfnParts = this.fqfn.split("/");
                if (fqfnParts.length != 3) {
                    throw new RuntimeException("Fully qualified function names (FQFNs) must be of the form tenant/namespace/name");
                }
                this.tenant = fqfnParts[0];
                this.namespace = fqfnParts[1];
                this.functionName = fqfnParts[2];
            } else {
                if (this.tenant == null) {
                    this.tenant = "public";
                }
                if (this.namespace == null) {
                    this.namespace = "default";
                }
                if (null == this.functionName) {
                    throw new RuntimeException("You must specify a name for the function or a Fully Qualified Function Name (FQFN)");
                }
            }
        }

        public String getFqfn() {
            return this.fqfn;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }

    abstract class NamespaceCommand
    extends BaseCommand {
        @CommandLine.Option(names={"--tenant"}, description={"The tenant of a Pulsar Function"})
        protected String tenant;
        @CommandLine.Option(names={"--namespace"}, description={"The namespace of a Pulsar Function"})
        protected String namespace;

        NamespaceCommand() {
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            this.processArguments();
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

