/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.internal;

import java.lang.reflect.Constructor;
import picocli.CommandLine;

public class InnerClassFactory
implements CommandLine.IFactory {
    private final Object outer;
    private final CommandLine.IFactory defaultFactory = CommandLine.defaultFactory();

    public InnerClassFactory(Object outer) {
        this.outer = outer;
    }

    public <K> K create(Class<K> cls) throws Exception {
        try {
            return (K)this.defaultFactory.create(cls);
        }
        catch (Exception ex0) {
            try {
                Constructor<K> constructor = cls.getDeclaredConstructor(this.outer.getClass());
                return constructor.newInstance(this.outer);
            }
            catch (Exception ex) {
                try {
                    K result = cls.newInstance();
                    return result;
                }
                catch (Exception ex2) {
                    try {
                        Constructor<K> constructor = cls.getDeclaredConstructor(new Class[0]);
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (Exception ex3) {
                        throw new CommandLine.InitializationException("Could not instantiate " + cls.getName() + " either with or without construction parameter " + this.outer + ": " + ex, ex);
                    }
                }
            }
        }
    }
}

