/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.io.BatchSourceConfig;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Interface for managing Pulsar IO Sources (ingress data into Pulsar)"}, aliases={"source"})
public class CmdSources
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdSources.class);
    private final CreateSource createSource = new CreateSource();
    private final DeleteSource deleteSource;
    private final GetSource getSource;
    private final GetSourceStatus getSourceStatus;
    private final ListSources listSources;
    private final UpdateSource updateSource = new UpdateSource();
    private final RestartSource restartSource;
    private final StopSource stopSource;
    private final StartSource startSource;
    private final LocalSourceRunner localSourceRunner;

    public CmdSources(Supplier<PulsarAdmin> admin) {
        super("sources", admin);
        this.deleteSource = new DeleteSource();
        this.listSources = new ListSources();
        this.getSource = new GetSource();
        this.getSourceStatus = new GetSourceStatus();
        this.restartSource = new RestartSource();
        this.stopSource = new StopSource();
        this.startSource = new StartSource();
        this.localSourceRunner = new LocalSourceRunner();
        this.addCommand("create", this.createSource);
        this.addCommand("update", this.updateSource);
        this.addCommand("delete", this.deleteSource);
        this.addCommand("get", this.getSource);
        this.addCommand("status", this.getSourceStatus, "getstatus");
        this.addCommand("list", this.listSources);
        this.addCommand("stop", this.stopSource);
        this.addCommand("start", this.startSource);
        this.addCommand("restart", this.restartSource);
        this.addCommand("localrun", this.localSourceRunner);
        this.addCommand("available-sources", new ListBuiltInSources());
        this.addCommand("reload", new ReloadBuiltInSources());
    }

    public CreateSource getCreateSource() {
        return this.createSource;
    }

    public DeleteSource getDeleteSource() {
        return this.deleteSource;
    }

    public GetSource getGetSource() {
        return this.getSource;
    }

    public GetSourceStatus getGetSourceStatus() {
        return this.getSourceStatus;
    }

    public ListSources getListSources() {
        return this.listSources;
    }

    public UpdateSource getUpdateSource() {
        return this.updateSource;
    }

    public RestartSource getRestartSource() {
        return this.restartSource;
    }

    public StopSource getStopSource() {
        return this.stopSource;
    }

    public StartSource getStartSource() {
        return this.startSource;
    }

    public LocalSourceRunner getLocalSourceRunner() {
        return this.localSourceRunner;
    }

    @CommandLine.Command(description={"Submit a Pulsar IO source connector to run in a Pulsar cluster"})
    protected class CreateSource
    extends SourceDetailsCommand {
        protected CreateSource() {
        }

        @Override
        void runCmd() throws Exception {
            if (Utils.isFunctionPackageUrlSupported((String)this.sourceConfig.getArchive())) {
                CmdSources.this.getAdmin().sources().createSourceWithUrl(this.sourceConfig, this.sourceConfig.getArchive());
            } else {
                CmdSources.this.getAdmin().sources().createSource(this.sourceConfig, this.sourceConfig.getArchive());
            }
            this.print("Created successfully");
        }
    }

    @CommandLine.Command(description={"Update a Pulsar IO source connector"})
    protected class UpdateSource
    extends SourceDetailsCommand {
        @CommandLine.Option(names={"--update-auth-data"}, description={"Whether or not to update the auth data"})
        protected boolean updateAuthData;

        protected UpdateSource() {
        }

        @Override
        void runCmd() throws Exception {
            UpdateOptionsImpl updateOptions = new UpdateOptionsImpl();
            updateOptions.setUpdateAuthData(this.updateAuthData);
            if (Utils.isFunctionPackageUrlSupported((String)this.sourceConfig.getArchive())) {
                CmdSources.this.getAdmin().sources().updateSourceWithUrl(this.sourceConfig, this.sourceConfig.getArchive(), (UpdateOptions)updateOptions);
            } else {
                CmdSources.this.getAdmin().sources().updateSource(this.sourceConfig, this.sourceConfig.getArchive(), (UpdateOptions)updateOptions);
            }
            this.print("Updated successfully");
        }

        @Override
        protected void validateSourceConfigs(SourceConfig sourceConfig) {
            if (sourceConfig.getTenant() == null) {
                sourceConfig.setTenant("public");
            }
            if (sourceConfig.getNamespace() == null) {
                sourceConfig.setNamespace("default");
            }
        }
    }

    @CommandLine.Command(description={"Stops a Pulsar IO source connector"})
    protected class DeleteSource
    extends SourceCommand {
        protected DeleteSource() {
        }

        @Override
        void runCmd() throws Exception {
            CmdSources.this.getAdmin().sources().deleteSource(this.tenant, this.namespace, this.sourceName);
            this.print("Delete source successfully");
        }
    }

    @CommandLine.Command(description={"List all running Pulsar IO source connectors"})
    protected class ListSources
    extends BaseCommand {
        @CommandLine.Option(names={"--tenant"}, description={"The source's tenant"})
        protected String tenant;
        @CommandLine.Option(names={"--namespace"}, description={"The source's namespace"})
        protected String namespace;

        protected ListSources() {
        }

        @Override
        public void processArguments() {
            if (this.tenant == null) {
                this.tenant = "public";
            }
            if (this.namespace == null) {
                this.namespace = "default";
            }
        }

        @Override
        void runCmd() throws Exception {
            List sources = CmdSources.this.getAdmin().sources().listSources(this.tenant, this.namespace);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)sources));
        }
    }

    @CommandLine.Command(description={"Gets the information about a Pulsar IO source connector"})
    protected class GetSource
    extends SourceCommand {
        protected GetSource() {
        }

        @Override
        void runCmd() throws Exception {
            SourceConfig sourceConfig = CmdSources.this.getAdmin().sources().getSource(this.tenant, this.namespace, this.sourceName);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)sourceConfig));
        }
    }

    @CommandLine.Command(description={"Check the current status of a Pulsar Source"})
    class GetSourceStatus
    extends SourceCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The source instanceId (Get-status of all instances if instance-id is not provided"})
        protected String instanceId;

        GetSourceStatus() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((CharSequence)this.instanceId)) {
                this.print(CmdSources.this.getAdmin().sources().getSourceStatus(this.tenant, this.namespace, this.sourceName));
            } else {
                this.print(CmdSources.this.getAdmin().sources().getSourceStatus(this.tenant, this.namespace, this.sourceName, Integer.parseInt(this.instanceId)));
            }
        }
    }

    @CommandLine.Command(description={"Restart source instance"})
    class RestartSource
    extends SourceCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The source instanceId (restart all instances if instance-id is not provided"})
        protected String instanceId;

        RestartSource() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
                try {
                    CmdSources.this.getAdmin().sources().restartSource(this.tenant, this.namespace, this.sourceName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdSources.this.getAdmin().sources().restartSource(this.tenant, this.namespace, this.sourceName);
            }
            System.out.println("Restarted successfully");
        }
    }

    @CommandLine.Command(description={"Stop source instance"})
    class StopSource
    extends SourceCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The source instanceId (stop all instances if instance-id is not provided"})
        protected String instanceId;

        StopSource() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
                try {
                    CmdSources.this.getAdmin().sources().stopSource(this.tenant, this.namespace, this.sourceName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdSources.this.getAdmin().sources().stopSource(this.tenant, this.namespace, this.sourceName);
            }
            System.out.println("Stopped successfully");
        }
    }

    @CommandLine.Command(description={"Start source instance"})
    class StartSource
    extends SourceCommand {
        @CommandLine.Option(names={"--instance-id"}, description={"The source instanceId (start all instances if instance-id is not provided"})
        protected String instanceId;

        StartSource() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
                try {
                    CmdSources.this.getAdmin().sources().startSource(this.tenant, this.namespace, this.sourceName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdSources.this.getAdmin().sources().startSource(this.tenant, this.namespace, this.sourceName);
            }
            System.out.println("Started successfully");
        }
    }

    @CommandLine.Command(description={"Run a Pulsar IO source connector locally (rather than deploying it to the Pulsar cluster)"})
    protected class LocalSourceRunner
    extends CreateSource {
        @CommandLine.Option(names={"--state-storage-service-url"}, description={"The URL for the state storage service (the default is Apache BookKeeper)"})
        protected String stateStorageServiceUrl;
        @CommandLine.Option(names={"--brokerServiceUrl"}, description={"The URL for the Pulsar broker"}, hidden=true)
        protected String deprecatedBrokerServiceUrl;
        @CommandLine.Option(names={"--broker-service-url"}, description={"The URL for the Pulsar broker"})
        protected String brokerServiceUrl;
        @CommandLine.Option(names={"--clientAuthPlugin"}, description={"Client authentication plugin using which function-process can connect to broker"}, hidden=true)
        protected String deprecatedClientAuthPlugin;
        @CommandLine.Option(names={"--client-auth-plugin"}, description={"Client authentication plugin using which function-process can connect to broker"})
        protected String clientAuthPlugin;
        @CommandLine.Option(names={"--clientAuthParams"}, description={"Client authentication param"}, hidden=true)
        protected String deprecatedClientAuthParams;
        @CommandLine.Option(names={"--client-auth-params"}, description={"Client authentication param"})
        protected String clientAuthParams;
        @CommandLine.Option(names={"--use_tls"}, description={"Use tls connection"}, hidden=true)
        protected Boolean deprecatedUseTls;
        @CommandLine.Option(names={"--use-tls"}, description={"Use tls connection"})
        protected boolean useTls;
        @CommandLine.Option(names={"--tls_allow_insecure"}, description={"Allow insecure tls connection"}, hidden=true)
        protected Boolean deprecatedTlsAllowInsecureConnection;
        @CommandLine.Option(names={"--tls-allow-insecure"}, description={"Allow insecure tls connection"})
        protected boolean tlsAllowInsecureConnection;
        @CommandLine.Option(names={"--hostname_verification_enabled"}, description={"Enable hostname verification"}, hidden=true)
        protected Boolean deprecatedTlsHostNameVerificationEnabled;
        @CommandLine.Option(names={"--hostname-verification-enabled"}, description={"Enable hostname verification"})
        protected boolean tlsHostNameVerificationEnabled;
        @CommandLine.Option(names={"--tls_trust_cert_path"}, description={"tls trust cert file path"}, hidden=true)
        protected String deprecatedTlsTrustCertFilePath;
        @CommandLine.Option(names={"--tls-trust-cert-path"}, description={"tls trust cert file path"})
        protected String tlsTrustCertFilePath;
        @CommandLine.Option(names={"--secrets-provider-classname"}, description={"Whats the classname for secrets provider"})
        protected String secretsProviderClassName;
        @CommandLine.Option(names={"--secrets-provider-config"}, description={"Config that needs to be passed to secrets provider"})
        protected String secretsProviderConfig;
        @CommandLine.Option(names={"--metrics-port-start"}, description={"The starting port range for metrics server"})
        protected String metricsPortStart;

        protected LocalSourceRunner() {
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((CharSequence)this.brokerServiceUrl) && !StringUtils.isBlank((CharSequence)this.deprecatedBrokerServiceUrl)) {
                this.brokerServiceUrl = this.deprecatedBrokerServiceUrl;
            }
            if (StringUtils.isBlank((CharSequence)this.clientAuthPlugin) && !StringUtils.isBlank((CharSequence)this.deprecatedClientAuthPlugin)) {
                this.clientAuthPlugin = this.deprecatedClientAuthPlugin;
            }
            if (StringUtils.isBlank((CharSequence)this.clientAuthParams) && !StringUtils.isBlank((CharSequence)this.deprecatedClientAuthParams)) {
                this.clientAuthParams = this.deprecatedClientAuthParams;
            }
            if (!this.useTls && this.deprecatedUseTls != null) {
                this.useTls = this.deprecatedUseTls;
            }
            if (!this.tlsAllowInsecureConnection && this.deprecatedTlsAllowInsecureConnection != null) {
                this.tlsAllowInsecureConnection = this.deprecatedTlsAllowInsecureConnection;
            }
            if (!this.tlsHostNameVerificationEnabled && this.deprecatedTlsHostNameVerificationEnabled != null) {
                this.tlsHostNameVerificationEnabled = this.deprecatedTlsHostNameVerificationEnabled;
            }
            if (StringUtils.isBlank((CharSequence)this.tlsTrustCertFilePath) && !StringUtils.isBlank((CharSequence)this.deprecatedTlsTrustCertFilePath)) {
                this.tlsTrustCertFilePath = this.deprecatedTlsTrustCertFilePath;
            }
        }

        @VisibleForTesting
        List<String> getLocalRunArgs() throws Exception {
            this.mergeArgs();
            LinkedList<String> localRunArgs = new LinkedList<String>();
            localRunArgs.add(System.getenv("PULSAR_HOME") + "/bin/function-localrunner");
            localRunArgs.add("--sourceConfig");
            localRunArgs.add(new Gson().toJson((Object)this.sourceConfig));
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (field.getName().toUpperCase().startsWith("DEPRECATED") || field.getName().contains("$") || (value = field.get(this)) == null) continue;
                localRunArgs.add("--" + field.getName());
                localRunArgs.add(value.toString());
            }
            return localRunArgs;
        }

        @Override
        public void runCmd() throws Exception {
            ProcessBuilder processBuilder = new ProcessBuilder(this.getLocalRunArgs()).inheritIO();
            Process process = processBuilder.start();
            process.waitFor();
        }

        @Override
        protected String validateSourceType(String sourceType) {
            return sourceType;
        }
    }

    @CommandLine.Command(description={"Get the list of Pulsar IO connector sources supported by Pulsar cluster"})
    public class ListBuiltInSources
    extends BaseCommand {
        @Override
        void runCmd() throws Exception {
            CmdSources.this.getAdmin().sources().getBuiltInSources().stream().filter(x -> !StringUtils.isEmpty((CharSequence)x.getSourceClass())).forEach(connector -> {
                System.out.println(connector.getName());
                System.out.println(WordUtils.wrap((String)connector.getDescription(), (int)80));
                System.out.println("----------------------------------------");
            });
        }
    }

    @CommandLine.Command(description={"Reload the available built-in connectors"})
    public class ReloadBuiltInSources
    extends BaseCommand {
        @Override
        void runCmd() throws Exception {
            CmdSources.this.getAdmin().sources().reloadBuiltInSources();
        }
    }

    abstract class SourceCommand
    extends BaseCommand {
        @CommandLine.Option(names={"--tenant"}, description={"The source's tenant"})
        protected String tenant;
        @CommandLine.Option(names={"--namespace"}, description={"The source's namespace"})
        protected String namespace;
        @CommandLine.Option(names={"--name"}, description={"The source's name"})
        protected String sourceName;

        SourceCommand() {
        }

        @Override
        void processArguments() throws Exception {
            super.processArguments();
            if (this.tenant == null) {
                this.tenant = "public";
            }
            if (this.namespace == null) {
                this.namespace = "default";
            }
            if (null == this.sourceName) {
                throw new RuntimeException("You must specify a name for the source");
            }
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getSourceName() {
            return this.sourceName;
        }
    }

    abstract class SourceDetailsCommand
    extends BaseCommand {
        @CommandLine.Option(names={"--tenant"}, description={"The source's tenant"})
        protected String tenant;
        @CommandLine.Option(names={"--namespace"}, description={"The source's namespace"})
        protected String namespace;
        @CommandLine.Option(names={"--name"}, description={"The source's name"})
        protected String name;
        @CommandLine.Option(names={"-t", "--source-type"}, description={"The source's connector provider"})
        protected String sourceType;
        @CommandLine.Option(names={"--processingGuarantees"}, description={"The processing guarantees (aka delivery semantics) applied to the Source"}, hidden=true)
        protected FunctionConfig.ProcessingGuarantees deprecatedProcessingGuarantees;
        @CommandLine.Option(names={"--processing-guarantees"}, description={"The processing guarantees (as known as delivery semantics) applied to the source. A source connector receives messages from external system and writes messages to a Pulsar topic. The '--processing-guarantees' is used to ensure the processing guarantees for writing messages to the Pulsar topic. The available values are `ATLEAST_ONCE`, `ATMOST_ONCE`, `EFFECTIVELY_ONCE`. If it is not specified, `ATLEAST_ONCE` delivery guarantee is used."})
        protected FunctionConfig.ProcessingGuarantees processingGuarantees;
        @CommandLine.Option(names={"-o", "--destinationTopicName"}, description={"The Pulsar topic to which data is sent"}, hidden=true)
        protected String deprecatedDestinationTopicName;
        @CommandLine.Option(names={"--destination-topic-name"}, description={"The Pulsar topic to which data is sent"})
        protected String destinationTopicName;
        @CommandLine.Option(names={"--producer-config"}, description={"The custom producer configuration (as a JSON string)"})
        protected String producerConfig;
        @CommandLine.Option(names={"--batch-builder"}, description={"BatchBuilder provides two types of batch construction methods, DEFAULT and KEY_BASED. The default value is: DEFAULT"})
        protected String batchBuilder;
        @CommandLine.Option(names={"--deserializationClassName"}, description={"The SerDe classname for the source"}, hidden=true)
        protected String deprecatedDeserializationClassName;
        @CommandLine.Option(names={"--deserialization-classname"}, description={"The SerDe classname for the source"})
        protected String deserializationClassName;
        @CommandLine.Option(names={"-st", "--schema-type"}, description={"The schema type (either a builtin schema like 'avro', 'json', etc.. or custom Schema class name to be used to encode messages emitted from the source"})
        protected String schemaType;
        @CommandLine.Option(names={"--parallelism"}, description={"The source's parallelism factor (i.e. the number of source instances to run)"})
        protected Integer parallelism;
        @CommandLine.Option(names={"-a", "--archive"}, description={"The path to the NAR archive for the Source. It also supports url-path [http/https/file (file protocol assumes that file already exists on worker host)] from which worker can download the package."})
        protected String archive;
        @CommandLine.Option(names={"--className"}, description={"The source's class name if archive is file-url-path (file://)"}, hidden=true)
        protected String deprecatedClassName;
        @CommandLine.Option(names={"--classname"}, description={"The source's class name if archive is file-url-path (file://)"})
        protected String className;
        @CommandLine.Option(names={"--sourceConfigFile"}, description={"The path to a YAML config file specifying the source's configuration"}, hidden=true)
        protected String deprecatedSourceConfigFile;
        @CommandLine.Option(names={"--source-config-file"}, description={"The path to a YAML config file specifying the source's configuration"})
        protected String sourceConfigFile;
        @CommandLine.Option(names={"--cpu"}, description={"The CPU (in cores) that needs to be allocated per source instance (applicable only to Docker runtime)"})
        protected Double cpu;
        @CommandLine.Option(names={"--ram"}, description={"The RAM (in bytes) that need to be allocated per source instance (applicable only to the process and Docker runtimes)"})
        protected Long ram;
        @CommandLine.Option(names={"--disk"}, description={"The disk (in bytes) that need to be allocated per source instance (applicable only to Docker runtime)"})
        protected Long disk;
        @CommandLine.Option(names={"--sourceConfig"}, description={"Source config key/values"}, hidden=true)
        protected String deprecatedSourceConfigString;
        @CommandLine.Option(names={"--source-config"}, description={"Source config key/values"})
        protected String sourceConfigString;
        @CommandLine.Option(names={"--batch-source-config"}, description={"Batch source config key/values"})
        protected String batchSourceConfigString;
        @CommandLine.Option(names={"--custom-runtime-options"}, description={"A string that encodes options to customize the runtime, see docs for configured runtime for details"})
        protected String customRuntimeOptions;
        @CommandLine.Option(names={"--secrets"}, description={"The map of secretName to an object that encapsulates how the secret is fetched by the underlying secrets provider"})
        protected String secretsString;
        @CommandLine.Option(names={"--log-topic"}, description={"The topic to which the logs of a Pulsar Sink are produced"})
        protected String logTopic;
        @CommandLine.Option(names={"--runtime-flags"}, description={"Any flags that you want to pass to a runtime (for process & Kubernetes runtime only)."})
        protected String runtimeFlags;
        protected SourceConfig sourceConfig;

        SourceDetailsCommand() {
        }

        private void mergeArgs() {
            if (this.processingGuarantees == null && this.deprecatedProcessingGuarantees != null) {
                this.processingGuarantees = this.deprecatedProcessingGuarantees;
            }
            if (StringUtils.isBlank((CharSequence)this.destinationTopicName) && !StringUtils.isBlank((CharSequence)this.deprecatedDestinationTopicName)) {
                this.destinationTopicName = this.deprecatedDestinationTopicName;
            }
            if (StringUtils.isBlank((CharSequence)this.deserializationClassName) && !StringUtils.isBlank((CharSequence)this.deprecatedDeserializationClassName)) {
                this.deserializationClassName = this.deprecatedDeserializationClassName;
            }
            if (StringUtils.isBlank((CharSequence)this.className) && !StringUtils.isBlank((CharSequence)this.deprecatedClassName)) {
                this.className = this.deprecatedClassName;
            }
            if (StringUtils.isBlank((CharSequence)this.sourceConfigFile) && !StringUtils.isBlank((CharSequence)this.deprecatedSourceConfigFile)) {
                this.sourceConfigFile = this.deprecatedSourceConfigFile;
            }
            if (StringUtils.isBlank((CharSequence)this.sourceConfigString) && !StringUtils.isBlank((CharSequence)this.deprecatedSourceConfigString)) {
                this.sourceConfigString = this.deprecatedSourceConfigString;
            }
        }

        @Override
        void processArguments() throws Exception {
            super.processArguments();
            this.mergeArgs();
            this.sourceConfig = null != this.sourceConfigFile ? CmdUtils.loadConfig(this.sourceConfigFile, SourceConfig.class) : new SourceConfig();
            if (null != this.tenant) {
                this.sourceConfig.setTenant(this.tenant);
            }
            if (null != this.namespace) {
                this.sourceConfig.setNamespace(this.namespace);
            }
            if (null != this.name) {
                this.sourceConfig.setName(this.name);
            }
            if (null != this.className) {
                this.sourceConfig.setClassName(this.className);
            }
            if (null != this.destinationTopicName) {
                this.sourceConfig.setTopicName(this.destinationTopicName);
            }
            if (null != this.producerConfig) {
                Type type = new TypeToken<ProducerConfig>(){}.getType();
                this.sourceConfig.setProducerConfig((ProducerConfig)new Gson().fromJson(this.producerConfig, type));
            }
            if (null != this.deserializationClassName) {
                this.sourceConfig.setSerdeClassName(this.deserializationClassName);
            }
            if (null != this.schemaType) {
                this.sourceConfig.setSchemaType(this.schemaType);
            }
            if (null != this.batchBuilder) {
                this.sourceConfig.setBatchBuilder(this.batchBuilder);
            }
            if (null != this.processingGuarantees) {
                this.sourceConfig.setProcessingGuarantees(this.processingGuarantees);
            }
            if (this.parallelism != null) {
                this.sourceConfig.setParallelism(this.parallelism);
            }
            if (this.archive != null && (this.sourceType != null || this.sourceConfig.getSourceType() != null)) {
                throw new CliCommand.ParameterException("Cannot specify both archive and source-type");
            }
            if (this.archive != null) {
                this.sourceConfig.setArchive(this.archive);
            }
            if (this.sourceType != null) {
                this.sourceConfig.setArchive(this.validateSourceType(this.sourceType));
            } else if (this.sourceConfig.getSourceType() != null) {
                this.sourceConfig.setArchive(this.validateSourceType(this.sourceConfig.getSourceType()));
            }
            Resources resources = this.sourceConfig.getResources();
            if (this.cpu != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setCpu(this.cpu);
            }
            if (this.ram != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setRam(this.ram);
            }
            if (this.disk != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setDisk(this.disk);
            }
            if (resources != null) {
                this.sourceConfig.setResources(resources);
            }
            try {
                if (null != this.sourceConfigString) {
                    this.sourceConfig.setConfigs(this.parseConfigs(this.sourceConfigString));
                }
            }
            catch (Exception ex) {
                throw new CliCommand.ParameterException("Cannot parse source-config", ex);
            }
            if (null != this.batchSourceConfigString) {
                this.sourceConfig.setBatchSourceConfig(this.parseBatchSourceConfigs(this.batchSourceConfigString));
            }
            if (this.customRuntimeOptions != null) {
                this.sourceConfig.setCustomRuntimeOptions(this.customRuntimeOptions);
            }
            if (this.secretsString != null) {
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map secretsMap = (Map)new Gson().fromJson(this.secretsString, type);
                if (secretsMap == null) {
                    secretsMap = Collections.emptyMap();
                }
                this.sourceConfig.setSecrets(secretsMap);
            }
            if (null != this.logTopic) {
                this.sourceConfig.setLogTopic(this.logTopic);
            }
            if (null != this.runtimeFlags) {
                this.sourceConfig.setRuntimeFlags(this.runtimeFlags);
            }
            this.validateSourceConfigs(this.sourceConfig);
        }

        protected Map<String, Object> parseConfigs(String str) throws JsonProcessingException {
            ObjectMapper mapper = ObjectMapperFactory.getMapper().getObjectMapper();
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            return (Map)mapper.readValue(str, (TypeReference)typeRef);
        }

        protected BatchSourceConfig parseBatchSourceConfigs(String str) {
            return (BatchSourceConfig)new Gson().fromJson(str, BatchSourceConfig.class);
        }

        protected void validateSourceConfigs(SourceConfig sourceConfig) {
            if (StringUtils.isBlank((CharSequence)sourceConfig.getArchive())) {
                throw new CliCommand.ParameterException("Source archive not specified");
            }
            Utils.inferMissingArguments((SourceConfig)sourceConfig);
            if (!(Utils.isFunctionPackageUrlSupported((String)sourceConfig.getArchive()) || sourceConfig.getArchive().startsWith("builtin") || new File(sourceConfig.getArchive()).exists())) {
                throw new IllegalArgumentException(String.format("Source Archive %s does not exist", sourceConfig.getArchive()));
            }
            if (StringUtils.isBlank((CharSequence)sourceConfig.getName())) {
                throw new IllegalArgumentException("Source name not specified");
            }
            if (sourceConfig.getBatchSourceConfig() != null) {
                this.validateBatchSourceConfigs(sourceConfig.getBatchSourceConfig());
            }
        }

        protected void validateBatchSourceConfigs(BatchSourceConfig batchSourceConfig) {
            if (StringUtils.isBlank((CharSequence)batchSourceConfig.getDiscoveryTriggererClassName())) {
                throw new IllegalArgumentException("Discovery Triggerer not specified");
            }
        }

        protected String validateSourceType(String sourceType) throws IOException {
            Set availableSources;
            try {
                availableSources = CmdSources.this.getAdmin().sources().getBuiltInSources().stream().map(ConnectorDefinition::getName).collect(Collectors.toSet());
            }
            catch (PulsarAdminException e) {
                throw new IOException(e);
            }
            if (!availableSources.contains(sourceType)) {
                throw new CliCommand.ParameterException("Invalid source type '" + sourceType + "' -- Available sources are: " + availableSources);
            }
            return "builtin://" + sourceType;
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            this.processArguments();
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

