/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.IOUtils;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToIntegerConverter;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToLongConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToMillisConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToSecondsConverter;
import org.apache.pulsar.client.admin.ListNamespaceTopicsOptions;
import org.apache.pulsar.client.admin.Mode;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TopicType;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about namespaces"})
public class CmdNamespaces
extends CmdBase {
    public CmdNamespaces(Supplier<PulsarAdmin> admin) {
        super("namespaces", admin);
        this.addCommand("list", new GetNamespacesPerProperty());
        this.addCommand("list-cluster", new GetNamespacesPerCluster());
        this.addCommand("topics", new GetTopics());
        this.addCommand("bundles", new GetBundles());
        this.addCommand("destinations", new GetDestinations());
        this.addCommand("policies", new GetPolicies());
        this.addCommand("create", new Create());
        this.addCommand("delete", new Delete());
        this.addCommand("permissions", new Permissions());
        this.addCommand("grant-permission", new GrantPermissions());
        this.addCommand("revoke-permission", new RevokePermissions());
        this.addCommand("subscription-permission", new SubscriptionPermissions());
        this.addCommand("grant-subscription-permission", new GrantSubscriptionPermissions());
        this.addCommand("revoke-subscription-permission", new RevokeSubscriptionPermissions());
        this.addCommand("set-clusters", new SetReplicationClusters());
        this.addCommand("get-clusters", new GetReplicationClusters());
        this.addCommand("set-subscription-types-enabled", new SetSubscriptionTypesEnabled());
        this.addCommand("get-subscription-types-enabled", new GetSubscriptionTypesEnabled());
        this.addCommand("remove-subscription-types-enabled", new RemoveSubscriptionTypesEnabled());
        this.addCommand("get-backlog-quotas", new GetBacklogQuotaMap());
        this.addCommand("set-backlog-quota", new SetBacklogQuota());
        this.addCommand("remove-backlog-quota", new RemoveBacklogQuota());
        this.addCommand("get-persistence", new GetPersistence());
        this.addCommand("set-persistence", new SetPersistence());
        this.addCommand("remove-persistence", new RemovePersistence());
        this.addCommand("get-message-ttl", new GetMessageTTL());
        this.addCommand("set-message-ttl", new SetMessageTTL());
        this.addCommand("remove-message-ttl", new RemoveMessageTTL());
        this.addCommand("get-max-subscriptions-per-topic", new GetMaxSubscriptionsPerTopic());
        this.addCommand("set-max-subscriptions-per-topic", new SetMaxSubscriptionsPerTopic());
        this.addCommand("remove-max-subscriptions-per-topic", new RemoveMaxSubscriptionsPerTopic());
        this.addCommand("get-subscription-expiration-time", new GetSubscriptionExpirationTime());
        this.addCommand("set-subscription-expiration-time", new SetSubscriptionExpirationTime());
        this.addCommand("remove-subscription-expiration-time", new RemoveSubscriptionExpirationTime());
        this.addCommand("get-anti-affinity-group", new GetAntiAffinityGroup());
        this.addCommand("set-anti-affinity-group", new SetAntiAffinityGroup());
        this.addCommand("get-anti-affinity-namespaces", new GetAntiAffinityNamespaces());
        this.addCommand("delete-anti-affinity-group", new DeleteAntiAffinityGroup());
        this.addCommand("set-deduplication", new SetDeduplication());
        this.addCommand("get-deduplication", new GetDeduplication());
        this.addCommand("remove-deduplication", new RemoveDeduplication());
        this.addCommand("set-auto-topic-creation", new SetAutoTopicCreation());
        this.addCommand("get-auto-topic-creation", new GetAutoTopicCreation());
        this.addCommand("remove-auto-topic-creation", new RemoveAutoTopicCreation());
        this.addCommand("set-auto-subscription-creation", new SetAutoSubscriptionCreation());
        this.addCommand("get-auto-subscription-creation", new GetAutoSubscriptionCreation());
        this.addCommand("remove-auto-subscription-creation", new RemoveAutoSubscriptionCreation());
        this.addCommand("get-retention", new GetRetention());
        this.addCommand("set-retention", new SetRetention());
        this.addCommand("remove-retention", new RemoveRetention());
        this.addCommand("set-bookie-affinity-group", new SetBookieAffinityGroup());
        this.addCommand("get-bookie-affinity-group", new GetBookieAffinityGroup());
        this.addCommand("delete-bookie-affinity-group", new DeleteBookieAffinityGroup());
        this.addCommand("unload", new Unload());
        this.addCommand("split-bundle", new SplitBundle());
        this.addCommand("get-topic-positions", new GetTopicHashPositions());
        this.addCommand("set-dispatch-rate", new SetDispatchRate());
        this.addCommand("remove-dispatch-rate", new RemoveDispatchRate());
        this.addCommand("get-dispatch-rate", new GetDispatchRate());
        this.addCommand("set-subscribe-rate", new SetSubscribeRate());
        this.addCommand("get-subscribe-rate", new GetSubscribeRate());
        this.addCommand("remove-subscribe-rate", new RemoveSubscribeRate());
        this.addCommand("set-subscription-dispatch-rate", new SetSubscriptionDispatchRate());
        this.addCommand("get-subscription-dispatch-rate", new GetSubscriptionDispatchRate());
        this.addCommand("remove-subscription-dispatch-rate", new RemoveSubscriptionDispatchRate());
        this.addCommand("set-publish-rate", new SetPublishRate());
        this.addCommand("get-publish-rate", new GetPublishRate());
        this.addCommand("remove-publish-rate", new RemovePublishRate());
        this.addCommand("set-replicator-dispatch-rate", new SetReplicatorDispatchRate());
        this.addCommand("get-replicator-dispatch-rate", new GetReplicatorDispatchRate());
        this.addCommand("remove-replicator-dispatch-rate", new RemoveReplicatorDispatchRate());
        this.addCommand("clear-backlog", new ClearBacklog());
        this.addCommand("unsubscribe", new Unsubscribe());
        this.addCommand("set-encryption-required", new SetEncryptionRequired());
        this.addCommand("get-encryption-required", new GetEncryptionRequired());
        this.addCommand("set-subscription-auth-mode", new SetSubscriptionAuthMode());
        this.addCommand("get-subscription-auth-mode", new GetSubscriptionAuthMode());
        this.addCommand("set-delayed-delivery", new SetDelayedDelivery());
        this.addCommand("get-delayed-delivery", new GetDelayedDelivery());
        this.addCommand("remove-delayed-delivery", new RemoveDelayedDelivery());
        this.addCommand("get-inactive-topic-policies", new GetInactiveTopicPolicies());
        this.addCommand("set-inactive-topic-policies", new SetInactiveTopicPolicies());
        this.addCommand("remove-inactive-topic-policies", new RemoveInactiveTopicPolicies());
        this.addCommand("get-max-producers-per-topic", new GetMaxProducersPerTopic());
        this.addCommand("set-max-producers-per-topic", new SetMaxProducersPerTopic());
        this.addCommand("remove-max-producers-per-topic", new RemoveMaxProducersPerTopic());
        this.addCommand("get-max-consumers-per-topic", new GetMaxConsumersPerTopic());
        this.addCommand("set-max-consumers-per-topic", new SetMaxConsumersPerTopic());
        this.addCommand("remove-max-consumers-per-topic", new RemoveMaxConsumersPerTopic());
        this.addCommand("get-max-consumers-per-subscription", new GetMaxConsumersPerSubscription());
        this.addCommand("set-max-consumers-per-subscription", new SetMaxConsumersPerSubscription());
        this.addCommand("remove-max-consumers-per-subscription", new RemoveMaxConsumersPerSubscription());
        this.addCommand("get-max-unacked-messages-per-subscription", new GetMaxUnackedMessagesPerSubscription());
        this.addCommand("set-max-unacked-messages-per-subscription", new SetMaxUnackedMessagesPerSubscription());
        this.addCommand("remove-max-unacked-messages-per-subscription", new RemoveMaxUnackedMessagesPerSubscription());
        this.addCommand("get-max-unacked-messages-per-consumer", new GetMaxUnackedMessagesPerConsumer());
        this.addCommand("set-max-unacked-messages-per-consumer", new SetMaxUnackedMessagesPerConsumer());
        this.addCommand("remove-max-unacked-messages-per-consumer", new RemoveMaxUnackedMessagesPerConsumer());
        this.addCommand("get-compaction-threshold", new GetCompactionThreshold());
        this.addCommand("set-compaction-threshold", new SetCompactionThreshold());
        this.addCommand("remove-compaction-threshold", new RemoveCompactionThreshold());
        this.addCommand("get-offload-threshold", new GetOffloadThreshold());
        this.addCommand("set-offload-threshold", new SetOffloadThreshold());
        this.addCommand("get-offload-deletion-lag", new GetOffloadDeletionLag());
        this.addCommand("set-offload-deletion-lag", new SetOffloadDeletionLag());
        this.addCommand("clear-offload-deletion-lag", new ClearOffloadDeletionLag());
        this.addCommand("get-schema-autoupdate-strategy", new GetSchemaAutoUpdateStrategy());
        this.addCommand("set-schema-autoupdate-strategy", new SetSchemaAutoUpdateStrategy());
        this.addCommand("get-schema-compatibility-strategy", new GetSchemaCompatibilityStrategy());
        this.addCommand("set-schema-compatibility-strategy", new SetSchemaCompatibilityStrategy());
        this.addCommand("get-is-allow-auto-update-schema", new GetIsAllowAutoUpdateSchema());
        this.addCommand("set-is-allow-auto-update-schema", new SetIsAllowAutoUpdateSchema());
        this.addCommand("get-schema-validation-enforce", new GetSchemaValidationEnforced());
        this.addCommand("set-schema-validation-enforce", new SetSchemaValidationEnforced());
        this.addCommand("set-offload-policies", new SetOffloadPolicies());
        this.addCommand("remove-offload-policies", new RemoveOffloadPolicies());
        this.addCommand("get-offload-policies", new GetOffloadPolicies());
        this.addCommand("set-deduplication-snapshot-interval", new SetDeduplicationSnapshotInterval());
        this.addCommand("get-deduplication-snapshot-interval", new GetDeduplicationSnapshotInterval());
        this.addCommand("remove-deduplication-snapshot-interval", new RemoveDeduplicationSnapshotInterval());
        this.addCommand("set-max-topics-per-namespace", new SetMaxTopicsPerNamespace());
        this.addCommand("get-max-topics-per-namespace", new GetMaxTopicsPerNamespace());
        this.addCommand("remove-max-topics-per-namespace", new RemoveMaxTopicsPerNamespace());
        this.addCommand("set-property", new SetPropertyForNamespace());
        this.addCommand("get-property", new GetPropertyForNamespace());
        this.addCommand("remove-property", new RemovePropertyForNamespace());
        this.addCommand("set-properties", new SetPropertiesForNamespace());
        this.addCommand("get-properties", new GetPropertiesForNamespace());
        this.addCommand("clear-properties", new ClearPropertiesForNamespace());
        this.addCommand("get-resource-group", new GetResourceGroup());
        this.addCommand("set-resource-group", new SetResourceGroup());
        this.addCommand("remove-resource-group", new RemoveResourceGroup());
        this.addCommand("get-entry-filters", new GetEntryFiltersPerTopic());
        this.addCommand("set-entry-filters", new SetEntryFiltersPerTopic());
        this.addCommand("remove-entry-filters", new RemoveEntryFiltersPerTopic());
        this.addCommand("update-migration-state", new UpdateMigrationState());
        this.addCommand("set-dispatcher-pause-on-ack-state-persistent", new SetDispatcherPauseOnAckStatePersistent());
        this.addCommand("get-dispatcher-pause-on-ack-state-persistent", new GetDispatcherPauseOnAckStatePersistent());
        this.addCommand("remove-dispatcher-pause-on-ack-state-persistent", new RemoveDispatcherPauseOnAckStatePersistent());
    }

    @CommandLine.Command(description={"Get the namespaces for a tenant"})
    private class GetNamespacesPerProperty
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant-name"}, arity="1")
        private String tenant;

        private GetNamespacesPerProperty() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaces(this.tenant));
        }
    }

    @CommandLine.Command(description={"Get the namespaces for a tenant in a cluster"}, hidden=true)
    private class GetNamespacesPerCluster
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/cluster"}, arity="1")
        private String params;

        private GetNamespacesPerCluster() {
        }

        @Override
        void run() throws PulsarAdminException {
            String[] parts = GetNamespacesPerCluster.validatePropertyCluster(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaces(parts[0], parts[1]));
        }
    }

    @CommandLine.Command(description={"Get the list of topics for a namespace"})
    private class GetTopics
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-m", "--mode"}, description={"Allowed topic domain mode (persistent, non_persistent, all)."})
        private Mode mode;
        @CommandLine.Option(names={"-ist", "--include-system-topic"}, description={"Include system topic"})
        private boolean includeSystemTopic;

        private GetTopics() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetTopics.validateNamespace(this.namespaceName);
            ListNamespaceTopicsOptions options = ListNamespaceTopicsOptions.builder().mode(this.mode).includeSystemTopic(this.includeSystemTopic).build();
            this.print(CmdNamespaces.this.getAdmin().namespaces().getTopics(namespace, options));
        }
    }

    @CommandLine.Command(description={"Get the list of bundles for a namespace"})
    private class GetBundles
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetBundles() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetBundles.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getBundles(namespace));
        }
    }

    @CommandLine.Command(description={"Get the list of destinations for a namespace"}, hidden=true)
    private class GetDestinations
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetDestinations() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDestinations.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getTopics(namespace));
        }
    }

    @CommandLine.Command(description={"Get the configuration policies of a namespace"})
    private class GetPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetPolicies.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPolicies(namespace));
        }
    }

    @CommandLine.Command(description={"Creates a new namespace"})
    private class Create
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--clusters", "-c"}, description={"List of clusters this namespace will be assigned"}, required=false, split=",")
        private List<String> clusters;
        @CommandLine.Option(names={"--bundles", "-b"}, description={"number of bundles to activate"}, required=false)
        private int numBundles = 0;
        private static final long MAX_BUNDLES = 0x100000000L;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Create.validateNamespace(this.namespaceName);
            if (this.numBundles < 0 || (long)this.numBundles > 0x100000000L) {
                throw new CliCommand.ParameterException("Invalid number of bundles. Number of bundles has to be in the range of (0, 2^32].");
            }
            NamespaceName namespaceName = NamespaceName.get((String)namespace);
            if (namespaceName.isV2()) {
                Policies policies = new Policies();
                BundlesData bundlesData = policies.bundles = this.numBundles > 0 ? BundlesData.builder().numBundles(this.numBundles).build() : null;
                if (this.clusters != null) {
                    policies.replication_clusters = new HashSet<String>(this.clusters);
                }
                CmdNamespaces.this.getAdmin().namespaces().createNamespace(namespace, policies);
            } else {
                if (this.numBundles == 0) {
                    CmdNamespaces.this.getAdmin().namespaces().createNamespace(namespace);
                } else {
                    CmdNamespaces.this.getAdmin().namespaces().createNamespace(namespace, this.numBundles);
                }
                if (this.clusters != null && !this.clusters.isEmpty()) {
                    CmdNamespaces.this.getAdmin().namespaces().setNamespaceReplicationClusters(namespace, new HashSet<String>(this.clusters));
                }
            }
        }
    }

    @CommandLine.Command(description={"Deletes a namespace."})
    private class Delete
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-f", "--force"}, description={"Delete namespace forcefully by force deleting all topics under it"})
        private boolean force = false;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Delete.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().deleteNamespace(namespace, this.force);
        }
    }

    @CommandLine.Command(description={"Get the permissions on a namespace"})
    private class Permissions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private Permissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Permissions.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPermissions(namespace));
        }
    }

    @CommandLine.Command(description={"Grant permissions on a namespace"})
    private class GrantPermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--role"}, description={"Client role to which grant permissions"}, required=true)
        private String role;
        @CommandLine.Option(names={"--actions"}, description={"Actions to be granted (produce,consume,sources,sinks,functions,packages)"}, required=true, split=",")
        private List<String> actions;

        private GrantPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GrantPermissions.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().grantPermissionOnNamespace(namespace, this.role, this.getAuthActions(this.actions));
        }
    }

    @CommandLine.Command(description={"Revoke permissions on a namespace"})
    private class RevokePermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--role"}, description={"Client role to which revoke permissions"}, required=true)
        private String role;

        private RevokePermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RevokePermissions.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().revokePermissionsOnNamespace(namespace, this.role);
        }
    }

    @CommandLine.Command(description={"Get permissions to access subscription admin-api"})
    private class SubscriptionPermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private SubscriptionPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SubscriptionPermissions.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPermissionOnSubscription(namespace));
        }
    }

    @CommandLine.Command(description={"Grant permissions to access subscription admin-api"})
    private class GrantSubscriptionPermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription name for which permission will be granted to roles"}, required=true)
        private String subscription;
        @CommandLine.Option(names={"-rs", "--roles"}, description={"Client roles to which grant permissions (comma separated roles)"}, required=true, split=",")
        private List<String> roles;

        private GrantSubscriptionPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GrantSubscriptionPermissions.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().grantPermissionOnSubscription(namespace, this.subscription, (Set)Sets.newHashSet(this.roles));
        }
    }

    @CommandLine.Command(description={"Revoke permissions to access subscription admin-api"})
    private class RevokeSubscriptionPermissions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-s", "--subscription"}, description={"Subscription name for which permission will be revoked to roles"}, required=true)
        private String subscription;
        @CommandLine.Option(names={"-r", "--role"}, description={"Client role to which revoke permissions"}, required=true)
        private String role;

        private RevokeSubscriptionPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RevokeSubscriptionPermissions.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().revokePermissionOnSubscription(namespace, this.subscription, this.role);
        }
    }

    @CommandLine.Command(description={"Set replication clusters for a namespace"})
    private class SetReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--clusters", "-c"}, description={"Replication Cluster Ids list (comma separated values)"}, required=true)
        private String clusterIds;

        private SetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetReplicationClusters.validateNamespace(this.namespaceName);
            ArrayList clusters = Lists.newArrayList((Object[])this.clusterIds.split(","));
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceReplicationClusters(namespace, (Set)Sets.newHashSet((Iterable)clusters));
        }
    }

    @CommandLine.Command(description={"Get replication clusters for a namespace"})
    private class GetReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetReplicationClusters.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceReplicationClusters(namespace));
        }
    }

    @CommandLine.Command(description={"Set subscription types enabled for a namespace"})
    private class SetSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--types", "-t"}, description={"Subscription types enabled list (comma separated values). Possible values: (Exclusive, Shared, Failover, Key_Shared)."}, required=true, split=",")
        private List<String> subTypes;

        private SetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscriptionTypesEnabled.validateNamespace(this.namespaceName);
            HashSet types = new HashSet();
            this.subTypes.forEach(s -> {
                SubscriptionType subType;
                try {
                    subType = SubscriptionType.valueOf((String)s);
                }
                catch (IllegalArgumentException exception) {
                    throw new CliCommand.ParameterException(String.format("Illegal subscription type %s. Possible values: %s.", s, Arrays.toString(SubscriptionType.values())));
                }
                types.add(subType);
            });
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionTypesEnabled(namespace, types);
        }
    }

    @CommandLine.Command(description={"Get subscription types enabled for a namespace"})
    private class GetSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionTypesEnabled.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionTypesEnabled(namespace));
        }
    }

    @CommandLine.Command(description={"Remove subscription types enabled for a namespace"})
    private class RemoveSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscriptionTypesEnabled.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscriptionTypesEnabled(namespace);
        }
    }

    @CommandLine.Command(description={"Get the backlog quota policies for a namespace"})
    private class GetBacklogQuotaMap
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetBacklogQuotaMap.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getBacklogQuotaMap(namespace));
        }
    }

    @CommandLine.Command(description={"Set a backlog quota policy for a namespace"})
    private class SetBacklogQuota
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-l", "--limit"}, description={"Size limit (eg: 10M, 16G)"}, converter={ByteUnitToLongConverter.class})
        private Long limit;
        @CommandLine.Option(names={"-lt", "--limitTime"}, description={"Time limit in second (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), non-positive number for disabling time limit."}, converter={TimeUnitToSecondsConverter.class})
        private Long limitTimeInSec;
        @CommandLine.Option(names={"-p", "--policy"}, description={"Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]"}, required=true)
        private String policyStr;
        @CommandLine.Option(names={"-t", "--type"}, description={"Backlog quota type to set. Valid options are: destination_storage (default) and message_age. destination_storage limits backlog by size. message_age limits backlog by time, that is, message timestamp (broker or publish timestamp). You can set size or time to control the backlog, or combine them together to control the backlog. "})
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            String namespace = SetBacklogQuota.validateNamespace(this.namespaceName);
            BacklogQuota.Builder builder = BacklogQuota.builder().retentionPolicy(policy);
            if (backlogQuotaType == BacklogQuota.BacklogQuotaType.destination_storage) {
                if (this.limit == null) {
                    throw new CliCommand.ParameterException("Quota type of 'destination_storage' needs a size limit");
                }
                builder.limitSize(this.limit.longValue());
            } else {
                if (this.limitTimeInSec == null) {
                    throw new CliCommand.ParameterException("Quota type of 'message_age' needs a time limit");
                }
                builder.limitTime(this.limitTimeInSec.intValue());
            }
            CmdNamespaces.this.getAdmin().namespaces().setBacklogQuota(namespace, builder.build(), backlogQuotaType);
        }
    }

    @CommandLine.Command(description={"Remove a backlog quota policy from a namespace"})
    private class RemoveBacklogQuota
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-t", "--type"}, description={"Backlog quota type to remove. Valid options are: destination_storage, message_age"})
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            String namespace = RemoveBacklogQuota.validateNamespace(this.namespaceName);
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            CmdNamespaces.this.getAdmin().namespaces().removeBacklogQuota(namespace, backlogQuotaType);
        }
    }

    @CommandLine.Command(description={"Get the persistence policies for a namespace"})
    private class GetPersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetPersistence.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPersistence(namespace));
        }
    }

    @CommandLine.Command(description={"Set the persistence policies for a namespace"})
    private class SetPersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-e", "--bookkeeper-ensemble"}, description={"Number of bookies to use for a topic"})
        private int bookkeeperEnsemble = 2;
        @CommandLine.Option(names={"-w", "--bookkeeper-write-quorum"}, description={"How many writes to make of each entry"})
        private int bookkeeperWriteQuorum = 2;
        @CommandLine.Option(names={"-a", "--bookkeeper-ack-quorum"}, description={"Number of acks (guaranteed copies) to wait for each entry"})
        private int bookkeeperAckQuorum = 2;
        @CommandLine.Option(names={"-r", "--ml-mark-delete-max-rate"}, description={"Throttling rate of mark-delete operation (0 means no throttle)"})
        private double managedLedgerMaxMarkDeleteRate = 0.0;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetPersistence.validateNamespace(this.namespaceName);
            if (this.bookkeeperEnsemble <= 0 || this.bookkeeperWriteQuorum <= 0 || this.bookkeeperAckQuorum <= 0) {
                throw new CliCommand.ParameterException("[--bookkeeper-ensemble], [--bookkeeper-write-quorum] and [--bookkeeper-ack-quorum] must greater than 0.");
            }
            if (this.managedLedgerMaxMarkDeleteRate < 0.0) {
                throw new CliCommand.ParameterException("[--ml-mark-delete-max-rate] cannot less than 0.");
            }
            CmdNamespaces.this.getAdmin().namespaces().setPersistence(namespace, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate));
        }
    }

    @CommandLine.Command(description={"Remove the persistence policies for a namespace"})
    private class RemovePersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemovePersistence.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removePersistence(namespace);
        }
    }

    @CommandLine.Command(description={"Get message TTL for a namespace"})
    private class GetMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMessageTTL.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceMessageTTL(namespace));
        }
    }

    @CommandLine.Command(description={"Set Message TTL for a namespace"})
    private class SetMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--messageTTL", "-ttl"}, description={"Message TTL in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w). When the value is set to `0`, TTL is disabled."}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long messageTTLInSecond;

        private SetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMessageTTL.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceMessageTTL(namespace, this.messageTTLInSecond.intValue());
        }
    }

    @CommandLine.Command(description={"Remove Message TTL for a namespace"})
    private class RemoveMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMessageTTL.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeNamespaceMessageTTL(namespace);
        }
    }

    @CommandLine.Command(description={"Get max subscriptions per topic for a namespace"})
    private class GetMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxSubscriptionsPerTopic.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxSubscriptionsPerTopic(namespace));
        }
    }

    @CommandLine.Command(description={"Set max subscriptions per topic for a namespace"})
    private class SetMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-subscriptions-per-topic", "-m"}, description={"Max subscriptions per topic"}, required=true)
        private int maxSubscriptionsPerTopic;

        private SetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxSubscriptionsPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxSubscriptionsPerTopic(namespace, this.maxSubscriptionsPerTopic);
        }
    }

    @CommandLine.Command(description={"Remove max subscriptions per topic for a namespace"})
    private class RemoveMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxSubscriptionsPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxSubscriptionsPerTopic(namespace);
        }
    }

    @CommandLine.Command(description={"Get subscription expiration time for a namespace"})
    private class GetSubscriptionExpirationTime
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSubscriptionExpirationTime() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionExpirationTime.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionExpirationTime(namespace));
        }
    }

    @CommandLine.Command(description={"Set subscription expiration time for a namespace"})
    private class SetSubscriptionExpirationTime
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-t", "--time"}, description={"Subscription expiration time in minutes"}, required=true)
        private int expirationTime;

        private SetSubscriptionExpirationTime() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscriptionExpirationTime.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionExpirationTime(namespace, this.expirationTime);
        }
    }

    @CommandLine.Command(description={"Remove subscription expiration time for a namespace"})
    private class RemoveSubscriptionExpirationTime
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveSubscriptionExpirationTime() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscriptionExpirationTime.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscriptionExpirationTime(namespace);
        }
    }

    @CommandLine.Command(description={"Get Anti-affinity group name for a namespace"})
    private class GetAntiAffinityGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetAntiAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetAntiAffinityGroup.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceAntiAffinityGroup(namespace));
        }
    }

    @CommandLine.Command(description={"Set Anti-affinity group name for a namespace"})
    private class SetAntiAffinityGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--group", "-g"}, description={"Anti-affinity group name"}, required=true)
        private String antiAffinityGroup;

        private SetAntiAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetAntiAffinityGroup.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceAntiAffinityGroup(namespace, this.antiAffinityGroup);
        }
    }

    @CommandLine.Command(description={"Get Anti-affinity namespaces grouped with the given anti-affinity group name"})
    private class GetAntiAffinityNamespaces
    extends CliCommand {
        @CommandLine.Option(names={"--tenant", "-p"}, description={"tenant is only used for authorization. Client has to be admin of any of the tenant to access this api"}, required=false)
        private String tenant;
        @CommandLine.Option(names={"--cluster", "-c"}, description={"Cluster name"}, required=true)
        private String cluster;
        @CommandLine.Option(names={"--group", "-g"}, description={"Anti-affinity group name"}, required=true)
        private String antiAffinityGroup;

        private GetAntiAffinityNamespaces() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdNamespaces.this.getAdmin().namespaces().getAntiAffinityNamespaces(this.tenant, this.cluster, this.antiAffinityGroup));
        }
    }

    @CommandLine.Command(description={"Remove Anti-affinity group name for a namespace"})
    private class DeleteAntiAffinityGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private DeleteAntiAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = DeleteAntiAffinityGroup.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().deleteNamespaceAntiAffinityGroup(namespace);
        }
    }

    @CommandLine.Command(description={"Enable or disable deduplication for a namespace"})
    private class SetDeduplication
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable deduplication"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable deduplication"})
        private boolean disable = false;

        private SetDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDeduplication.validateNamespace(this.namespaceName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setDeduplicationStatus(namespace, this.enable);
        }
    }

    @CommandLine.Command(description={"Get Deduplication for a namespace"})
    private class GetDeduplication
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDeduplication.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDeduplicationStatus(namespace));
        }
    }

    @CommandLine.Command(description={"Remove Deduplication for a namespace"})
    private class RemoveDeduplication
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDeduplication.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeDeduplicationStatus(namespace);
        }
    }

    @CommandLine.Command(description={"Enable or disable autoTopicCreation for a namespace, overriding broker settings"})
    private class SetAutoTopicCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable allowAutoTopicCreation on namespace"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable allowAutoTopicCreation on namespace"})
        private boolean disable = false;
        @CommandLine.Option(names={"--type", "-t"}, description={"Type of topic to be auto-created. Possible values: (partitioned, non-partitioned). Default value: non-partitioned"})
        private String type = "non-partitioned";
        @CommandLine.Option(names={"--num-partitions", "-n"}, description={"Default number of partitions of topic to be auto-created, applicable to partitioned topics only"}, required=false)
        private Integer defaultNumPartitions = null;

        private SetAutoTopicCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetAutoTopicCreation.validateNamespace(this.namespaceName);
            this.type = this.type.toLowerCase().trim();
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            if (this.enable) {
                if (!TopicType.isValidTopicType((String)this.type)) {
                    throw new CliCommand.ParameterException("Must specify type of topic to be created. Possible values: (partitioned, non-partitioned)");
                }
                if (TopicType.PARTITIONED.toString().equals(this.type) && (this.defaultNumPartitions == null || this.defaultNumPartitions <= 0)) {
                    throw new CliCommand.ParameterException("Must specify num-partitions or num-partitions > 0 for partitioned topic type.");
                }
            }
            CmdNamespaces.this.getAdmin().namespaces().setAutoTopicCreation(namespace, AutoTopicCreationOverride.builder().allowAutoTopicCreation(this.enable).topicType(this.type).defaultNumPartitions(this.defaultNumPartitions).build());
        }
    }

    @CommandLine.Command(description={"Get autoTopicCreation info for a namespace"})
    private class GetAutoTopicCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetAutoTopicCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetAutoTopicCreation.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getAutoTopicCreation(namespace));
        }
    }

    @CommandLine.Command(description={"Remove override of autoTopicCreation for a namespace"})
    private class RemoveAutoTopicCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveAutoTopicCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveAutoTopicCreation.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeAutoTopicCreation(namespace);
        }
    }

    @CommandLine.Command(description={"Enable autoSubscriptionCreation for a namespace, overriding broker settings"})
    private class SetAutoSubscriptionCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable allowAutoSubscriptionCreation on namespace"})
        private boolean enable = false;

        private SetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetAutoSubscriptionCreation.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setAutoSubscriptionCreation(namespace, AutoSubscriptionCreationOverride.builder().allowAutoSubscriptionCreation(this.enable).build());
        }
    }

    @CommandLine.Command(description={"Get the autoSubscriptionCreation for a namespace"})
    private class GetAutoSubscriptionCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetAutoSubscriptionCreation.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getAutoSubscriptionCreation(namespace));
        }
    }

    @CommandLine.Command(description={"Remove override of autoSubscriptionCreation for a namespace"})
    private class RemoveAutoSubscriptionCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveAutoSubscriptionCreation.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeAutoSubscriptionCreation(namespace);
        }
    }

    @CommandLine.Command(description={"Get the retention policy for a namespace"})
    private class GetRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetRetention.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getRetention(namespace));
        }
    }

    @CommandLine.Command(description={"Set the retention policy for a namespace"})
    private class SetRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--time", "-t"}, description={"Retention time with optional time unit suffix. For example, 100m, 3h, 2d, 5w. If the time unit is not specified, the default unit is seconds. For example, -t 120 sets retention to 2 minutes. 0 means no retention and -1 means infinite time retention."}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long retentionTimeInSec;
        @CommandLine.Option(names={"--size", "-s"}, description={"Retention size limit with optional size unit suffix. For example, 4096, 10M, 16G, 3T.  The size unit suffix character can be k/K, m/M, g/G, or t/T.  If the size unit suffix is not specified, the default unit is bytes. 0 or less than 1MB means no retention and -1 means infinite size retention"}, required=true, converter={ByteUnitToLongConverter.class})
        private Long sizeLimit;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetRetention.validateNamespace(this.namespaceName);
            int retentionTimeInMin = this.retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(this.retentionTimeInSec) : this.retentionTimeInSec.intValue();
            long retentionSizeInMB = this.sizeLimit != -1L ? this.sizeLimit / 0x100000L : this.sizeLimit;
            CmdNamespaces.this.getAdmin().namespaces().setRetention(namespace, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @CommandLine.Command(description={"Remove the retention policy for a namespace"})
    private class RemoveRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveRetention.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeRetention(namespace);
        }
    }

    @CommandLine.Command(description={"Set the bookie-affinity group name"})
    private class SetBookieAffinityGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--primary-group", "-pg"}, description={"Bookie-affinity primary-groups (comma separated) name where namespace messages should be written"}, required=true)
        private String bookieAffinityGroupNamePrimary;
        @CommandLine.Option(names={"--secondary-group", "-sg"}, description={"Bookie-affinity secondary-group (comma separated) name where namespace messages should be written. If you want to verify whether there are enough bookies in groups, use `--secondary-group` flag. Messages in this namespace are stored in secondary groups. If a group does not contain enough bookies, a topic cannot be created."}, required=false)
        private String bookieAffinityGroupNameSecondary;

        private SetBookieAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetBookieAffinityGroup.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setBookieAffinityGroup(namespace, BookieAffinityGroupData.builder().bookkeeperAffinityGroupPrimary(this.bookieAffinityGroupNamePrimary).bookkeeperAffinityGroupSecondary(this.bookieAffinityGroupNameSecondary).build());
        }
    }

    @CommandLine.Command(description={"Get the bookie-affinity group name"})
    private class GetBookieAffinityGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetBookieAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetBookieAffinityGroup.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getBookieAffinityGroup(namespace));
        }
    }

    @CommandLine.Command(description={"Set the bookie-affinity group name"})
    private class DeleteBookieAffinityGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private DeleteBookieAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = DeleteBookieAffinityGroup.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().deleteBookieAffinityGroup(namespace);
        }
    }

    @CommandLine.Command(description={"Unload a namespace from the current serving broker"})
    private class Unload
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary}"})
        private String bundle;
        @CommandLine.Option(names={"--destinationBroker", "-d"}, description={"Target brokerWebServiceAddress to which the bundle has to be allocated to. --destinationBroker cannot be set when --bundle is not specified."})
        private String destinationBroker;

        private Unload() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Unload.validateNamespace(this.namespaceName);
            if (this.bundle == null) {
                if (StringUtils.isNotBlank((CharSequence)this.destinationBroker)) {
                    throw new CliCommand.ParameterException("--destinationBroker cannot be set when --bundle is not specified.");
                }
                CmdNamespaces.this.getAdmin().namespaces().unload(namespace);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().unloadNamespaceBundle(namespace, this.bundle, this.destinationBroker);
            }
        }
    }

    @CommandLine.Command(description={"Split a namespace-bundle from the current serving broker"})
    private class SplitBundle
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary} (mutually exclusive with --bundle-type)"}, required=false)
        private String bundle;
        @CommandLine.Option(names={"--bundle-type", "-bt"}, description={"bundle type (mutually exclusive with --bundle)"}, required=false)
        private Policies.BundleType bundleType;
        @CommandLine.Option(names={"--unload", "-u"}, description={"Unload newly split bundles after splitting old bundle"}, required=false)
        private boolean unload;
        @CommandLine.Option(names={"--split-algorithm-name", "-san"}, description={"Algorithm name for split namespace bundle. Valid options are: [range_equally_divide, topic_count_equally_divide, specified_positions_divide, flow_or_qps_equally_divide]. Use broker side config if absent"}, required=false)
        private String splitAlgorithmName;
        @CommandLine.Option(names={"--split-boundaries", "-sb"}, description={"Specified split boundary for bundle split, will split one bundle to multi bundles only works with specified_positions_divide algorithm"}, required=false)
        private List<Long> splitBoundaries;

        private SplitBundle() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SplitBundle.validateNamespace(this.namespaceName);
            if (StringUtils.isBlank((CharSequence)this.bundle) && this.bundleType == null) {
                throw new CliCommand.ParameterException("Must pass one of the params: --bundle / --bundle-type");
            }
            if (StringUtils.isNotBlank((CharSequence)this.bundle) && this.bundleType != null) {
                throw new CliCommand.ParameterException("--bundle and --bundle-type are mutually exclusive");
            }
            String string = this.bundle = this.bundleType != null ? this.bundleType.toString() : this.bundle;
            if (this.splitBoundaries == null || this.splitBoundaries.size() == 0) {
                CmdNamespaces.this.getAdmin().namespaces().splitNamespaceBundle(namespace, this.bundle, this.unload, this.splitAlgorithmName);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().splitNamespaceBundle(namespace, this.bundle, this.unload, this.splitAlgorithmName, this.splitBoundaries);
            }
        }
    }

    @CommandLine.Command(description={"Get the positions for one or more topic(s) in a namespace bundle"})
    private class GetTopicHashPositions
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary} format namespace bundle"}, required=false)
        private String bundle;
        @CommandLine.Option(names={"--topic-list", "-tl"}, description={"The list of topics(both non-partitioned topic and partitioned topic) to get positions in this bundle, if none topic provided, will get the positions of all topics in this bundle"}, required=false)
        private List<String> topics;

        private GetTopicHashPositions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetTopicHashPositions.validateNamespace(this.namespaceName);
            if (StringUtils.isBlank((CharSequence)this.bundle)) {
                throw new CliCommand.ParameterException("Must pass one of the params: --bundle ");
            }
            this.print(CmdNamespaces.this.getAdmin().namespaces().getTopicHashPositions(namespace, this.bundle, this.topics));
        }
    }

    @CommandLine.Command(description={"Set message-dispatch-rate for all topics of the namespace"})
    private class SetDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"}, required=false)
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"}, required=false)
        private boolean relativeToPublishRate = false;

        private SetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDispatchRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setDispatchRate(namespace, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Remove configured message-dispatch-rate for all topics of the namespace"})
    private class RemoveDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDispatchRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeDispatchRate(namespace);
        }
    }

    @CommandLine.Command(description={"Get configured message-dispatch-rate for all topics of the namespace (Disabled if value < 0)"})
    private class GetDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDispatchRate.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDispatchRate(namespace));
        }
    }

    @CommandLine.Command(description={"Set subscribe-rate per consumer for all topics of the namespace"})
    private class SetSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--subscribe-rate", "-sr"}, description={"subscribe-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int subscribeRate = -1;
        @CommandLine.Option(names={"--subscribe-rate-period", "-st"}, description={"subscribe-rate-period in second type (default 30 second will be overwrite if not passed)"}, required=false)
        private int subscribeRatePeriodSec = 30;

        private SetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscribeRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setSubscribeRate(namespace, new SubscribeRate(this.subscribeRate, this.subscribeRatePeriodSec));
        }
    }

    @CommandLine.Command(description={"Get configured subscribe-rate per consumer for all topics of the namespace"})
    private class GetSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscribeRate.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscribeRate(namespace));
        }
    }

    @CommandLine.Command(description={"Remove configured subscribe-rate per consumer for all topics of the namespace"})
    private class RemoveSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscribeRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscribeRate(namespace);
        }
    }

    @CommandLine.Command(description={"Set subscription message-dispatch-rate for all subscription of the namespace"})
    private class SetSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"}, required=false)
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"}, required=false)
        private boolean relativeToPublishRate = false;

        private SetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscriptionDispatchRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionDispatchRate(namespace, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Get subscription configured message-dispatch-rate for all topics of the namespace (Disabled if value < 0)"})
    private class GetSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionDispatchRate.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionDispatchRate(namespace));
        }
    }

    @CommandLine.Command(description={"Remove subscription configured message-dispatch-rate for all topics of the namespace"})
    private class RemoveSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscriptionDispatchRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscriptionDispatchRate(namespace);
        }
    }

    @CommandLine.Command(description={"Set publish-rate for all topics of the namespace"})
    private class SetPublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--msg-publish-rate", "-m"}, description={"message-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgPublishRate = -1;
        @CommandLine.Option(names={"--byte-publish-rate", "-b"}, description={"byte-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long bytePublishRate = -1L;

        private SetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetPublishRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setPublishRate(namespace, new PublishRate(this.msgPublishRate, this.bytePublishRate));
        }
    }

    @CommandLine.Command(name="get-publish-rate", description={"Get configured message-publish-rate for all topics of the namespace (Disabled if value < 0)"})
    private class GetPublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetPublishRate.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPublishRate(namespace));
        }
    }

    @CommandLine.Command(description={"Remove publish-rate for all topics of the namespace"})
    private class RemovePublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemovePublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemovePublishRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removePublishRate(namespace);
        }
    }

    @CommandLine.Command(description={"Set replicator message-dispatch-rate for all topics of the namespace"})
    private class SetReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"}, required=false)
        private int dispatchRatePeriodSec = 1;

        private SetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetReplicatorDispatchRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setReplicatorDispatchRate(namespace, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).build());
        }
    }

    @CommandLine.Command(description={"Get replicator configured message-dispatch-rate for all topics of the namespace (Disabled if value < 0)"})
    private class GetReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetReplicatorDispatchRate.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getReplicatorDispatchRate(namespace));
        }
    }

    @CommandLine.Command(description={"Remove replicator configured message-dispatch-rate for all topics of the namespace"})
    private class RemoveReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveReplicatorDispatchRate.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeReplicatorDispatchRate(namespace);
        }
    }

    @CommandLine.Command(description={"Clear backlog for a namespace"})
    private class ClearBacklog
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--sub", "-s"}, description={"subscription name"})
        private String subscription;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary}"})
        private String bundle;
        @CommandLine.Option(names={"--force", "-force"}, description={"Whether to force clear backlog without prompt"})
        private boolean force;

        private ClearBacklog() {
        }

        @Override
        void run() throws PulsarAdminException, IOException {
            String prompt;
            boolean confirm;
            if (!this.force && !(confirm = IOUtils.confirmPrompt(prompt = "Are you sure you want to clear the backlog?"))) {
                return;
            }
            String namespace = ClearBacklog.validateNamespace(this.namespaceName);
            if (this.subscription != null && this.bundle != null) {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBundleBacklogForSubscription(namespace, this.bundle, this.subscription);
            } else if (this.subscription != null) {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBacklogForSubscription(namespace, this.subscription);
            } else if (this.bundle != null) {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBundleBacklog(namespace, this.bundle);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBacklog(namespace);
            }
        }
    }

    @CommandLine.Command(description={"Unsubscribe the given subscription on all topics on a namespace"})
    private class Unsubscribe
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--sub", "-s"}, description={"subscription name"}, required=true)
        private String subscription;
        @CommandLine.Option(names={"--bundle", "-b"}, description={"{start-boundary}_{end-boundary}"})
        private String bundle;

        private Unsubscribe() {
        }

        @Override
        void run() throws Exception {
            String namespace = Unsubscribe.validateNamespace(this.namespaceName);
            if (this.bundle != null) {
                CmdNamespaces.this.getAdmin().namespaces().unsubscribeNamespaceBundle(namespace, this.bundle, this.subscription);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().unsubscribeNamespace(namespace, this.subscription);
            }
        }
    }

    @CommandLine.Command(description={"Enable or disable message encryption required for a namespace"})
    private class SetEncryptionRequired
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable message encryption required"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable message encryption required"})
        private boolean disable = false;

        private SetEncryptionRequired() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetEncryptionRequired.validateNamespace(this.namespaceName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setEncryptionRequiredStatus(namespace, this.enable);
        }
    }

    @CommandLine.Command(description={"Get encryption required for a namespace"})
    private class GetEncryptionRequired
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetEncryptionRequired() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetEncryptionRequired.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getEncryptionRequiredStatus(namespace));
        }
    }

    @CommandLine.Command(description={"Set subscription auth mode on a namespace"})
    private class SetSubscriptionAuthMode
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-m", "--subscription-auth-mode"}, description={"Subscription authorization mode for Pulsar policies. Valid options are: [None, Prefix]"}, required=true)
        private String mode;

        private SetSubscriptionAuthMode() {
        }

        @Override
        void run() throws Exception {
            String namespace = SetSubscriptionAuthMode.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionAuthMode(namespace, SubscriptionAuthMode.valueOf((String)this.mode));
        }
    }

    @CommandLine.Command(description={"Get subscriptionAuthMod for a namespace"})
    private class GetSubscriptionAuthMode
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSubscriptionAuthMode() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionAuthMode.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionAuthMode(namespace));
        }
    }

    @CommandLine.Command(description={"Set the delayed delivery policy on a namespace"})
    private class SetDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable delayed delivery messages"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable delayed delivery messages"})
        private boolean disable = false;
        @CommandLine.Option(names={"--time", "-t"}, description={"The tick time for when retrying on delayed delivery messages, affecting the accuracy of the delivery time compared to the scheduled time. (eg: 1s, 10s, 1m, 5h, 3d)"}, converter={TimeUnitToMillisConverter.class})
        private Long delayedDeliveryTimeInMills = 1000L;
        @CommandLine.Option(names={"--maxDelay", "-md"}, description={"The max allowed delay for delayed delivery. (eg: 1s, 10s, 1m, 5h, 3d)"}, converter={TimeUnitToMillisConverter.class})
        private Long delayedDeliveryMaxDelayInMillis = 0L;

        private SetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDelayedDelivery.validateNamespace(this.namespaceName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setDelayedDeliveryMessages(namespace, DelayedDeliveryPolicies.builder().tickTime(this.delayedDeliveryTimeInMills.longValue()).active(this.enable).maxDeliveryDelayInMillis(this.delayedDeliveryMaxDelayInMillis.longValue()).build());
        }
    }

    @CommandLine.Command(description={"Get the delayed delivery policy for a namespace"})
    private class GetDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDelayedDelivery.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDelayedDelivery(namespace));
        }
    }

    @CommandLine.Command(description={"Remove delayed delivery policies from a namespace"})
    private class RemoveDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDelayedDelivery.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeDelayedDeliveryMessages(namespace);
        }
    }

    @CommandLine.Command(description={"Get the inactive topic policy for a namespace"})
    private class GetInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetInactiveTopicPolicies.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getInactiveTopicPolicies(namespace));
        }
    }

    @CommandLine.Command(description={"Set the inactive topic policies on a namespace"})
    private class SetInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable-delete-while-inactive", "-e"}, description={"Enable delete while inactive"})
        private boolean enableDeleteWhileInactive = false;
        @CommandLine.Option(names={"--disable-delete-while-inactive", "-d"}, description={"Disable delete while inactive"})
        private boolean disableDeleteWhileInactive = false;
        @CommandLine.Option(names={"--max-inactive-duration", "-t"}, description={"Max duration of topic inactivity in seconds, topics that are inactive for longer than this value will be deleted (eg: 1s, 10s, 1m, 5h, 3d)"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long maxInactiveDurationInSeconds;
        @CommandLine.Option(names={"--delete-mode", "-m"}, description={"Mode of delete inactive topic, Valid options are: [delete_when_no_subscriptions, delete_when_subscriptions_caught_up]"}, required=true)
        private String inactiveTopicDeleteMode;

        private SetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetInactiveTopicPolicies.validateNamespace(this.namespaceName);
            if (this.enableDeleteWhileInactive == this.disableDeleteWhileInactive) {
                throw new CliCommand.ParameterException("Need to specify either enable-delete-while-inactive or disable-delete-while-inactive");
            }
            InactiveTopicDeleteMode deleteMode = null;
            try {
                deleteMode = InactiveTopicDeleteMode.valueOf((String)this.inactiveTopicDeleteMode);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException("delete mode can only be set to delete_when_no_subscriptions or delete_when_subscriptions_caught_up");
            }
            CmdNamespaces.this.getAdmin().namespaces().setInactiveTopicPolicies(namespace, new InactiveTopicPolicies(deleteMode, this.maxInactiveDurationInSeconds.intValue(), this.enableDeleteWhileInactive));
        }
    }

    @CommandLine.Command(description={"Remove inactive topic policies from a namespace"})
    private class RemoveInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveInactiveTopicPolicies.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeInactiveTopicPolicies(namespace);
        }
    }

    @CommandLine.Command(description={"Get maxProducersPerTopic for a namespace"})
    private class GetMaxProducersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxProducersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxProducersPerTopic.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxProducersPerTopic(namespace));
        }
    }

    @CommandLine.Command(description={"Set maxProducersPerTopic for a namespace"})
    private class SetMaxProducersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-producers-per-topic", "-p"}, description={"maxProducersPerTopic for a namespace"}, required=true)
        private int maxProducersPerTopic;

        private SetMaxProducersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxProducersPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxProducersPerTopic(namespace, this.maxProducersPerTopic);
        }
    }

    @CommandLine.Command(description={"Remove max producers per topic for a namespace"})
    private class RemoveMaxProducersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxProducersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxProducersPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxProducersPerTopic(namespace);
        }
    }

    @CommandLine.Command(description={"Get maxConsumersPerTopic for a namespace"})
    private class GetMaxConsumersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxConsumersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxConsumersPerTopic.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxConsumersPerTopic(namespace));
        }
    }

    @CommandLine.Command(description={"Set maxConsumersPerTopic for a namespace"})
    private class SetMaxConsumersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-consumers-per-topic", "-c"}, description={"maxConsumersPerTopic for a namespace"}, required=true)
        private int maxConsumersPerTopic;

        private SetMaxConsumersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxConsumersPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxConsumersPerTopic(namespace, this.maxConsumersPerTopic);
        }
    }

    @CommandLine.Command(description={"Remove max consumers per topic for a namespace"})
    private class RemoveMaxConsumersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxConsumersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxConsumersPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxConsumersPerTopic(namespace);
        }
    }

    @CommandLine.Command(description={"Get maxConsumersPerSubscription for a namespace"})
    private class GetMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxConsumersPerSubscription.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxConsumersPerSubscription(namespace));
        }
    }

    @CommandLine.Command(description={"Set maxConsumersPerSubscription for a namespace"})
    private class SetMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-consumers-per-subscription", "-c"}, description={"maxConsumersPerSubscription for a namespace"}, required=true)
        private int maxConsumersPerSubscription;

        private SetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxConsumersPerSubscription.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxConsumersPerSubscription(namespace, this.maxConsumersPerSubscription);
        }
    }

    @CommandLine.Command(description={"Remove maxConsumersPerSubscription for a namespace"})
    private class RemoveMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxConsumersPerSubscription.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxConsumersPerSubscription(namespace);
        }
    }

    @CommandLine.Command(description={"Get maxUnackedMessagesPerSubscription for a namespace"})
    private class GetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxUnackedMessagesPerSubscription.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxUnackedMessagesPerSubscription(namespace));
        }
    }

    @CommandLine.Command(description={"Set maxUnackedMessagesPerSubscription for a namespace"})
    private class SetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-unacked-messages-per-subscription", "-c"}, description={"maxUnackedMessagesPerSubscription for a namespace"}, required=true)
        private int maxUnackedMessagesPerSubscription;

        private SetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxUnackedMessagesPerSubscription.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxUnackedMessagesPerSubscription(namespace, this.maxUnackedMessagesPerSubscription);
        }
    }

    @CommandLine.Command(description={"Remove maxUnackedMessagesPerSubscription for a namespace"})
    private class RemoveMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxUnackedMessagesPerSubscription.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxUnackedMessagesPerSubscription(namespace);
        }
    }

    @CommandLine.Command(description={"Get maxUnackedMessagesPerConsumer for a namespace"})
    private class GetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxUnackedMessagesPerConsumer.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxUnackedMessagesPerConsumer(namespace));
        }
    }

    @CommandLine.Command(description={"Set maxUnackedMessagesPerConsumer for a namespace"})
    private class SetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-unacked-messages-per-topic", "-c"}, description={"maxUnackedMessagesPerConsumer for a namespace"}, required=true)
        private int maxUnackedMessagesPerConsumer;

        private SetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxUnackedMessagesPerConsumer.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxUnackedMessagesPerConsumer(namespace, this.maxUnackedMessagesPerConsumer);
        }
    }

    @CommandLine.Command(description={"Remove maxUnackedMessagesPerConsumer for a namespace"})
    private class RemoveMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxUnackedMessagesPerConsumer.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxUnackedMessagesPerConsumer(namespace);
        }
    }

    @CommandLine.Command(description={"Get compactionThreshold for a namespace"})
    private class GetCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetCompactionThreshold.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getCompactionThreshold(namespace));
        }
    }

    @CommandLine.Command(description={"Set compactionThreshold for a namespace"})
    private class SetCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--threshold", "-t"}, description={"Maximum number of bytes in a topic backlog before compaction is triggered (eg: 10M, 16G, 3T). 0 disables automatic compaction"}, required=true, converter={ByteUnitToLongConverter.class})
        private Long threshold = 0L;

        private SetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetCompactionThreshold.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setCompactionThreshold(namespace, this.threshold.longValue());
        }
    }

    @CommandLine.Command(description={"Remove compactionThreshold for a namespace"})
    private class RemoveCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveCompactionThreshold.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeCompactionThreshold(namespace);
        }
    }

    @CommandLine.Command(description={"Get offloadThreshold for a namespace"})
    private class GetOffloadThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetOffloadThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetOffloadThreshold.validateNamespace(this.namespaceName);
            this.print("offloadThresholdInBytes: " + CmdNamespaces.this.getAdmin().namespaces().getOffloadThreshold(namespace));
            this.print("offloadThresholdInSeconds: " + CmdNamespaces.this.getAdmin().namespaces().getOffloadThresholdInSeconds(namespace));
        }
    }

    @CommandLine.Command(description={"Set offloadThreshold for a namespace"})
    private class SetOffloadThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--size", "-s"}, description={"Maximum number of bytes stored in the pulsar cluster for a topic before data will start being automatically offloaded to longterm storage (eg: 10M, 16G, 3T, 100). -1 falls back to the cluster's namespace default. Negative values disable automatic offload. 0 triggers offloading as soon as possible."}, required=true, converter={ByteUnitToLongConverter.class})
        private Long threshold = -1L;
        @CommandLine.Option(names={"--time", "-t"}, description={"Maximum number of seconds stored on the pulsar cluster for a topic before the broker will start offloading to longterm storage (eg: 10m, 5h, 3d, 2w)."}, converter={TimeUnitToSecondsConverter.class})
        private Long thresholdInSeconds = -1L;

        private SetOffloadThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetOffloadThreshold.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setOffloadThreshold(namespace, this.threshold.longValue());
            CmdNamespaces.this.getAdmin().namespaces().setOffloadThresholdInSeconds(namespace, this.thresholdInSeconds.longValue());
        }
    }

    @CommandLine.Command(description={"Get offloadDeletionLag, in minutes, for a namespace"})
    private class GetOffloadDeletionLag
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetOffloadDeletionLag() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetOffloadDeletionLag.validateNamespace(this.namespaceName);
            Long lag = CmdNamespaces.this.getAdmin().namespaces().getOffloadDeleteLagMs(namespace);
            if (lag != null) {
                System.out.println(TimeUnit.MINUTES.convert(lag, TimeUnit.MILLISECONDS) + " minute(s)");
            } else {
                System.out.println("Unset for namespace. Defaulting to broker setting.");
            }
        }
    }

    @CommandLine.Command(description={"Set offloadDeletionLag for a namespace"})
    private class SetOffloadDeletionLag
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--lag", "-l"}, description={"Duration to wait after offloading a ledger segment, before deleting the copy of that segment from cluster local storage. (eg: 10m, 5h, 3d, 2w)."}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long lagInSec = -1L;

        private SetOffloadDeletionLag() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetOffloadDeletionLag.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setOffloadDeleteLag(namespace, this.lagInSec.longValue(), TimeUnit.SECONDS);
        }
    }

    @CommandLine.Command(description={"Clear offloadDeletionLag for a namespace"})
    private class ClearOffloadDeletionLag
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private ClearOffloadDeletionLag() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ClearOffloadDeletionLag.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().clearOffloadDeleteLag(namespace);
        }
    }

    @CommandLine.Command(description={"Get the schema auto-update strategy for a namespace"})
    private class GetSchemaAutoUpdateStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSchemaAutoUpdateStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSchemaAutoUpdateStrategy.validateNamespace(this.namespaceName);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getSchemaAutoUpdateCompatibilityStrategy(namespace).toString().toUpperCase());
        }
    }

    @CommandLine.Command(description={"Set the schema auto-update strategy for a namespace"})
    private class SetSchemaAutoUpdateStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--compatibility", "-c"}, description={"Compatibility level required for new schemas created via a Producer. Possible values (Full, Backward, Forward)."})
        private String strategyParam = null;
        @CommandLine.Option(names={"--disabled", "-d"}, description={"Disable automatic schema updates"})
        private boolean disabled = false;

        private SetSchemaAutoUpdateStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String strategyStr;
            String namespace = SetSchemaAutoUpdateStrategy.validateNamespace(this.namespaceName);
            SchemaAutoUpdateCompatibilityStrategy strategy = null;
            String string = strategyStr = this.strategyParam != null ? this.strategyParam.toUpperCase() : "";
            if (this.disabled) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.AutoUpdateDisabled;
            } else if (strategyStr.equals("FULL")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.Full;
            } else if (strategyStr.equals("BACKWARD")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.Backward;
            } else if (strategyStr.equals("FORWARD")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.Forward;
            } else if (strategyStr.equals("NONE")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.AlwaysCompatible;
            } else {
                throw new CliCommand.ParameterException("Either --compatibility or --disabled must be specified");
            }
            CmdNamespaces.this.getAdmin().namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, strategy);
        }
    }

    @CommandLine.Command(description={"Get the schema compatibility strategy for a namespace"})
    private class GetSchemaCompatibilityStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSchemaCompatibilityStrategy.validateNamespace(this.namespaceName);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getSchemaCompatibilityStrategy(namespace).toString().toUpperCase());
        }
    }

    @CommandLine.Command(description={"Set the schema compatibility strategy for a namespace"})
    private class SetSchemaCompatibilityStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--compatibility", "-c"}, description={"Compatibility level required for new schemas created via a Producer. Possible values (FULL, BACKWARD, FORWARD, UNDEFINED, BACKWARD_TRANSITIVE, FORWARD_TRANSITIVE, FULL_TRANSITIVE, ALWAYS_INCOMPATIBLE,ALWAYS_COMPATIBLE)."})
        private String strategyParam = null;

        private SetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            SchemaCompatibilityStrategy strategy;
            String namespace = SetSchemaCompatibilityStrategy.validateNamespace(this.namespaceName);
            String strategyStr = this.strategyParam != null ? this.strategyParam.toUpperCase() : "";
            try {
                strategy = SchemaCompatibilityStrategy.valueOf((String)strategyStr);
            }
            catch (IllegalArgumentException exception) {
                throw new CliCommand.ParameterException(String.format("Illegal schema compatibility strategy %s. Possible values: %s", strategyStr, Arrays.toString(SchemaCompatibilityStrategy.values())));
            }
            CmdNamespaces.this.getAdmin().namespaces().setSchemaCompatibilityStrategy(namespace, strategy);
        }
    }

    @CommandLine.Command(description={"Get the namespace whether allow auto update schema"})
    private class GetIsAllowAutoUpdateSchema
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetIsAllowAutoUpdateSchema() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetIsAllowAutoUpdateSchema.validateNamespace(this.namespaceName);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getIsAllowAutoUpdateSchema(namespace));
        }
    }

    @CommandLine.Command(description={"Set the namespace whether allow auto update schema"})
    private class SetIsAllowAutoUpdateSchema
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable schema validation enforced"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable schema validation enforced"})
        private boolean disable = false;

        private SetIsAllowAutoUpdateSchema() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetIsAllowAutoUpdateSchema.validateNamespace(this.namespaceName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setIsAllowAutoUpdateSchema(namespace, this.enable);
        }
    }

    @CommandLine.Command(description={"Get the schema validation enforced"})
    private class GetSchemaValidationEnforced
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the namespace"})
        private boolean applied = false;

        private GetSchemaValidationEnforced() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSchemaValidationEnforced.validateNamespace(this.namespaceName);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getSchemaValidationEnforced(namespace, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the schema whether open schema validation enforced"})
    private class SetSchemaValidationEnforced
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable schema validation enforced"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable schema validation enforced"})
        private boolean disable = false;

        private SetSchemaValidationEnforced() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSchemaValidationEnforced.validateNamespace(this.namespaceName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setSchemaValidationEnforced(namespace, this.enable);
        }
    }

    @CommandLine.Command(description={"Set the offload policies for a namespace"})
    private class SetOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--driver", "-d"}, description={"Driver to use to offload old data to long term storage, (Possible values: S3, aws-s3, google-cloud-storage, filesystem, azureblob)"}, required=true)
        private String driver;
        @CommandLine.Option(names={"--region", "-r"}, description={"The long term storage region, default is s3ManagedLedgerOffloadRegion or gcsManagedLedgerOffloadRegion in broker.conf"}, required=false)
        private String region;
        @CommandLine.Option(names={"--bucket", "-b"}, description={"Bucket to place offloaded ledger into"}, required=false)
        private String bucket;
        @CommandLine.Option(names={"--endpoint", "-e"}, description={"Alternative endpoint to connect to, s3 default is s3ManagedLedgerOffloadServiceEndpoint in broker.conf"}, required=false)
        private String endpoint;
        @CommandLine.Option(names={"--aws-id", "-i"}, description={"AWS Credential Id to use when using driver S3 or aws-s3"}, required=false)
        private String awsId;
        @CommandLine.Option(names={"--aws-secret", "-s"}, description={"AWS Credential Secret to use when using driver S3 or aws-s3"}, required=false)
        private String awsSecret;
        @CommandLine.Option(names={"--s3-role", "-ro"}, description={"S3 Role used for STSAssumeRoleSessionCredentialsProvider"}, required=false)
        private String s3Role;
        @CommandLine.Option(names={"--s3-role-session-name", "-rsn"}, description={"S3 role session name used for STSAssumeRoleSessionCredentialsProvider"}, required=false)
        private String s3RoleSessionName;
        @CommandLine.Option(names={"--maxBlockSize", "-mbs"}, description={"Max block size (eg: 32M, 64M), default is 64MBs3 and google-cloud-storage requires this parameter"}, required=false, converter={ByteUnitToIntegerConverter.class})
        private Integer maxBlockSizeInBytes = 0x4000000;
        @CommandLine.Option(names={"--readBufferSize", "-rbs"}, description={"Read buffer size (eg: 1M, 5M), default is 1MB"}, required=false, converter={ByteUnitToIntegerConverter.class})
        private Integer readBufferSizeInBytes = 0x100000;
        @CommandLine.Option(names={"--offloadAfterElapsed", "-oae"}, description={"Delay time in Millis for deleting the bookkeeper ledger after offload (or seconds,minutes,hours,days,weeks eg: 10s, 100m, 3h, 2d, 5w)."}, required=false, converter={TimeUnitToMillisConverter.class})
        private Long offloadAfterElapsedInMillis = OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
        @CommandLine.Option(names={"--offloadAfterThreshold", "-oat"}, description={"Offload after threshold size (eg: 1M, 5M)"}, required=false, converter={ByteUnitToLongConverter.class})
        private Long offloadAfterThresholdInBytes = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
        @CommandLine.Option(names={"--offloadAfterThresholdInSeconds", "-oats"}, description={"Offload after threshold seconds (or minutes,hours,days,weeks eg: 100m, 3h, 2d, 5w)."}, required=false, converter={TimeUnitToSecondsConverter.class})
        private Long offloadThresholdInSeconds = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_SECONDS;
        @CommandLine.Option(names={"--offloadedReadPriority", "-orp"}, description={"Read priority for offloaded messages. By default, once messages are offloaded to long-term storage, brokers read messages from long-term storage, but messages can still exist in BookKeeper for a period depends on your configuration. For messages that exist in both long-term storage and BookKeeper, you can set where to read messages from with the option `tiered-storage-first` or `bookkeeper-first`."}, required=false)
        private String offloadReadPriorityStr;
        public final List<String> driverNames = OffloadPoliciesImpl.DRIVER_NAMES;

        private SetOffloadPolicies() {
        }

        public boolean driverSupported(String driver) {
            return this.driverNames.stream().anyMatch(d -> d.equalsIgnoreCase(driver));
        }

        public boolean isS3Driver(String driver) {
            if (StringUtils.isEmpty((CharSequence)driver)) {
                return false;
            }
            return driver.equalsIgnoreCase(this.driverNames.get(0)) || driver.equalsIgnoreCase(this.driverNames.get(1));
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetOffloadPolicies.validateNamespace(this.namespaceName);
            if (!this.driverSupported(this.driver)) {
                throw new CliCommand.ParameterException("The driver " + this.driver + " is not supported, (Possible values: " + String.join((CharSequence)",", this.driverNames) + ").");
            }
            if (this.isS3Driver(this.driver) && Strings.isNullOrEmpty((String)this.region) && Strings.isNullOrEmpty((String)this.endpoint)) {
                throw new CliCommand.ParameterException("Either s3ManagedLedgerOffloadRegion or s3ManagedLedgerOffloadServiceEndpoint must be set if s3 offload enabled");
            }
            OffloadedReadPriority offloadedReadPriority = OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY;
            if (this.offloadReadPriorityStr != null) {
                try {
                    offloadedReadPriority = OffloadedReadPriority.fromString((String)this.offloadReadPriorityStr);
                }
                catch (Exception e) {
                    throw new CliCommand.ParameterException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + this.offloadReadPriorityStr, e);
                }
            }
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)this.driver, (String)this.region, (String)this.bucket, (String)this.endpoint, (String)this.s3Role, (String)this.s3RoleSessionName, (String)this.awsId, (String)this.awsSecret, (Integer)this.maxBlockSizeInBytes, (Integer)this.readBufferSizeInBytes, (Long)this.offloadAfterThresholdInBytes, (Long)this.offloadThresholdInSeconds, (Long)this.offloadAfterElapsedInMillis, (OffloadedReadPriority)offloadedReadPriority);
            CmdNamespaces.this.getAdmin().namespaces().setOffloadPolicies(namespace, (OffloadPolicies)offloadPolicies);
        }
    }

    @CommandLine.Command(description={"Remove the offload policies for a namespace"})
    private class RemoveOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveOffloadPolicies.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeOffloadPolicies(namespace);
        }
    }

    @CommandLine.Command(description={"Get the offload policies for a namespace"})
    private class GetOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetOffloadPolicies.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getOffloadPolicies(namespace));
        }
    }

    @CommandLine.Command(description={"Set deduplicationSnapshotInterval for a namespace"})
    private class SetDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--interval", "-i"}, description={"deduplicationSnapshotInterval for a namespace"}, required=true)
        private int interval;

        private SetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDeduplicationSnapshotInterval.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setDeduplicationSnapshotInterval(namespace, Integer.valueOf(this.interval));
        }
    }

    @CommandLine.Command(description={"Get deduplicationSnapshotInterval for a namespace"})
    private class GetDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDeduplicationSnapshotInterval.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDeduplicationSnapshotInterval(namespace));
        }
    }

    @CommandLine.Command(description={"Remove deduplicationSnapshotInterval for a namespace"})
    private class RemoveDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDeduplicationSnapshotInterval.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeDeduplicationSnapshotInterval(namespace);
        }
    }

    @CommandLine.Command(description={"Set max topics per namespace"})
    private class SetMaxTopicsPerNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--max-topics-per-namespace", "-t"}, description={"max topics per namespace"}, required=true)
        private int maxTopicsPerNamespace;

        private SetMaxTopicsPerNamespace() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxTopicsPerNamespace.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setMaxTopicsPerNamespace(namespace, this.maxTopicsPerNamespace);
        }
    }

    @CommandLine.Command(description={"Get max topics per namespace"})
    private class GetMaxTopicsPerNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetMaxTopicsPerNamespace() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxTopicsPerNamespace.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxTopicsPerNamespace(namespace));
        }
    }

    @CommandLine.Command(description={"Remove max topics per namespace"})
    private class RemoveMaxTopicsPerNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveMaxTopicsPerNamespace() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxTopicsPerNamespace.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxTopicsPerNamespace(namespace);
        }
    }

    @CommandLine.Command(description={"Set property for a namespace"})
    private class SetPropertyForNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--key", "-k"}, description={"Key of the property"}, required=true)
        private String key;
        @CommandLine.Option(names={"--value", "-v"}, description={"Value of the property"}, required=true)
        private String value;

        private SetPropertyForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = SetPropertyForNamespace.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setProperty(namespace, this.key, this.value);
        }
    }

    @CommandLine.Command(description={"Get property for a namespace"})
    private class GetPropertyForNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--key", "-k"}, description={"Key of the property"}, required=true)
        private String key;

        private GetPropertyForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = GetPropertyForNamespace.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getProperty(namespace, this.key));
        }
    }

    @CommandLine.Command(description={"Remove property for a namespace"})
    private class RemovePropertyForNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--key", "-k"}, description={"Key of the property"}, required=true)
        private String key;

        private RemovePropertyForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = RemovePropertyForNamespace.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().removeProperty(namespace, this.key));
        }
    }

    @CommandLine.Command(description={"Set properties of a namespace"})
    private class SetPropertiesForNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--properties", "-p"}, description={"key value pair properties(a=a,b=b,c=c)"}, required=true)
        private List<String> properties;

        private SetPropertiesForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = SetPropertiesForNamespace.validateNamespace(this.namespaceName);
            if (this.properties.size() == 0) {
                throw new CliCommand.ParameterException(String.format("Required at least one property for the namespace, but found %d.", this.properties.size()));
            }
            Map<String, String> map = CmdNamespaces.this.parseListKeyValueMap(this.properties);
            CmdNamespaces.this.getAdmin().namespaces().setProperties(namespace, map);
        }
    }

    @CommandLine.Command(description={"Get properties of a namespace"})
    private class GetPropertiesForNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetPropertiesForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = GetPropertiesForNamespace.validateNamespace(this.namespaceName);
            Map properties = CmdNamespaces.this.getAdmin().namespaces().getProperties(namespace);
            this.prettyPrint(properties);
        }
    }

    @CommandLine.Command(description={"Clear all properties for a namespace"})
    private class ClearPropertiesForNamespace
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private ClearPropertiesForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = ClearPropertiesForNamespace.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().clearProperties(namespace);
        }
    }

    @CommandLine.Command(description={"Get ResourceGroup for a namespace"})
    private class GetResourceGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetResourceGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetResourceGroup.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceResourceGroup(namespace));
        }
    }

    @CommandLine.Command(description={"Set ResourceGroup for a namespace"})
    private class SetResourceGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--resource-group-name", "-rgn"}, description={"ResourceGroup name"}, required=true)
        private String rgName;

        private SetResourceGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetResourceGroup.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceResourceGroup(namespace, this.rgName);
        }
    }

    @CommandLine.Command(description={"Remove ResourceGroup from a namespace"})
    private class RemoveResourceGroup
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveResourceGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveResourceGroup.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeNamespaceResourceGroup(namespace);
        }
    }

    @CommandLine.Command(description={"Get entry filters for a namespace"})
    private class GetEntryFiltersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetEntryFiltersPerTopic.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceEntryFilters(namespace));
        }
    }

    @CommandLine.Command(description={"Set entry filters for a namespace"})
    private class SetEntryFiltersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--entry-filters-name", "-efn"}, description={"The class name for the entry filter."}, required=true)
        private String entryFiltersName = "";

        private SetEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetEntryFiltersPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceEntryFilters(namespace, new EntryFilters(this.entryFiltersName));
        }
    }

    @CommandLine.Command(description={"Remove entry filters for a namespace"})
    private class RemoveEntryFiltersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveEntryFiltersPerTopic.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeNamespaceEntryFilters(namespace);
        }
    }

    @CommandLine.Command(description={"Update migration state for a namespace"})
    private class UpdateMigrationState
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;
        @CommandLine.Option(names={"--migrated"}, description={"Is namespace migrated"})
        private boolean migrated;

        private UpdateMigrationState() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = UpdateMigrationState.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().updateMigrationState(namespace, this.migrated);
        }
    }

    @CommandLine.Command(description={"Enable dispatcherPauseOnAckStatePersistent for a namespace"})
    private class SetDispatcherPauseOnAckStatePersistent
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private SetDispatcherPauseOnAckStatePersistent() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDispatcherPauseOnAckStatePersistent.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().setDispatcherPauseOnAckStatePersistent(namespace);
        }
    }

    @CommandLine.Command(description={"Get the dispatcherPauseOnAckStatePersistent for a namespace"})
    private class GetDispatcherPauseOnAckStatePersistent
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private GetDispatcherPauseOnAckStatePersistent() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDispatcherPauseOnAckStatePersistent.validateNamespace(this.namespaceName);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDispatcherPauseOnAckStatePersistent(namespace));
        }
    }

    @CommandLine.Command(description={"Remove dispatcherPauseOnAckStatePersistent for a namespace"})
    private class RemoveDispatcherPauseOnAckStatePersistent
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespaceName;

        private RemoveDispatcherPauseOnAckStatePersistent() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDispatcherPauseOnAckStatePersistent.validateNamespace(this.namespaceName);
            CmdNamespaces.this.getAdmin().namespaces().removeDispatcherPauseOnAckStatePersistent(namespace);
        }
    }
}

