/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.internal.PulsarAdminImpl;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;

public class PulsarAdminBuilderImpl
implements PulsarAdminBuilder {
    protected ClientConfigurationData conf;
    private ClassLoader clientBuilderClassLoader = null;
    private boolean acceptGzipCompression = true;

    public PulsarAdmin build() throws PulsarClientException {
        return new PulsarAdminImpl(this.conf.getServiceUrl(), this.conf, this.clientBuilderClassLoader, this.acceptGzipCompression);
    }

    public PulsarAdminBuilderImpl() {
        this.conf = new ClientConfigurationData();
    }

    private PulsarAdminBuilderImpl(ClientConfigurationData conf) {
        this.conf = conf;
    }

    public PulsarAdminBuilder clone() {
        PulsarAdminBuilderImpl pulsarAdminBuilder = new PulsarAdminBuilderImpl(this.conf.clone());
        pulsarAdminBuilder.clientBuilderClassLoader = this.clientBuilderClassLoader;
        pulsarAdminBuilder.acceptGzipCompression = this.acceptGzipCompression;
        return pulsarAdminBuilder;
    }

    public PulsarAdminBuilder loadConf(Map<String, Object> config) {
        this.conf = (ClientConfigurationData)ConfigurationDataUtils.loadData(config, (Object)this.conf, ClientConfigurationData.class);
        this.setAuthenticationFromPropsIfAvailable(this.conf);
        if (config.containsKey("acceptGzipCompression")) {
            Object acceptGzipCompressionObj = config.get("acceptGzipCompression");
            this.acceptGzipCompression = acceptGzipCompressionObj instanceof Boolean ? (Boolean)acceptGzipCompressionObj : Boolean.parseBoolean(acceptGzipCompressionObj.toString());
        }
        return this;
    }

    public PulsarAdminBuilder serviceHttpUrl(String serviceHttpUrl) {
        this.conf.setServiceUrl(serviceHttpUrl);
        return this;
    }

    public PulsarAdminBuilder authentication(Authentication authentication) {
        this.conf.setAuthentication(authentication);
        return this;
    }

    public PulsarAdminBuilder authentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, authParams));
        return this;
    }

    public PulsarAdminBuilder authentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        this.conf.setAuthentication(AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
        return this;
    }

    private void setAuthenticationFromPropsIfAvailable(ClientConfigurationData clientConfig) {
        String authPluginClass = clientConfig.getAuthPluginClassName();
        String authParams = clientConfig.getAuthParams();
        Map authParamMap = clientConfig.getAuthParamMap();
        if (StringUtils.isBlank((CharSequence)authPluginClass) || StringUtils.isBlank((CharSequence)authParams) && authParamMap == null) {
            return;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)authParams)) {
                this.authentication(authPluginClass, authParams);
            } else if (authParamMap != null) {
                this.authentication(authPluginClass, authParamMap);
            }
        }
        catch (PulsarClientException.UnsupportedAuthenticationException ex) {
            throw new RuntimeException("Failed to create authentication: " + ex.getMessage(), ex);
        }
    }

    public PulsarAdminBuilder tlsKeyFilePath(String tlsKeyFilePath) {
        this.conf.setTlsKeyFilePath(tlsKeyFilePath);
        return this;
    }

    public PulsarAdminBuilder tlsCertificateFilePath(String tlsCertificateFilePath) {
        this.conf.setTlsCertificateFilePath(tlsCertificateFilePath);
        return this;
    }

    public PulsarAdminBuilder tlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.conf.setTlsTrustCertsFilePath(tlsTrustCertsFilePath);
        return this;
    }

    public PulsarAdminBuilder allowTlsInsecureConnection(boolean allowTlsInsecureConnection) {
        this.conf.setTlsAllowInsecureConnection(allowTlsInsecureConnection);
        return this;
    }

    public PulsarAdminBuilder enableTlsHostnameVerification(boolean enableTlsHostnameVerification) {
        this.conf.setTlsHostnameVerificationEnable(enableTlsHostnameVerification);
        return this;
    }

    public PulsarAdminBuilder useKeyStoreTls(boolean useKeyStoreTls) {
        this.conf.setUseKeyStoreTls(useKeyStoreTls);
        return this;
    }

    public PulsarAdminBuilder sslProvider(String sslProvider) {
        this.conf.setSslProvider(sslProvider);
        return this;
    }

    public PulsarAdminBuilder tlsKeyStoreType(String tlsKeyStoreType) {
        this.conf.setTlsKeyStoreType(tlsKeyStoreType);
        return this;
    }

    public PulsarAdminBuilder tlsKeyStorePath(String tlsTrustStorePath) {
        this.conf.setTlsKeyStorePath(tlsTrustStorePath);
        return this;
    }

    public PulsarAdminBuilder tlsKeyStorePassword(String tlsKeyStorePassword) {
        this.conf.setTlsKeyStorePassword(tlsKeyStorePassword);
        return this;
    }

    public PulsarAdminBuilder tlsTrustStoreType(String tlsTrustStoreType) {
        this.conf.setTlsTrustStoreType(tlsTrustStoreType);
        return this;
    }

    public PulsarAdminBuilder tlsTrustStorePath(String tlsTrustStorePath) {
        this.conf.setTlsTrustStorePath(tlsTrustStorePath);
        return this;
    }

    public PulsarAdminBuilder tlsTrustStorePassword(String tlsTrustStorePassword) {
        this.conf.setTlsTrustStorePassword(tlsTrustStorePassword);
        return this;
    }

    public PulsarAdminBuilder tlsCiphers(Set<String> tlsCiphers) {
        this.conf.setTlsCiphers(tlsCiphers);
        return this;
    }

    public PulsarAdminBuilder tlsProtocols(Set<String> tlsProtocols) {
        this.conf.setTlsProtocols(tlsProtocols);
        return this;
    }

    public PulsarAdminBuilder connectionTimeout(int connectionTimeout, TimeUnit connectionTimeoutUnit) {
        this.conf.setConnectionTimeoutMs((int)connectionTimeoutUnit.toMillis(connectionTimeout));
        return this;
    }

    public PulsarAdminBuilder readTimeout(int readTimeout, TimeUnit readTimeoutUnit) {
        this.conf.setReadTimeoutMs((int)readTimeoutUnit.toMillis(readTimeout));
        return this;
    }

    public PulsarAdminBuilder requestTimeout(int requestTimeout, TimeUnit requestTimeoutUnit) {
        this.conf.setRequestTimeoutMs((int)requestTimeoutUnit.toMillis(requestTimeout));
        return this;
    }

    public PulsarAdminBuilder autoCertRefreshTime(int autoCertRefreshTime, TimeUnit autoCertRefreshTimeUnit) {
        this.conf.setAutoCertRefreshSeconds((int)autoCertRefreshTimeUnit.toSeconds(autoCertRefreshTime));
        return this;
    }

    public PulsarAdminBuilder setContextClassLoader(ClassLoader clientBuilderClassLoader) {
        this.clientBuilderClassLoader = clientBuilderClassLoader;
        return this;
    }

    public PulsarAdminBuilder acceptGzipCompression(boolean acceptGzipCompression) {
        this.acceptGzipCompression = acceptGzipCompression;
        return this;
    }

    public ClientConfigurationData getConf() {
        return this.conf;
    }
}

