/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.util.DateFormatter;

public class ConsumerStatsImpl
implements ConsumerStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double msgRateRedeliver;
    public double messageAckRate;
    public double chunkedMessageRate;
    public String consumerName;
    public int availablePermits;
    public int unackedMessages;
    public int avgMessagesPerEntry;
    public boolean blockedConsumerOnUnackedMsgs;
    public String readPositionWhenJoining;
    private String address;
    private String connectedSince;
    private String clientVersion;
    @Deprecated
    public long lastAckedTimestamp;
    @Deprecated
    public long lastConsumedTimestamp;
    public long lastConsumedFlowTimestamp;
    public List<String> keyHashRanges;
    public Map<String, String> metadata;

    public ConsumerStatsImpl add(ConsumerStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.messageAckRate += stats.messageAckRate;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.availablePermits += stats.availablePermits;
        this.unackedMessages += stats.unackedMessages;
        this.blockedConsumerOnUnackedMsgs = stats.blockedConsumerOnUnackedMsgs;
        this.readPositionWhenJoining = stats.readPositionWhenJoining;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getConnectedSince() {
        return this.connectedSince;
    }

    public void setConnectedSince(String connectedSince) {
        this.connectedSince = connectedSince;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String getReadPositionWhenJoining() {
        return this.readPositionWhenJoining;
    }

    public String getLastAckedTime() {
        return DateFormatter.format(this.lastAckedTimestamp);
    }

    public String getLastConsumedTime() {
        return DateFormatter.format(this.lastConsumedTimestamp);
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public long getBytesOutCounter() {
        return this.bytesOutCounter;
    }

    public long getMsgOutCounter() {
        return this.msgOutCounter;
    }

    public double getMsgRateRedeliver() {
        return this.msgRateRedeliver;
    }

    public double getMessageAckRate() {
        return this.messageAckRate;
    }

    public double getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public int getAvailablePermits() {
        return this.availablePermits;
    }

    public int getUnackedMessages() {
        return this.unackedMessages;
    }

    public int getAvgMessagesPerEntry() {
        return this.avgMessagesPerEntry;
    }

    public boolean isBlockedConsumerOnUnackedMsgs() {
        return this.blockedConsumerOnUnackedMsgs;
    }

    @Deprecated
    public long getLastAckedTimestamp() {
        return this.lastAckedTimestamp;
    }

    @Deprecated
    public long getLastConsumedTimestamp() {
        return this.lastConsumedTimestamp;
    }

    public long getLastConsumedFlowTimestamp() {
        return this.lastConsumedFlowTimestamp;
    }

    public List<String> getKeyHashRanges() {
        return this.keyHashRanges;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public void setBytesOutCounter(long bytesOutCounter) {
        this.bytesOutCounter = bytesOutCounter;
    }

    public void setMsgOutCounter(long msgOutCounter) {
        this.msgOutCounter = msgOutCounter;
    }

    public void setMsgRateRedeliver(double msgRateRedeliver) {
        this.msgRateRedeliver = msgRateRedeliver;
    }

    public void setMessageAckRate(double messageAckRate) {
        this.messageAckRate = messageAckRate;
    }

    public void setChunkedMessageRate(double chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setAvailablePermits(int availablePermits) {
        this.availablePermits = availablePermits;
    }

    public void setUnackedMessages(int unackedMessages) {
        this.unackedMessages = unackedMessages;
    }

    public void setAvgMessagesPerEntry(int avgMessagesPerEntry) {
        this.avgMessagesPerEntry = avgMessagesPerEntry;
    }

    public void setBlockedConsumerOnUnackedMsgs(boolean blockedConsumerOnUnackedMsgs) {
        this.blockedConsumerOnUnackedMsgs = blockedConsumerOnUnackedMsgs;
    }

    public void setReadPositionWhenJoining(String readPositionWhenJoining) {
        this.readPositionWhenJoining = readPositionWhenJoining;
    }

    @Deprecated
    public void setLastAckedTimestamp(long lastAckedTimestamp) {
        this.lastAckedTimestamp = lastAckedTimestamp;
    }

    @Deprecated
    public void setLastConsumedTimestamp(long lastConsumedTimestamp) {
        this.lastConsumedTimestamp = lastConsumedTimestamp;
    }

    public void setLastConsumedFlowTimestamp(long lastConsumedFlowTimestamp) {
        this.lastConsumedFlowTimestamp = lastConsumedFlowTimestamp;
    }

    public void setKeyHashRanges(List<String> keyHashRanges) {
        this.keyHashRanges = keyHashRanges;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerStatsImpl)) {
            return false;
        }
        ConsumerStatsImpl other = (ConsumerStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (this.getBytesOutCounter() != other.getBytesOutCounter()) {
            return false;
        }
        if (this.getMsgOutCounter() != other.getMsgOutCounter()) {
            return false;
        }
        if (Double.compare(this.getMsgRateRedeliver(), other.getMsgRateRedeliver()) != 0) {
            return false;
        }
        if (Double.compare(this.getMessageAckRate(), other.getMessageAckRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getChunkedMessageRate(), other.getChunkedMessageRate()) != 0) {
            return false;
        }
        if (this.getAvailablePermits() != other.getAvailablePermits()) {
            return false;
        }
        if (this.getUnackedMessages() != other.getUnackedMessages()) {
            return false;
        }
        if (this.getAvgMessagesPerEntry() != other.getAvgMessagesPerEntry()) {
            return false;
        }
        if (this.isBlockedConsumerOnUnackedMsgs() != other.isBlockedConsumerOnUnackedMsgs()) {
            return false;
        }
        if (this.getLastAckedTimestamp() != other.getLastAckedTimestamp()) {
            return false;
        }
        if (this.getLastConsumedTimestamp() != other.getLastConsumedTimestamp()) {
            return false;
        }
        if (this.getLastConsumedFlowTimestamp() != other.getLastConsumedFlowTimestamp()) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        String this$readPositionWhenJoining = this.getReadPositionWhenJoining();
        String other$readPositionWhenJoining = other.getReadPositionWhenJoining();
        if (this$readPositionWhenJoining == null ? other$readPositionWhenJoining != null : !this$readPositionWhenJoining.equals(other$readPositionWhenJoining)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$connectedSince = this.getConnectedSince();
        String other$connectedSince = other.getConnectedSince();
        if (this$connectedSince == null ? other$connectedSince != null : !this$connectedSince.equals(other$connectedSince)) {
            return false;
        }
        String this$clientVersion = this.getClientVersion();
        String other$clientVersion = other.getClientVersion();
        if (this$clientVersion == null ? other$clientVersion != null : !this$clientVersion.equals(other$clientVersion)) {
            return false;
        }
        List<String> this$keyHashRanges = this.getKeyHashRanges();
        List<String> other$keyHashRanges = other.getKeyHashRanges();
        if (this$keyHashRanges == null ? other$keyHashRanges != null : !((Object)this$keyHashRanges).equals(other$keyHashRanges)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumerStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $bytesOutCounter = this.getBytesOutCounter();
        result = result * 59 + (int)($bytesOutCounter >>> 32 ^ $bytesOutCounter);
        long $msgOutCounter = this.getMsgOutCounter();
        result = result * 59 + (int)($msgOutCounter >>> 32 ^ $msgOutCounter);
        long $msgRateRedeliver = Double.doubleToLongBits(this.getMsgRateRedeliver());
        result = result * 59 + (int)($msgRateRedeliver >>> 32 ^ $msgRateRedeliver);
        long $messageAckRate = Double.doubleToLongBits(this.getMessageAckRate());
        result = result * 59 + (int)($messageAckRate >>> 32 ^ $messageAckRate);
        long $chunkedMessageRate = Double.doubleToLongBits(this.getChunkedMessageRate());
        result = result * 59 + (int)($chunkedMessageRate >>> 32 ^ $chunkedMessageRate);
        result = result * 59 + this.getAvailablePermits();
        result = result * 59 + this.getUnackedMessages();
        result = result * 59 + this.getAvgMessagesPerEntry();
        result = result * 59 + (this.isBlockedConsumerOnUnackedMsgs() ? 79 : 97);
        long $lastAckedTimestamp = this.getLastAckedTimestamp();
        result = result * 59 + (int)($lastAckedTimestamp >>> 32 ^ $lastAckedTimestamp);
        long $lastConsumedTimestamp = this.getLastConsumedTimestamp();
        result = result * 59 + (int)($lastConsumedTimestamp >>> 32 ^ $lastConsumedTimestamp);
        long $lastConsumedFlowTimestamp = this.getLastConsumedFlowTimestamp();
        result = result * 59 + (int)($lastConsumedFlowTimestamp >>> 32 ^ $lastConsumedFlowTimestamp);
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        String $readPositionWhenJoining = this.getReadPositionWhenJoining();
        result = result * 59 + ($readPositionWhenJoining == null ? 43 : $readPositionWhenJoining.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $connectedSince = this.getConnectedSince();
        result = result * 59 + ($connectedSince == null ? 43 : $connectedSince.hashCode());
        String $clientVersion = this.getClientVersion();
        result = result * 59 + ($clientVersion == null ? 43 : $clientVersion.hashCode());
        List<String> $keyHashRanges = this.getKeyHashRanges();
        result = result * 59 + ($keyHashRanges == null ? 43 : ((Object)$keyHashRanges).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerStatsImpl(msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesOutCounter=" + this.getBytesOutCounter() + ", msgOutCounter=" + this.getMsgOutCounter() + ", msgRateRedeliver=" + this.getMsgRateRedeliver() + ", messageAckRate=" + this.getMessageAckRate() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", consumerName=" + this.getConsumerName() + ", availablePermits=" + this.getAvailablePermits() + ", unackedMessages=" + this.getUnackedMessages() + ", avgMessagesPerEntry=" + this.getAvgMessagesPerEntry() + ", blockedConsumerOnUnackedMsgs=" + this.isBlockedConsumerOnUnackedMsgs() + ", readPositionWhenJoining=" + this.getReadPositionWhenJoining() + ", address=" + this.getAddress() + ", connectedSince=" + this.getConnectedSince() + ", clientVersion=" + this.getClientVersion() + ", lastAckedTimestamp=" + this.getLastAckedTimestamp() + ", lastConsumedTimestamp=" + this.getLastConsumedTimestamp() + ", lastConsumedFlowTimestamp=" + this.getLastConsumedFlowTimestamp() + ", keyHashRanges=" + this.getKeyHashRanges() + ", metadata=" + this.getMetadata() + ")";
    }
}

